/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.psi.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UriUtil;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.psi.jsp.WebDirectoryUtil;
import com.intellij.javaee.web.psi.resolve.reference.impl.providers.SetContextFolderFix;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JpsFileTargetContextUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFileReferenceHelper
extends FileReferenceHelper {
    private static final int MAX_DEPTH = 2;

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(0);
        }
        String string = WebUtil.trimURL((String)url);
        if (string == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public @NotNull List<? extends @NotNull LocalQuickFix> registerFixes(@NotNull FileReference reference) {
        SetContextFolderFix[] contextFolderFix;
        Pair<VirtualFile, String> pair;
        if (reference == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(2);
        }
        ArrayList<LocalQuickFix> list = new ArrayList<LocalQuickFix>();
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int count = fileReferenceSet.getAllReferences().length;
        WebFacet webFacet = this.getWebFacet(reference);
        if (webFacet != null && count != 0 && reference.getIndex() == count - 1 && fileReferenceSet.isAbsolutePathReference() && (pair = this.findWebRootCandidate(fileReferenceSet.getPathString(), webFacet)) != null) {
            list.add(this.doRegisterFix(pair, webFacet));
        }
        if (webFacet != null && (contextFolderFix = SetContextFolderFix.create(reference, webFacet)) != null) {
            Collections.addAll(list, contextFolderFix);
        }
        ArrayList<LocalQuickFix> arrayList = list;
        if (arrayList == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public WebDirectoryElement getPsiFileSystemItem(@NotNull Project project, @NotNull VirtualFile file) {
        WebFacet webFacet;
        if (project == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(5);
        }
        if ((webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryByFile(file, webFacet);
    }

    public PsiFileSystemItem findRoot(@NotNull Project project, @NotNull VirtualFile file) {
        WebFacet webFacet;
        if (project == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(7);
        }
        if ((webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryElementByPath("/", webFacet);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module thisModule) {
        if (thisModule == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(8);
        }
        WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil(thisModule.getProject());
        ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        WebUtil.getWebUtil().visitAllFacets(thisModule, facet -> {
            WebDirectoryElement directoryElement = util.findWebDirectoryElementByPath("/", (WebFacet)facet);
            if (directoryElement != null) {
                list.add((PsiFileSystemItem)directoryElement);
            }
        });
        ArrayList<PsiFileSystemItem> arrayList = list;
        if (arrayList == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project, @NotNull VirtualFile file, boolean isAbsoluteReference) {
        if (project == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = index.getModuleForFile(file);
            if (module == null) {
                List<FileTargetContext> list = Collections.emptyList();
                if (list == null) {
                    WebFileReferenceHelper.$$$reportNull$$$0(12);
                }
                return list;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil(module.getProject());
            ArrayList<FileTargetContext> list = new ArrayList<FileTargetContext>();
            WebUtil.getWebUtil().visitAllFacets(module, facet -> {
                List sourceRoots;
                WebDirectoryElement directoryElement = util.findWebDirectoryElementByPath("/", (WebFacet)facet);
                if (directoryElement != null) {
                    list.add(new FileTargetContext((PsiFileSystemItem)directoryElement));
                }
                if (!(sourceRoots = facet.getSourceRoots()).isEmpty()) {
                    ArrayList<FileTargetContext> sourceRootContexts = new ArrayList<FileTargetContext>(sourceRoots.size());
                    for (VirtualFile sourceRoot : sourceRoots) {
                        PsiDirectory directory = manager.findDirectory(sourceRoot);
                        if (directory == null) continue;
                        sourceRootContexts.add(new FileTargetContext((PsiFileSystemItem)directory));
                    }
                    list.addAll(JpsFileTargetContextUtils.prepareTargetContexts((Project)project, (VirtualFile)file, sourceRootContexts));
                }
            });
            ArrayList<FileTargetContext> arrayList = list;
            if (arrayList == null) {
                WebFileReferenceHelper.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        List list = ContainerUtil.map(this.getContexts(project, file), FileTargetContext::new);
        if (list == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        WebDirectoryElement parent;
        WebDirectoryElement item;
        if (project == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(15);
        }
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(16);
        }
        if ((item = this.getPsiFileSystemItem(project, file)) != null && (parent = item.getParent()) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            String path = parent.getPath();
            Collection collection = WebUtil.getWebUtil().getContextsByPath(path, module);
            if (collection == null) {
                WebFileReferenceHelper.$$$reportNull$$$0(17);
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(18);
        }
        return list;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(19);
        }
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(20);
        }
        return WebUtil.isInsideWebRoots((VirtualFile)file, (Project)project);
    }

    @Nullable
    protected Pair<VirtualFile, String> findWebRootCandidate(String path, WebFacet webFacet) {
        ContentEntry[] contentEntries;
        List webRoots = webFacet.getWebRoots();
        Module module = webFacet.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            VirtualFile webRootCandidate;
            VirtualFile virtualFile = entry.getFile();
            if (virtualFile == null || (webRootCandidate = WebFileReferenceHelper.scan(virtualFile, path.split("/"), entry, webRoots, 0)) == null) continue;
            VirtualFile base = webRootCandidate;
            String mapTo = "/";
            int pos = 0;
            for (WebRoot webRoot : webRoots) {
                if (!webRoot.getRelativePath().equals(mapTo)) continue;
                if ((pos = path.indexOf(47, pos + 1)) == -1) {
                    return null;
                }
                mapTo = path.substring(0, pos);
                webRootCandidate = UriUtil.findRelativeFile((String)mapTo, (VirtualFile)base);
                if (webRootCandidate != null) continue;
                return null;
            }
            return Pair.create((Object)webRootCandidate, (Object)mapTo);
        }
        return null;
    }

    @Nullable
    protected WebFacet getWebFacet(FileReference reference) {
        PsiElement element = reference.getElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        Iterator iterator = WebFacet.getInstances((Module)module).iterator();
        return iterator.hasNext() ? (WebFacet)iterator.next() : null;
    }

    protected LocalQuickFix doRegisterFix(Pair<VirtualFile, String> pair, WebFacet webFacet) {
        return new AddWebRootIntentionAction((VirtualFile)pair.first, (String)pair.second, webFacet);
    }

    @Nullable
    private static VirtualFile scan(@NotNull VirtualFile file, String[] path, ContentEntry contentEntry, List<WebRoot> webRoots, int depth) {
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(21);
        }
        if (!file.isDirectory()) {
            return null;
        }
        boolean containsWebRoot = false;
        for (WebRoot root : webRoots) {
            VirtualFile rootFile = root.getFile();
            if (Comparing.equal((Object)file, (Object)rootFile)) {
                return null;
            }
            if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)rootFile, (boolean)false)) continue;
            containsWebRoot = true;
            break;
        }
        if (!containsWebRoot) {
            boolean valid = true;
            for (VirtualFile entry : contentEntry.getExcludeFolderFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)entry, (boolean)false)) continue;
                valid = false;
                break;
            }
            if (valid) {
                return file;
            }
        }
        if (depth < 2) {
            for (VirtualFile child : file.getChildren()) {
                VirtualFile result = WebFileReferenceHelper.scan(child, path, contentEntry, webRoots, depth + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 9, 12, 13, 14, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/WebFileReferenceHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/WebFileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 9, 12, 13, 14, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class AddWebRootIntentionAction
    implements IntentionAction,
    LocalQuickFix {
        private final VirtualFile myWebRootCandidate;
        private final String myMapTo;
        private final WebFacet myWebFacet;

        AddWebRootIntentionAction(@NotNull VirtualFile webRootCandidate, @NotNull String mapTo, @NotNull WebFacet webFacet) {
            if (webRootCandidate == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(0);
            }
            if (mapTo == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(1);
            }
            if (webFacet == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(2);
            }
            this.myWebRootCandidate = webRootCandidate;
            this.myMapTo = mapTo;
            this.myWebFacet = webFacet;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = J2EEBundle.message((String)"add.web.root", (Object[])new Object[]{this.myWebRootCandidate.getPath()});
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.getText();
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = J2EEBundle.message((String)"web.root.family", (Object[])new Object[0]);
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(7);
            }
            this.invoke(project, null, null);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(8);
            }
            return true;
        }

        public final void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(9);
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> this.myWebFacet.addWebRoot(this.myWebRootCandidate, this.myMapTo));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webRootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapTo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webFacet";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

