/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSUnorderedModifiersStructure;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b \n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 \u007f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u007fB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0016J&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0004J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0014J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0014J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0014J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0014J\b\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0011H\u0004J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0014J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0014J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0004J\b\u0010+\u001a\u00020\bH\u0002J\b\u0010,\u001a\u00020\bH\u0014J\u0006\u0010-\u001a\u00020\bJ\b\u0010/\u001a\u00020\bH\u0002J\b\u00100\u001a\u00020!H\u0002J\b\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020\bH\u0014J\b\u00103\u001a\u00020\bH\u0002J\b\u00104\u001a\u00020\bH\u0002J\b\u00105\u001a\u00020\bH\u0014J\b\u00106\u001a\u00020!H\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\nH\u0004J\u001a\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\n2\b\u00109\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010:\u001a\u00020\bH\u0002J\u0010\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020\u0011H\u0002J\b\u0010=\u001a\u00020\bH\u0002J\b\u0010>\u001a\u00020\bH\u0004J\u0010\u0010?\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020BH\u0002J\u0012\u0010C\u001a\u00020\b2\b\u0010D\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010E\u001a\u00020\bH\u0002J\u0012\u0010F\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010G\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010H\u001a\u00020\bH\u0014J\b\u0010I\u001a\u00020\bH\u0002J\b\u0010M\u001a\u00020\bH\u0014J\b\u0010N\u001a\u00020\bH\u0002J\b\u0010Q\u001a\u00020\bH\u0016J\u0006\u0010R\u001a\u00020\bJ\b\u0010T\u001a\u00020\bH\u0004J\b\u0010U\u001a\u00020\bH\u0004J\u001a\u0010Q\u001a\u00020\b2\u0006\u0010V\u001a\u00020\u00112\b\b\u0001\u0010W\u001a\u00020XH\u0004J\b\u0010Y\u001a\u00020\bH\u0014J\u0010\u0010Y\u001a\u00020\b2\u0006\u0010Z\u001a\u00020\nH\u0004J\b\u0010[\u001a\u00020!H\u0014J\u0012\u0010\\\u001a\u00020\b2\b\u0010]\u001a\u0004\u0018\u00010\u0011H\u0004J\b\u0010^\u001a\u00020!H\u0004J\b\u0010_\u001a\u00020\bH\u0002J\u000e\u0010`\u001a\u00020\b2\u0006\u0010Z\u001a\u00020\nJ\b\u0010c\u001a\u00020\bH\u0014J\u0018\u0010g\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010h\u001a\u00020\u0011H\u0002J\b\u0010i\u001a\u00020\bH\u0014J\u0018\u0010j\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010k\u001a\u00020\bH\u0016J\u001a\u0010l\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010A\u001a\u00020BH\u0004J\b\u0010m\u001a\u00020\bH\u0016J\b\u0010q\u001a\u00020\bH\u0016J\u0006\u0010r\u001a\u00020\bJ\u0012\u0010s\u001a\u00020\b2\b\u0010t\u001a\u0004\u0018\u00010\u0011H\u0004J \u0010u\u001a\u00020\b2\u0006\u0010v\u001a\u00020\b2\u0006\u0010w\u001a\u00020\b2\u0006\u0010x\u001a\u00020\bH\u0016J\b\u0010y\u001a\u00020\bH\u0014J\u0006\u0010z\u001a\u00020\bJ\b\u0010{\u001a\u00020\bH\u0016J\b\u0010~\u001a\u00020XH\u0014R\u0014\u0010#\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010.\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010$R\u0014\u0010@\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010$R\u0014\u0010J\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0014\u0010O\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010$R\u0014\u0010P\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010$R\u0014\u0010S\u001a\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010$R\u0014\u0010a\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010LR\u0014\u0010d\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010LR\u0014\u0010f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010$R\u0014\u0010l\u001a\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010$R\u0014\u0010n\u001a\b\u0012\u0004\u0012\u00020p0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010|\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b}\u0010L\u00a8\u0006\u0080\u0001"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser;", "P", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "Lcom/intellij/lang/javascript/parsing/JSPsiTypeParser;", "parser", "<init>", "(Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;)V", "parseQualifiedTypeNameTail", "", "expr", "Lcom/intellij/lang/PsiBuilder$Marker;", "tryParseType", "parseAfterDotInQualifiedTypeNameRest", "allowStar", "marker", "Lcom/intellij/openapi/util/Ref;", "separator", "Lcom/intellij/psi/tree/IElementType;", "parseType", "parseConditionalType", "parseInUnionOrIntersectionType", "expectedUnion", "isTopLevel", "functionTypeAllowedByContext", "canAdvanceSeparator", "isValidSeparator", "isFunctionTypeAllowed", "isFirstComponent", "allowedByContext", "parseUnionOrIntersectionComponent", "functionTypeAllowed", "parseInferType", "tryParseConstraintOfInferType", "", "parseTypeWithConditionalTypeAllowed", "isConditionalTypeAllowed", "()Z", "advanceTypeKeywordAndNestedType", "type", "parseDistinctType", "readonlyTypeAllowed", "parseDistinctTypeNoSuffix", "parseFunctionOrParenthesizedType", "parseJSDocAnyOrDecoratedType", "parseJSDocFunctionType", "parseJSDocFunctionTypeParameter", "isPossibleTypePrefxiWithColon", "validateReadonlyTail", "parseStringTemplateAsTypeLiteral", "parseTemplateLiteralType", "allowSingleTemplateLiteralInType", "areArrayBracketsFollowing", "parseNamedOrThisType", "parseTypeOfInnerExpression", "parseImportTypeInner", "parseSuffixType", "typeMarker", "attributeListMarker", "canContinueParsingArray", "parseSingleTokenLiteralType", "literalType", "parseSingleOrPrimitiveType", "parserSingleType", "parseTypePredicate", "isFunctionTypeExpected", "startIndex", "", "isDefinitelyFunctionToken", "elementTypeAfterIdentifier", "parseFunctionType", "isAbstractNew", "parseFunctionReturnType", "result", "parseTupleType", "tupleTypeElementType", "getTupleTypeElementType", "()Lcom/intellij/psi/tree/IElementType;", "doParseTupleType", "parseTupleTypeMember", "isTupleElementName", "isNextTokenColonOrQuestionColon", "parseObjectType", "parseMappedType", "isStartOfMappedType", "parseMappedTypeNoMarker", "parseMappedTypeParameter", "rBraceType", "missingRBraceMessageKey", "", "parseTypeMember", "typeMember", "parseTypeMemberPropertyName", "isFunctionHeaderStart", "token", "forceCheckForSemicolonOrComma", "checkForComma", "parseInterfaceSimplePropertyOrFunction", "propertySignatureElementType", "getPropertySignatureElementType", "tryParseObjectMemberType", "functionSignatureElementType", "getFunctionSignatureElementType", "isIndexSignatureProperty", "parseFunctionHeaderNoMarker", "elementType", "parseFunctionParameterList", "parseIndexSignatureNoMarker", "checkSemicolon", "isStartOfType", "tryParseTypeParameterList", "AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE", "Ljava/util/function/Predicate;", "Lcom/intellij/lang/PsiBuilder;", "parseTypeParameter", "parseOptionalTypeArgumentListInExpression", "isAcceptableTokenTypeAfterTypeArguments", "tokenType", "tryParseTypeArgumentList", "revert", "allowNewLine", "isExpression", "allowTypeArgumentsTrailingComma", "parseTypeInGenericArgument", "parseTypeAliasType", "singleTypeElementType", "getSingleTypeElementType", "getTypeNameExpectedMessage", "Companion", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nTypeScriptPsiTypeParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptPsiTypeParser.kt\ncom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1785:1\n13#2:1786\n*S KotlinDebug\n*F\n+ 1 TypeScriptPsiTypeParser.kt\ncom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser\n*L\n1690#1:1786\n*E\n"})
public class TypeScriptPsiTypeParser<P extends ES6Parser>
extends JSPsiTypeParser<P> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Predicate<PsiBuilder> AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TokenSet NON_REFERENCE_PRIMITIVE_TYPES;
    @NotNull
    private static final Key<Boolean> IS_CONDITIONAL_TYPE_ALLOWED;
    @JvmField
    @NotNull
    protected static final Predicate<PsiBuilder> AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE;
    @NotNull
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS;
    @NotNull
    private static final JSModifiersStructure TYPE_PARAMETER_MODIFIERS_STRUCTURE;

    public TypeScriptPsiTypeParser(@NotNull P parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super((JavaScriptParser)parser);
        this.AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE = arg_0 -> TypeScriptPsiTypeParser.AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE$lambda$0(this, arg_0);
    }

    @Override
    protected boolean parseQualifiedTypeNameTail(@NotNull PsiBuilder.Marker expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        expr.drop();
        return this.tryParseTypeArgumentList(false, false, false);
    }

    @Override
    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            return this.parseType();
        }
        return false;
    }

    @Override
    protected boolean parseAfterDotInQualifiedTypeNameRest(boolean allowStar, @NotNull Ref<PsiBuilder.Marker> marker, @NotNull IElementType separator) {
        Intrinsics.checkNotNullParameter(marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.LT) {
            return true;
        }
        return super.parseAfterDotInQualifiedTypeNameRest(allowStar, marker, separator);
    }

    @Override
    public boolean parseType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        if (!this.parseInUnionOrIntersectionType(true, true, true)) {
            mark.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD && !JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder) && this.isConditionalTypeAllowed()) {
            this.builder.advanceLexer();
            boolean result = this.parseConditionalType();
            mark.done(BasicTypeScriptElementTypes.CONDITIONAL_TYPE);
            return result;
        }
        mark.drop();
        return true;
    }

    private final boolean parseConditionalType() {
        boolean extendsType = this.parseTypeWithConditionalTypeAllowed(false);
        if (!extendsType) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.QUEST) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.question", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        boolean trueType = this.parseTypeWithConditionalTypeAllowed(true);
        if (!trueType) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.colon", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseTypeWithConditionalTypeAllowed(true);
    }

    protected final boolean parseInUnionOrIntersectionType(boolean expectedUnion, boolean isTopLevel, boolean functionTypeAllowedByContext) {
        int typeCounter = 0;
        boolean result = false;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker unionTypeMarker = marker;
        do {
            if (this.canAdvanceSeparator(expectedUnion)) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionType(false, isTopLevel && typeCounter == 1, functionTypeAllowedByContext) : (result = this.parseUnionOrIntersectionComponent(this.isFunctionTypeAllowed(isTopLevel && ++typeCounter == 1, functionTypeAllowedByContext)));
        } while (result && this.isValidSeparator(expectedUnion));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done(BasicTypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result;
    }

    protected boolean canAdvanceSeparator(boolean expectedUnion) {
        IElementType separator = this.builder.getTokenType();
        return separator == JSTokenTypes.OR || separator == JSTokenTypes.AND;
    }

    protected boolean isValidSeparator(boolean expectedUnion) {
        IElementType type = this.builder.getTokenType();
        return expectedUnion ? type == JSTokenTypes.OR : type == JSTokenTypes.AND;
    }

    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return isFirstComponent && allowedByContext;
    }

    protected boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.KEYOF_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType(BasicTypeScriptElementTypes.TYPE_OPERATOR);
        }
        if (type == JSTokenTypes.AWAITED_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType(BasicTypeScriptElementTypes.AWAITED_TYPE);
        }
        if (type == JSTokenTypes.INFER_KEYWORD && this.parseInferType()) {
            return true;
        }
        Boolean wasConditionalTypeAllowed = (Boolean)this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)true);
        boolean result = this.parseDistinctType(functionTypeAllowed, true);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)wasConditionalTypeAllowed);
        return result;
    }

    private final boolean parseInferType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        IElementType type = this.builder.getTokenType();
        if (!this.isIdentifierToken(type)) {
            marker2.rollbackTo();
            return false;
        }
        this.builder.advanceLexer();
        this.tryParseConstraintOfInferType();
        marker2.done(BasicTypeScriptElementTypes.INFER_TYPE);
        return true;
    }

    private final void tryParseConstraintOfInferType() {
        if (this.builder.getTokenType() != JSTokenTypes.EXTENDS_KEYWORD) {
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        this.parseTypeWithConditionalTypeAllowed(false);
        if (!this.isConditionalTypeAllowed() || this.builder.getTokenType() != JSTokenTypes.QUEST) {
            marker2.drop();
        } else {
            marker2.rollbackTo();
        }
    }

    private final boolean parseTypeWithConditionalTypeAllowed(boolean isConditionalTypeAllowed) {
        Boolean wasConditionalTypeAllowed = (Boolean)this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)isConditionalTypeAllowed);
        boolean result = this.parseType();
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)wasConditionalTypeAllowed);
        return result;
    }

    private final boolean isConditionalTypeAllowed() {
        return !Intrinsics.areEqual((Object)this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED), (Object)false);
    }

    protected final boolean advanceTypeKeywordAndNestedType(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        this.builder.advanceLexer();
        boolean result = this.parseUnionOrIntersectionComponent(true);
        marker2.done(type);
        return result;
    }

    protected boolean parseDistinctType(boolean functionTypeAllowed, boolean readonlyTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker typeMarker = marker;
        PsiBuilder.Marker attListMarker = null;
        boolean result = false;
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            if (readonlyTypeAllowed) {
                boolean parsed = false;
                PsiBuilder.Marker beforeAttrList = this.builder.mark();
                attListMarker = this.builder.mark();
                this.builder.advanceLexer();
                attListMarker.done(JSElementTypes.ATTRIBUTE_LIST);
                PsiBuilder.Marker markerForArrayPostfix = this.builder.mark();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                    PsiBuilder.Marker marker2 = this.builder.mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                    PsiBuilder.Marker mark = marker2;
                    boolean tupleParsed = this.doParseTupleType();
                    if (tupleParsed) {
                        if (!this.areArrayBracketsFollowing()) {
                            mark.drop();
                            PsiBuilder.Marker marker3 = markerForArrayPostfix;
                            Intrinsics.checkNotNull((Object)marker3);
                            marker3.drop();
                            markerForArrayPostfix = null;
                            PsiBuilder.Marker marker4 = beforeAttrList;
                            Intrinsics.checkNotNull((Object)marker4);
                            marker4.done(this.getTupleTypeElementType());
                            beforeAttrList = null;
                            attListMarker = null;
                        } else {
                            mark.done(this.getTupleTypeElementType());
                        }
                        parsed = true;
                    } else {
                        mark.drop();
                    }
                } else {
                    boolean parsedType = this.parseDistinctType(false, false);
                    if (parsedType && this.validateReadonlyTail()) {
                        parsed = true;
                    }
                }
                PsiBuilder.Marker marker5 = beforeAttrList;
                if (marker5 != null) {
                    marker5.drop();
                }
                if (!parsed) {
                    PsiBuilder.Marker marker6 = markerForArrayPostfix;
                    Intrinsics.checkNotNull((Object)marker6);
                    marker6.drop();
                    PsiBuilder.Marker marker7 = attListMarker;
                    Intrinsics.checkNotNull((Object)marker7);
                    marker7.rollbackTo();
                    attListMarker = null;
                    result = this.parseNamedOrThisType();
                } else {
                    if (markerForArrayPostfix != null) {
                        typeMarker.drop();
                        typeMarker = markerForArrayPostfix;
                    }
                    result = true;
                }
            } else {
                result = this.parseNamedOrThisType();
            }
        } else {
            result = this.parseDistinctTypeNoSuffix(functionTypeAllowed);
        }
        if (readonlyTypeAllowed) {
            result &= this.parseSuffixType(typeMarker, attListMarker);
        } else {
            typeMarker.drop();
        }
        return result;
    }

    protected boolean parseDistinctTypeNoSuffix(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.LPAR) {
            return this.parseFunctionOrParenthesizedType(functionTypeAllowed);
        }
        if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.LT || this.isAbstractNew(type)) {
            return this.parseFunctionType();
        }
        if (type == JSTokenTypes.LBRACE) {
            return this.isStartOfMappedType() ? this.parseMappedType() : this.parseObjectType();
        }
        if (type == JSTokenTypes.LBRACKET) {
            return this.parseTupleType();
        }
        if (type == JSTokenTypes.IMPORT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.parseImportTypeInner();
            marker2.done(this.getSingleTypeElementType());
            return true;
        }
        if (type == JSTokenTypes.TYPEOF_KEYWORD) {
            if (this.builder.lookAhead(1) == JSTokenTypes.IMPORT_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker marker3 = marker;
                this.builder.advanceLexer();
                this.parseImportTypeInner();
                marker3.done(this.getSingleTypeElementType());
            } else {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker marker4 = marker;
                this.builder.advanceLexer();
                this.parseTypeOfInnerExpression();
                marker4.done(BasicTypeScriptElementTypes.TYPEOF_TYPE);
            }
            return true;
        }
        if (type == JSTokenTypes.THIS_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker5 = marker;
            this.builder.advanceLexer();
            marker5.done(BasicTypeScriptElementTypes.THIS_TYPE);
            return true;
        }
        if (type == JSTokenTypes.THIS_KEYWORD || type == JSTokenTypes.ASSERTS_KEYWORD || NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || this.isIdentifierToken(type)) {
            return this.parseNamedOrThisType();
        }
        if (JSTokenTypes.STRING_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(BasicTypeScriptElementTypes.STRING_LITERAL_TYPE);
            return true;
        }
        if (type == JSTokenTypes.BACKQUOTE) {
            if (this.builder.lookAhead(1) == JSTokenTypes.STRING_TEMPLATE_PART && this.builder.lookAhead(2) == JSTokenTypes.BACKQUOTE && this.allowSingleTemplateLiteralInType()) {
                this.parseStringTemplateAsTypeLiteral();
                return true;
            }
            return this.parseTemplateLiteralType();
        }
        if (type == JSTokenTypes.NUMERIC_LITERAL || type == JSTokenTypes.MINUS && this.builder.lookAhead(1) == JSTokenTypes.NUMERIC_LITERAL) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker literalTypeMark = marker;
            PsiBuilder.Marker prefixMark = null;
            if (type == JSTokenTypes.MINUS) {
                prefixMark = this.builder.mark();
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker marker6 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker6, (String)"mark(...)");
            PsiBuilder.Marker expressionMarker = marker6;
            this.builder.advanceLexer();
            expressionMarker.done(JSElementTypes.LITERAL_EXPRESSION);
            PsiBuilder.Marker marker7 = prefixMark;
            if (marker7 != null) {
                marker7.done(JSElementTypes.PREFIX_EXPRESSION);
            }
            literalTypeMark.done(BasicTypeScriptElementTypes.NUMBER_LITERAL_TYPE);
            return true;
        }
        if (JSTokenTypes.BOOLEAN_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(BasicTypeScriptElementTypes.BOOLEAN_LITERAL_TYPE);
            return true;
        }
        if (type == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parseJSDocFunctionType();
        }
        if (type == JSTokenTypes.EXCL || type == JSTokenTypes.MULT || type == JSTokenTypes.QUEST) {
            return this.parseJSDocAnyOrDecoratedType();
        }
        this.builder.error(this.getTypeNameExpectedMessage());
        return false;
    }

    protected final boolean parseFunctionOrParenthesizedType(boolean functionTypeAllowed) {
        boolean isFunctionType;
        boolean result = false;
        boolean bl = isFunctionType = functionTypeAllowed && this.isFunctionTypeExpected();
        if (isFunctionType) {
            result = this.parseFunctionType();
        } else {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker parenthesized = marker;
            this.builder.advanceLexer();
            result = this.parseType();
            if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rparen", new Object[0]));
                result = false;
            }
            parenthesized.done(BasicTypeScriptElementTypes.PARENTHESIZED);
        }
        return result;
    }

    private final boolean parseJSDocAnyOrDecoratedType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        IElementType startToken = this.builder.getTokenType();
        this.builder.advanceLexer();
        if (startToken == JSTokenTypes.MULT) {
            mark.done(this.getSingleTypeElementType());
            return true;
        }
        boolean result = this.parseDistinctType(false, false);
        if (result || startToken == JSTokenTypes.EXCL) {
            mark.done(BasicTypeScriptElementTypes.JSDOC_DECORATED_TYPE);
            return result;
        }
        mark.rollbackTo();
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        mark = marker2;
        this.builder.advanceLexer();
        mark.done(this.getSingleTypeElementType());
        return true;
    }

    protected boolean parseJSDocFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        this.builder.advanceLexer();
        IElementType token = this.builder.getTokenType();
        if (token == JSTokenTypes.LPAR) {
            boolean success;
            block8: {
                this.builder.advanceLexer();
                success = true;
                if (this.builder.getTokenType() != JSTokenTypes.RPAR) {
                    while (true) {
                        if (!this.parseJSDocFunctionTypeParameter()) {
                            success = false;
                            break block8;
                        }
                        IElementType type = this.builder.getTokenType();
                        if (type == JSTokenTypes.RPAR) {
                            this.builder.advanceLexer();
                            break block8;
                        }
                        if (type != JSTokenTypes.COMMA) break;
                        this.builder.advanceLexer();
                    }
                    success = false;
                } else {
                    PsiBuilder.Marker marker2 = this.builder.mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                    PsiBuilder.Marker emptyMarker = marker2;
                    emptyMarker.done(JSElementTypes.EMPTY_EXPRESSION);
                    this.builder.advanceLexer();
                }
            }
            if (!success) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                mark.done(BasicTypeScriptElementTypes.JSDOC_FUNCTION_TYPE);
                return true;
            }
            token = this.builder.getTokenType();
        }
        if (token == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
        }
        mark.done(BasicTypeScriptElementTypes.JSDOC_FUNCTION_TYPE);
        return true;
    }

    public final boolean parseJSDocFunctionTypeParameter() {
        IElementType next;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            IElementType afterDotDotDot = this.builder.getTokenType();
            if (afterDotDotDot == JSTokenTypes.RPAR || afterDotDotDot == JSTokenTypes.COMMA || this.builder.eof()) {
                mark.done(BasicTypeScriptElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
                return true;
            }
        } else if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.THIS_KEYWORD) {
            this.builder.advanceLexer();
            IElementType afterKind = this.builder.getTokenType();
            if (afterKind == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
            } else {
                mark.done(BasicTypeScriptElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
                return true;
            }
        }
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            if (this.builder.lookAhead(1) == JSTokenTypes.COLON) {
                if (this.isPossibleTypePrefxiWithColon()) {
                    this.builder.advanceLexer();
                    this.builder.advanceLexer();
                }
            } else if (this.builder.lookAhead(1) == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
            }
        }
        boolean result = this.parseType();
        if (this.builder.getTokenType() == JSTokenTypes.COMMA && this.isIdentifierToken(next = this.builder.lookAhead(1))) {
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            PsiBuilder.Marker temp = marker2;
            this.builder.advanceLexer();
            if (Intrinsics.areEqual((Object)"optional", (Object)this.builder.getTokenText())) {
                this.builder.remapCurrentToken(JSTokenTypes.QUEST);
                this.builder.advanceLexer();
                temp.drop();
            } else {
                temp.rollbackTo();
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.QUEST || this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            IElementType valueCandidate = this.builder.getTokenType();
            if (this.isIdentifierToken(valueCandidate) || valueCandidate == JSTokenTypes.STRING_LITERAL || valueCandidate == JSTokenTypes.TRUE_KEYWORD || valueCandidate == JSTokenTypes.FALSE_KEYWORD || valueCandidate == JSTokenTypes.NULL_KEYWORD || valueCandidate == JSTokenTypes.UNDEFINED_KEYWORD) {
                this.builder.advanceLexer();
            }
        }
        mark.done(BasicTypeScriptElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
        return result;
    }

    private final boolean isPossibleTypePrefxiWithColon() {
        return this.builder.getTokenType() != JSTokenTypes.MODULE_KEYWORD && !Intrinsics.areEqual((Object)"event", (Object)this.builder.getTokenText()) && !Intrinsics.areEqual((Object)"external", (Object)this.builder.getTokenText());
    }

    private final boolean validateReadonlyTail() {
        boolean lastIsIndexer;
        boolean parsedIndexerTail;
        block4: {
            PsiBuilder.Marker indexerTailMarker = null;
            parsedIndexerTail = true;
            lastIsIndexer = false;
            while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                if (indexerTailMarker == null) {
                    indexerTailMarker = this.builder.mark();
                }
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) {
                    this.builder.advanceLexer();
                    lastIsIndexer = true;
                    continue;
                }
                lastIsIndexer = false;
                parsedIndexerTail = this.parseType();
                if (!parsedIndexerTail) break;
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    parsedIndexerTail = false;
                    break;
                }
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker marker = indexerTailMarker;
            if (marker == null) break block4;
            marker.rollbackTo();
        }
        return parsedIndexerTail && lastIsIndexer;
    }

    private final void parseStringTemplateAsTypeLiteral() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mMarker = marker;
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker expressionMarker = marker2;
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        expressionMarker.done(JSElementTypes.STRING_TEMPLATE_EXPRESSION);
        mMarker.done(BasicTypeScriptElementTypes.STRING_LITERAL_TYPE);
    }

    private final boolean parseTemplateLiteralType() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BACKQUOTE);
        boolean parsedSomething = false;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker templateLiteralType = marker;
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                templateLiteralType.done(BasicTypeScriptElementTypes.TEMPLATE_LITERAL_TYPE);
                return parsedSomething;
            }
            if (this.builder.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                    this.builder.advanceLexer();
                    if (!this.parseType()) {
                        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
                    }
                    JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                this.builder.advanceLexer();
            }
            parsedSomething = true;
        }
        JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.BACKQUOTE, "javascript.parser.message.missing.back.quote");
        templateLiteralType.done(BasicTypeScriptElementTypes.TEMPLATE_LITERAL_TYPE);
        return true;
    }

    protected boolean allowSingleTemplateLiteralInType() {
        return true;
    }

    private final boolean areArrayBracketsFollowing() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && this.builder.lookAhead(1) == JSTokenTypes.RBRACKET;
    }

    private final boolean parseNamedOrThisType() {
        boolean result = false;
        boolean isAssert = this.builder.getTokenType() == JSTokenTypes.ASSERTS_KEYWORD;
        IElementType lookAhead = this.builder.lookAhead(isAssert ? 2 : 1);
        if (lookAhead == JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            if (isAssert) {
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker marker3 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
            PsiBuilder.Marker innerMarker = marker3;
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            if (!JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
                result = this.parseTypePredicate(marker2);
            } else {
                marker2.rollbackTo();
                result = this.parseSingleOrPrimitiveType();
            }
        } else if (isAssert) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker4 = marker;
            this.builder.advanceLexer();
            PsiBuilder.Marker marker5 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker5, (String)"mark(...)");
            PsiBuilder.Marker innerMarker = marker5;
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            marker4.done(BasicTypeScriptElementTypes.TYPE_PREDICATE);
            result = true;
        } else {
            boolean isUniqueSymbol = false;
            if (this.isIdentifierToken(lookAhead) && Intrinsics.areEqual((Object)"unique", (Object)this.builder.getTokenText())) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker mark = marker;
                this.builder.advanceLexer();
                if (!Intrinsics.areEqual((Object)"symbol", (Object)this.builder.getTokenText())) {
                    mark.rollbackTo();
                } else {
                    this.builder.advanceLexer();
                    mark.done(this.getSingleTypeElementType());
                    isUniqueSymbol = true;
                }
            }
            result = isUniqueSymbol || this.parseSingleOrPrimitiveType();
        }
        return result;
    }

    protected boolean parseTypeOfInnerExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.THIS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.parser.buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            if (this.builder.getTokenType() == JSTokenTypes.DOT && this.builder.lookAhead(1) == JSTokenTypes.PRIVATE_KEYWORD) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                marker2.done(JSElementTypes.REFERENCE_EXPRESSION);
                PsiBuilder.Marker marker3 = marker2.precede();
                Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"precede(...)");
                marker2 = marker3;
            }
            if (!this.parseQualifiedTypeNameRest(false, marker2)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                return false;
            }
            return true;
        }
        if (!this.parseQualifiedTypeName()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    private final void parseImportTypeInner() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker call = marker2;
        ((ES6Parser)this.parser).getExpressionParser().parseImportCall(call);
        if (!this.parseQualifiedTypeNameRest(false, expr)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    protected final boolean parseSuffixType(@NotNull PsiBuilder.Marker typeMarker) {
        Intrinsics.checkNotNullParameter((Object)typeMarker, (String)"typeMarker");
        return this.parseSuffixType(typeMarker, null);
    }

    protected boolean parseSuffixType(@NotNull PsiBuilder.Marker typeMarker, @Nullable PsiBuilder.Marker attributeListMarker) {
        Intrinsics.checkNotNullParameter((Object)typeMarker, (String)"typeMarker");
        PsiBuilder.Marker typeMarker2 = typeMarker;
        boolean result = true;
        while (this.canContinueParsingArray()) {
            this.builder.advanceLexer();
            if (this.isStartOfType()) {
                this.parseType();
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                    result = false;
                    break;
                }
                this.builder.advanceLexer();
                typeMarker2.done(BasicTypeScriptElementTypes.INDEXED_ACCESS_TYPE);
            } else {
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                    result = false;
                    break;
                }
                this.builder.advanceLexer();
                if (attributeListMarker != null && !this.canContinueParsingArray()) {
                    typeMarker2.drop();
                    attributeListMarker.precede().done(BasicTypeScriptElementTypes.ARRAY_TYPE);
                    return true;
                }
                typeMarker2.done(BasicTypeScriptElementTypes.ARRAY_TYPE);
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeMarker2.precede(), (String)"precede(...)");
        }
        typeMarker2.drop();
        return result;
    }

    private final boolean canContinueParsingArray() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && !JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder);
    }

    private final void parseSingleTokenLiteralType(IElementType literalType) {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker typeMarker = marker;
        String errorMessage = ((ES6Parser)this.parser).getExpressionParser().validateLiteral();
        this.parser.buildTokenElement(JSElementTypes.LITERAL_EXPRESSION);
        if (errorMessage != null) {
            this.builder.error(errorMessage);
        }
        typeMarker.done(literalType);
    }

    private final boolean parseSingleOrPrimitiveType() {
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            this.builder.advanceLexer();
            marker2.done(this.getSingleTypeElementType());
            return true;
        }
        return this.parserSingleType();
    }

    protected final boolean parserSingleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        boolean result = this.parseQualifiedTypeName();
        marker2.done(this.getSingleTypeElementType());
        return result;
    }

    private final boolean parseTypePredicate(PsiBuilder.Marker marker) {
        this.builder.advanceLexer();
        boolean result = this.parseType();
        marker.done(BasicTypeScriptElementTypes.TYPE_PREDICATE);
        return result;
    }

    protected boolean isFunctionTypeExpected() {
        return this.isFunctionTypeExpected(0);
    }

    private final boolean isFunctionTypeExpected(int startIndex) {
        IElementType elementTypeAfterRPar;
        IElementType elementTypeAfterLPar = this.builder.lookAhead(startIndex + 1);
        if (elementTypeAfterLPar == null || elementTypeAfterLPar == JSTokenTypes.RPAR) {
            return true;
        }
        if (elementTypeAfterLPar == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        if (FunctionParser.Companion.willParseDestructuringAssignment(elementTypeAfterLPar) && JSArrowFunctionDetector.INSTANCE.isArrowFunctionType(this.builder, ((ES6Parser)this.parser).getFunctionParser())) {
            return true;
        }
        if (elementTypeAfterLPar != JSTokenTypes.THIS_KEYWORD && !this.isIdentifierToken(elementTypeAfterLPar)) {
            return false;
        }
        IElementType elementTypeAfterIdentifier = this.builder.lookAhead(startIndex + 2);
        if (this.isDefinitelyFunctionToken(elementTypeAfterIdentifier)) {
            return true;
        }
        return elementTypeAfterIdentifier == JSTokenTypes.RPAR && (elementTypeAfterRPar = this.builder.lookAhead(startIndex + 3)) == JSTokenTypes.EQGT;
    }

    protected boolean isDefinitelyFunctionToken(@Nullable IElementType elementTypeAfterIdentifier) {
        return elementTypeAfterIdentifier == JSTokenTypes.COMMA || elementTypeAfterIdentifier == JSTokenTypes.COLON || elementTypeAfterIdentifier == JSTokenTypes.QUEST;
    }

    private final boolean parseFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        if (this.builder.getTokenType() == JSTokenTypes.ABSTRACT_KEYWORD) {
            PsiBuilder.Marker marker3 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
            PsiBuilder.Marker attributeList = marker3;
            this.builder.advanceLexer();
            attributeList.done(JSElementTypes.ATTRIBUTE_LIST);
        }
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean result = this.parseFunctionParameterList();
        result = this.parseFunctionReturnType(marker2, result);
        return result;
    }

    private final boolean isAbstractNew(IElementType type) {
        return type == JSTokenTypes.ABSTRACT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.NEW_KEYWORD;
    }

    protected boolean parseFunctionReturnType(@NotNull PsiBuilder.Marker marker, boolean result) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        boolean result2 = result;
        result2 &= JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        marker.done(BasicTypeScriptElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseTypeWithConditionalTypeAllowed(true);
    }

    private final boolean parseTupleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        boolean result = this.doParseTupleType();
        marker2.done(this.getTupleTypeElementType());
        return result;
    }

    @NotNull
    protected IElementType getTupleTypeElementType() {
        return BasicTypeScriptElementTypes.TUPLE_TYPE;
    }

    protected boolean doParseTupleType() {
        boolean bl;
        boolean result = true;
        boolean bl2 = bl = this.builder.getTokenType() == JSTokenTypes.LBRACKET;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected && !JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.tuple.comma.or.rbracket")) {
                result = false;
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(this.getTypeNameExpectedMessage());
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) break;
            if (!this.parseTupleTypeMember()) {
                result = false;
                break;
            }
            commaExpected = true;
        }
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            result = false;
        }
        return result;
    }

    private final boolean parseTupleTypeMember() {
        boolean isSpread;
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker element = marker;
        boolean bl = isSpread = this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT;
        if (isSpread) {
            this.builder.advanceLexer();
        }
        if (this.isTupleElementName()) {
            boolean bl2;
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
            boolean bl3 = bl2 = this.builder.getTokenType() == JSTokenTypes.COLON;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.builder.advanceLexer();
            if (!this.parseType()) {
                element.drop();
                return false;
            }
        } else {
            if (!this.parseType()) {
                element.drop();
                return false;
            }
            if (!isSpread && this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
        }
        element.done(BasicTypeScriptElementTypes.TUPLE_MEMBER_ELEMENT);
        return true;
    }

    private final boolean isTupleElementName() {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType()) && this.isStartOfType() && this.isNextTokenColonOrQuestionColon();
    }

    private final boolean isNextTokenColonOrQuestionColon() {
        IElementType type = this.builder.lookAhead(1);
        return type == JSTokenTypes.COLON || type == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON;
    }

    public boolean parseObjectType() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return false;
        }
        return this.parseObjectType(JSTokenTypes.RBRACE, "javascript.parser.message.missing.rbrace");
    }

    public final boolean parseMappedType() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        boolean result = this.parseMappedTypeNoMarker();
        mark.done(BasicTypeScriptElementTypes.MAPPED_TYPE);
        return result;
    }

    protected final boolean isStartOfMappedType() {
        int startCheckIndex = 1;
        IElementType type = this.builder.lookAhead(1);
        if (type == JSTokenTypes.PLUS || type == JSTokenTypes.MINUS) {
            type = this.builder.lookAhead(2);
            ++startCheckIndex;
        }
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            ++startCheckIndex;
        }
        IElementType iElementType = this.builder.lookAhead(startCheckIndex);
        if (iElementType == null) {
            return false;
        }
        IElementType nextToken = iElementType;
        if (nextToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType afterNext = this.builder.lookAhead(startCheckIndex + 1);
        if (!this.isIdentifierToken(afterNext)) {
            return false;
        }
        return this.builder.lookAhead(startCheckIndex + 2) == JSTokenTypes.IN_KEYWORD;
    }

    protected final boolean parseMappedTypeNoMarker() {
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        boolean mustHaveReadonly = false;
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveReadonly = true;
        }
        if (!mustHaveReadonly && this.builder.getTokenType() == JSTokenTypes.READONLY_KEYWORD) {
            this.builder.advanceLexer();
        }
        if (mustHaveReadonly && !JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.READONLY_KEYWORD, "javascript.parser.message.expected.readonly")) {
            return false;
        }
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.LBRACKET, "javascript.parser.message.expected.lbracket")) {
            return false;
        }
        if (!this.parseMappedTypeParameter()) {
            return false;
        }
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            return false;
        }
        boolean mustHaveQuestion = false;
        tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveQuestion = true;
        }
        if (!mustHaveQuestion && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (mustHaveQuestion && !JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.QUEST, "javascript.parser.message.expected.question")) {
            return false;
        }
        this.tryParseType();
        ((ES6Parser)this.parser).getStatementParser().forceCheckForSemicolon();
        return JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
    }

    protected final boolean parseMappedTypeParameter() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker parameter = marker;
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            parameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.IN_KEYWORD, "javascript.parser.message.expected.in")) {
            parameter.drop();
            return false;
        }
        boolean result = this.parseType();
        if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
            this.builder.advanceLexer();
            result &= this.parseType();
        }
        parameter.done(BasicTypeScriptElementTypes.MAPPED_TYPE_PARAMETER);
        return result;
    }

    protected final boolean parseObjectType(@NotNull IElementType rBraceType, @PropertyKey(resourceBundle="messages.JavaScriptParserBundle") @NotNull String missingRBraceMessageKey) {
        Intrinsics.checkNotNullParameter((Object)rBraceType, (String)"rBraceType");
        Intrinsics.checkNotNullParameter((Object)missingRBraceMessageKey, (String)"missingRBraceMessageKey");
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker marker2 = marker;
        IElementType lBraceType = this.builder.getTokenType();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != rBraceType) {
            if (this.builder.eof() || this.builder.getTokenType() == lBraceType) {
                this.builder.error(JavaScriptParserBundle.message(missingRBraceMessageKey, new Object[0]));
                marker2.done(BasicTypeScriptElementTypes.OBJECT_TYPE);
                return false;
            }
            this.parseTypeMember();
        }
        this.builder.advanceLexer();
        marker2.done(BasicTypeScriptElementTypes.OBJECT_TYPE);
        return true;
    }

    protected boolean parseTypeMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker typeMember = marker;
        this.parser.parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return this.parseTypeMember(typeMember);
    }

    protected final boolean parseTypeMember(@NotNull PsiBuilder.Marker typeMember) {
        Intrinsics.checkNotNullParameter((Object)typeMember, (String)"typeMember");
        boolean result = false;
        IElementType firstToken = this.builder.getTokenType();
        if (this.isFunctionHeaderStart(firstToken) || firstToken == JSTokenTypes.NEW_KEYWORD && this.isFunctionHeaderStart(this.builder.lookAhead(1))) {
            result = this.parseFunctionHeaderNoMarker(typeMember, JSElementTypes.CALL_SIGNATURE);
        } else if ((firstToken == JSTokenTypes.GET_KEYWORD || firstToken == JSTokenTypes.SET_KEYWORD) && JSKeywordSets.PROPERTY_NAMES.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker attributeList = marker;
            this.builder.advanceLexer();
            attributeList.done(JSElementTypes.ATTRIBUTE_LIST);
            ((ES6Parser)this.parser).getExpressionParser().advancePropertyName(this.builder.getTokenType());
            result = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            ((ES6Parser)this.parser).getExpressionParser().advancePropertyName(firstToken);
            result = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            if (this.isIndexSignatureProperty()) {
                result = this.parseIndexSignatureNoMarker(typeMember, false);
            } else {
                this.parseTypeMemberPropertyName();
                result = this.parseInterfaceSimplePropertyOrFunction(typeMember);
            }
        } else if (firstToken == JSTokenTypes.COLON || firstToken == JSTokenTypes.QUEST) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.member", new Object[0]));
            this.parseInterfaceSimplePropertyOrFunction(typeMember);
            result = false;
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.member", new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result = false;
        }
        this.forceCheckForSemicolonOrComma();
        return result;
    }

    protected void parseTypeMemberPropertyName() {
        ((ES6Parser)this.parser).getExpressionParser().parsePropertyName();
    }

    protected final boolean isFunctionHeaderStart(@Nullable IElementType token) {
        return token == JSTokenTypes.LPAR || token == JSTokenTypes.LT;
    }

    protected final void forceCheckForSemicolonOrComma() {
        boolean checkForComma;
        boolean checkForSemicolon = ((ES6Parser)this.parser).getStatementParser().checkForSemicolon();
        if (!(checkForSemicolon || (checkForComma = this.checkForComma()) || JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder))) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.newline.or.semicolon", new Object[0]));
        }
    }

    private final boolean checkForComma() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public final boolean parseInterfaceSimplePropertyOrFunction(@NotNull PsiBuilder.Marker typeMember) {
        Intrinsics.checkNotNullParameter((Object)typeMember, (String)"typeMember");
        if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (this.isFunctionHeaderStart(this.builder.getTokenType())) {
            this.parseFunctionHeaderNoMarker(typeMember, this.getFunctionSignatureElementType());
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.tryParseObjectMemberType();
            }
            typeMember.done(this.getPropertySignatureElementType());
            typeMember.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        return true;
    }

    @NotNull
    protected IElementType getPropertySignatureElementType() {
        return BasicTypeScriptElementTypes.PROPERTY_SIGNATURE;
    }

    protected boolean tryParseObjectMemberType() {
        return this.tryParseType();
    }

    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        return JSElementTypes.FUNCTION_SIGNATURE;
    }

    public boolean isIndexSignatureProperty() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType secondToken = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(secondToken)) {
            return false;
        }
        IElementType thirdToken = this.builder.lookAhead(2);
        return thirdToken == JSTokenTypes.COLON;
    }

    private final boolean parseFunctionHeaderNoMarker(PsiBuilder.Marker marker, IElementType elementType) {
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean bl = this.isFunctionHeaderStart(this.builder.getTokenType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean result = this.parseFunctionParameterList();
        boolean bl2 = this.builder.getTokenType() != JSTokenTypes.COLON || this.tryParseType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result &= bl2;
    }

    protected boolean parseFunctionParameterList() {
        return !((ES6Parser)this.parser).getFunctionParser().parseParameterList((boolean)false).hasErrors;
    }

    public boolean parseIndexSignatureNoMarker(@NotNull PsiBuilder.Marker marker, boolean checkSemicolon) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        return Companion.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.parser, checkSemicolon, true);
    }

    protected final boolean isStartOfType() {
        return this.isStartOfType(this.builder.getTokenType(), 0);
    }

    protected final boolean isStartOfType(@Nullable IElementType type, int startIndex) {
        if (type == null) {
            return false;
        }
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || JSKeywordSets.PRIMITIVE_TYPES.contains(type) || JSTokenTypes.IMPORT_KEYWORD == type || JSTokenTypes.THIS_KEYWORD == type || JSTokenTypes.TYPEOF_KEYWORD == type || JSTokenTypes.NEW_KEYWORD == type || JSTokenTypes.STRING_LITERAL == type || JSTokenTypes.NUMERIC_LITERAL == type || JSTokenTypes.TRUE_KEYWORD == type || JSTokenTypes.FALSE_KEYWORD == type || JSTokenTypes.LBRACE == type || JSTokenTypes.LBRACKET == type || JSTokenTypes.LT == type || JSTokenTypes.OR == type || JSTokenTypes.AND == type || JSTokenTypes.BACKQUOTE == type) {
            return true;
        }
        if (JSTokenTypes.MINUS == type && this.builder.lookAhead(startIndex + 1) == JSTokenTypes.NUMERIC_LITERAL) {
            return true;
        }
        if (type == JSTokenTypes.LPAR) {
            if (this.isFunctionTypeExpected(startIndex)) {
                return true;
            }
            IElementType lookAheadElement = this.builder.lookAhead(startIndex + 1);
            if (lookAheadElement == JSTokenTypes.RPAR) {
                return true;
            }
            return this.isStartOfType(lookAheadElement, startIndex + 1);
        }
        return this.isIdentifierToken(type);
    }

    @Override
    public boolean tryParseTypeParameterList() {
        boolean result = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker typeParameterList = marker;
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first && !JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                    typeParameterList.drop();
                    return false;
                }
                if (!first && this.builder.getTokenType() == JSTokenTypes.GT) break;
                boolean typeParameterParsed = this.parseTypeParameter();
                result &= typeParameterParsed;
                if (!typeParameterParsed) {
                    this.builder.advanceLexer();
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeParameterList.done(BasicTypeScriptElementTypes.TYPE_PARAMETER_LIST);
        }
        return result;
    }

    public boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType()) && !JSTokenTypes.TYPE_PARAMETER_MODIFIERS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
            return false;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker typeParameter = marker;
        if (JSTokenTypes.TYPE_PARAMETER_MODIFIERS.contains(this.builder.getTokenType())) {
            this.parser.parseModifiers(TYPE_PARAMETER_MODIFIERS_STRUCTURE, true, this.AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE);
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.builder.advanceLexer();
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            PsiBuilder.Marker constraint = marker2;
            this.parseType();
            constraint.done(BasicTypeScriptElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            PsiBuilder.Marker marker3 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker3, (String)"mark(...)");
            PsiBuilder.Marker defaultType = marker3;
            this.parseType();
            defaultType.done(BasicTypeScriptElementTypes.TYPE_PARAMETER_DEFAULT);
        }
        typeParameter.done(BasicTypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    public final boolean parseOptionalTypeArgumentListInExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            IElementType tokenType;
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker marker2 = marker;
            if (this.tryParseTypeArgumentList(true, false, true) && this.isAcceptableTokenTypeAfterTypeArguments(tokenType = this.builder.getTokenType())) {
                marker2.drop();
                return true;
            }
            marker2.rollbackTo();
        }
        return false;
    }

    protected final boolean isAcceptableTokenTypeAfterTypeArguments(@Nullable IElementType tokenType) {
        if (tokenType == null || tokenType == JSTokenTypes.LPAR || tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
            return true;
        }
        if (tokenType == JSTokenTypes.LT || tokenType == JSTokenTypes.GT || tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            return false;
        }
        if (JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder)) {
            return true;
        }
        if (tokenType == JSTokenTypes.QUEST_QUEST || tokenType == JSTokenTypes.OROR || tokenType == JSTokenTypes.ANDAND || tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.XOR || tokenType == JSTokenTypes.AND || tokenType == JSTokenTypes.EQEQ || tokenType == JSTokenTypes.NE || tokenType == JSTokenTypes.EQEQEQ || tokenType == JSTokenTypes.NEQEQ || tokenType == JSTokenTypes.LE || tokenType == JSTokenTypes.GE || tokenType == JSTokenTypes.INSTANCEOF_KEYWORD || tokenType == JSTokenTypes.IN_KEYWORD || tokenType == JSTokenTypes.AS_KEYWORD || tokenType == JSTokenTypes.SATISFIES_KEYWORD || tokenType == JSTokenTypes.LTLT || tokenType == JSTokenTypes.GTGT || tokenType == JSTokenTypes.GTGTGT || tokenType == JSTokenTypes.MULT || tokenType == JSTokenTypes.DIV || tokenType == JSTokenTypes.PERC || tokenType == JSTokenTypes.MULTMULT) {
            return true;
        }
        if (tokenType == JSTokenTypes.SUPER_KEYWORD || tokenType == JSTokenTypes.NULL_KEYWORD || tokenType == JSTokenTypes.TRUE_KEYWORD || tokenType == JSTokenTypes.FALSE_KEYWORD || tokenType == JSTokenTypes.NUMERIC_LITERAL || tokenType == JSTokenTypes.STRING_LITERAL || tokenType == JSTokenTypes.STRING_LITERAL_PART || tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.CLASS_KEYWORD || tokenType == JSTokenTypes.NEW_KEYWORD || tokenType == JSTokenTypes.DIVEQ || tokenType == JSTokenTypes.IDENTIFIER || tokenType == JSTokenTypes.IMPORT_KEYWORD && (this.builder.lookAhead(1) == JSTokenTypes.LPAR || this.builder.lookAhead(1) == JSTokenTypes.LT || this.builder.lookAhead(1) == JSTokenTypes.DOT)) {
            return false;
        }
        return tokenType != JSTokenTypes.TILDE && tokenType != JSTokenTypes.EXCL && tokenType != JSTokenTypes.DELETE_KEYWORD && tokenType != JSTokenTypes.TYPEOF_KEYWORD && tokenType != JSTokenTypes.VOID_KEYWORD && tokenType != JSTokenTypes.PLUSPLUS && tokenType != JSTokenTypes.MINUSMINUS && tokenType != JSTokenTypes.AWAIT_KEYWORD && tokenType != JSTokenTypes.YIELD_KEYWORD && tokenType != JSTokenTypes.PRIVATE_IDENTIFIER;
    }

    @Override
    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine, boolean isExpression) {
        boolean result = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT && (allowNewLine || !JavaScriptParserBase.Companion.hasLineTerminatorBefore(this.builder))) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker typeArgumentList = marker;
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first) {
                    if (!JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                        if (revert) {
                            typeArgumentList.rollbackTo();
                        } else {
                            typeArgumentList.drop();
                        }
                        return false;
                    }
                    if (this.builder.getTokenType() == JSTokenTypes.GT) {
                        if (this.allowTypeArgumentsTrailingComma()) break;
                        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                        break;
                    }
                }
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    if (first) {
                        first = false;
                    }
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                    continue;
                }
                if (!(result &= this.parseTypeInGenericArgument()) && revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                first = false;
            }
            if (isExpression) {
                ES6ExpressionParser.Companion.collapseGtAndGetPriority(true, this.builder);
            }
            if (this.builder.getTokenType() != JSTokenTypes.GT) {
                if (revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.gt", new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
            typeArgumentList.done(BasicTypeScriptElementTypes.TYPE_ARGUMENT_LIST);
        }
        return result;
    }

    protected boolean allowTypeArgumentsTrailingComma() {
        return false;
    }

    public final boolean parseTypeInGenericArgument() {
        boolean result2;
        block1: {
            PsiBuilder.Marker outer = null;
            if (this.isIdentifierToken(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.EQ) {
                outer = this.builder.mark();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
            }
            result2 = this.parseType();
            PsiBuilder.Marker marker = outer;
            if (marker == null) break block1;
            marker.done(BasicTypeScriptElementTypes.NAMED_GENERIC_ARG);
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.equal", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @NotNull
    protected IElementType getSingleTypeElementType() {
        return BasicTypeScriptElementTypes.SINGLE_TYPE;
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        return JavaScriptParserBundle.message("javascript.parser.message.expected.typename", new Object[0]);
    }

    private static final boolean AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE$lambda$0(TypeScriptPsiTypeParser this$0, PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this$0.isIdentifierToken(builder.getTokenType());
    }

    private static final boolean AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE$lambda$0(PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType type = builder.getTokenType();
        return type == null || type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON || type == JSTokenTypes.QUEST || type == JSTokenTypes.COLON || type == JSTokenTypes.LPAR ? false : !JavaScriptParserBase.Companion.hasLineTerminatorBefore(builder);
    }

    @JvmStatic
    public static final boolean parseIndexSignatureNoMarker(@NotNull PsiBuilder.Marker marker, @NotNull PsiBuilder builder, @NotNull ES6Parser parser, boolean checkSemicolon, boolean requireVarName) {
        return Companion.parseIndexSignatureNoMarker(marker, builder, parser, checkSemicolon, requireVarName);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptPsiTypeParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.VOID_KEYWORD, JSTokenTypes.ANY_KEYWORD, JSTokenTypes.SYMBOL_KEYWORD, JSTokenTypes.NEVER_KEYWORD, JSTokenTypes.UNKNOWN_KEYWORD, JSTokenTypes.OBJECT_TYPE_KEYWORD, JSTokenTypes.MIXED_KEYWORD, JSTokenTypes.NULL_KEYWORD, JSTokenTypes.INTRINSIC_KEYWORD};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        NON_REFERENCE_PRIMITIVE_TYPES = tokenSet;
        Key key = Key.create((String)"conditional.type.allowed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_CONDITIONAL_TYPE_ALLOWED = key;
        AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE = TypeScriptPsiTypeParser::AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE$lambda$0;
        TYPE_MEMBER_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.READONLY_KEYWORD, false, 2, null);
        iElementTypeArray = new IElementType[]{JSTokenTypes.CONST_KEYWORD, JSTokenTypes.IN_KEYWORD, JSTokenTypes.OUT_KEYWORD};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        TYPE_PARAMETER_MODIFIERS_STRUCTURE = new JSUnorderedModifiersStructure(tokenSet2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NON_REFERENCE_PRIMITIVE_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "IS_CONDITIONAL_TYPE_ALLOWED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE", "Ljava/util/function/Predicate;", "Lcom/intellij/lang/PsiBuilder;", "TYPE_MEMBER_MODIFIERS", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "parseIndexSignatureNoMarker", "marker", "Lcom/intellij/lang/PsiBuilder$Marker;", "builder", "parser", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "checkSemicolon", "requireVarName", "TYPE_PARAMETER_MODIFIERS_STRUCTURE", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final boolean parseIndexSignatureNoMarker(@NotNull PsiBuilder.Marker marker, @NotNull PsiBuilder builder, @NotNull ES6Parser parser, boolean checkSemicolon, boolean requireVarName) {
            boolean hasColon;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            boolean bl2 = bl = builder.getTokenType() == JSTokenTypes.LBRACKET;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            builder.advanceLexer();
            boolean bl3 = hasColon = builder.lookAhead(1) == JSTokenTypes.COLON;
            if (hasColon && requireVarName && !parser.isIdentifierToken(builder.getTokenType())) {
                builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                marker.drop();
                return false;
            }
            boolean result = false;
            FunctionParser.MethodEmptiness data = (FunctionParser.MethodEmptiness)((Object)builder.getUserData(FunctionParser.methodsEmptinessKey));
            try {
                builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)(hasColon ? FunctionParser.MethodEmptiness.POSSIBLY : FunctionParser.MethodEmptiness.ALWAYS));
                FunctionParser functionParser = parser.getFunctionParser();
                PsiBuilder.Marker marker2 = builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                result = functionParser.parseSingleParameter(marker2);
            }
            finally {
                builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)data);
            }
            if (builder.getTokenType() != JSTokenTypes.RBRACKET) {
                builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                marker.done(BasicTypeScriptElementTypes.INDEX_SIGNATURE);
                marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                return result;
            }
            builder.advanceLexer();
            result &= builder.getTokenType() != JSTokenTypes.COLON || parser.getTypeParser().tryParseType();
            if (checkSemicolon) {
                parser.getStatementParser().forceCheckForSemicolon();
            }
            marker.done(BasicTypeScriptElementTypes.INDEX_SIGNATURE);
            marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

