/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.StubIndexSupport;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.index.JSPackageIndexSupport;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionScriptResolveUtil {
    public static final String AS3_NAMESPACE = "AS3";
    @NonNls
    private static final String SCRIPT_TAG_NAME = "Script";
    public static final String ADD_EVENT_LISTENER_METHOD = "addEventListener";
    public static final String REMOVE_EVENT_LISTENER_METHOD = "removeEventListener";
    private static final List<Class<? extends JSElement>> ANONYMOUS_EVENT_LISTENER_CLASSES = Arrays.asList(JSFunctionExpression.class, JSParenthesizedExpression.class, JSCallExpression.class, JSExpressionStatement.class, JSFile.class);
    private static final TokenSet mainDeclaredElementTokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{ActionScriptElementTypes.ACTIONSCRIPT_CLASS, ActionScriptElementTypes.ACTIONSCRIPT_FUNCTION, ActionScriptElementTypes.NAMESPACE_DECLARATION}), BasicTypeScriptElementTypes.VAR_STATEMENTS});
    @NonNls
    public static final String FLASH_EVENTS_IEVENT_DISPATCHER = "flash.events.IEventDispatcher";

    public static boolean isAnonymousEventHandlerTag(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlText && !SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName());
    }

    public static boolean isAnonymousEventHandlerAttribute(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlAttributeValue;
    }

    public static boolean isAnonymousEventHandler(JSFunctionExpression expr) {
        JSFile file = (JSFile)ActionScriptResolveUtil.iterateUp(expr, ANONYMOUS_EVENT_LISTENER_CLASSES);
        return file != null && (ActionScriptResolveUtil.isAnonymousEventHandlerTag(file) || ActionScriptResolveUtil.isAnonymousEventHandlerAttribute(file));
    }

    public static boolean isInsideAnonymousEventHandler(PsiElement element) {
        return ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(element, new ConstantFunction((Object)Boolean.TRUE)) != null;
    }

    @Nullable
    public static <T> T computeIfInsideAnonymousEventHandler(PsiElement psiElement, Function<? super JSFunctionExpression, ? extends T> function) {
        while (psiElement instanceof JSExpression) {
            psiElement = psiElement.getParent();
        }
        if (psiElement instanceof JSArgumentList) {
            JSExpression methodExpression = ((JSCallExpression)psiElement.getParent()).getMethodExpression();
            if (methodExpression instanceof JSParenthesizedExpression) {
                methodExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression();
            }
            if (methodExpression instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)methodExpression)) {
                return (T)function.fun((Object)((JSFunctionExpression)methodExpression));
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement iterateUp(PsiElement element, List<Class<? extends JSElement>> classes) {
        Iterator<Class<? extends JSElement>> i = classes.iterator();
        while (i.hasNext()) {
            if (element == null || !i.next().isInstance(element)) {
                return null;
            }
            if (!i.hasNext()) continue;
            element = element.getParent();
        }
        return element;
    }

    public static <E extends PsiElement> void processIncludedFiles(TokenSet filter, JSFile file, List<? super E> result, Collection<? super JSFile> visited) {
        if (visited.contains(file)) {
            return;
        }
        visited.add(file);
        for (PsiElement element : JSResolveUtil.getStubbedChildren(file, filter)) {
            if (element instanceof JSIncludeDirective) {
                PsiFile includedFile = ((JSIncludeDirective)element).resolveFile();
                if (!(includedFile instanceof JSFile)) continue;
                ActionScriptResolveUtil.processIncludedFiles(filter, (JSFile)includedFile, result, visited);
                continue;
            }
            result.add(element);
        }
    }

    public static boolean isImplicitlyDeclaringEventDispatcher(JSAttributeList attributeList) {
        return attributeList != null && attributeList.getAttributesByName("Bindable").length != 0;
    }

    public static String replaceInternalName(String name) {
        return "Vector$object".equals(name) ? "Vector" : name;
    }

    public static boolean checkProcessFunctionPreconditions(@NotNull JSFunction function, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        JSResolveProcessorEx processorEx;
        boolean resolvingNewExpressionInOtherASClass;
        if (function == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(1);
        }
        if (state == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(3);
        }
        if (!Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT)) && ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass(function)) {
            return true;
        }
        boolean bl = resolvingNewExpressionInOtherASClass = DialectDetector.isActionScript((PsiElement)function.getContainingFile()) && processor instanceof JSResolveProcessorEx && (processorEx = (JSResolveProcessorEx)processor).isTypeContext() && place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression && JSResolveUtil.getClassOfContext(place) != JSResolveUtil.getClassOfContext(function);
        return resolvingNewExpressionInOtherASClass && function.isConstructor();
    }

    public static boolean hasExcludeClassMetadata(@NotNull JSAttributeListOwner attributeListOwner) {
        JSAttributeList attributeList;
        if (attributeListOwner == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(4);
        }
        return (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.findAttributeByName("ExcludeClass") != null;
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor) {
        return ActionScriptResolveUtil.processMetaAttributesForClass(jsClass, processor, true);
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, boolean withIncludedFiles) {
        return ActionScriptResolveUtil.doProcessMetaAttributesForClass(jsClass, processor, null, true, withIncludedFiles);
    }

    private static boolean doProcessMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, PsiElement lastParent, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements;
        if (jsClass instanceof JSClass) {
            PsiElement current;
            int ind;
            if ("Object".equals(((JSClass)jsClass).getQualifiedName())) {
                return true;
            }
            elements = JSResolveUtil.getStubbedChildren(jsClass.getContext());
            for (ind = elements.length - 1; ind >= 0 && elements[ind] != jsClass; --ind) {
            }
            --ind;
            while (ind >= 0 && (current = elements[ind]) instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, jsClass, (JSIncludeDirective)current, false)) {
                    return false;
                }
                --ind;
            }
            JSAttributeList attributeList = ((JSClass)jsClass).getAttributeList();
            if (attributeList != null && !ActionScriptResolveUtil.processAttributeList(processor, jsClass, attributeList, true, withIncludedFiles)) {
                return false;
            }
        }
        elements = JSResolveUtil.getStubbedChildren(jsClass);
        Ref continuePassElement = new Ref();
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement el = elements[i];
            if (el instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, lastParent, (JSIncludeDirective)el, forward)) {
                    return false;
                }
            } else if (el instanceof JSAttributeList) {
                if (!ActionScriptResolveUtil.processAttributeList(processor, lastParent, (JSAttributeList)el, forward, withIncludedFiles)) {
                    return false;
                }
            } else {
                JSAttributeList attributeList;
                continuePassElement.set(null);
                if (!processor.handleOtherElement(el, jsClass, (Ref<PsiElement>)continuePassElement)) {
                    return false;
                }
                PsiElement nextEl = (PsiElement)continuePassElement.get();
                if (nextEl instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)nextEl).getAttributeList()) != null && !ActionScriptResolveUtil.processAttributeList(processor, nextEl, attributeList, forward, withIncludedFiles)) {
                    return false;
                }
            }
            i += forward ? 1 : -1;
        }
        return true;
    }

    private static boolean processIncludeDirective(MetaDataProcessor processor, PsiElement lastParent, JSIncludeDirective el, boolean forward) {
        PsiFile file = el.resolveFile();
        return !(file instanceof JSFile) || ActionScriptResolveUtil.doProcessMetaAttributesForClass((PsiElement)file, processor, lastParent, forward, true);
    }

    public static boolean processAttributeList(MetaDataProcessor processor, PsiElement el, JSAttributeList attributeList, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements = JSResolveUtil.getStubbedChildren((PsiElement)attributeList);
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement cur = elements[i];
            if (cur instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, el, (JSIncludeDirective)cur, forward)) {
                    return false;
                }
            } else if (cur instanceof JSAttribute) {
                if (!processor.process((JSAttribute)cur)) {
                    return false;
                }
            } else if (cur instanceof JSNamedElement) break;
            i += forward ? 1 : -1;
        }
        return processor.handleOtherElement((PsiElement)attributeList, el, null);
    }

    public static boolean fieldIsImplicitAccessorMethod(JSFunction fun, JSVariable var) {
        JSAttributeList clazzAttributeList;
        if (!fun.isGetProperty() && !fun.isSetProperty()) {
            return false;
        }
        PsiElement funParent = JSResolveUtil.findParent(fun);
        if (!(funParent instanceof JSClass) || !((JSClass)funParent).isInterface()) {
            return false;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)var);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSClass clazz = (JSClass)parent;
        JSAttributeList attributeList = var.getAttributeList();
        if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        if (attributeList.findAttributeByName("Bindable") == null && ((clazzAttributeList = clazz.getAttributeList()) == null || clazzAttributeList.findAttributeByName("Bindable") == null)) {
            return false;
        }
        for (JSClass c : clazz.getImplementedInterfaces()) {
            if (c != funParent) continue;
            return true;
        }
        return false;
    }

    public static boolean weShouldSkipResolveBecauseOfImplicitClass(PsiElement elt) {
        if (elt == null) {
            return false;
        }
        PsiElement responsibleElement = elt instanceof JSFile ? elt : elt.getParent();
        return responsibleElement instanceof JSFile && DialectDetector.isActionScript(responsibleElement) && responsibleElement.getContext() != null;
    }

    public static String findPackageForMxml(PsiElement expression) {
        String s = null;
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile.getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4 && containingFile.getContext() != null) {
            PsiFile contextContainingFile = containingFile.getContext().getContainingFile();
            VirtualFile file = contextContainingFile.getOriginalFile().getVirtualFile();
            s = JSResolveUtil.getExpectedPackageNameFromFile(file, containingFile.getProject());
        }
        return s;
    }

    @Nullable
    public static JSNamedElement findMainDeclaredElement(@NotNull PsiFileImpl file) {
        if (file == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(5);
        }
        if (!DialectDetector.isActionScript((PsiElement)file)) {
            return null;
        }
        JSNamedElement mainDeclaredElement = null;
        StubElement stub = file.getStub();
        if (stub != null) {
            StubElement packageStub = stub.findChildStubByElementType(JSElementTypes.PACKAGE_STATEMENT);
            if (packageStub != null) {
                StubElement qualifiedElement = packageStub.findChildStubByElementType((IElementType)ActionScriptElementTypes.ACTIONSCRIPT_CLASS);
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByElementType(ActionScriptElementTypes.ACTIONSCRIPT_FUNCTION);
                }
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByElementType(ActionScriptElementTypes.NAMESPACE_DECLARATION);
                }
                if (qualifiedElement == null && (qualifiedElement = packageStub.findChildStubByElementType(JSElementTypes.VAR_STATEMENT)) != null) {
                    qualifiedElement = qualifiedElement.findChildStubByElementType((IElementType)ActionScriptElementTypes.ACTIONSCRIPT_VARIABLE);
                }
                if (qualifiedElement != null) {
                    mainDeclaredElement = (JSNamedElement)qualifiedElement.getPsi();
                }
            }
        } else {
            JSPackageStatement statement = (JSPackageStatement)file.findChildByClass(JSPackageStatement.class);
            if (statement != null) {
                ASTNode node = statement.getNode().findChildByType(mainDeclaredElementTokenSet);
                if (node != null && node.getElementType() == JSElementTypes.VAR_STATEMENT) {
                    node = node.findChildByType((IElementType)ActionScriptElementTypes.ACTIONSCRIPT_VARIABLE);
                }
                if (node != null) {
                    mainDeclaredElement = (JSNamedElement)node.getPsi();
                }
            }
        }
        return mainDeclaredElement;
    }

    public static boolean isSpecialCallResolveCaseEcmaScript(PsiElement place, PsiElement lastParent) {
        return lastParent instanceof JSCallExpression && place instanceof JSReferenceExpression && ((JSCallExpression)lastParent).getMethodExpression() == place && ((JSReferenceExpression)place).getQualifier() == null && lastParent.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
    }

    public static boolean isFileLocalSymbol(PsiElement element) {
        JSAttributeList attrList;
        if (element instanceof XmlBackedJSClass) {
            return false;
        }
        JSPackageStatement packageStatement = (JSPackageStatement)PsiTreeUtil.getContextOfType((PsiElement)element, JSPackageStatement.class, (boolean)false);
        if (packageStatement != null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (file.getLanguage() != FlexSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        if (file.getContext() != null) {
            return false;
        }
        String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
        JSAttributeList jSAttributeList = attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (attrList != null) {
            if (attrList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return !attrList.hasModifier(JSAttributeList.ModifierType.NATIVE) && (qName == null || qName.indexOf(46) == -1);
            }
            if (ActionScriptPsiImplUtil.getNamespace(attrList) != null || qName != null && qName.indexOf(46) != -1) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static JSResolveUtil.AssignableTypeStatus isAssignableTypeStatus(@NonNls String _expectedType, @NonNls String _type, @Nullable PsiElement context) {
        boolean nonecma;
        String expectedType = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_expectedType));
        String type = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_type));
        if (expectedType != null && JSResolveUtil.hasMultipleOccurenceDelimiters(expectedType) || type != null && JSResolveUtil.hasMultipleOccurenceDelimiters(type)) {
            StringTokenizer expectedTypeIterator = new StringTokenizer(expectedType != null ? expectedType : "", "|/");
            while (expectedTypeIterator.hasMoreElements()) {
                String primitiveExpectedType = expectedTypeIterator.nextToken().trim();
                StringTokenizer typeIterator = new StringTokenizer(type != null ? type : "", "|/");
                while (typeIterator.hasMoreElements()) {
                    String primitiveType = typeIterator.nextToken().trim();
                    JSResolveUtil.AssignableTypeStatus state = ActionScriptResolveUtil.isAssignableTypeStatus(primitiveExpectedType, primitiveType, context);
                    if (state == JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL) continue;
                    return state;
                }
            }
            return JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedType == null || expectedType.equals("*") || expectedType.equals("Object")) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if (expectedType.equals(type)) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        boolean bl = nonecma = context != null && context.getContainingFile().getLanguage() != FlexSupportLoader.ECMA_SCRIPT_L4;
        if (nonecma && type != null && JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(type) && expectedType.startsWith("function")) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(type);
        JSResolveUtil.GenericSignature expectedSignature = JSResolveUtil.extractGenericSignature(expectedType);
        if (expectedSignature != null && signature != null) {
            return ActionScriptResolveUtil.isAssignableTypeStatus(expectedSignature.elementType, signature.elementType, context) == JSResolveUtil.AssignableTypeStatus.OK && expectedSignature.genericType.equals(signature.genericType) ? JSResolveUtil.AssignableTypeStatus.OK : JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedSignature != null) {
            if (nonecma && expectedSignature.elementType.equals(type)) {
                return JSResolveUtil.AssignableTypeStatus.OK;
            }
            return "*".equals(type) ? JSResolveUtil.AssignableTypeStatus.OK : JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (signature != null) {
            return ActionScriptResolveUtil.isAssignableTypeStatus(expectedType, signature.elementType, context);
        }
        if ("Number".equals(expectedType) && ("int".equals(type) || "uint".equals(type))) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("int".equals(expectedType) && ("Number".equals(type) || "uint".equals(type))) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("uint".equals(expectedType) && ("int".equals(type) || "Number".equals(type))) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("Array".equals(type) && ("IArguments".equals(expectedType) || expectedType.startsWith("Array") || JSTypeEvaluateManager.isArrayType(expectedType))) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("Array".equals(expectedType) && JSTypeEvaluateManager.isArrayType(type)) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("String".equalsIgnoreCase(expectedType) && (nonecma ? "Number".equalsIgnoreCase(type) || "int".equals(type) || "Boolean".equalsIgnoreCase(type) : "XML".equals(type) || "XMLList".equals(type))) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("void".equals(type)) {
            return JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if ("Boolean".equalsIgnoreCase(expectedType)) {
            return JSResolveUtil.AssignableTypeStatus.LANG_IMPLICIT_COERCION;
        }
        if (("XML".equals(expectedType) || "XMLList".equals(expectedType)) && "Object".equals(type)) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        if ("*".equals(type)) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        PsiElement typeClass = JSResolveUtil.findType(type, context, !nonecma);
        if (!(typeClass instanceof JSClass)) {
            if (nonecma) {
                HashSet visited = new HashSet();
                boolean result = JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, type, (Processor<? super JSType>)((Processor)baseType -> {
                    String qName = JSTypeUtils.getQualifiedNameMatchingType(baseType, false);
                    if (qName != null && !visited.contains(qName)) {
                        visited.add(qName);
                        return !expectedType.equals(qName);
                    }
                    return true;
                }));
                if (!result) {
                    return JSResolveUtil.AssignableTypeStatus.OK;
                }
                return ActionScriptResolveUtil.checkTypedef(context, expectedType, type);
            }
            return JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        boolean result = JSResolveUtil.processHierarchy((JSClass)typeClass, (Processor<? super JSClass>)((Processor)jsClass -> !jsClass.getQualifiedName().equals(expectedType)), true);
        if (!result) {
            return JSResolveUtil.AssignableTypeStatus.OK;
        }
        return ActionScriptResolveUtil.checkTypedef(context, expectedType, type);
    }

    private static JSResolveUtil.AssignableTypeStatus checkTypedef(PsiElement context, String expectedType, String type) {
        JSType typedefType = JSTypeEvaluateManager.getTypedefValue(context, expectedType);
        return typedefType == null ? JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL : ActionScriptResolveUtil.isAssignableTypeStatus(typedefType.getTypeText(), type, context);
    }

    @Deprecated
    public static boolean isAssignableType(@NonNls String expectedType, @NonNls String type, @Nullable PsiElement context) {
        if (context == null) {
            return ActionScriptResolveUtil.isAssignableTypeStatus(expectedType, type, null) != JSResolveUtil.AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        return JSResolveUtil.isAssignableType(expectedType, type, context);
    }

    @Deprecated
    @Contract(value="null, _ -> null")
    @Nullable
    public static String getQualifiedExpressionType(@Nullable JSExpression expression, PsiFile containingFile) {
        JSType type = ActionScriptResolveUtil.getQualifiedExpressionJSType(expression);
        return type == null ? null : ActionScriptResolveUtil.getPresentableType(type, true);
    }

    @Nullable
    public static String getPresentableType(@Nullable JSType type, boolean resolved) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return type.isEcma() || resolved ? "String" : "string";
        }
        return resolved ? type.getResolvedTypeText() : type.getTypeText();
    }

    @Deprecated
    @Nullable
    public static JSClass findClassOfQualifier(JSExpression qualifier, PsiFile containingFile) {
        PsiElement qName;
        String s = ActionScriptResolveUtil.getQualifiedExpressionType(qualifier, containingFile);
        PsiElement psiElement = qName = s != null ? JSClassResolver.findClassFromNamespace(s, (PsiElement)containingFile) : null;
        if (qName instanceof JSClass) {
            return (JSClass)qName;
        }
        return null;
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static JSType getQualifiedExpressionJSType(@Nullable JSExpression expression) {
        if (expression != null) {
            JSType jsType = JSResolveUtil.getExpressionJSType(expression);
            if (jsType instanceof JSCustomElementType && ((JSCustomElementType)jsType).getElement() instanceof JSPackage) {
                return null;
            }
            if (JSTypeUtils.isActionScriptVectorType(jsType)) {
                PsiElement resolve;
                if (expression instanceof JSCallExpression) {
                    expression = ((JSCallExpression)expression).getMethodExpression();
                }
                if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSFunction && !((JSFunction)resolve).isConstructor()) {
                    jsType = JSFunctionImpl.getReturnTypeInContext((JSFunction)resolve, (PsiElement)expression);
                }
            }
            return jsType;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromClass(@NotNull JSReferenceExpression expression, @NotNull JSClass resolveResult) {
        Object parent;
        if (expression == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(6);
        }
        if (resolveResult == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(7);
        }
        if ((parent = expression.getParent()) instanceof JSExpression) {
            parent = JSUtils.unparenthesize((JSExpression)parent);
        }
        String psiElementType = parent instanceof JSReferenceExpression || JSResolveUtil.isExprInStrictTypeContext(expression) || PsiTreeUtil.getChildOfType((PsiElement)expression, JSE4XNamespaceReference.class) != null || parent instanceof JSCallExpression ? resolveResult.getQualifiedName() : "Class";
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, false);
        if (psiElementType != null) {
            JSType namedType = JSNamedTypeFactory.createType(psiElementType, typeSource, JSContext.UNKNOWN);
            return JSTypeUtils.isActionScriptVectorType(namedType) ? JSTypeParser.createType(expression.getProject(), JSImportHandlingUtil.resolveTypeName(expression.getText(), (PsiElement)expression), typeSource) : namedType;
        }
        return null;
    }

    private static boolean processTopPackages(JSResolveProcessorEx processor, ResolveState state, Project project, GlobalSearchScope scope) {
        if (processor.skipTopLevelItems()) {
            return true;
        }
        return JSPackageIndexSupport.getInstance().processElementsInScope("", processor.getName(), (file, name, kind, isPublic) -> {
            if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                return true;
            }
            return processor.execute((PsiElement)new JSPackageWrapper(name, project, scope), state);
        }, scope, project);
    }

    public static boolean shouldProcessTopLevelGlobalContext(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        PsiElement placeParent;
        if (place == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(9);
        }
        return ActionScriptResolveUtil.shouldProcessImports(place, processor) && (!((placeParent = place.getParent()) instanceof JSCallExpression) || place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null && ((JSResolveProcessorEx)processor).needsAllVariants() || placeParent instanceof JSNewExpression);
    }

    public static boolean shouldProcessImports(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (place == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(11);
        }
        if (!(processor instanceof JSResolveProcessorEx) || ((JSResolveProcessorEx)processor).isLocalResolve()) {
            return false;
        }
        return !(place instanceof JSReferenceExpression) || ((JSReferenceExpression)place).getQualifier() == null || ((JSResolveProcessorEx)processor).needsAllVariants();
    }

    public static boolean processGlobalActionScriptThings(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiElement scope) {
        DialectOptionHolder holder;
        if (processor == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(12);
        }
        if (state == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(13);
        }
        if (place == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(15);
        }
        if ((holder = DialectDetector.dialectOfElement(scope)) == null || !(processor instanceof JSResolveProcessorEx)) {
            return true;
        }
        JSResolveProcessorEx processorEx = (JSResolveProcessorEx)processor;
        if (holder.isECMA4 && (ActionScriptResolveUtil.shouldProcessImports(place, processor) || place.getParent() instanceof JSImportStatement && processorEx.getName() == null)) {
            return ActionScriptResolveUtil.processGlobalThings(processorEx, state, place, scope);
        }
        return true;
    }

    public static boolean processGlobalThings(JSResolveProcessorEx processor, ResolveState state, PsiElement place, PsiElement context) {
        boolean result = true;
        Project project = context.getProject();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        PsiElement placeParent = place.getParent();
        if (ActionScriptResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) && (!(place instanceof JSReferenceExpression) || placeParent instanceof JSReferenceExpression || placeParent instanceof JSNamedElement && ActionScriptFunctionImpl.getNamespaceReference((JSNamedElement)placeParent) == place || processor.needPackages() || processor.getName() == null)) {
            result = ActionScriptResolveUtil.processTopPackages(processor, state, project, scope);
        }
        if (result && !processor.needPackages()) {
            boolean refExpr = place instanceof JSReferenceExpression;
            GlobalSymbolsAcceptanceState acceptOnlyClasses = null;
            if (refExpr && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place)) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && processor.getName() == null && JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)place)) {
                acceptOnlyClasses = null;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && placeParent instanceof JSImportStatement && processor.getName() == null) {
                acceptOnlyClasses = null;
            }
            if (placeParent instanceof JSUseNamespaceDirective) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS;
            } else if (placeParent instanceof JSAttributeList && JSResolveUtil.isPlaceWhereNsCanBe(placeParent) || placeParent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(placeParent)) {
                PsiElement parent = JSResolveUtil.findParent(placeParent);
                acceptOnlyClasses = parent instanceof JSExpressionCodeFragment ? GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : (parent instanceof JSClass ? GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS : GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES);
            }
            result = ActionScriptResolveUtil.processTopLevelClasses(processor, state, project, scope, acceptOnlyClasses, true);
        }
        return result;
    }

    public static boolean processTopLevelClasses(JSResolveProcessorEx processor, ResolveState state, Project project, GlobalSearchScope scope, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements) {
        boolean result = true;
        String resolvedName = processor.getName();
        if (resolvedName == null) {
            if (processor.skipTopLevelItems()) {
                return true;
            }
            for (String s : StubIndexSupport.getInstance().getAllKeys(JSIndexKeys.JS_NAME_INDEX_KEY, project)) {
                if (!processor.needTopLevelClassName(s) || "IArguments".equals(s)) continue;
                for (JSQualifiedNamedElement e : StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_NAME_INDEX_KEY, s, project, scope, JSQualifiedNamedElement.class)) {
                    if (e instanceof JSAttributeListOwner && ActionScriptResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)((Object)e)) || !ActionScriptResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.getPlace())) continue;
                    result &= processor.execute((PsiElement)e, state);
                }
            }
        } else {
            for (JSQualifiedNamedElement e : StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, resolvedName, project, scope, JSQualifiedNamedElement.class)) {
                if (StringUtil.equals((CharSequence)e.getName(), (CharSequence)resolvedName) && ActionScriptResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.getPlace()) && !(result = processor.execute((PsiElement)e, state))) break;
            }
        }
        return result;
    }

    public static boolean acceptableSymbol(JSQualifiedNamedElement e, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements, PsiElement place) {
        boolean isNotTopLevel;
        if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES ? !(e instanceof JSClass) : (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES ? e instanceof JSClass : acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS && !(e instanceof JSNamespaceDeclaration) && !(e instanceof JSVariable))) {
            return false;
        }
        String qName = e.getQualifiedName();
        boolean bl = isNotTopLevel = qName != null && qName.indexOf(46) != -1;
        if (!isNotTopLevel && !ActionScriptResolveUtil.isAccessibleSymbol(e, place)) {
            return false;
        }
        if (!acceptQualifiedElements && isNotTopLevel) {
            return false;
        }
        return !(e instanceof JSVariable) && !(e instanceof JSFunction) || DialectDetector.isActionScript((PsiElement)e);
    }

    public static boolean isAccessibleSymbol(JSQualifiedNamedElement subject, PsiElement context) {
        if (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)subject)) {
            return context != null && ActionScriptResolveUtil.isFileLocalSymbolAccessible((PsiElement)subject, context);
        }
        return true;
    }

    private static boolean isFileLocalSymbolAccessible(PsiElement subject, PsiElement context) {
        PsiElement fragmentContext;
        PsiFile contextFile = context.getContainingFile().getOriginalFile();
        if (contextFile instanceof PsiCodeFragment && (fragmentContext = JSResolveUtil.getContext((PsiElement)contextFile)) != null) {
            contextFile = fragmentContext.getContainingFile();
        }
        return subject.getContainingFile() == contextFile;
    }

    public static boolean isAccessibleFromCurrentActionScriptPackage(PsiElement element, String packageName2, PsiElement place) {
        JSAttributeList attrList;
        if (place == null || element != null && !DialectDetector.isActionScript(element)) {
            return true;
        }
        if (packageName2 == null) {
            return false;
        }
        PsiFile containingFile = place.getContainingFile();
        if (place.getParent() instanceof JSReferenceListMember && containingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile) && element instanceof JSAttributeListOwner && (attrList = ((JSAttributeListOwner)element).getAttributeList()) != null && attrList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        if (!ActionScriptResolveUtil.isAccessibleFromActionScriptPackage(element, packageName2)) {
            return (JSResolveUtil.getPackageName(element).isEmpty() || packageName2.isEmpty()) && (ActionScriptResolveUtil.isFileLocalSymbol(element) && ActionScriptResolveUtil.isFileLocalSymbolAccessible(element, place) || ResolveProcessor.toSkipPackageLocalCheck(place));
        }
        return true;
    }

    public static boolean isAccessibleFromActionScriptPackage(@Nullable PsiElement element, @NotNull String forcedPackageName) {
        if (forcedPackageName == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(16);
        }
        if (!(element instanceof JSAttributeListOwner) || !DialectDetector.isActionScript(element)) {
            return true;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PRIVATE && element instanceof JSClass) {
                return false;
            }
            if (!(accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || ActionScriptPsiImplUtil.getNamespace(attributeList) != null || element instanceof JSFunction && ((JSFunction)element).isConstructor() || ActionScriptResolveUtil.isQualifiedAS2Symbol(element))) {
                PsiElement parent = JSResolveUtil.findParent(element);
                if (parent instanceof JSClass ? ((JSClass)parent).isInterface() : !(parent instanceof JSFile) && !(parent instanceof JSPackageStatement)) {
                    return true;
                }
                String packageName2 = JSResolveUtil.getPackageName(element);
                if (!forcedPackageName.equals(packageName2)) {
                    return false;
                }
                if (forcedPackageName.isEmpty() && element instanceof JSClass && ActionScriptResolveUtil.isFileLocalSymbol(element)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isQualifiedAS2Symbol(PsiElement element) {
        String qName;
        return element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.getPackageName((String)qName).isEmpty() && JSResolveUtil.findParent(element) instanceof JSFile;
    }

    public static boolean isAccessibleFromCurrentActionScriptPackage(PsiElement element, PsiElement place) {
        return ActionScriptResolveUtil.isAccessibleFromCurrentActionScriptPackage(element, place != null ? JSResolveUtil.getPackageNameFromPlace(place) : null, place);
    }

    public static boolean isActionScriptClassMemberExceptOverride(@NotNull JSPsiElementBase member) {
        if (member == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(17);
        }
        if (DialectDetector.isActionScript((PsiElement)member) && JSResolveUtil.findParent((PsiElement)member) instanceof JSClass) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = member instanceof JSAttributeListOwner ? ((JSAttributeListOwner)((Object)member)).getAttributeList() : null;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                return true;
            }
        }
        return false;
    }

    public static String buildQualifiedName(String packageName, String className) {
        return (String)(packageName != null && !packageName.isEmpty() ? packageName + "." : "") + className;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeListOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedPackageName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProcessFunctionPreconditions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExcludeClassMetadata";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainDeclaredElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcessTopLevelGlobalContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcessImports";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processGlobalActionScriptThings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessibleFromActionScriptPackage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isActionScriptClassMemberExceptOverride";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface MetaDataProcessor {
        public boolean process(@NotNull JSAttribute var1);

        public boolean handleOtherElement(PsiElement var1, PsiElement var2, @Nullable Ref<PsiElement> var3);
    }

    public static enum GlobalSymbolsAcceptanceState {
        ACCEPT_ONLY_CLASSES,
        ACCEPT_NO_CLASSES,
        ACCEPT_NAMESPACE_DECLARATIONS,
        WHATEVER;

    }
}

