/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.VersionKind;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u001a$\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000f\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u0010\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a.\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u0017\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a*\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u001f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006#"}, d2={"toLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "additionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "checkApiVersionIsNotGreaterThenLanguageVersion", "", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "checkLanguageVersionIsStable", "checkOutdatedVersions", "language", "api", "findOutdatedVersion", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "Lorg/jetbrains/kotlin/cli/common/arguments/VersionKind;", "checkProgressiveMode", "checkExplicitApiAndExplicitReturnTypesAtTheSameTime", "parseOrConfigureLanguageVersion", "parseVersion", "value", "", "versionOf", "configureAnalysisFlags", "", "configureLanguageFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "cli-common"})
@SourceDebugExtension(value={"SMAP\nCommonCompilerArgumentsConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCompilerArgumentsConfigurator.kt\norg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArgumentsConfiguratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n827#2:352\n855#2,2:353\n1563#2:355\n1634#2,3:356\n*S KotlinDebug\n*F\n+ 1 CommonCompilerArgumentsConfigurator.kt\norg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArgumentsConfiguratorKt\n*L\n338#1:352\n338#1:353,2\n338#1:355\n338#1:356,3\n*E\n"})
public final class CommonCompilerArgumentsConfiguratorKt {
    @NotNull
    public static final LanguageVersionSettings toLanguageVersionSettings(@NotNull CommonCompilerArguments $this$toLanguageVersionSettings, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$toLanguageVersionSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        return CommonCompilerArgumentsConfiguratorKt.toLanguageVersionSettings($this$toLanguageVersionSettings, collector, MapsKt.emptyMap());
    }

    @NotNull
    public static final LanguageVersionSettings toLanguageVersionSettings(@NotNull CommonCompilerArguments $this$toLanguageVersionSettings, @NotNull MessageCollector collector, @NotNull Map<AnalysisFlag<?>, ? extends Object> additionalAnalysisFlags) {
        Intrinsics.checkNotNullParameter((Object)$this$toLanguageVersionSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter(additionalAnalysisFlags, (String)"additionalAnalysisFlags");
        LanguageVersion languageVersion = CommonCompilerArgumentsConfiguratorKt.parseOrConfigureLanguageVersion($this$toLanguageVersionSettings, collector);
        LanguageVersion languageVersion2 = CommonCompilerArgumentsConfiguratorKt.parseVersion($this$toLanguageVersionSettings, collector, $this$toLanguageVersionSettings.getApiVersion(), "API");
        if (languageVersion2 == null) {
            languageVersion2 = languageVersion;
        }
        ApiVersion apiVersion2 = ApiVersion.Companion.createByLanguageVersion(languageVersion2);
        CommonCompilerArgumentsConfiguratorKt.checkApiVersionIsNotGreaterThenLanguageVersion($this$toLanguageVersionSettings, languageVersion, apiVersion2, collector);
        LanguageVersionSettingsImpl languageVersionSettings = new LanguageVersionSettingsImpl(languageVersion, apiVersion2, MapsKt.plus(CommonCompilerArgumentsConfiguratorKt.configureAnalysisFlags($this$toLanguageVersionSettings, collector, languageVersion), additionalAnalysisFlags), CommonCompilerArgumentsConfiguratorKt.configureLanguageFeatures($this$toLanguageVersionSettings, collector));
        CommonCompilerArgumentsConfiguratorKt.checkLanguageVersionIsStable($this$toLanguageVersionSettings, languageVersion, collector);
        CommonCompilerArgumentsConfiguratorKt.checkOutdatedVersions($this$toLanguageVersionSettings, languageVersion, apiVersion2, collector);
        CommonCompilerArgumentsConfiguratorKt.checkProgressiveMode($this$toLanguageVersionSettings, languageVersion, collector);
        CommonCompilerArgumentsConfiguratorKt.checkExplicitApiAndExplicitReturnTypesAtTheSameTime($this$toLanguageVersionSettings, collector);
        return languageVersionSettings;
    }

    private static final void checkApiVersionIsNotGreaterThenLanguageVersion(CommonCompilerArguments $this$checkApiVersionIsNotGreaterThenLanguageVersion, LanguageVersion languageVersion, ApiVersion apiVersion2, MessageCollector collector) {
        if (apiVersion2.compareTo(ApiVersion.Companion.createByLanguageVersion(languageVersion)) > 0) {
            if (!$this$checkApiVersionIsNotGreaterThenLanguageVersion.getSuppressApiVersionGreaterThanLanguageVersionError()) {
                MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion2.getVersionString() + ") cannot be greater than -language-version (" + languageVersion.getVersionString() + ')', null, 4, null);
            }
        } else if ($this$checkApiVersionIsNotGreaterThenLanguageVersion.getSuppressApiVersionGreaterThanLanguageVersionError()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.WARNING, "Useless suppress -Xsuppress-api-version-greater-than-language-version-error", null, 4, null);
        }
    }

    public static final void checkLanguageVersionIsStable(@NotNull CommonCompilerArguments $this$checkLanguageVersionIsStable, @NotNull LanguageVersion languageVersion, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$checkLanguageVersionIsStable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (!languageVersion.isStable() && !$this$checkLanguageVersionIsStable.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, "Language version " + languageVersion.getVersionString() + " is experimental, there are no backwards compatibility guarantees for new language and library features", null, 4, null);
        }
    }

    private static final void checkOutdatedVersions(CommonCompilerArguments $this$checkOutdatedVersions, LanguageVersion language2, ApiVersion api, MessageCollector collector) {
        Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> triple = CommonCompilerArgumentsConfiguratorKt.findOutdatedVersion(language2, api);
        if (triple == null) {
            return;
        }
        Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> triple2 = triple;
        LanguageOrApiVersion version2 = (LanguageOrApiVersion)triple2.component1();
        LanguageOrApiVersion supportedVersion = (LanguageOrApiVersion)triple2.component2();
        VersionKind versionKind = (VersionKind)((Object)triple2.component3());
        if (version2.isUnsupported()) {
            StringBuilder stringBuilder = new StringBuilder().append(versionKind.getText()).append(" version ").append(version2.getVersionString()).append(" is no longer supported; please, use version ");
            LanguageOrApiVersion languageOrApiVersion = supportedVersion;
            Intrinsics.checkNotNull((Object)languageOrApiVersion);
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, stringBuilder.append(languageOrApiVersion.getVersionString()).append(" or greater.").toString(), null, 4, null);
        } else if (version2.isDeprecated() && !$this$checkOutdatedVersions.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, versionKind.getText() + " version " + version2.getVersionString() + " is deprecated and its support will be removed in a future version of Kotlin", null, 4, null);
        }
    }

    private static final Triple<LanguageOrApiVersion, LanguageOrApiVersion, VersionKind> findOutdatedVersion(LanguageVersion language2, ApiVersion api) {
        return language2.isUnsupported() ? new Triple((Object)language2, (Object)LanguageVersion.FIRST_SUPPORTED, (Object)VersionKind.LANGUAGE) : (api.isUnsupported() ? new Triple((Object)api, (Object)ApiVersion.FIRST_SUPPORTED, (Object)VersionKind.API) : (language2.isDeprecated() ? new Triple((Object)language2, null, (Object)VersionKind.LANGUAGE) : (api.isDeprecated() ? new Triple((Object)api, null, (Object)VersionKind.API) : null)));
    }

    private static final void checkProgressiveMode(CommonCompilerArguments $this$checkProgressiveMode, LanguageVersion languageVersion, MessageCollector collector) {
        if ($this$checkProgressiveMode.getProgressiveMode() && languageVersion.compareTo((Enum)LanguageVersion.LATEST_STABLE) < 0 && !$this$checkProgressiveMode.getSuppressVersionWarnings()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, "'-progressive' is meaningful only for the latest language version (" + LanguageVersion.LATEST_STABLE + "), while this build uses " + languageVersion + "\nCompiler behavior in such mode is undefined; please, consider moving to the latest stable version or turning off progressive mode.", null, 4, null);
        }
    }

    private static final void checkExplicitApiAndExplicitReturnTypesAtTheSameTime(CommonCompilerArguments $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime, MessageCollector collector) {
        if (Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi(), (Object)ExplicitApiMode.DISABLED.getState()) || Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes(), (Object)ExplicitApiMode.DISABLED.getState())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi(), (Object)$this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes())) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, StringsKt.trimIndent((String)("\n                    '-Xexplicit-api' and '-XXexplicit-return-types' flags cannot have different values at the same time.\n                    Consider use only one of those flags\n                    Passed:\n                      '-Xexplicit-api=" + $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitApi() + "'\n                      '-XXexplicit-return-types=" + $this$checkExplicitApiAndExplicitReturnTypesAtTheSameTime.getExplicitReturnTypes() + "'\n                    ")), null, 4, null);
        }
    }

    private static final LanguageVersion parseOrConfigureLanguageVersion(CommonCompilerArguments $this$parseOrConfigureLanguageVersion, MessageCollector collector) {
        LanguageVersion languageVersion;
        if ($this$parseOrConfigureLanguageVersion.getUseK2()) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "Compiler flag -Xuse-k2 is no more supported. Compiler versions 2.0+ use K2 by default, unless the language version is set to 1.9 or earlier", null, 4, null);
        }
        if ((languageVersion = CommonCompilerArgumentsConfiguratorKt.parseVersion($this$parseOrConfigureLanguageVersion, collector, $this$parseOrConfigureLanguageVersion.getLanguageVersion(), "language")) == null) {
            languageVersion = LanguageVersion.LATEST_STABLE;
        }
        return languageVersion;
    }

    /*
     * WARNING - void declaration
     */
    private static final LanguageVersion parseVersion(CommonCompilerArguments $this$parseVersion, MessageCollector collector, String value2, String versionOf) {
        LanguageVersion languageVersion;
        if (value2 == null) {
            languageVersion = null;
        } else {
            languageVersion = LanguageVersion.Companion.fromVersionString(value2);
            if (languageVersion == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LanguageVersion p0;
                void $this$filterNotTo$iv$iv;
                CommonCompilerArguments $this$parseVersion_u24lambda_u241 = $this$parseVersion;
                boolean bl = false;
                Iterable $this$filterNot$iv = LanguageVersion.getEntries();
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    p0 = (LanguageVersion)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.isUnsupported()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    p0 = (LanguageVersion)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(p0.getDescription());
                }
                List versionStrings = (List)destination$iv$iv;
                String message = "Unknown " + versionOf + " version: " + value2 + "\nSupported " + versionOf + " versions: " + CollectionsKt.joinToString$default((Iterable)versionStrings, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                collector.report(CompilerMessageSeverity.ERROR, message, null);
                languageVersion = null;
            }
        }
        return languageVersion;
    }

    @NotNull
    public static final Map<AnalysisFlag<?>, Object> configureAnalysisFlags(@NotNull CommonCompilerArguments $this$configureAnalysisFlags, @NotNull MessageCollector collector, @NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$configureAnalysisFlags, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        return $this$configureAnalysisFlags.getConfigurator().configureAnalysisFlags($this$configureAnalysisFlags, collector, languageVersion);
    }

    @NotNull
    public static final Map<LanguageFeature, LanguageFeature.State> configureLanguageFeatures(@NotNull CommonCompilerArguments $this$configureLanguageFeatures, @NotNull MessageCollector collector) {
        Intrinsics.checkNotNullParameter((Object)$this$configureLanguageFeatures, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        return $this$configureLanguageFeatures.getConfigurator().configureLanguageFeatures($this$configureLanguageFeatures, collector);
    }
}

