/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildTime;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.compilerRunner.JpsCompilationResult;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsCompileStatisticsData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 E2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002:\u0001EB7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0001J\u0016\u0010\u001f\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u0016\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0016J\u0019\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0019\u0010+\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0013H\u0096\u0001J\u001d\u0010,\u001a\u00020\u001c2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040.H\u0096\u0001J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001aH\u0016J\u0011\u00101\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0004H\u0096\u0001J\u0019\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0013H\u0096\u0001J\u0019\u00105\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0013H\u0096\u0001J \u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020:2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0019\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010=\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u0003H\u0096\u0001J\u0010\u0010>\u001a\u00020?2\u0006\u00109\u001a\u00020:H\u0016J\u0015\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040.H\u0096\u0001J\u0012\u0010A\u001a\u00020\u001c2\b\u0010B\u001a\u0004\u0018\u00010\nH\u0016J\u0019\u0010C\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010D\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u0003H\u0096\u0001R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\n\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl;", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildPerformanceMetric;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "reporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "label", "", "kotlinVersion", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;Ljava/lang/String;Ljava/lang/String;)V", "changedFiles", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "compilerArguments", "exitCode", "finishTime", "", "kotlinLanguageVersion", "moduleString", "Lorg/jetbrains/annotations/NotNull;", "startTime", "tags", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addChangedFiles", "files", "", "addCompilerArguments", "arguments", "addCompilerMetrics", "jpsCompilationResult", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilationResult;", "addGcMetric", "metric", "value", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addMetric", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTag", "tag", "addTimeMetric", "addTimeMetricMs", "time", "durationMs", "addTimeMetricNs", "durationNs", "buildFinish", "moduleChunk", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "endGcMetric", "name", "endMeasure", "flush", "Lorg/jetbrains/kotlin/jps/statistic/JpsCompileStatisticsData;", "getMetrics", "setKotlinLanguageVersion", "languageVersion", "startGcMetric", "startMeasure", "Companion", "jps-plugin"})
public final class JpsBuilderMetricReporterImpl
implements JpsBuilderMetricReporter,
BuildMetricsReporter<JpsBuildTime, JpsBuildPerformanceMetric> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final BuildMetricsReporterImpl<JpsBuildTime, JpsBuildPerformanceMetric> reporter;
    @Nullable
    private final String label;
    @NotNull
    private final String kotlinVersion;
    private final long startTime;
    private long finishTime;
    @NotNull
    private final HashSet<StatTag> tags;
    @NotNull
    private final ArrayList<String> changedFiles;
    @NotNull
    private final ArrayList<String> compilerArguments;
    @NotNull
    private final String moduleString;
    @NotNull
    private String exitCode;
    @Nullable
    private String kotlinLanguageVersion;
    @Nullable
    private static final String hostName;
    private static final UUID uuid;

    public JpsBuilderMetricReporterImpl(@NotNull ModuleChunk chunk, @NotNull BuildMetricsReporterImpl<JpsBuildTime, JpsBuildPerformanceMetric> reporter, @Nullable String label, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        this.reporter = reporter;
        this.label = label;
        this.kotlinVersion = kotlinVersion;
        this.startTime = System.currentTimeMillis();
        this.tags = new HashSet();
        this.changedFiles = new ArrayList();
        this.compilerArguments = new ArrayList();
        String string = chunk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chunk.name");
        this.moduleString = string;
        this.exitCode = "Unknown";
    }

    public /* synthetic */ JpsBuilderMetricReporterImpl(ModuleChunk moduleChunk, BuildMetricsReporterImpl buildMetricsReporterImpl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = "kotlin_version";
        }
        this(moduleChunk, buildMetricsReporterImpl, string, string2);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.reporter.addAttribute(attribute);
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.addGcMetric(metric, value2);
    }

    @Override
    public void addMetric(@NotNull JpsBuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addMetric((JpsBuildPerformanceMetric)((BuildPerformanceMetric)metric), value2);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.reporter.addMetrics(metrics);
    }

    @Override
    public void addTimeMetric(@NotNull JpsBuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addTimeMetric((JpsBuildPerformanceMetric)((BuildPerformanceMetric)metric));
    }

    @Override
    public void addTimeMetricMs(@NotNull JpsBuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricMs((JpsBuildTime)((BuildTime)time), durationMs);
    }

    @Override
    public void addTimeMetricNs(@NotNull JpsBuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricNs((JpsBuildTime)((BuildTime)time), durationNs);
    }

    @Override
    public void endGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.endGcMetric(name2, value2);
    }

    @Override
    public void endMeasure(@NotNull JpsBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.endMeasure((JpsBuildTime)((BuildTime)time));
    }

    @Override
    @NotNull
    public BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> getMetrics() {
        return this.reporter.getMetrics();
    }

    @Override
    public void startGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.startGcMetric(name2, value2);
    }

    @Override
    public void startMeasure(@NotNull JpsBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.startMeasure((JpsBuildTime)((BuildTime)time));
    }

    @Override
    public void buildFinish(@NotNull ModuleChunk moduleChunk, @NotNull CompileContext context, @NotNull String exitCode) {
        Intrinsics.checkNotNullParameter((Object)moduleChunk, (String)"moduleChunk");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        this.finishTime = System.currentTimeMillis();
        this.exitCode = exitCode;
    }

    @Override
    public void addChangedFiles(@NotNull List<String> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.changedFiles.addAll((Collection<String>)files2);
    }

    @Override
    public void addCompilerArguments(@NotNull List<String> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        this.compilerArguments.addAll((Collection<String>)arguments2);
    }

    @Override
    public void setKotlinLanguageVersion(@Nullable String languageVersion) {
        this.kotlinLanguageVersion = languageVersion;
    }

    @Override
    public void addTag(@NotNull StatTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.tags.add(tag);
    }

    @Override
    public void addCompilerMetrics(@NotNull JpsCompilationResult jpsCompilationResult) {
        Intrinsics.checkNotNullParameter((Object)jpsCompilationResult, (String)"jpsCompilationResult");
        this.reporter.addMetrics(jpsCompilationResult.getBuildMetrics());
    }

    @Override
    @NotNull
    public JpsCompileStatisticsData flush(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> buildMetrics = this.reporter.getMetrics();
        String string = context.getProjectDescriptor().getProject().getName();
        String string2 = this.label;
        String string3 = this.moduleString;
        String string4 = this.exitCode;
        long l = this.startTime;
        long l2 = this.finishTime - this.startTime;
        HashSet<StatTag> hashSet = this.tags;
        String string5 = uuid.toString();
        ArrayList<String> arrayList = this.changedFiles;
        String string6 = this.kotlinVersion;
        String string7 = hostName;
        long l3 = this.finishTime;
        Map<JpsBuildTime, Long> map = buildMetrics.getBuildTimes().asMapMs();
        Map<JpsBuildPerformanceMetric, Long> map2 = buildMetrics.getBuildPerformanceMetrics().asMap();
        ArrayList<String> arrayList2 = this.compilerArguments;
        Set set = SetsKt.emptySet();
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        Map<String, Long> map3 = buildMetrics.getGcMetrics().asGcTimeMap();
        Map<String, Long> map4 = buildMetrics.getGcMetrics().asGcCountMap();
        String string8 = this.kotlinLanguageVersion;
        Set set2 = hashSet;
        List list3 = arrayList;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString()");
        return new JpsCompileStatisticsData(string, string2, string3, string4, l, l2, set2, list3, string5, string6, string8, string7, l3, (List<String>)arrayList2, set, map, map2, map3, map4, "JPS_DATA", true, list, null, list2);
    }

    static {
        String string;
        Companion = new Companion(null);
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
        uuid = UUID.randomUUID();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl$Companion;", "", "()V", "hostName", "", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "jps-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

