/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.ReenterableCounter;
import org.jetbrains.kotlin.util.SimpleCounter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u001f\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010H\u0004J!\u0010\u001b\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H$\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u001eJ&\u0010\u001c\u001a\u00020\u00122\u001e\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "excludedFrom", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "getExcludedFrom$util_runtime", "()Ljava/util/List;", "count", "", "totalTimeNanos", "", "increment", "", "time", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "reset", "incrementTime", "delta", "countTime", "report", "consumer", "Lkotlin/Function1;", "Lkotlin/Function3;", "Companion", "util.runtime"})
@SourceDebugExtension(value={"SMAP\nPerformanceCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1869#2,2:229\n1869#2,2:231\n*S KotlinDebug\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter\n*L\n92#1:229,2\n96#1:231,2\n*E\n"})
public abstract class PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private static final ArrayList<PerformanceCounter> allCounters = new ArrayList();
    private static boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> arrayList = allCounters;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = allCounters.add(this);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CounterWithExclude> getExcludedFrom$util_runtime() {
        return this.excludedFrom;
    }

    public final void increment() {
        int n = this.count;
        this.count = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int n = this.count;
        this.count = n + 1;
        if (!enabled) {
            return (T)block.invoke();
        }
        Iterable $this$forEach$iv = this.excludedFrom;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CounterWithExclude it = (CounterWithExclude)element$iv;
            boolean bl = false;
            it.enterExcludedMethod();
        }
        try {
            T t = this.countTime(block);
            return t;
        }
        finally {
            Iterable $this$forEach$iv2 = this.excludedFrom;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CounterWithExclude it = (CounterWithExclude)element$iv;
                boolean bl = false;
                it.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        this.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke((Object)(this.name + " performed " + this.count + " times"));
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke((Object)(this.name + " performed " + this.count + " times, total time " + millis + " ms"));
        }
    }

    public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.invoke((Object)this.name, (Object)this.count, (Object)this.totalTimeNanos);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fJ&\u0010\f\u001a\u00020\r2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0011J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\rJ\u001a\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\tH\u0007J'\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00102\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001d\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter$Companion;", "", "<init>", "()V", "allCounters", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "Lkotlin/collections/ArrayList;", "enabled", "", "currentTime", "", "report", "", "consumer", "Lkotlin/Function1;", "", "Lkotlin/Function3;", "", "numberOfCounters", "getNumberOfCounters", "()I", "setTimeCounterEnabled", "enable", "resetAllCounters", "create", "name", "reenterable", "excluded", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "getOrPut", "T", "threadLocal", "Ljava/lang/ThreadLocal;", "default", "Lkotlin/Function0;", "getOrPut$util_runtime", "(Ljava/lang/ThreadLocal;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "util.runtime"})
    @SourceDebugExtension(value={"SMAP\nPerformanceCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n37#2:229\n36#2,3:230\n37#2:235\n36#2,3:236\n13472#3,2:233\n13472#3,2:239\n1#4:241\n1869#5,2:242\n*S KotlinDebug\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter$Companion\n*L\n28#1:229\n28#1:230,3\n35#1:235\n35#1:236,3\n30#1:233,2\n37#1:239,2\n49#1:242,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getNumberOfCounters() {
            int n;
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                n = allCounters.size();
            }
            return n;
        }

        public final void setTimeCounterEnabled(boolean enable) {
            enabled = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Iterable $this$forEach$iv = allCounters;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PerformanceCounter p0 = (PerformanceCounter)element$iv;
                    boolean bl2 = false;
                    p0.reset();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name2, boolean reenterable) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name2) : (PerformanceCounter)new SimpleCounter(name2);
        }

        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string, bl);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name2, PerformanceCounter ... excluded) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)excluded, (String)"excluded");
            return new CounterWithExclude(name2, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$util_runtime(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkNotNullParameter(threadLocal, (String)"threadLocal");
            Intrinsics.checkNotNullParameter(function0, (String)"default");
            boolean $i$f$getOrPut$util_runtime = false;
            Object value2 = threadLocal.get();
            if (value2 == null) {
                value2 = function0.invoke();
                threadLocal.set(value2);
            }
            return value2;
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return org.jetbrains.kotlin.util.PerformanceCounter$Companion.create$default(this, name2, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

