/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.kapt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ReflectionUtilKt;
import org.jetbrains.kotlin.utils.kapt.ClassLoaderData;
import org.jetbrains.kotlin.utils.kapt.MemoryLeak;
import org.jetbrains.kotlin.utils.kapt.MemoryLeakDetectorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector;", "", "<init>", "()V", "classLoaderData", "", "Lorg/jetbrains/kotlin/utils/kapt/ClassLoaderData;", "add", "", "classLoader", "Ljava/lang/ClassLoader;", "process", "", "Lorg/jetbrains/kotlin/utils/kapt/MemoryLeak;", "isParanoid", "", "inspectStatics", "util"})
@SourceDebugExtension(value={"SMAP\nMemoryLeakDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryLeakDetector.kt\norg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1634#2,3:143\n1#3:146\n*S KotlinDebug\n*F\n+ 1 MemoryLeakDetector.kt\norg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector\n*L\n82#1:143,3\n*E\n"})
public final class MemoryLeakDetector {
    @NotNull
    public static final MemoryLeakDetector INSTANCE = new MemoryLeakDetector();
    @NotNull
    private static final List<ClassLoaderData> classLoaderData = new ArrayList();

    private MemoryLeakDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List<ClassLoaderData> list = classLoaderData;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = classLoaderData.add(new ClassLoaderData(classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<MemoryLeak> process(boolean isParanoid) {
        Set memoryLeaks = new LinkedHashSet();
        List<ClassLoaderData> list = classLoaderData;
        synchronized (list) {
            boolean bl = false;
            List newClassLoaderData = new ArrayList();
            for (ClassLoaderData data2 : classLoaderData) {
                if ((ClassLoader)data2.getRef().get() == null) continue;
                data2.setAge(data2.getAge() + 1);
                if (isParanoid || data2.getAge() >= 5) {
                    ClassLoader classLoader;
                    INSTANCE.inspectStatics(classLoader);
                    continue;
                }
                ((Collection)newClassLoaderData).add(data2);
            }
            classLoaderData.clear();
            boolean bl2 = classLoaderData.addAll(newClassLoaderData);
        }
        return memoryLeaks;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MemoryLeak> inspectStatics(ClassLoader classLoader) {
        Set $this$mapTo$iv;
        Vector loadedClasses = MemoryLeakDetectorKt.access$loadedClasses(classLoader);
        try {
            void destination$iv;
            Iterable iterable = loadedClasses;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Class clazz = (Class)item$iv;
                void var16_9 = destination$iv;
                boolean bl = false;
                var16_9.add(it);
            }
            $this$mapTo$iv = (Set)destination$iv;
        }
        catch (ConcurrentModificationException e) {
            Thread.sleep(100L);
            return this.inspectStatics(classLoader);
        }
        Set loadedClassesSet = $this$mapTo$iv;
        Set leaks = new LinkedHashSet();
        for (Class clazz : loadedClassesSet) {
            Object object;
            try {
                object = clazz.getDeclaredFields();
            }
            catch (Throwable e) {
                continue;
            }
            Object[] declaredFields = object;
            object = ArrayIteratorKt.iterator((Object[])declaredFields);
            while (object.hasNext()) {
                Object object2;
                Field field = (Field)object.next();
                if (!Modifier.isStatic(field.getModifiers())) continue;
                Intrinsics.checkNotNull((Object)field);
                Object object3 = ReflectionUtilKt.getSafe(field, null);
                if (object3 == null) continue;
                Object it = object2 = object3;
                boolean bl = false;
                Object object4 = !MemoryLeakDetectorKt.access$isPrimitiveOrString(it) ? object2 : null;
                if (object4 == null) continue;
                Object value2 = object4;
                if (MemoryLeakDetectorKt.access$isJavacComponent(value2)) {
                    object3 = leaks;
                    String string = clazz.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    object3.add(new MemoryLeak(string, string2, "Field leaks an Annotation Processing component (" + value2 + ")."));
                    continue;
                }
                if (!(value2 instanceof Class) || !loadedClassesSet.contains(value2)) continue;
                object3 = leaks;
                String string = clazz.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string3 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                object3.add(new MemoryLeak(string, string3, "Field leaks a class type from the same ClassLoader (" + ((Class)value2).getName() + ")."));
            }
        }
        return leaks;
    }
}

