/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.editor;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class QlSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"QL_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"QL_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"QL_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey DATETIME = TextAttributesKey.createTextAttributesKey((String)"QL_DATETIME", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey OP_SIGN = TextAttributesKey.createTextAttributesKey((String)"QL_OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey PARENTHS = TextAttributesKey.createTextAttributesKey((String)"QL_PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"QL_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"QL_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey COMMENTS = TextAttributesKey.createTextAttributesKey((String)"QL_COMMENTS", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
    public static final TextAttributesKey ENTITY = TextAttributesKey.createTextAttributesKey((String)"QL_ENTITY", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey ATTRIBUTE = TextAttributesKey.createTextAttributesKey((String)"QL_ATTRIBUTE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey ID_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"QL_ID_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
    public static final TextAttributesKey FUNCTION = TextAttributesKey.createTextAttributesKey((String)"QL_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
    public static final TextAttributesKey PARAMETER = TextAttributesKey.createTextAttributesKey((String)"QL_PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    public static final TextAttributesKey ILLEGAL = TextAttributesKey.createTextAttributesKey((String)"QL_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    private final Language myLanguage;

    public QlSyntaxHighlighter(@NotNull Language language) {
        if (language == null) {
            QlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        this.myLanguage = language;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new QlLexer(this.myLanguage);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType type) {
        if (type == TokenType.BAD_CHARACTER || type == QlLexer.QL_STRING_UNCLOSED) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)ILLEGAL);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_COMMA) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)COMMA);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_DOT) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)DOT);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_STRING) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)STRING);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(4);
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_NUMBER) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)NUMBER);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(5);
            }
            return textAttributesKeyArray;
        }
        if (QlLexer.QL_BINARY_OPERATORS.contains(type) || type == QlTypes.QL_QUEST || type == QlTypes.QL_COLON || type == QlTypes.QL_SEMICOLON) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)OP_SIGN);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(6);
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_LEFT_PAREN || type == QlTypes.QL_RIGHT_PAREN || type == QlTypes.QL_LEFT_BRACKET || type == QlTypes.QL_RIGHT_BRACKET) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)PARENTHS);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(7);
            }
            return textAttributesKeyArray;
        }
        if (QlLexer.getKeywordMap(this.myLanguage).containsKey(type.toString())) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)KEYWORD);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(8);
            }
            return textAttributesKeyArray;
        }
        if (type == QlLexer.QL_MULTI_LINE_COMMENT) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)COMMENTS);
            if (textAttributesKeyArray == null) {
                QlSyntaxHighlighter.$$$reportNull$$$0(9);
            }
            return textAttributesKeyArray;
        }
        if (TextAttributesKey.EMPTY_ARRAY == null) {
            QlSyntaxHighlighter.$$$reportNull$$$0(10);
        }
        return TextAttributesKey.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ql/editor/QlSyntaxHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ql/editor/QlSyntaxHighlighter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static final class EqlSyntaxHighlighter
    extends QlSyntaxHighlighter {
        public EqlSyntaxHighlighter() {
            super(JpqlLanguage.EQL);
        }
    }

    public static final class EjbqlSyntaxHighlighter
    extends QlSyntaxHighlighter {
        public EjbqlSyntaxHighlighter() {
            super(JpqlLanguage.EJBQL);
        }
    }

    public static final class HqlSyntaxHighlighter
    extends QlSyntaxHighlighter {
        public HqlSyntaxHighlighter() {
            super(JpqlLanguage.HQL);
        }
    }

    public static final class JpqlSyntaxHighlighter
    extends QlSyntaxHighlighter {
        public JpqlSyntaxHighlighter() {
            super(JpqlLanguage.JPQL);
        }
    }
}

