/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.json;

import com.google.protobuf.DescriptorProtos;
import com.intellij.httpClient.grpc.json.GrpcLanguageInjectionUtils;
import com.intellij.httpClient.grpc.json.GrpcMessageToJsonSchemaConverter;
import com.intellij.httpClient.grpc.json.GrpcResolveUtils;
import com.intellij.httpClient.grpc.json.JsonSchemaData;
import com.intellij.httpClient.grpc.requests.GrpcReflectionService;
import com.intellij.httpClient.grpc.requests.GrpcReflectionServiceKt;
import com.intellij.httpClient.grpc.requests.GrpcRequestpsiUtilsKt;
import com.intellij.httpClient.grpc.requests.MethodsByServiceKey;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.grpc.restClient.url.GrpcRequestUtilsKt;
import com.intellij.httpClient.grpc.restClient.url.GrpcServiceUrlReference;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.progress.CancellationUtil;
import com.jetbrains.jsonSchema.extension.ContentAwareJsonSchemaFileProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/grpc/json/GrpcJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/ContentAwareJsonSchemaFileProvider;", "<init>", "()V", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "tryComputeReflectedSchema", "grpcRequestPsi", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "methodFqn", "", "computeMethodParameterType", "descriptors", "", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorProto;", "methodsByServiceKey", "Lcom/intellij/httpClient/grpc/requests/MethodsByServiceKey;", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcJsonSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcJsonSchemaProviderFactory.kt\ncom/intellij/httpClient/grpc/json/GrpcJsonSchemaProviderFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n4225#2,11:52\n295#3,2:63\n*S KotlinDebug\n*F\n+ 1 GrpcJsonSchemaProviderFactory.kt\ncom/intellij/httpClient/grpc/json/GrpcJsonSchemaProviderFactory\n*L\n32#1:52,11\n47#1:63,2\n*E\n"})
public final class GrpcJsonSchemaProviderFactory
implements ContentAwareJsonSchemaFileProvider {
    @Nullable
    public VirtualFile getSchemaFile(@NotNull PsiFile psiFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        HttpRequest httpRequest = GrpcLanguageInjectionUtils.INSTANCE.findGrpcMethodByInjectedFragment(psiFile);
        if (httpRequest == null) {
            return null;
        }
        HttpRequest grpcRequestPsi = httpRequest;
        String string = GrpcResolveUtils.INSTANCE.findRequestMethodFqn$intellij_httpClient_grpc(grpcRequestPsi);
        if (string == null) {
            return null;
        }
        String methodFqn = string;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PbMessageDefinition parameterMessageDefinition = GrpcResolveUtils.INSTANCE.resolveMethodParameter$intellij_httpClient_grpc(methodFqn, project);
        if (parameterMessageDefinition != null) {
            Project project2 = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            JsonSchemaData jsonSchemaData = GrpcMessageToJsonSchemaConverter.INSTANCE.getOrComputeSchemaData(parameterMessageDefinition, project2);
            object = jsonSchemaData != null ? jsonSchemaData.getVirtualFile() : null;
        } else {
            object = this.tryComputeReflectedSchema(grpcRequestPsi, methodFqn);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryComputeReflectedSchema(HttpRequest grpcRequestPsi, String methodFqn) {
        void $this$filterIsInstanceTo$iv$iv;
        HttpRequestTarget httpRequestTarget = grpcRequestPsi.getRequestTarget();
        if (httpRequestTarget == null) {
            return null;
        }
        HttpRequestTarget requestTarget = httpRequestTarget;
        GrpcRequest grpcRequest = GrpcRequestpsiUtilsKt.getOrComputeGrpcRequest(requestTarget);
        if (grpcRequest == null) {
            return null;
        }
        GrpcRequest grpcRequest2 = grpcRequest;
        PsiReference[] psiReferenceArray = requestTarget.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] $this$filterIsInstance$iv = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GrpcServiceUrlReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GrpcServiceUrlReference grpcServiceUrlReference = (GrpcServiceUrlReference)((Object)CollectionsKt.singleOrNull((List)((List)destination$iv$iv)));
        if (grpcServiceUrlReference == null) {
            return null;
        }
        GrpcServiceUrlReference serviceNameReference = grpcServiceUrlReference;
        String string = grpcRequest2.getScheme();
        String string2 = grpcRequest2.getHost();
        int n = grpcRequest2.getPort();
        String string3 = serviceNameReference.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        MethodsByServiceKey methodsByServiceKey = new MethodsByServiceKey(string, string2, n, string3);
        Project project = grpcRequestPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List descriptors = (List)CancellationUtil.getCancellable(GrpcReflectionService.Companion.getInstance(project).retrieveAllProtoDescriptorsFuture(methodsByServiceKey));
        String string4 = this.computeMethodParameterType(descriptors, methodsByServiceKey, methodFqn);
        if (string4 == null) {
            return null;
        }
        String inputTypeFqn = string4;
        return GrpcMessageToJsonSchemaConverter.INSTANCE.computeReflectedSchemaData(inputTypeFqn, descriptors);
    }

    /*
     * WARNING - void declaration
     */
    private final String computeMethodParameterType(List<DescriptorProtos.FileDescriptorProto> descriptors, MethodsByServiceKey methodsByServiceKey, String methodFqn) {
        Object v0;
        Object object;
        block1: {
            void $this$firstOrNull$iv;
            object = GrpcReflectionServiceKt.mapMethodsByServices(descriptors, methodsByServiceKey);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DescriptorProtos.MethodDescriptorProto it = (DescriptorProtos.MethodDescriptorProto)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)GrpcRequestUtilsKt.asShortName(methodFqn))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        DescriptorProtos.MethodDescriptorProto methodDescriptorProto = v0;
        return methodDescriptorProto != null && (object = methodDescriptorProto.getInputType()) != null ? StringsKt.removePrefix((String)object, (CharSequence)".") : null;
    }
}

