/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a9\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\u0004\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00020\u0005H\u0080\b\u001a3\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\b0\u0005H\u0080\b\u001a-\u0010\t\u001a\u00020\b\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\b0\u0005H\u0080\b\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000b\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0001H\u0000\u001aD\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u0002H\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0005H\u0000\u001a>\u0010\u0010\u001a\u00020\b\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u0002H\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0005H\u0000\u001a>\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\u00030\u000b2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u0002H\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0005H\u0000\u001a\u001d\u0010\u0013\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000bH\u0000\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"fastMap", "Landroidx/collection/ObjectList;", "R", "T", "transform", "Lkotlin/Function1;", "fastFilter", "predicate", "", "all", "toMutableObjectList", "Landroidx/collection/MutableObjectList;", "sortedBy", "K", "", "selector", "isSorted", "sortBy", "", "removeLast", "(Landroidx/collection/MutableObjectList;)Ljava/lang/Object;", "runtime"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nandroidx/compose/runtime/collection/ExtensionsKt\n+ 2 ObjectList.kt\nandroidx/collection/ObjectList\n+ 3 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n36#1:80\n37#1:87\n287#2,4:73\n292#2:79\n287#2,6:81\n287#2,4:88\n292#2:94\n287#2,6:95\n287#2,4:101\n292#2:107\n919#3,2:77\n919#3,2:92\n919#3,2:105\n1#4:108\n1010#5,2:109\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nandroidx/compose/runtime/collection/ExtensionsKt\n*L\n29#1:80\n29#1:87\n24#1:73,4\n24#1:79\n29#1:81,6\n31#1:88,4\n31#1:94\n36#1:95,6\n42#1:101,4\n42#1:107\n24#1:77,2\n31#1:92,2\n42#1:105,2\n64#1:109,2\n*E\n"})
public final class ExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> ObjectList<R> fastMap(@NotNull ObjectList<T> $this$fastMap, @NotNull Function1<? super T, ? extends R> transform) {
        boolean $i$f$fastMap = false;
        MutableObjectList target = new MutableObjectList($this$fastMap.getSize());
        ObjectList<T> this_$iv = $this$fastMap;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            void this_$iv2;
            Object it = content$iv[i$iv];
            boolean bl = false;
            MutableObjectList mutableObjectList = target;
            Object element$iv = transform.invoke(it);
            boolean $i$f$plusAssign = false;
            this_$iv2.add(element$iv);
        }
        return target;
    }

    @NotNull
    public static final <T> ObjectList<T> fastFilter(@NotNull ObjectList<T> $this$fastFilter, @NotNull Function1<? super T, Boolean> predicate) {
        boolean bl;
        block3: {
            boolean $i$f$fastFilter = false;
            ObjectList<T> $this$all$iv = $this$fastFilter;
            boolean $i$f$all = false;
            ObjectList<T> this_$iv$iv = $this$all$iv;
            boolean $i$f$forEach = false;
            Object[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                Object it$iv = content$iv$iv[i$iv$iv];
                boolean bl2 = false;
                if (((Boolean)predicate.invoke(it$iv)).booleanValue()) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return $this$fastFilter;
        }
        MutableObjectList<Object> target = new MutableObjectList<Object>(0, 1, null);
        ObjectList<T> this_$iv = $this$fastFilter;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object it = content$iv[i$iv];
            boolean bl3 = false;
            if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
            MutableObjectList<Object> this_$iv2 = target;
            boolean $i$f$plusAssign = false;
            this_$iv2.add(it);
        }
        return target;
    }

    public static final <T> boolean all(@NotNull ObjectList<T> $this$all, @NotNull Function1<? super T, Boolean> predicate) {
        boolean $i$f$all = false;
        ObjectList<T> this_$iv = $this$all;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object it = content$iv[i$iv];
            boolean bl = false;
            if (((Boolean)predicate.invoke(it)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final <T> MutableObjectList<T> toMutableObjectList(@NotNull ObjectList<T> $this$toMutableObjectList) {
        MutableObjectList<Object> target = new MutableObjectList<Object>($this$toMutableObjectList.getSize());
        ObjectList<T> this_$iv = $this$toMutableObjectList;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object it = content$iv[i$iv];
            boolean bl = false;
            MutableObjectList<Object> this_$iv2 = target;
            boolean $i$f$plusAssign = false;
            this_$iv2.add(it);
        }
        return target;
    }

    @NotNull
    public static final <T, K extends Comparable<? super K>> ObjectList<T> sortedBy(@NotNull ObjectList<T> $this$sortedBy, @NotNull Function1<? super T, ? extends K> selector) {
        ObjectList objectList;
        if (ExtensionsKt.isSorted($this$sortedBy, selector)) {
            objectList = $this$sortedBy;
        } else {
            MutableObjectList<T> mutableObjectList;
            MutableObjectList<T> it = mutableObjectList = ExtensionsKt.toMutableObjectList($this$sortedBy);
            boolean bl = false;
            ExtensionsKt.sortBy(it, selector);
            objectList = mutableObjectList;
        }
        return objectList;
    }

    public static final <T, K extends Comparable<? super K>> boolean isSorted(@NotNull ObjectList<T> $this$isSorted, @NotNull Function1<? super T, ? extends K> selector) {
        if ($this$isSorted.getSize() <= 1) {
            return true;
        }
        T previousValue = $this$isSorted.get(0);
        Comparable comparable = (Comparable)selector.invoke(previousValue);
        if (comparable == null) {
            return false;
        }
        Comparable previousKey = comparable;
        int n = $this$isSorted.getSize();
        for (int i = 1; i < n; ++i) {
            Comparable key;
            T value = $this$isSorted.get(i);
            if ((Comparable)selector.invoke(value) == null) {
                return false;
            }
            if (previousKey.compareTo(key) > 0) {
                return false;
            }
            previousKey = key;
        }
        return true;
    }

    public static final <T, K extends Comparable<? super K>> void sortBy(@NotNull MutableObjectList<T> $this$sortBy, @NotNull Function1<? super T, ? extends K> selector) {
        List<T> $this$sortBy$iv = $this$sortBy.asMutableList();
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(selector){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                }
            });
        }
    }

    public static final <T> T removeLast(@NotNull MutableObjectList<T> $this$removeLast) {
        Object e;
        if ($this$removeLast.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        int last = $this$removeLast.getSize() - 1;
        Object it = e = $this$removeLast.get(last);
        boolean bl = false;
        $this$removeLast.removeAt(last);
        return (T)e;
    }
}

