/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.mongoDB;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.data.mongoDB.SpringDataMongoDbUtils;
import com.intellij.spring.data.mongoDB.SpringDataMongodbBundle;
import com.intellij.spring.gutter.groups.SpringGroupMergeableLineMarkerInfo;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public final class SpringDataMongoDbLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @GutterName
    public String getName() {
        return SpringDataMongodbBundle.message("spring.data.mongodb.gutter.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.MongoDB;
        if (icon == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement element;
        if (elements == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringDataMongoDbUtils.hasSpringDataMongoDbSupport(ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return;
        }
        for (PsiElement psiElement : elements) {
            UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
            if (uParent instanceof UClass) {
                SpringDataMongoDbLineMarkerProvider.addMongoDocumentLineMarker(result, (UClass)uParent);
                continue;
            }
            if (!(uParent instanceof UMethod) && !(uParent instanceof UField)) continue;
            SpringDataMongoDbLineMarkerProvider.addMongoFieldLineMarker(result, (UDeclaration)uParent);
        }
    }

    private static void addMongoDocumentLineMarker(@NotNull Collection<? super LineMarkerInfo<?>> result, @NotNull UClass uClass) {
        if (result == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (uClass == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (!uClass.getJavaPsi().hasAnnotation("org.springframework.data.mongodb.core.mapping.Document") && !SpringDataMongoDbLineMarkerProvider.hasAnnotatedMembers(uClass)) {
            return;
        }
        PsiElement uastAnchorPsi = SpringDataMongoDbLineMarkerProvider.getUastAnchor(uClass.getUastAnchor());
        if (uastAnchorPsi == null) {
            return;
        }
        result.add(SpringDataMongoDbLineMarkerProvider.createDocumentLineMarker(uastAnchorPsi));
    }

    private static void addMongoFieldLineMarker(@NotNull Collection<? super LineMarkerInfo<?>> result, @NotNull UDeclaration uDeclaration) {
        if (result == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (uDeclaration == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (SpringDataMongoDbUtils.isReadonlyProperty(uDeclaration)) {
            return;
        }
        PsiElement anchor = SpringDataMongoDbLineMarkerProvider.getUastAnchor(uDeclaration.getUastAnchor());
        if (anchor == null) {
            return;
        }
        if (SpringDataMongoDbUtils.getMongoDbDocumentId(uDeclaration.getJavaPsi()) != null) {
            result.add((LineMarkerInfo<?>)SpringDataMongoDbLineMarkerProvider.createFieldLineMarker(anchor, DatabaseIcons.MongoFieldGoldKey));
        } else if (SpringDataMongoDbUtils.getMongoDbDocumentField(uDeclaration.getJavaPsi()) != null) {
            result.add((LineMarkerInfo<?>)SpringDataMongoDbLineMarkerProvider.createFieldLineMarker(anchor, DatabaseIcons.MongoField));
        } else {
            if (uDeclaration instanceof UMethod) {
                return;
            }
            UClass uClass = (UClass)UastUtils.getParentOfType((UElement)uDeclaration, UClass.class);
            if (uClass == null) {
                return;
            }
            boolean hasDocumentAnno = ContainerUtil.exists((Iterable)uClass.getUAnnotations(), uAnno -> StringUtil.equals((CharSequence)uAnno.getQualifiedName(), (CharSequence)"org.springframework.data.mongodb.core.mapping.Document"));
            if (!hasDocumentAnno) {
                return;
            }
            PsiElement psiElement = uDeclaration.getJavaPsi();
            if (!(psiElement instanceof PsiMember)) {
                return;
            }
            PsiMember psiMember = (PsiMember)psiElement;
            String fieldName = SpringDataMongoDbUtils.getFieldName(psiMember);
            if (StringUtil.isEmptyOrSpaces((String)fieldName)) {
                return;
            }
            if (SpringDataMongoDbUtils.isIdFieldName(fieldName)) {
                result.add((LineMarkerInfo<?>)SpringDataMongoDbLineMarkerProvider.createFieldLineMarker(anchor, DatabaseIcons.MongoFieldGoldKey));
            } else {
                result.add((LineMarkerInfo<?>)SpringDataMongoDbLineMarkerProvider.createFieldLineMarker(anchor, DatabaseIcons.MongoField));
            }
        }
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createDocumentLineMarker(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(8);
        }
        Project project = psiElement.getProject();
        return new SpringGroupMergeableLineMarkerInfo(psiElement, psiElement.getTextRange(), AllIcons.Providers.MongoDB, el -> SpringDataMongodbBundle.message("open.in.database.view", new Object[0]), (e, elt) -> {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elt, PsiClass.class);
            if (psiClass == null) {
                return;
            }
            String documentName = SpringDataMongoDbUtils.getDocumentName(psiClass);
            if (StringUtil.isEmptyOrSpaces((String)documentName)) {
                return;
            }
            DbTable document = SpringDataMongoDbUtils.findDocument(project, documentName);
            if (document == null) {
                SpringDataMongoDbLineMarkerProvider.showErrorNotification(e, SpringDataMongodbBundle.message("spring.data.mongodb.document.not.found", new Object[0]));
                return;
            }
            DbNavigationUtils.navigateToDatabaseView((DbElement)document, (boolean)true);
        });
    }

    @NotNull
    private static SpringGroupMergeableLineMarkerInfo createFieldLineMarker(@NotNull PsiElement psiElement, @NotNull Icon icon) {
        if (psiElement == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (icon == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(10);
        }
        return new SpringGroupMergeableLineMarkerInfo(psiElement, psiElement.getTextRange(), icon, el -> SpringDataMongodbBundle.message("open.in.database.view", new Object[0]), (e, elt) -> {
            PsiElement patt0$temp = elt.getParent();
            if (!(patt0$temp instanceof PsiMember)) {
                return;
            }
            PsiMember parentPsiMember = (PsiMember)patt0$temp;
            DbElement mongoDbField = SpringDataMongoDbUtils.getMongoDbField(parentPsiMember);
            if (mongoDbField == null) {
                SpringDataMongoDbLineMarkerProvider.showErrorNotification(e, SpringDataMongodbBundle.message("spring.data.mongodb.field.not.found", new Object[0]));
                return;
            }
            DbNavigationUtils.navigateToDatabaseView((DbElement)mongoDbField, (boolean)true);
        });
    }

    @Nullable
    private static PsiElement getUastAnchor(@Nullable UElement uAnchor) {
        return uAnchor != null ? uAnchor.getSourcePsi() : null;
    }

    private static boolean hasAnnotatedMembers(@NotNull UClass uClass) {
        if (uClass == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (ContainerUtil.exists((Object[])uClass.getFields(), SpringDataMongoDbLineMarkerProvider::hasMongoFieldAnnotation)) {
            return true;
        }
        return ContainerUtil.exists((Object[])uClass.getMethods(), SpringDataMongoDbLineMarkerProvider::hasMongoFieldAnnotation);
    }

    private static boolean hasMongoFieldAnnotation(@NotNull UDeclaration uDeclaration) {
        if (uDeclaration == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(12);
        }
        return uDeclaration.findAnnotation("org.springframework.data.mongodb.core.mapping.Field") != null;
    }

    private static void showErrorNotification(@Nullable MouseEvent e, @Nls @NotNull String message) {
        if (message == null) {
            SpringDataMongoDbLineMarkerProvider.$$$reportNull$$$0(13);
        }
        if (e == null) {
            return;
        }
        JComponent label = HintUtil.createErrorLabel((String)message);
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(e), Balloon.Position.above);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/mongoDB/SpringDataMongoDbLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/mongoDB/SpringDataMongoDbLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMongoDocumentLineMarker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMongoFieldLineMarker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentLineMarker";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFieldLineMarker";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotatedMembers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasMongoFieldAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

