/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NotNull;

public final class UnInjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        String string = IntelliLangBundle.message((String)"intelliLang.uninject.language.action.text", (Object[])new Object[0]);
        if (string == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(3);
        }
        return new IntentionPreviewInfo.Html(IntelliLangBundle.message((String)"intelliLang.uninject.language.action.preview", (Object[])new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(5);
        }
        return UnInjectLanguageAction.isAvailableImpl(project, editor, psiFile);
    }

    public static boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile psiFile) {
        int offset;
        PsiFile element;
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(6);
        }
        if ((element = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)psiFile, (int)(offset = editor.getCaretModel().getOffset()))) == null) {
            return InjectedReferencesContributor.isInjected(psiFile.findReferenceAt(offset));
        }
        return element.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runReadAction(() -> UnInjectLanguageAction.invokeImpl(project, editor, psiFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(Project project, Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
        if (psiFile == null) {
            PsiElement element;
            LanguageInjectionSupport support;
            PsiReference reference = file.findReferenceAt(offset);
            if (reference == null) {
                return;
            }
            PsiElement psiElement = reference.getElement();
            if (psiElement instanceof PsiLanguageInjectionHost) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)psiElement;
                for (LanguageInjectionSupport support2 : InjectorUtils.getActiveInjectionSupports()) {
                    if (!support2.isApplicableTo(host) || !support2.removeInjectionInPlace(host)) continue;
                    PsiManager.getInstance((Project)project).dropPsiCaches();
                    return;
                }
            }
            if ((support = (LanguageInjectionSupport)(element = reference.getElement()).getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT)) != null && support.removeInjection(element)) {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
        if (host == null) {
            return;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
        if (support == null) {
            return;
        }
        try {
            if (!support.removeInjectionInPlace(host)) {
                UnInjectLanguageAction.defaultFunctionalityWorked(host);
            }
        }
        finally {
            InjectLanguageAction.forceToMoveCaret(editor);
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host) {
        HashSet<String> languages = new HashSet<String>();
        List files = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        if (files == null) {
            return false;
        }
        for (Pair pair : files) {
            for (Language lang = ((PsiElement)pair.first).getLanguage(); lang != null; lang = lang.getBaseLanguage()) {
                languages.add(lang.getID());
            }
        }
        return Configuration.getProjectInstance((Project)host.getProject()).setHostInjectionEnabled(host, languages, false);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

