/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.jsp.JspSpiUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.lang.UrlClassLoader;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserClassLoader {
    private final boolean myIncludeModuleOutput;
    private final Key<CachedValue<CachedInfo>> myKey;
    private static final UserClassLoader LIBRARIES_CACHE = new UserClassLoader("libraries class loader", false){

        @Override
        protected Object[] getDependencies(Module module) {
            return new Object[]{ProjectRootManager.getInstance((Project)module.getProject())};
        }
    };
    private static final UserClassLoader ALL_CLASSPATH_CACHE = new UserClassLoader("all classpath class loader", true){

        @Override
        protected Object[] getDependencies(Module module) {
            return new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT};
        }
    };

    private CachedValueProvider<CachedInfo> createProvider(final @NotNull Module module, final @Nullable PsiFile context) {
        if (module == null) {
            UserClassLoader.$$$reportNull$$$0(0);
        }
        return new CachedValueProvider<CachedInfo>(){

            public CachedValueProvider.Result<CachedInfo> compute() {
                List files = JspSpiUtil.buildFiles((VirtualFile)(context == null ? null : context.getVirtualFile()), (Module)module, (boolean)UserClassLoader.this.myIncludeModuleOutput);
                CachedInfo cachedInfo = new CachedInfo((ClassLoader)UrlClassLoader.build().files(files).parent(this.getClass().getClassLoader()).noPreload().allowLock(false).get());
                return new CachedValueProvider.Result((Object)cachedInfo, UserClassLoader.this.getDependencies(module));
            }
        };
    }

    public UserClassLoader(String keyName, boolean includeModuleOutput) {
        this.myIncludeModuleOutput = includeModuleOutput;
        this.myKey = Key.create((String)keyName);
    }

    protected abstract Object[] getDependencies(Module var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class<?> loadCachedClass(String className, @NotNull Module module, @Nullable PsiFile context) {
        CachedValue cachedValue;
        Module dataHolder;
        if (module == null) {
            UserClassLoader.$$$reportNull$$$0(1);
        }
        Module module2 = dataHolder = context == null ? module : context;
        synchronized (module2) {
            cachedValue = (CachedValue)dataHolder.getUserData(this.myKey);
            if (cachedValue == null) {
                CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
                cachedValue = cachedValuesManager.createCachedValue(this.createProvider(module, context), false);
                dataHolder.putUserData(this.myKey, (Object)cachedValue);
            }
        }
        CachedInfo cachedInfo = (CachedInfo)cachedValue.getValue();
        assert (cachedInfo != null);
        return cachedInfo.loadClass(className);
    }

    @Nullable
    public static Class<?> loadClass(String className, @NotNull Module module) {
        if (module == null) {
            UserClassLoader.$$$reportNull$$$0(2);
        }
        return UserClassLoader.loadClass(className, module, null);
    }

    @Nullable
    public static Class<?> loadClass(String className, @NotNull Module module, @Nullable PsiFile context) {
        Project project;
        PsiClass psiClass;
        if (module == null) {
            UserClassLoader.$$$reportNull$$$0(3);
        }
        if ((psiClass = JavaPsiFacade.getInstance((Project)(project = module.getProject())).findClass(className.replace('$', '.'), GlobalSearchScope.allScope((Project)project))) != null) {
            Class<?> aClass;
            VirtualFile file = psiClass.getContainingFile().getVirtualFile();
            assert (file != null);
            if (FileTypeRegistry.getInstance().isFileOfType(file, StdFileTypes.CLASS) && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(file) && (aClass = LIBRARIES_CACHE.loadCachedClass(className, module, context)) != null) {
                return aClass;
            }
            return ALL_CLASSPATH_CACHE.loadCachedClass(className, module, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/jsp/impl/UserClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCachedClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CachedInfo {
        private final Map<String, Class<?>> classes = FactoryMap.create(className -> {
            try {
                return classLoader.loadClass((String)className);
            }
            catch (Throwable e) {
                return null;
            }
        });

        CachedInfo(ClassLoader classLoader) {
        }

        Class<?> loadClass(String className) {
            return this.classes.get(className);
        }
    }
}

