/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseDriverUtils {
    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @Nullable DatabaseDriver driver, @Nullable Dbms dbms) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(0);
        }
        return DatabaseDriverUtils.getSupportedRange(artifactList, driver == null ? Collections.emptyList() : driver.getArtifacts(), dbms);
    }

    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @NotNull List<DatabaseDriver.ArtifactRef> artifacts, @Nullable Dbms dbms) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(1);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(2);
        }
        Version minV = Version.ZERO;
        Version maxV = Version.INFINITY;
        for (DatabaseDriver.ArtifactRef artifact : artifacts) {
            Couple<Version> range = DatabaseDriverUtils.getSupportedRange(artifactList, artifact, dbms);
            if (minV.less((Version)range.first)) {
                minV = (Version)range.first;
            }
            if (!((Version)range.second).less(maxV)) continue;
            maxV = (Version)range.second;
        }
        return maxV.isOrGreater(minV) ? Couple.of((Object)minV, (Object)maxV) : Couple.of((Object)Version.INFINITY, (Object)Version.INFINITY);
    }

    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver.ArtifactRef artifact, @Nullable Dbms dbms) {
        Version version;
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(4);
        }
        DatabaseArtifactList.ArtifactVersion artifactVersion = (version = artifact.getArtifactVersion()) == null ? null : artifactList.resolveVersion(artifact.getId(), version);
        List<DatabaseArtifactList.Constraint> constraints = artifactVersion == null ? Collections.emptyList() : artifactVersion.artifact.constraints;
        Version minV = null;
        Version maxV = null;
        boolean limited = false;
        for (DatabaseArtifactList.Constraint c2 : constraints) {
            if (!c2.matches(version, dbms, true)) continue;
            limited = true;
            maxV = DatabaseDriverUtils.merge(maxV, c2.dbFrom, 1);
            minV = DatabaseDriverUtils.merge(minV, c2.dbTo, -1);
        }
        if (limited && minV == null && maxV == null) {
            return Couple.of((Object)Version.INFINITY, (Object)Version.ZERO);
        }
        return Couple.of((Object)Objects.requireNonNullElse(minV, Version.ZERO), (Object)Objects.requireNonNullElse(maxV, Version.INFINITY));
    }

    private static Version merge(Version minV, Version v, int s) {
        return minV == null || v != null && v.compareTo(minV) == s ? v : minV;
    }

    public static boolean isDriverFilesValid(@NotNull DatabaseArtifactList artifactList, @NotNull List<DatabaseDriver.ArtifactRef> artifacts, @Nullable Collection<SimpleClasspathElement> actual, @NotNull DatabaseArtifactContext context) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(5);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(7);
        }
        return ContainerUtil.and(artifacts, a -> DatabaseDriverUtils.isDriverFilesValid(artifactList, a.getId(), a.getArtifactVersion(), actual, context));
    }

    public static boolean isDriverFilesValid(@NotNull DatabaseArtifactList artifactList, @NotNull String artifact, @Nullable Version version, @Nullable Collection<SimpleClasspathElement> actual, @NotNull DatabaseArtifactContext context) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(8);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(10);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        if (version == null) {
            return actual != null && !actual.isEmpty() && DatabaseDriverUtils.isFileListExists(DatabaseDriverUtils.getUrls(actual));
        }
        return loader.isValid(artifactList, artifact, version, context);
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver driver, @NotNull List<DatabaseDriver.ArtifactRef> artifacts, @NotNull DatabaseArtifactContext context) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(11);
        }
        if (driver == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(12);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(13);
        }
        if (context == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(14);
        }
        return ContainerUtil.and(artifacts, a -> DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, driver, a.getId(), a.getArtifactVersion(), a.getChannel(), context));
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver driver, @NotNull String artifact, @Nullable Version version, @Nullable String channel, @NotNull DatabaseArtifactContext context) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(15);
        }
        if (driver == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(16);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(18);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        DatabaseArtifactList.ArtifactVersion actualVersion = DatabaseArtifactList.resolveVersion(artifactList, artifact, version, channel, driver);
        if (actualVersion == null) {
            return loader.isValid(artifactList, artifact, version, context);
        }
        return (version == Version.INFINITY || version == null || actualVersion.version.equals((Object)version)) && loader.isValid(actualVersion, context);
    }

    public static boolean hasMissingLocalFiles(@NotNull DatabaseArtifactList.ArtifactVersion artifactVersion, @NotNull DatabaseArtifactContext context) {
        if (artifactVersion == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(19);
        }
        if (context == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(20);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        return loader.hasMissingLocalFiles(artifactVersion, context);
    }

    @NotNull
    private static JBIterable<String> getUrls(@Nullable Collection<SimpleClasspathElement> actual) {
        JBIterable jBIterable = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (jBIterable == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    private static boolean isFileListExists(@NotNull JBIterable<String> urls) {
        if (urls == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(22);
        }
        return urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty();
    }

    public static int getFirstErrorPos(@NotNull LocalDataSource ds, @NotNull DatabaseDriver dr) {
        if (ds == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(23);
        }
        if (dr == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(24);
        }
        String url = StringUtil.notNullize((String)ds.getUrl());
        JdbcUrlParser parsed = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(dr.getJDBCUrlParsers(), url));
        if (parsed == null) {
            return 0;
        }
        parsed.setUrlText(url);
        List<TextRange> errors = parsed.getInvalidRanges();
        if (errors.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        TextRange firstError = Collections.min(errors, Comparator.comparing(TextRange::getStartOffset));
        return firstError.getStartOffset();
    }

    public static boolean passesConstraints(@NotNull DatabaseDriver driver, @NotNull LocalDataSource dataSource) {
        DatabaseDriver.Constraint constraint;
        if (driver == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(25);
        }
        if (dataSource == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(26);
        }
        if ((constraint = DatabaseDriverUtils.getConstraint(driver, dataSource)) == null) {
            return true;
        }
        return constraint.matches(dataSource.getDbms(), dataSource.getVersion());
    }

    public static DatabaseDriver.Constraint getConstraint(@NotNull DatabaseDriver driver, @NotNull LocalDataSource dataSource) {
        if (driver == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(27);
        }
        if (dataSource == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(28);
        }
        Set<DatabaseDriver.Constraint> constraints = driver.getConstraints();
        return (DatabaseDriver.Constraint)ContainerUtil.find(constraints, c2 -> c2.matches(dataSource.getDbms(), null));
    }

    public static List<Path> getNativeLibrariesPaths(@NotNull DatabaseDriver driver, DatabaseArtifactList.Item.Arch arch, @NotNull Project project) {
        if (driver == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(29);
        }
        if (project == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(30);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        DatabaseDriverClasspathManager manager = DatabaseDriverClasspathManager.Companion.getInstance(project);
        List<SimpleClasspathElement> libPaths = manager.getNativeLibraryPaths(driver);
        ArrayList<Path> result = new ArrayList<Path>();
        for (SimpleClasspathElement element : libPaths) {
            for (String url : element.getClassesRootUrls()) {
                File file = new File(StringUtil.trimStart((String)url, (String)"file://"));
                if (FileUtil.isJarOrZip((File)file)) {
                    Path nativeLibrary = loader.getNativeLibrary(file.toPath(), null, arch, DatabaseArtifactContext.Companion.getInstance(project, driver));
                    if (nativeLibrary == null) continue;
                    result.add(nativeLibrary);
                    continue;
                }
                result.add(file.isFile() ? file.getParentFile().toPath() : file.toPath());
            }
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        for (DatabaseDriver.ArtifactRef artifact : driver.getArtifacts()) {
            DatabaseArtifactList.ArtifactVersion version;
            if (artifact.getArtifactVersion() == null || (version = artifacts.resolveVersion(artifact.getId(), artifact.getArtifactVersion())) == null) continue;
            result.addAll(loader.getNativeLibraries(version, arch, DatabaseArtifactContext.Companion.getInstance(project, driver)));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactList";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactVersion";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverUtils";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverUtils";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesValid";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesUpToDate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingLocalFiles";
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFileListExists";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFirstErrorPos";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "passesConstraints";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getConstraint";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibrariesPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21 -> new IllegalStateException(string);
        };
    }
}

