/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.artifacts;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.util.DatabaseDriverManagerUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.platform.eel.path.EelPath;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactDefaultContext;", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "<init>", "()V", "createContextForDriver", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "getDownloadPath", "Ljava/nio/file/Path;", "useEel", "", "isApplicable", "item", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item;", "arch", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch;", "os", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$OS;", "getUserHome", "Lcom/intellij/platform/eel/path/EelPath;", "getNativeLibsRoot", "intellij.database.core.impl"})
public class DatabaseArtifactDefaultContext
implements DatabaseArtifactContext {
    @Override
    @NotNull
    public DatabaseArtifactContext createContextForDriver(@NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return this;
    }

    @Override
    @NotNull
    public Path getDownloadPath() {
        Path path = Path.of(DatabaseDriverManagerUtil.getDownloadPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @Override
    public boolean useEel() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull DatabaseArtifactList.Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        DatabaseArtifactList.Item.OS oS = item.os;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oS), (String)"os");
        if (!this.isApplicable(oS)) return false;
        if (item.archDependsOn != DatabaseArtifactList.Item.ArchDependsOn.SYSTEM) return true;
        DatabaseArtifactList.Item.Arch arch = item.arch;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)arch), (String)"arch");
        if (!this.isApplicable(arch)) return false;
        return true;
    }

    @Override
    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.Arch arch) {
        Intrinsics.checkNotNullParameter((Object)((Object)arch), (String)"arch");
        return arch.applicable;
    }

    @Override
    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.OS os) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        return os.applicable;
    }

    @Override
    @Nullable
    public EelPath getUserHome() {
        return null;
    }

    @Override
    @NotNull
    public Path getNativeLibsRoot() {
        Path path = Path.of(PathManager.getSystemPath(), new String[0]).resolve("jdbc-native-deps");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

