/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcUrlParserUtil {
    @Nullable
    public static JdbcUrlParser stateful(@Nullable StatelessJdbcUrlParser parser) {
        return parser == null ? null : parser.createStateful();
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url) {
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(0);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(1);
        }
        return JdbcUrlParserUtil.select(parsers, url, null);
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable StatelessJdbcUrlParser.LocationType loc) {
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(2);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(3);
        }
        StatelessJdbcUrlParser chosen = null;
        int rank = -1;
        for (StatelessJdbcUrlParser p : parsers) {
            int curRank;
            if (loc != null && !p.getPossibleLocations().contains((Object)loc) || !p.isUrlValueValid(url) || (curRank = JdbcUrlParserUtil.getRank(JdbcUrlParserUtil.parsed(p, url))) <= rank) continue;
            chosen = p;
            rank = curRank;
        }
        return chosen;
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable StatelessJdbcUrlParser parser, @Nullable String url) {
        if (url == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtil.stateful(parser);
        if (stateful == null) {
            return null;
        }
        stateful.setUrlText(url);
        return stateful.isValid() ? stateful : null;
    }

    public static int getRank(@Nullable JdbcUrlParser parsed) {
        int curRank = 0;
        if (parsed != null) {
            for (String parameter : parsed.getParameterNames()) {
                if (!StringUtil.isNotEmpty((String)parsed.getParameter(parameter))) continue;
                ++curRank;
            }
        }
        return curRank;
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config) {
        if (config == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(4);
        }
        return JdbcUrlParserUtil.select(config, config.getUrl());
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config, @Nullable String url) {
        DatabaseDriver driver;
        if (config == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(5);
        }
        if (url == null) {
            return null;
        }
        if (config instanceof DatabaseConnectionPoint && (driver = ((DatabaseConnectionPoint)config).getDatabaseDriver()) != null) {
            return JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url);
        }
        return JdbcUrlParserUtil.select(config, url, DatabaseDriverManager.getInstance().getDrivers());
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config, @NotNull String url, Collection<? extends DatabaseDriver> drivers) {
        if (config == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(6);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(7);
        }
        for (DatabaseDriver databaseDriver : drivers) {
            StatelessJdbcUrlParser parser;
            if (!Objects.equals(config.getDriverClass(), databaseDriver.getDriverClass()) || (parser = JdbcUrlParserUtil.select(databaseDriver.getJDBCUrlParsers(), url)) == null) continue;
            return parser;
        }
        return null;
    }

    public static boolean areParametersValidFor(@NotNull StatelessJdbcUrlParser parser, @NotNull Map<String, String> parameters) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            StatelessParametersHolder.ParameterInfo info;
            if (StringUtil.isEmpty((String)entry.getValue()) || (info = parser.getParameterInfo(entry.getKey())) != null && (info.getQuote() != null || info.isValueValid(entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config, @Nullable String url) {
        if (config == null) {
            return null;
        }
        StatelessJdbcUrlParser parser = JdbcUrlParserUtil.select(config, url);
        return JdbcUrlParserUtil.parsed(parser, url);
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config) {
        String url = config == null ? null : config.getUrl();
        return JdbcUrlParserUtil.parsed(config, url);
    }

    @Nullable
    public static HostPort extractFirstHostPort(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p) {
        List<HostPort> hostsPorts;
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(10);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(11);
        }
        return (hostsPorts = JdbcUrlParserUtil.extractHostsPorts(parsers, url, p)).isEmpty() ? null : hostsPorts.get(0);
    }

    @NotNull
    public static @NotNull List<@NotNull HostPort> extractHostsPorts(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p) {
        JdbcUrlParser parser;
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(12);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(13);
        }
        if ((parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(parsers, url, StatelessJdbcUrlParser.LocationType.REMOTE))) != null) {
            parser.setUrlText(url);
        }
        if (parser == null || !parser.isValid()) {
            List<HostPort> list = Collections.emptyList();
            if (list == null) {
                JdbcUrlParserUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (p != null) {
            p.set((Object)parser);
        }
        List<String> hosts = parser.getParameters("host");
        List<String> ports = parser.getParameters("port");
        if (hosts.size() != ports.size()) {
            List<HostPort> list = Collections.emptyList();
            if (list == null) {
                JdbcUrlParserUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<HostPort> hostsPorts = new ArrayList<HostPort>();
        for (int i2 = 0; i2 < hosts.size(); ++i2) {
            String host = hosts.get(i2);
            String port = ports.get(i2);
            if (StringUtil.isEmpty((String)port)) {
                port = parser.getParameterDefValue("port");
            }
            if (StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port)) continue;
            hostsPorts.add(new HostPort(host, port));
        }
        ArrayList<HostPort> arrayList = hostsPorts;
        if (arrayList == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(17);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(18);
        }
        if (JdbcUrlParserUtil.areBoundsInapplicable(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly())) {
            return connectionPoint;
        }
        if (!connectionPoint.getDataSource().isRewriteBounds() || bounds.rewriteParameters.isEmpty()) {
            return null;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters, null);
        if (JdbcUrlParserUtil.isBoundDetectionFailed(bounds, parser, parameter)) {
            return null;
        }
        if (!JdbcUrlParserUtil.isBoundDetectionUnsure(bounds, parser, parameter)) {
            if (StringUtil.isEmpty((String)parameter)) {
                parameter = bounds.defaultValue;
            }
            if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
                return connectionPoint;
            }
        }
        return JdbcUrlParserUtil.rebound(parser, connectionPoint, bounds, neededParam);
    }

    private static boolean isBoundDetectionUnsure(DatabaseDriver.Bounds bounds, LazyStatefulParser parser, String parameter) {
        return parameter == null && parser.getParser() == null && ContainerUtil.exists(bounds.rewriteParameters, p -> (Boolean)p.second);
    }

    private static boolean isBoundDetectionFailed(DatabaseDriver.Bounds bounds, LazyStatefulParser parser, String parameter) {
        return parameter == null && parser.getParser() == null && (Boolean)bounds.rewriteParameters.get((int)0).second != false;
    }

    public static boolean isBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(19);
        }
        return (bounds = JdbcUrlParserUtil.getBounds(connectionPoint)) != null && (!bounds.inReadOnlyMode || connectionPoint.isReadOnly());
    }

    public static boolean isDatabaseBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(20);
        }
        if (!JdbcUrlParserUtil.isBounded(connectionPoint)) {
            return false;
        }
        DatabaseDriver.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds != null && bounds.boundTo == ObjectKind.DATABASE;
    }

    @Nullable
    public static DatabaseDriver.Bounds getBounds(@Nullable DatabaseConnectionPoint connectionPoint) {
        return JdbcUrlParserUtil.getBounds(connectionPoint == null ? null : connectionPoint.getDatabaseDriver());
    }

    @Nullable
    private static DatabaseDriver.Bounds getBounds(@Nullable DatabaseDriver driver) {
        return driver == null ? null : driver.getConnectionBounds();
    }

    public static boolean isReboundable(@NotNull DatabaseConnectionPoint connectionPoint) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(21);
        }
        if (!connectionPoint.getDataSource().isRewriteBounds()) {
            return false;
        }
        DatabaseDriver.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds != null && !bounds.rewriteParameters.isEmpty();
    }

    @Nullable
    private static DatabaseConnectionPoint rebound(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDriver.Bounds bounds, final @NotNull String neededParam) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(22);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(23);
        }
        if (bounds == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(24);
        }
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(25);
        }
        if (bounds.rewriteParameters.isEmpty() || !connectionPoint.getDataSource().isRewriteBounds()) {
            return null;
        }
        final Pair<String, Boolean> param = JdbcUrlParserUtil.chooseRewriteParameter(parser, connectionPoint, bounds);
        if (((Boolean)param.second).booleanValue()) {
            JdbcUrlParser urlParser = parser.getParser();
            if (urlParser == null) {
                return null;
            }
            urlParser.setParameter((String)param.first, neededParam);
            final String rewritten = urlParser.getUrlText();
            return new DatabaseConnectionPoint.Adapter(connectionPoint){

                @Override
                public String getUrl() {
                    return rewritten;
                }
            };
        }
        return new DatabaseConnectionPoint.Adapter(connectionPoint){

            @Override
            @NotNull
            public Properties getConnectionProperties() {
                Properties properties = super.getConnectionProperties();
                properties.setProperty((String)param.first, neededParam);
                Properties properties2 = properties;
                if (properties2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return properties2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil$2", "getConnectionProperties"));
            }
        };
    }

    private static Pair<String, Boolean> chooseRewriteParameter(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDriver.Bounds bounds) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(26);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(27);
        }
        if (bounds == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(28);
        }
        Ref index = Ref.create();
        JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters, (Ref<Integer>)index);
        if (!index.isNull()) {
            return bounds.rewriteParameters.get((Integer)index.get());
        }
        List<Pair<String, Boolean>> parameters = bounds.rewriteParameters;
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            Pair<String, Boolean> p = parameters.get(i2);
            if (((Boolean)p.second).booleanValue()) continue;
            return p;
        }
        return bounds.rewriteParameters.get(0);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull SearchPath path, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(29);
        }
        if (path == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(30);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(31);
        }
        if ((bounds = JdbcUrlParserUtil.getBounds(connectionPoint)) == null) {
            return false;
        }
        ObjectPath b = needed.findParent(bounds.boundTo, false);
        if (b == null) {
            return false;
        }
        return ContainerUtil.find((Iterable)path.elements, e -> e.findParent(bounds.boundTo, false) == b) == null;
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(32);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(33);
        }
        if (JdbcUrlParserUtil.areBoundsInapplicable(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly())) {
            return false;
        }
        if (!connectionPoint.getDataSource().isRewriteBounds() || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters, null);
        if (JdbcUrlParserUtil.isBoundDetectionUnsure(bounds, parser, parameter)) {
            return true;
        }
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull TreePattern needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(34);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(35);
        }
        if (JdbcUrlParserUtil.areBoundsInapplicable(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly())) {
            return false;
        }
        if (!connectionPoint.getDataSource().isRewriteBounds() || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        TreePatternNode.Group neededParam = needed.root.getGroup(bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters, null);
        if (JdbcUrlParserUtil.isBoundDetectionUnsure(bounds, parser, parameter)) {
            return true;
        }
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static String getBoundParameter(@NotNull DatabaseConnectionPoint connectionPoint) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(36);
        }
        if (JdbcUrlParserUtil.areBoundsInapplicable(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return null;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters, null);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return StringUtil.nullize((String)parameter);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath current, @NotNull ObjectPath needed) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(37);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(38);
        }
        if (current == null) {
            return JdbcUrlParserUtil.outOfBounds(connectionPoint, needed);
        }
        return JdbcUrlParserUtil.outOfBounds(connectionPoint.getDatabaseDriver(), connectionPoint.isReadOnly(), current, needed);
    }

    public static boolean outOfBounds(@Nullable DatabaseDriver driver, boolean isReadOnly, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (current == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(39);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(40);
        }
        if (JdbcUrlParserUtil.areBoundsInapplicable(bounds = JdbcUrlParserUtil.getBounds(driver), isReadOnly)) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo), neededParam);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull String neededParam) {
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(41);
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.equalsIgnoreCase(currentParameter);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull TreePatternNode.Group neededParam) {
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(42);
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.matchedChildren(ObjectName.plain((String)currentParameter), CasingProvider.MIXED_CASING, null);
    }

    private static boolean areBoundsInapplicable(@Nullable DatabaseDriver.Bounds bounds, boolean isReadOnly) {
        return bounds == null || !isReadOnly && bounds.inReadOnlyMode;
    }

    @Nullable
    public static ObjectPath toBound(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath path) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(43);
        }
        if (path == null || !JdbcUrlParserUtil.outOfBounds(connectionPoint, path)) {
            return null;
        }
        DatabaseDriver.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds == null ? null : JdbcUrlParserUtil.getObjectPathTo(path, bounds.boundTo);
    }

    @Nullable
    public static String getObjectItem(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        ObjectPath p;
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(44);
        }
        return (p = JdbcUrlParserUtil.getObjectPathTo(path, kind)) == null ? null : p.getName();
    }

    @Nullable
    public static ObjectPath getObjectPathTo(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(45);
        }
        return path == null ? null : path.findParent(kind, false);
    }

    @Nullable
    private static String findParameter(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull List<Pair<String, Boolean>> params, @Nullable Ref<Integer> idx) {
        if (parser == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(46);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(47);
        }
        if (params == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(48);
        }
        HashMap<Object, Object> properties = null;
        for (int i2 = 0; i2 < params.size(); ++i2) {
            String value;
            Pair<String, Boolean> param = params.get(i2);
            if (((Boolean)param.second).booleanValue()) {
                JdbcUrlParser urlParser = parser.getParser();
                if (urlParser == null) {
                    return null;
                }
                value = StringUtil.nullize((String)urlParser.getParameter((String)param.first));
            } else {
                if (properties == null) {
                    properties = new HashMap<Object, Object>(connectionPoint.getConnectionProperties());
                }
                value = (String)ObjectUtils.tryCast(properties.get(param.first), String.class);
            }
            if (value == null) continue;
            if (idx != null) {
                idx.set((Object)i2);
            }
            return value;
        }
        return null;
    }

    public static boolean isAuthSupported(@NotNull StatelessParametersHolder parametersHolder) {
        Collection<String> parameters;
        if (parametersHolder == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(49);
        }
        return (parameters = parametersHolder.getParameterNames()).contains("password") || parameters.contains("user");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: 
            case 22: 
            case 26: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 18: 
            case 31: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 25: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neededParam";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHostsPorts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areParametersValidFor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractFirstHostPort";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractHostsPorts";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "connectedTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBounded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseBounded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReboundable";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rebound";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseRewriteParameter";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "outOfBounds";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBoundParameter";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "paramOutOfBounds";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toBound";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getObjectItem";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPathTo";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findParameter";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isAuthSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static final class LazyStatefulParser {
        private final RawConnectionConfig myConfig;
        private Ref<JdbcUrlParser> myParser;

        private LazyStatefulParser(RawConnectionConfig config) {
            this.myConfig = config;
        }

        @Nullable
        JdbcUrlParser getParser() {
            if (this.myParser == null) {
                this.myParser = Ref.create((Object)JdbcUrlParserUtil.parsed(this.myConfig));
            }
            return (JdbcUrlParser)this.myParser.get();
        }
    }

    public static final class SimpleDataSourceURLBuilder {
        private static final String REGION_PARAMETER = "region";
        private final JdbcUrlParser myParser;
        private final Set<String> myParameterNames;

        private SimpleDataSourceURLBuilder(@NotNull DatabaseDriver driver, @NotNull Set<String> expectedParameters) {
            if (driver == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(0);
            }
            if (expectedParameters == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(1);
            }
            StatelessJdbcUrlParser sparser = (StatelessJdbcUrlParser)ContainerUtil.find(driver.getJDBCUrlParsers(), p -> p.getParameterNames().containsAll(expectedParameters));
            if (sparser == null) {
                throw new IllegalStateException("No JDBC URL parser found for driver " + driver.getId() + " and parameters '" + String.valueOf(expectedParameters) + "')");
            }
            this.myParser = sparser.createStateful();
            for (String parameter : sparser.getParameterNames()) {
                this.myParser.setParameter(parameter, StringUtil.notNullize((String)sparser.getParameterDefValue(parameter)));
            }
            this.myParameterNames = new HashSet<String>(sparser.getParameterNames());
        }

        @NotNull
        public static SimpleDataSourceURLBuilder create(@NotNull DatabaseDriver driver, @NotNull Set<String> expectedParameters) {
            if (driver == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(2);
            }
            if (expectedParameters == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(3);
            }
            return new SimpleDataSourceURLBuilder(driver, expectedParameters);
        }

        @NotNull
        public SimpleDataSourceURLBuilder setHost(@NotNull String host) {
            if (host == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(4);
            }
            this.myParser.setParameter("host", host);
            SimpleDataSourceURLBuilder simpleDataSourceURLBuilder = this;
            if (simpleDataSourceURLBuilder == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(5);
            }
            return simpleDataSourceURLBuilder;
        }

        @NotNull
        public SimpleDataSourceURLBuilder setPort(@NotNull String port) {
            if (port == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(6);
            }
            this.myParser.setParameter("port", port);
            SimpleDataSourceURLBuilder simpleDataSourceURLBuilder = this;
            if (simpleDataSourceURLBuilder == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(7);
            }
            return simpleDataSourceURLBuilder;
        }

        @NotNull
        public SimpleDataSourceURLBuilder setDatabase(@NotNull String database) {
            if (database == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(8);
            }
            this.myParser.setParameter("database", database);
            SimpleDataSourceURLBuilder simpleDataSourceURLBuilder = this;
            if (simpleDataSourceURLBuilder == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(9);
            }
            return simpleDataSourceURLBuilder;
        }

        @NotNull
        public SimpleDataSourceURLBuilder setRegion(@NotNull String region) {
            if (region == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(10);
            }
            if (!this.myParameterNames.contains(REGION_PARAMETER)) {
                throw new IllegalArgumentException("Parameter 'region' is not supported by parser");
            }
            this.myParser.setParameter(REGION_PARAMETER, region);
            SimpleDataSourceURLBuilder simpleDataSourceURLBuilder = this;
            if (simpleDataSourceURLBuilder == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(11);
            }
            return simpleDataSourceURLBuilder;
        }

        @NotNull
        public SimpleDataSourceURLBuilder setParameter(@NotNull String parameter, @NotNull String value) {
            if (parameter == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(12);
            }
            if (value == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(13);
            }
            if (!this.myParameterNames.contains(parameter)) {
                throw new IllegalArgumentException("Parameter '" + parameter + "' is not supported by parser");
            }
            this.myParser.setParameter(parameter, value);
            SimpleDataSourceURLBuilder simpleDataSourceURLBuilder = this;
            if (simpleDataSourceURLBuilder == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(14);
            }
            return simpleDataSourceURLBuilder;
        }

        @NotNull
        public String build() {
            String string = this.myParser.getUrlText();
            if (string == null) {
                SimpleDataSourceURLBuilder.$$$reportNull$$$0(15);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 9, 11, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedParameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil$SimpleDataSourceURLBuilder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "port";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "database";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = REGION_PARAMETER;
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil$SimpleDataSourceURLBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHost";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPort";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDatabase";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRegion";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setParameter";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setHost";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 15: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setPort";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setDatabase";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setRegion";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setParameter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 9, 11, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

