/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure.forest;

import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.AnyFun;
import com.intellij.database.view.structure.forest.DvArm;
import com.intellij.database.view.structure.forest.DvBushRef;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForestRootFolder;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.util.containers.UtilKt;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 J*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001JB\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0001\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u001bJ,\u0010\u001c\u001a\u0002H\u0018\"\u0004\b\u0001\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0000\u00a2\u0006\u0004\b-\u0010.J\u0006\u0010/\u001a\u000200J\r\u00101\u001a\u000200H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u000200H\u0000\u00a2\u0006\u0002\b4J\r\u00105\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b9J\u0019\u0010:\u001a\u0002002\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0000\u00a2\u0006\u0002\b;J\u0019\u0010<\u001a\u0002002\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0000\u00a2\u0006\u0002\b=J\u0010\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020?J\u0013\u0010A\u001a\u00020B2\u0006\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010CJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020?0E2\u0006\u0010@\u001a\u00020?J\u000e\u0010F\u001a\u00020\"2\u0006\u0010@\u001a\u00020?J\u000e\u0010G\u001a\u00020\"2\u0006\u0010@\u001a\u00020?J\u000e\u0010H\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020?J\u000e\u0010I\u001a\u00020,2\u0006\u0010@\u001a\u00020?R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0011\u0010 \u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006K"}, d2={"Lcom/intellij/database/view/structure/forest/DvForest;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "", "bushClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "getBushClass", "()Ljava/lang/Class;", "root", "Lcom/intellij/database/view/structure/forest/DvForestRootFolder;", "getRoot", "()Lcom/intellij/database/view/structure/forest/DvForestRootFolder;", "orderCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "bushes", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/view/structure/forest/DvBushRef;", "modifyingThread", "Ljava/lang/Thread;", "readTree", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "modifyTree", "isNotEmpty", "", "()Z", "isEmpty", "bushRefCount", "", "getBushRefCount", "()I", "isBushRegistered", "bush", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)Z", "ensureFolderPath", "Lcom/intellij/database/view/structure/forest/DvFolder;", "path", "", "", "ensureFolderPath$intellij_database_core_impl", "([Ljava/lang/String;)Lcom/intellij/database/view/structure/forest/DvFolder;", "renumberAll", "", "clearAll", "clearAll$intellij_database_core_impl", "checkModifyingThread", "checkModifyingThread$intellij_database_core_impl", "nextOrderId", "nextOrderId$intellij_database_core_impl", "adjustOrderId", "orderId", "adjustOrderId$intellij_database_core_impl", "registerBush", "registerBush$intellij_database_core_impl", "deregisterBush", "deregisterBush$intellij_database_core_impl", "treeParentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "treeParentOfBush", "Lcom/intellij/database/view/structure/forest/DvArm;", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)Lcom/intellij/database/view/structure/forest/DvArm;", "treeChildrenOf", "Lkotlin/sequences/Sequence;", "treeCountAllChildrenOf", "treeCountRealChildrenOf", "treeIsValid", "treePresentableNameOf", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvForest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForest.kt\ncom/intellij/database/view/structure/forest/DvForest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,208:1\n1#2:209\n18#3:210\n*S KotlinDebug\n*F\n+ 1 DvForest.kt\ncom/intellij/database/view/structure/forest/DvForest\n*L\n193#1:210\n*E\n"})
public final class DvForest<B extends BasicUniqueBush> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<B> bushClass;
    @NotNull
    private final DvForestRootFolder root;
    @NotNull
    private final AtomicInteger orderCounter;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final WeakHashMap<B, DvBushRef<B>> bushes;
    @Nullable
    private volatile transient Thread modifyingThread;

    @NotNull
    public final Class<B> getBushClass() {
        return this.bushClass;
    }

    @NotNull
    public final DvForestRootFolder getRoot() {
        return this.root;
    }

    public DvForest(@NotNull Class<B> bushClass) {
        Intrinsics.checkNotNullParameter(bushClass, (String)"bushClass");
        this.orderCounter = new AtomicInteger(0);
        this.bushClass = bushClass;
        this.root = new DvForestRootFolder(this);
        this.lock = new ReentrantReadWriteLock();
        this.bushes = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R readTree(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock.ReadLock wl = this.lock.readLock();
        wl.lock();
        try {
            Object object = action.invoke();
            return (R)object;
        }
        finally {
            wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R modifyTree(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock.WriteLock wl = this.lock.writeLock();
        wl.lock();
        try {
            this.modifyingThread = Thread.currentThread();
            Object object = action.invoke();
            return (R)object;
        }
        finally {
            this.modifyingThread = null;
            wl.unlock();
        }
    }

    public final boolean isNotEmpty() {
        return this.root.isNotEmpty();
    }

    public final boolean isEmpty() {
        return this.root.isEmpty();
    }

    public final int getBushRefCount() {
        return this.bushes.size();
    }

    public final boolean isBushRegistered(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        return this.bushes.containsKey(bush);
    }

    @NotNull
    public final DvFolder ensureFolderPath$intellij_database_core_impl(@NotNull String[] path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DvFolder folder = this.root;
        for (String nameInPath : path) {
            Object v0;
            String name;
            block3: {
                name = ((Object)StringsKt.trim((CharSequence)nameInPath)).toString();
                if (((CharSequence)name).length() == 0) continue;
                Iterable iterable = folder.getInnerFolders();
                for (Object t : iterable) {
                    DvNiceFolder it = (DvNiceFolder)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            DvNiceFolder f = v0;
            if (f == null) {
                f = folder.createNewInnerFolder(name);
            }
            folder = f;
        }
        return folder;
    }

    public final void renumberAll() {
        this.modifyTree(() -> DvForest.renumberAll$lambda$0(this));
    }

    public final void clearAll$intellij_database_core_impl() {
        this.checkModifyingThread$intellij_database_core_impl();
        this.root.clearAll$intellij_database_core_impl();
        this.bushes.clear();
        this.orderCounter.set(0);
    }

    public final void checkModifyingThread$intellij_database_core_impl() throws ConcurrentModificationException {
        Thread currentThread = Thread.currentThread();
        Thread modifyingThread = this.modifyingThread;
        if (modifyingThread == null) {
            String string = currentThread.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String currentThreadStr = string;
            throw new ConcurrentModificationException("Attempting to modify the forest without capturing the lock. The current thread is " + currentThreadStr);
        }
        if (!Intrinsics.areEqual((Object)currentThread, (Object)modifyingThread)) {
            String string = currentThread.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String currentThreadStr = string;
            String string2 = modifyingThread.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String modifyingThreadStr = string2;
            throw new ConcurrentModificationException("Attempting to modify the forest without capturing the lock, when another thread is already modifying it. The current thread is " + currentThreadStr + ", the modifying thread is " + modifyingThreadStr);
        }
    }

    public final int nextOrderId$intellij_database_core_impl() {
        return this.orderCounter.incrementAndGet();
    }

    public final void adjustOrderId$intellij_database_core_impl(int orderId) {
        this.orderCounter.getAndUpdate(arg_0 -> DvForest.adjustOrderId$lambda$0(orderId, arg_0));
    }

    public final void registerBush$intellij_database_core_impl(@NotNull DvBushRef<?> bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        Map map = this.bushes;
        Object obj = bush.getBush();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type B of com.intellij.database.view.structure.forest.DvForest");
        Object obj2 = obj;
        DvBushRef<?> dvBushRef = bush;
        map.put(obj2, dvBushRef);
    }

    public final void deregisterBush$intellij_database_core_impl(@NotNull DvBushRef<?> bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        Map map = this.bushes;
        Object obj = bush.getBush();
        TypeIntrinsics.asMutableMap((Object)map).remove(obj);
    }

    @Nullable
    public final BasicNode treeParentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvArm ? (BasicNode)((DvArm)node).getParent() : (AnyFun.isInstanceOf((Object)node, this.bushClass) ? (BasicNode)this.treeParentOfBush((BasicUniqueBush)node) : null);
    }

    @NotNull
    public final DvArm treeParentOfBush(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        DvBushRef<B> dvBushRef = this.bushes.get(bush);
        return dvBushRef != null && (dvBushRef = dvBushRef.getParent()) != null ? (DvArm)dvBushRef : (DvArm)this.root;
    }

    @NotNull
    public final Sequence<BasicNode> treeChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvFolder ? ((DvFolder)node).getSuitableChildren() : (basicNode instanceof DvBushRef ? UtilKt.sequenceOfNotNull(((DvBushRef)node).getBush()) : SequencesKt.emptySequence());
    }

    /*
     * WARNING - void declaration
     */
    public final int treeCountAllChildrenOf(@NotNull BasicNode node) {
        int n;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof DvFolder) {
            n = ((DvFolder)node).getSuitableChildrenCount();
        } else if (basicNode instanceof DvBushRef) {
            int _true_$iv;
            void $this$choose$iv;
            boolean bl = ((DvBushRef)node).isValid();
            boolean bl2 = true;
            int _false_$iv = 0;
            boolean $i$f$choose = false;
            n = $this$choose$iv != false ? _true_$iv : _false_$iv;
        } else {
            n = 0;
        }
        return n;
    }

    public final int treeCountRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.treeCountAllChildrenOf(node);
    }

    public final boolean treeIsValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvBushRef ? ((DvBushRef)node).isValid() : true;
    }

    @NotNull
    public final String treePresentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final Unit renumberAll$lambda$0(DvForest this$0) {
        int counter = 0;
        Sequence<DvArm> armSequence = this$0.root.traversAll();
        for (DvArm a : armSequence) {
            DvArm dvArm = a;
            if (dvArm instanceof DvForestRootFolder) continue;
            if (dvArm instanceof DvNiceFolder) {
                ((DvNiceFolder)a).setOrderId(++counter);
                continue;
            }
            if (dvArm instanceof DvBushRef) {
                ((DvBushRef)a).setOrderId(++counter);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this$0.orderCounter.set(counter);
        return Unit.INSTANCE;
    }

    private static final int adjustOrderId$lambda$0(int $orderId, int curr) {
        return Math.max($orderId, curr);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u0007H\u0086\b\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/structure/forest/DvForest$Companion;", "", "<init>", "()V", "createForest", "Lcom/intellij/database/view/structure/forest/DvForest;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <B extends BasicUniqueBush> DvForest<B> createForest() {
            boolean $i$f$createForest = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"B");
            return new DvForest<BasicUniqueBush>(BasicUniqueBush.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

