/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.microservices.jvm.config.ConfigKeyDeclarationPsiElement;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.ValueHintPsiElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigKeyDocumentationProviderBase
extends AbstractDocumentationProvider {
    private static final String CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX = "CONFIG_KEY_DECLARATION_PSI_ELEMENT_";
    private static final String CONFIG_KEY_LINK_SEPARATOR = "___";
    public static final Key<Module> CONFIG_KEY_DECLARATION_MODULE = Key.create((String)"ConfigKeyDeclarationModule");
    @NonNls
    private static final String UNKNOWN_TYPE = "unknown type";
    @NonNls
    private static final String DEPRECATED = "Deprecated";
    @NonNls
    private static final String DEFAULT = "Default";
    @NonNls
    private static final String VALUES = "Values";
    @NonNls
    private static final String SEE = "See";
    @NonNls
    private static final String ORIGINAL_DOCUMENTATION = "Original documentation";

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKey = (ConfigKeyDeclarationPsiElement)element;
            StringBuilder sb = new StringBuilder();
            sb.append("<b>").append(configKey.getName()).append("</b>");
            String locationString = configKey.getLocationString();
            if (locationString != null) {
                sb.append(" [").append(StringUtil.escapeXmlEntities((String)locationString)).append("]\n");
            }
            ConfigKeyDocumentationProviderBase.appendConfigKeyType(sb, element, configKey.getType());
            @NlsSafe String info = sb.toString();
            return info;
        }
        String valueHintDocumentation = ConfigKeyDocumentationProviderBase.getValueHintDocumentation(element);
        if (valueHintDocumentation != null) {
            return valueHintDocumentation;
        }
        return super.getQuickNavigateInfo(element, originalElement);
    }

    @Nullable
    @NlsSafe
    private static String getValueHintDocumentation(PsiElement element) {
        if (element instanceof ValueHintPsiElement) {
            MetaConfigKey.ValueHint hint = ((ValueHintPsiElement)element).getValueHint();
            return "<b>" + hint.getValue() + "</b>: " + hint.getDescriptionText().getFullText();
        }
        return null;
    }

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = (ConfigKeyDeclarationPsiElement)element;
            String keyName = configKeyDeclarationPsiElement.getName();
            return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey(element, keyName, this.getConfigManager());
        }
        String valueHintDocumentation = ConfigKeyDocumentationProviderBase.getValueHintDocumentation(element);
        if (valueHintDocumentation != null) {
            return valueHintDocumentation;
        }
        return this.generateDocForProperty(element);
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        if (!StringUtil.startsWith((CharSequence)link, (CharSequence)CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX)) {
            return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
        }
        String fqn = StringUtil.substringAfter((String)link, (String)CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX);
        assert (fqn != null) : link;
        String moduleName = StringUtil.substringBefore((String)fqn, (String)CONFIG_KEY_LINK_SEPARATOR);
        assert (moduleName != null) : link;
        String key = StringUtil.substringAfter((String)fqn, (String)CONFIG_KEY_LINK_SEPARATOR);
        Module module = ModuleManager.getInstance((Project)psiManager.getProject()).findModuleByName(moduleName);
        MetaConfigKey replacementKey = this.getConfigManager().findCanonicalApplicationMetaConfigKey(module, key);
        if (replacementKey != null) {
            return replacementKey.getDeclaration();
        }
        return super.getDocumentationElementForLink(psiManager, link, context);
    }

    @NotNull
    protected abstract MetaConfigKeyManager getConfigManager();

    @Nullable
    protected abstract String getConfigKey(PsiElement var1);

    @NlsSafe
    private String generateDocForProperty(PsiElement element) {
        String configKey = this.getConfigKey(element);
        if (configKey == null) {
            return ConfigKeyDocumentationProviderBase.generateDocForBeanProperty(element);
        }
        return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey(element, configKey, this.getConfigManager());
    }

    @Nullable
    private static String generateDocForBeanProperty(PsiElement element) {
        if (!(element instanceof BeanPropertyElement)) {
            return null;
        }
        BeanPropertyElement property = (BeanPropertyElement)element;
        PsiElement originalElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement((PsiElement)property.getMethod());
        return ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(originalElement);
    }

    private static void appendConfigKeyType(StringBuilder sb, PsiElement context, @Nullable PsiType psiType) {
        if (psiType == null) {
            sb.append('(').append(UNKNOWN_TYPE).append(')');
        } else {
            JavaDocInfoGeneratorFactory.create((Project)context.getProject(), null).generateType(sb, psiType, context);
        }
    }

    @Nullable
    @NlsSafe
    private static String getDocumentationTextForKey(@Nullable PsiElement originalElement, @Nullable String keyName, @NotNull MetaConfigKeyManager configKeyManager) {
        PsiElement docElement;
        String originalDoc;
        MetaConfigKey.Deprecation deprecation;
        if (configKeyManager == null) {
            ConfigKeyDocumentationProviderBase.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            return null;
        }
        Module module = (Module)ObjectUtils.chooseNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement), (Object)((Module)originalElement.getUserData(CONFIG_KEY_DECLARATION_MODULE)));
        MetaConfigKey key = configKeyManager.findCanonicalApplicationMetaConfigKey(module, keyName);
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append("<b>").append(keyName).append("</b><br>");
        ConfigKeyDocumentationProviderBase.appendConfigKeyType(sb, originalElement, key.getType());
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        String fullDescription = key.getDescriptionText().getFullText();
        boolean hasDescription = StringUtil.isNotEmpty((String)fullDescription);
        if (hasDescription) {
            sb.append(fullDescription);
            sb.append("<br><br>");
        }
        if ((deprecation = key.getDeprecation()) != MetaConfigKey.Deprecation.NOT_DEPRECATED) {
            String replacement;
            if (deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR) {
                sb.append("<font color='#").append(ColorUtil.toHex((Color)JBColor.RED)).append("'><b>").append(DEPRECATED).append("</b></font>");
            } else {
                sb.append("<b>").append(DEPRECATED).append("</b>");
            }
            String reasonText = deprecation.getReason().getFullText();
            if (StringUtil.isNotEmpty((String)reasonText)) {
                sb.append("  ").append(reasonText);
            }
            if ((replacement = deprecation.getReplacement()) != null) {
                sb.append("<br><em>").append(SEE).append(":</em> ");
                DocumentationManagerUtil.createHyperlink((StringBuilder)sb, (String)(CONFIG_KEY_DECLARATION_PSI_ELEMENT_PREFIX + module.getName() + CONFIG_KEY_LINK_SEPARATOR + replacement), (String)replacement, (boolean)true);
            }
            sb.append("<br>");
        }
        sb.append("</div>");
        sb.append("<table class='sections'>");
        String defaultValue = key.getDefaultValue();
        if (defaultValue != null) {
            ConfigKeyDocumentationProviderBase.appendSection(sb, DEFAULT, "<pre>" + defaultValue + "</pre>");
        }
        MetaConfigKey.ItemHint itemHint = key.getItemHint();
        List<MetaConfigKey.ValueHint> valueHints = itemHint.getValueHints();
        ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, valueHints, MetaConfigKey.ValueHint::getValue, hint -> hint.getDescriptionText().getFullText());
        PsiClass typeClass = ConfigKeyPathUtils.getPsiClass(key.getType());
        if (typeClass != null && typeClass.isEnum()) {
            List enumConstants = ContainerUtil.findAll((Object[])typeClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
            ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, enumConstants, field -> StringUtil.toLowerCase((String)StringUtil.defaultIfEmpty((String)field.getName(), (String)"<invalid>")), field -> {
                PsiElement navigationElement = field.getNavigationElement();
                if (!(navigationElement instanceof PsiDocCommentOwner)) {
                    return "";
                }
                PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                if (comment == null) {
                    return "";
                }
                StringBuilder doc = new StringBuilder();
                for (PsiElement element : comment.getDescriptionElements()) {
                    doc.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                }
                return doc.toString();
            });
        }
        sb.append("</table>");
        if (StringUtil.isEmpty((String)fullDescription) && StringUtil.isNotEmpty((String)(originalDoc = ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(docElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement(key.getDeclaration().getNavigationElement()))))) {
            sb.append("<div class='content'>");
            sb.append("<em>").append(ORIGINAL_DOCUMENTATION).append(":</em><br><br>");
            sb.append(originalDoc);
            sb.append("</div>");
        }
        return sb.toString();
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    private static <V> void appendValueDescriptionTable(StringBuilder sb, List<V> elements, Function<V, String> valueFunction, Function<V, String> descriptionFunction) {
        if (elements.isEmpty()) {
            return;
        }
        StringBuilder tableSb = new StringBuilder();
        tableSb.append("<table cellpadding=\"5\">");
        for (V value : elements) {
            tableSb.append("<tr>");
            tableSb.append("<td valign='top'><pre>").append((String)valueFunction.fun(value)).append("</pre></td>");
            tableSb.append("<td valign='top'>").append((String)descriptionFunction.fun(value)).append("</td>");
            tableSb.append("</tr>");
        }
        tableSb.append("</table>");
        ConfigKeyDocumentationProviderBase.appendSection(sb, VALUES, tableSb.toString());
    }

    @Nullable
    private static String getOriginalDocForPsiMember(PsiElement docElement) {
        if (!(docElement instanceof PsiMember)) {
            return null;
        }
        DocumentationProvider provider = DocumentationManager.getProviderFromElement((PsiElement)docElement);
        return provider.generateDoc(docElement, docElement);
    }

    @NotNull
    private static PsiElement getOriginalDocumentationElement(PsiElement navigationElement) {
        PsiField field;
        if (navigationElement instanceof PsiMethod && (field = PropertyUtilBase.findPropertyFieldByMember((PsiMember)((PsiMember)navigationElement))) != null && field.getDocComment() != null) {
            PsiField psiField = field;
            if (psiField == null) {
                ConfigKeyDocumentationProviderBase.$$$reportNull$$$0(1);
            }
            return psiField;
        }
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            ConfigKeyDocumentationProviderBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyDocumentationProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyDocumentationProviderBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalDocumentationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationTextForKey";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

