/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\r\u001a\u00020\u0000H\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\"H\u0016J\u0013\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "Lcom/intellij/openapi/util/JDOMExternalizable;", "", "entries", "", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "<init>", "(Ljava/util/List;)V", "()V", "entryCount", "", "getEntryCount", "()I", "clone", "copyFrom", "", "packageTable", "getEntries", "", "()[Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "insertEntryAt", "entry", "index", "removeEntryAt", "getEntryAt", "setEntryAt", "contains", "", "packageName", "", "removeEmptyPackages", "addEntry", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "parentNode", "equals", "other", "", "hashCode", "kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageEntryTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageEntryTable.kt\norg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n37#2,2:107\n1761#3,3:109\n1869#3,2:112\n*S KotlinDebug\n*F\n+ 1 KotlinPackageEntryTable.kt\norg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable\n*L\n26#1:107,2\n46#1:109,3\n60#1:112,2\n*E\n"})
public final class KotlinPackageEntryTable
implements JDOMExternalizable,
Cloneable {
    @NotNull
    private final List<KotlinPackageEntry> entries;

    public KotlinPackageEntryTable(@NotNull List<KotlinPackageEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
    }

    public KotlinPackageEntryTable() {
        this(new ArrayList());
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    @NotNull
    public KotlinPackageEntryTable clone() {
        KotlinPackageEntryTable clone = new KotlinPackageEntryTable();
        clone.copyFrom(this);
        return clone;
    }

    public final void copyFrom(@NotNull KotlinPackageEntryTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        this.entries.clear();
        this.entries.addAll((Collection<KotlinPackageEntry>)packageTable.entries);
    }

    @NotNull
    public final KotlinPackageEntry[] getEntries() {
        Collection $this$toTypedArray$iv = this.entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new KotlinPackageEntry[0]);
    }

    public final void insertEntryAt(@NotNull KotlinPackageEntry entry, int index) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(index, entry);
    }

    public final void removeEntryAt(int index) {
        this.entries.remove(index);
    }

    @NotNull
    public final KotlinPackageEntry getEntryAt(int index) {
        return this.entries.get(index);
    }

    public final void setEntryAt(@NotNull KotlinPackageEntry entry, int index) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.set(index, entry);
    }

    public final boolean contains(@NotNull String packageName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinPackageEntry it = (KotlinPackageEntry)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isSpecial() && it.matchesPackageName(packageName))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void removeEmptyPackages() {
        CollectionsKt.removeAll(this.entries, KotlinPackageEntryTable::removeEmptyPackages$lambda$0);
    }

    public final void addEntry(@NotNull KotlinPackageEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.entries.clear();
        List list = element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String packageName;
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"package")) continue;
            if (it.getAttributeValue("name") == null) {
                throw new InvalidDataException();
            }
            String string = it.getAttributeValue("alias");
            boolean alias = string != null ? Boolean.parseBoolean(string) : false;
            String string2 = it.getAttributeValue("withSubpackages");
            boolean withSubpackages = string2 != null ? Boolean.parseBoolean(string2) : false;
            KotlinPackageEntry entry = ((CharSequence)packageName).length() == 0 && !alias ? KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY : (((CharSequence)packageName).length() == 0 && alias ? KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY : new KotlinPackageEntry(packageName, withSubpackages));
            this.entries.add(entry);
        }
    }

    public void writeExternal(@NotNull Element parentNode) {
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        for (KotlinPackageEntry entry : this.entries) {
            Element element = new Element("package");
            parentNode.addContent(element);
            String name = entry.isSpecial() ? "" : entry.getPackageName();
            boolean alias = Intrinsics.areEqual((Object)entry, (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY);
            element.setAttribute("name", name);
            element.setAttribute("alias", String.valueOf(alias));
            element.setAttribute("withSubpackages", String.valueOf(entry.getWithSubpackages()));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinPackageEntryTable)) {
            return false;
        }
        if (this.getEntryCount() != ((KotlinPackageEntryTable)other).getEntryCount()) {
            return false;
        }
        int n = ((Collection)this.entries).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)this.entries.get(i), (Object)((KotlinPackageEntryTable)other).entries.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        KotlinPackageEntry kotlinPackageEntry = (KotlinPackageEntry)CollectionsKt.firstOrNull(this.entries);
        return kotlinPackageEntry != null ? kotlinPackageEntry.hashCode() : 0;
    }

    private static final boolean removeEmptyPackages$lambda$0(KotlinPackageEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)it.getPackageName());
    }
}

