/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/editor/wordSelection/KotlinCodeBlockSelectioner;", "Lcom/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase;", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "findBlockContentStart", "block", "findBlockContentEnd", "Companion", "kotlin.base.code-insight.minimal"})
public final class KotlinCodeBlockSelectioner
extends ExtendWordSelectionHandlerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canSelect(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return Companion.canSelect(e);
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ArrayList result = new ArrayList();
        PsiElement block = KotlinCodeBlockSelectioner.Companion.isBrace(e) ? e.getParent() : e;
        Intrinsics.checkNotNull((Object)block);
        int start = this.findBlockContentStart(block);
        int end = this.findBlockContentEnd(block);
        if (end > start) {
            result.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(start, end)));
        }
        TextRange textRange = block.getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        result.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)textRange));
        return result;
    }

    private final int findBlockContentStart(PsiElement block) {
        PsiElement psiElement = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)block)), KotlinCodeBlockSelectioner::findBlockContentStart$lambda$0), (int)1), KotlinCodeBlockSelectioner::findBlockContentStart$lambda$1));
        if (psiElement == null) {
            psiElement = block;
        }
        PsiElement element = psiElement;
        return PsiUtilsKt.getStartOffset((PsiElement)element);
    }

    private final int findBlockContentEnd(PsiElement block) {
        PsiElement psiElement = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)block))))), KotlinCodeBlockSelectioner::findBlockContentEnd$lambda$0), (int)1), KotlinCodeBlockSelectioner::findBlockContentEnd$lambda$1));
        if (psiElement == null) {
            psiElement = block;
        }
        PsiElement element = psiElement;
        return PsiUtilsKt.getEndOffset((PsiElement)element);
    }

    private static final boolean findBlockContentStart$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.LBRACE);
    }

    private static final boolean findBlockContentStart$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace;
    }

    private static final boolean findBlockContentEnd$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.RBRACE);
    }

    private static final boolean findBlockContentEnd$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/editor/wordSelection/KotlinCodeBlockSelectioner$Companion;", "", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "isTarget", "isBrace", "kotlin.base.code-insight.minimal"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canSelect(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isTarget(e)) return true;
            if (!this.isBrace(e)) return false;
            PsiElement psiElement = e.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            if (!this.isTarget(psiElement)) return false;
            return true;
        }

        private final boolean isTarget(PsiElement e) {
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e), (Object)KtNodeTypes.BLOCK) || e instanceof KtWhenExpression;
        }

        private final boolean isBrace(PsiElement e) {
            IElementType iElementType = e.getNode().getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType elementType = iElementType;
            return Intrinsics.areEqual((Object)elementType, (Object)KtTokens.LBRACE) || Intrinsics.areEqual((Object)elementType, (Object)KtTokens.RBRACE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

