/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtil;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a7\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u001b\u0010\u0011\u001a\u0017\u0012\b\u0012\u00060\u0013R\u00020\r\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\u0002\b\u0014\u001a7\u0010\u0015\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u001b\u0010\u0011\u001a\u0017\u0012\b\u0012\u00060\u0013R\u00020\r\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\u0002\b\u0014\u001a\u0018\u0010\u0016\u001a\u0004\u0018\u00010\r*\u00060\u0013R\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0002\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0016\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0016\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\u00a8\u0006$"}, d2={"MODIFIERS_LIST_ENTRIES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getMODIFIERS_LIST_ENTRIES", "()Lcom/intellij/psi/tree/TokenSet;", "EXTEND_COLON_ELEMENTS", "getEXTEND_COLON_ELEMENTS", "DECLARATIONS", "getDECLARATIONS", "TYPE_COLON_ELEMENTS", "getTYPE_COLON_ELEMENTS", "beforeInside", "", "Lcom/intellij/formatting/SpacingBuilder;", "element", "Lcom/intellij/psi/tree/IElementType;", "tokenSet", "spacingFun", "Lkotlin/Function1;", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "Lkotlin/ExtensionFunctionType;", "afterInside", "spacesNoLineBreak", "spaces", "", "createSpacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "builderUtil", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "excludeLambdasAndObjects", "", "Lcom/intellij/openapi/util/TextRange;", "parent", "Lcom/intellij/formatting/ASTBlock;", "kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nkotlinSpacingRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinSpacingRules.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingRulesKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,761:1\n13805#2,2:762\n13805#2,2:764\n1#3:766\n*S KotlinDebug\n*F\n+ 1 kotlinSpacingRules.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingRulesKt\n*L\n34#1:762,2\n38#1:764,2\n*E\n"})
public final class KotlinSpacingRulesKt {
    @NotNull
    private static final TokenSet MODIFIERS_LIST_ENTRIES;
    @NotNull
    private static final TokenSet EXTEND_COLON_ELEMENTS;
    @NotNull
    private static final TokenSet DECLARATIONS;
    @NotNull
    private static final TokenSet TYPE_COLON_ELEMENTS;

    @NotNull
    public static final TokenSet getMODIFIERS_LIST_ENTRIES() {
        return MODIFIERS_LIST_ENTRIES;
    }

    @NotNull
    public static final TokenSet getEXTEND_COLON_ELEMENTS() {
        return EXTEND_COLON_ELEMENTS;
    }

    @NotNull
    public static final TokenSet getDECLARATIONS() {
        return DECLARATIONS;
    }

    @NotNull
    public static final TokenSet getTYPE_COLON_ELEMENTS() {
        return TYPE_COLON_ELEMENTS;
    }

    public static final void beforeInside(@NotNull SpacingBuilder $this$beforeInside, @NotNull IElementType element, @NotNull TokenSet tokenSet, @NotNull Function1<? super SpacingBuilder.RuleBuilder, Unit> spacingFun) {
        Intrinsics.checkNotNullParameter((Object)$this$beforeInside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        Intrinsics.checkNotNullParameter(spacingFun, (String)"spacingFun");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        Object[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType inType = (IElementType)element$iv;
            boolean bl = false;
            SpacingBuilder.RuleBuilder ruleBuilder = $this$beforeInside.beforeInside(element, inType);
            Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"beforeInside(...)");
            spacingFun.invoke((Object)ruleBuilder);
        }
    }

    public static final void afterInside(@NotNull SpacingBuilder $this$afterInside, @NotNull IElementType element, @NotNull TokenSet tokenSet, @NotNull Function1<? super SpacingBuilder.RuleBuilder, Unit> spacingFun) {
        Intrinsics.checkNotNullParameter((Object)$this$afterInside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        Intrinsics.checkNotNullParameter(spacingFun, (String)"spacingFun");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        Object[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType inType = (IElementType)element$iv;
            boolean bl = false;
            SpacingBuilder.RuleBuilder ruleBuilder = $this$afterInside.afterInside(element, inType);
            Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"afterInside(...)");
            spacingFun.invoke((Object)ruleBuilder);
        }
    }

    @Nullable
    public static final SpacingBuilder spacesNoLineBreak(@NotNull SpacingBuilder.RuleBuilder $this$spacesNoLineBreak, int spaces) {
        Intrinsics.checkNotNullParameter((Object)$this$spacesNoLineBreak, (String)"<this>");
        return $this$spacesNoLineBreak.spacing(spaces, spaces, 0, false, 0);
    }

    @NotNull
    public static final KotlinSpacingBuilder createSpacingBuilder(@NotNull CodeStyleSettings settings, @NotNull KotlinSpacingBuilderUtil builderUtil) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)builderUtil, (String)"builderUtil");
        KotlinCommonCodeStyleSettings kotlinCommonSettings = CodeStyleUtilsKt.getKotlinCommonSettings(settings);
        KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings(settings);
        return KotlinSpacingBuilderKt.rules(kotlinCommonSettings, builderUtil, (Function1<? super KotlinSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0(kotlinCommonSettings, kotlinCustomSettings, builderUtil, arg_0)));
    }

    private static final List<TextRange> excludeLambdasAndObjects(ASTBlock parent) {
        List rangesToExclude = new ArrayList();
        FormatterUtilKt.requireNode(parent).getPsi().accept((PsiElementVisitor)new KtTreeVisitorVoid(rangesToExclude){
            final /* synthetic */ List<TextRange> $rangesToExclude;
            {
                this.$rangesToExclude = $rangesToExclude;
            }

            public void visitLambdaExpression(KtLambdaExpression lambdaExpression) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                super.visitLambdaExpression(lambdaExpression);
                TextRange textRange = lambdaExpression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                this.$rangesToExclude.add(textRange);
            }

            public void visitObjectLiteralExpression(KtObjectLiteralExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitObjectLiteralExpression(expression);
                TextRange textRange = expression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                this.$rangesToExclude.add(textRange);
            }

            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                super.visitNamedFunction(function);
                if (function.getName() == null) {
                    TextRange textRange = function.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    this.$rangesToExclude.add(textRange);
                }
            }
        });
        Iterable iterable = TextRangeUtil.excludeRanges((TextRange)parent.getTextRange(), (List)rangesToExclude);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"excludeRanges(...)");
        return CollectionsKt.toList((Iterable)iterable);
    }

    private static final Unit createSpacingBuilder$lambda$0(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilderUtil $builderUtil, KotlinSpacingBuilder $this$rules) {
        Intrinsics.checkNotNullParameter((Object)$this$rules, (String)"$this$rules");
        $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$0));
        $this$rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1($kotlinCommonSettings, $this$rules, arg_0)));
        $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$2));
        $this$rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3($this$rules, $kotlinCustomSettings, $kotlinCommonSettings, $builderUtil, arg_0)));
        $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4($kotlinCustomSettings, $kotlinCommonSettings, $this$rules, arg_0)));
        $this$rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5($kotlinCommonSettings, $this$rules, $kotlinCustomSettings, $builderUtil, arg_0)));
        $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$6($kotlinCommonSettings, $kotlinCustomSettings, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$0(KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        $this$simple.before(KtNodeTypes.FILE_ANNOTATION_LIST).lineBreakInCode();
        $this$simple.between(KtNodeTypes.IMPORT_DIRECTIVE, KtNodeTypes.IMPORT_DIRECTIVE).lineBreakInCode();
        $this$simple.after(KtNodeTypes.IMPORT_LIST).blankLines(1);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$1(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
        Intrinsics.checkNotNullParameter((Object)$this$custom, (String)"$this$custom");
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, (IElementType)KtTokens.EOL_COMMENT, (IElementType)KtTokens.EOL_COMMENT, null, null, null, 56, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1$0($this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder customSpacingBuilder = KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, (IElementType)KtTokens.BLOCK_COMMENT, null, null, null, 59, null);
        Spacing spacing = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)$kotlinCommonSettings.KEEP_LINE_BREAKS, (int)$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        customSpacingBuilder.spacing(spacing);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, (IElementType)KtTokens.EOL_COMMENT, null, null, null, 59, null).spacing(KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1$commentSpacing($kotlinCommonSettings, 1));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1$1($kotlinCommonSettings, arg_0, arg_1, arg_2)));
        return Unit.INSTANCE;
    }

    private static final Spacing createSpacingBuilder$lambda$0$1$commentSpacing(KotlinCommonCodeStyleSettings kotlinCommonSettings, int minSpaces) {
        if (kotlinCommonSettings.KEEP_FIRST_COLUMN_COMMENT) {
            Spacing spacing = Spacing.createKeepingFirstColumnSpacing((int)minSpaces, (int)Integer.MAX_VALUE, (boolean)kotlinCommonSettings.KEEP_LINE_BREAKS, (int)kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
            Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createKeepingFirstColumnSpacing(...)");
            return spacing;
        }
        Spacing spacing = Spacing.createSpacing((int)minSpaces, (int)Integer.MAX_VALUE, (int)0, (boolean)kotlinCommonSettings.KEEP_LINE_BREAKS, (int)kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    private static final Spacing createSpacingBuilder$lambda$0$1$0(KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ASTNode nodeBeforeRight = FormatterUtilKt.requireNode(right).getTreePrev();
        return nodeBeforeRight instanceof PsiWhiteSpace && !((PsiElement)nodeBeforeRight).textContains('\n') ? KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1, false, 0, 26, null) : null;
    }

    private static final Spacing createSpacingBuilder$lambda$0$1$1(KotlinCommonCodeStyleSettings $kotlinCommonSettings, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ASTNode aSTNode = right.getNode();
        IElementType iElementType2 = aSTNode != null && (aSTNode = PsiUtilsKt.children((ASTNode)aSTNode)) != null && (aSTNode = (ASTNode)SequencesKt.firstOrNull((Sequence)aSTNode)) != null ? aSTNode.getElementType() : (iElementType = null);
        return Intrinsics.areEqual(iElementType, (Object)KtTokens.BLOCK_COMMENT) ? KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1$commentSpacing($kotlinCommonSettings, 0) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EOL_COMMENT) ? KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$1$commentSpacing($kotlinCommonSettings, 1) : null);
    }

    private static final Unit createSpacingBuilder$lambda$0$2(KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        $this$simple.after(KtNodeTypes.FILE_ANNOTATION_LIST).blankLines(1);
        $this$simple.after(KtNodeTypes.PACKAGE_DIRECTIVE).blankLines(1);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$3(KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilderUtil $builderUtil, KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
        Intrinsics.checkNotNullParameter((Object)$this$custom, (String)"$this$custom");
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, null, null, DECLARATIONS, DECLARATIONS, 15, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$0($this_rules, $kotlinCustomSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CLASS, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.OBJECT_DECLARATION, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.FUN, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.PROPERTY, KtNodeTypes.FUN, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.PROPERTY, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.SECONDARY_CONSTRUCTOR, KtNodeTypes.SECONDARY_CONSTRUCTOR, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.TYPEALIAS, KtNodeTypes.TYPEALIAS, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.ENUM_ENTRY, null, null, null, 57, null).emptyLinesIfLineBreakInLeft(0, 0, 1);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, (IElementType)KtTokens.SEMICOLON, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$1($this_rules, $kotlinCommonSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, (IElementType)KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$2($this_rules, $kotlinCommonSettings, $builderUtil, arg_0, arg_1, arg_2)));
        Function3 parameterWithDocCommentRule = (arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$3($this_rules, $kotlinCommonSettings, arg_0, arg_1, arg_2);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_PARAMETER_LIST, null, KtNodeTypes.VALUE_PARAMETER, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)parameterWithDocCommentRule);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.PROPERTY, null, KtNodeTypes.PROPERTY_ACCESSOR, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$3$4));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_ARGUMENT_LIST, (IElementType)KtTokens.LPAR, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$5($kotlinCommonSettings, $this_rules, $kotlinCustomSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_ARGUMENT_LIST, null, (IElementType)KtTokens.RPAR, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$6($kotlinCommonSettings, $this_rules, $kotlinCustomSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CONDITION, (IElementType)KtTokens.RPAR, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$7($kotlinCustomSettings, $this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.VALUE_PARAMETER, (IElementType)KtTokens.COMMA, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$3$8($this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY, null, (IElementType)KtTokens.LONG_TEMPLATE_ENTRY_END, null, null, null, 58, null), 0, false, 2, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY, (IElementType)KtTokens.LONG_TEMPLATE_ENTRY_START, null, null, null, null, 60, null), 0, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$0(KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings kotlinCustomSettings, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        ASTNode aSTNode = right.getNode();
        if (aSTNode == null) {
            return null;
        }
        ASTNode node = aSTNode;
        ASTNode aSTNode2 = KotlinSpacingBuilderKt.startOfDeclaration(node);
        if (aSTNode2 == null) {
            return null;
        }
        ASTNode elementStart = aSTNode2;
        return StringUtil.containsLineBreak((CharSequence)StringsKt.trimStart((CharSequence)node.getText().subSequence(0, elementStart.getStartOffset() - node.getStartOffset()))) ? KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1 + kotlinCustomSettings.BLANK_LINES_BEFORE_DECLARATION_WITH_COMMENT_OR_ANNOTATION_ON_SEPARATE_LINE, false, 0, 26, null) : null;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$1(KotlinSpacingBuilder $this_rules, KotlinCommonCodeStyleSettings $kotlinCommonSettings, ASTBlock parent, ASTBlock aSTBlock, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        PsiElement psiElement = FormatterUtilKt.requireNode(parent).getTreeParent().getPsi();
        KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
        if (ktClass == null) {
            return null;
        }
        KtClass klass = ktClass;
        return klass.isEnum() && DECLARATIONS.contains(FormatterUtilKt.requireNode(right).getElementType()) ? KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 2, false, $kotlinCommonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS, 10, null) : null;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$2(KotlinSpacingBuilder $this_rules, KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilderUtil $builderUtil, ASTBlock parent, ASTBlock left, ASTBlock right) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right).getElementType(), (Object)KtTokens.RBRACE)) {
            return KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 0, false, 0, 30, null);
        }
        PsiElement psiElement = FormatterUtilKt.requireNode(parent).getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
        KtClassBody classBody = (KtClassBody)psiElement;
        PsiElement psiElement2 = classBody.getParent();
        KtClassOrObject ktClassOrObject = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject parentPsi = ktClassOrObject;
        if ($kotlinCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER == 0 || KtPsiUtilKt.isObjectLiteral((KtClassOrObject)parentPsi)) {
            spacing = null;
        } else {
            int minLineFeeds = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right).getElementType(), (Object)KtNodeTypes.FUN) || Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right).getElementType(), (Object)KtNodeTypes.PROPERTY) ? $kotlinCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER + 1 : 0;
            boolean bl = $this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS;
            int n = $this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_DECLARATIONS;
            TextRange textRange = new TextRange(parentPsi.getTextRange().getStartOffset(), FormatterUtilKt.requireNode(left).getPsi().getTextRange().getStartOffset());
            DependentSpacingRule dependentSpacingRule = new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, $kotlinCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER + 1);
            Intrinsics.checkNotNullExpressionValue((Object)dependentSpacingRule, (String)"registerData(...)");
            spacing = $builderUtil.createLineFeedDependentSpacing(1, 1, minLineFeeds, bl, n, textRange, dependentSpacingRule);
        }
        return spacing;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$3(KotlinSpacingBuilder $this_rules, KotlinCommonCodeStyleSettings $kotlinCommonSettings, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right).getFirstChildNode().getElementType(), (Object)KtTokens.DOC_COMMENT) ? KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1, true, $kotlinCommonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS, 2, null) : null;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$4(ASTBlock parent, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        ASTNode it = FormatterUtilKt.requireNode(parent);
        boolean bl = false;
        ASTNode aSTNode = KotlinSpacingBuilderKt.startOfDeclaration(it);
        if (aSTNode == null) {
            aSTNode = it;
        }
        ASTNode startNode = aSTNode;
        return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)new TextRange(startNode.getStartOffset(), parent.getTextRange().getEndOffset()), (boolean)false, (int)0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Spacing createSpacingBuilder$lambda$0$3$5(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, ASTBlock parent, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        if ($kotlinCommonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE) {
            PsiElement psiElement = FormatterUtilKt.requireNode(parent).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
            if (KotlinCommonBlockKt.needWrapArgumentList(psiElement)) {
                spacing = Spacing.createDependentLFSpacing((int)0, (int)0, KotlinSpacingRulesKt.excludeLambdasAndObjects(parent), (boolean)$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE);
                return spacing;
            }
        }
        if ($kotlinCustomSettings.ALLOW_TRAILING_COMMA) {
            return null;
        }
        spacing = KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 0, false, 0, 30, null);
        return spacing;
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$6(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, ASTBlock parent, ASTBlock left, ASTBlock aSTBlock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        return $kotlinCommonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE ? Spacing.createDependentLFSpacing((int)0, (int)0, KotlinSpacingRulesKt.excludeLambdasAndObjects(parent), (boolean)$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE) : ($kotlinCustomSettings.ALLOW_TRAILING_COMMA ? null : (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(left).getElementType(), (Object)KtTokens.COMMA) ? KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, 0, false, 0, 30, null) : KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 0, false, 0, 30, null)));
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$7(KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock left, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        return $kotlinCustomSettings.IF_RPAREN_ON_NEW_LINE ? Spacing.createDependentLFSpacing((int)0, (int)0, KotlinSpacingRulesKt.excludeLambdasAndObjects(left), (boolean)$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE) : KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 0, false, 0, 30, null);
    }

    private static final Spacing createSpacingBuilder$lambda$0$3$8(KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock left, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        ASTNode aSTNode = left.getNode();
        return (aSTNode != null && (aSTNode = aSTNode.getLastChildNode()) != null ? aSTNode.getElementType() : null) == KtTokens.EOL_COMMENT ? KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1, false, 0, 26, null) : null;
    }

    private static final Unit createSpacingBuilder$lambda$0$4(KotlinCodeStyleSettings $kotlinCustomSettings, KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        $this$simple.before(KtTokens.DOC_COMMENT).lineBreakInCode();
        $this$simple.between(KtNodeTypes.PROPERTY, KtNodeTypes.PROPERTY).lineBreakInCode();
        $this$simple.between(KtNodeTypes.CLASS, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.FUN, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.PROPERTY, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.OBJECT_DECLARATION, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.SECONDARY_CONSTRUCTOR, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.CLASS_INITIALIZER, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.TYPEALIAS, DECLARATIONS).blankLines(1);
        $this$simple.before(KtNodeTypes.TYPEALIAS).lineBreakInCode();
        $this$simple.between(KtNodeTypes.ENUM_ENTRY, DECLARATIONS).blankLines(1);
        $this$simple.between(KtNodeTypes.ENUM_ENTRY, (IElementType)KtTokens.SEMICOLON).spaces(0);
        $this$simple.between((IElementType)KtTokens.COMMA, (IElementType)KtTokens.SEMICOLON).lineBreakInCodeIf($kotlinCustomSettings.ALLOW_TRAILING_COMMA);
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY};
        $this$simple.beforeInside(KtNodeTypes.FUN, TokenSet.create((IElementType[])iElementTypeArray)).lineBreakInCode();
        iElementTypeArray = new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY};
        $this$simple.beforeInside(KtNodeTypes.SECONDARY_CONSTRUCTOR, TokenSet.create((IElementType[])iElementTypeArray)).lineBreakInCode();
        iElementTypeArray = new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY};
        $this$simple.beforeInside(KtNodeTypes.CLASS, TokenSet.create((IElementType[])iElementTypeArray)).lineBreakInCode();
        iElementTypeArray = new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY};
        $this$simple.beforeInside(KtNodeTypes.OBJECT_DECLARATION, TokenSet.create((IElementType[])iElementTypeArray)).lineBreakInCode();
        $this$simple.beforeInside(KtNodeTypes.PROPERTY, KtNodeTypes.WHEN).spaces(0);
        SpacingBuilder.RuleBuilder ruleBuilder = $this$simple.beforeInside(KtNodeTypes.PROPERTY, KtNodeTypes.LABELED_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"beforeInside(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder, 1);
        $this$simple.before(KtNodeTypes.PROPERTY).lineBreakInCode();
        $this$simple.after(KtTokens.DOC_COMMENT).lineBreakInCode();
        SpacingBuilder.RuleBuilder ruleBuilder2 = $this$simple.aroundInside((IElementType)KtTokens.AND, KtNodeTypes.INTERSECTION_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder2, (String)"aroundInside(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder2, 1);
        $this$simple.between((IElementType)KtTokens.EOL_COMMENT, (IElementType)KtTokens.COMMA).lineBreakInCode();
        SpacingBuilder.RuleBuilder ruleBuilder3 = $this$simple.before((IElementType)KtTokens.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder3, (String)"before(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder3, $kotlinCommonSettings.SPACE_BEFORE_COMMA ? 1 : 0);
        $this$simple.after((IElementType)KtTokens.COMMA).spaceIf($kotlinCommonSettings.SPACE_AFTER_COMMA);
        int spacesAroundAssignment = $kotlinCommonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
        SpacingBuilder.RuleBuilder ruleBuilder4 = $this$simple.beforeInside((IElementType)KtTokens.EQ, KtNodeTypes.PROPERTY);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder4, (String)"beforeInside(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder4, spacesAroundAssignment);
        $this$simple.beforeInside((IElementType)KtTokens.EQ, KtNodeTypes.FUN).spacing(spacesAroundAssignment, spacesAroundAssignment, 0, false, 0);
        IElementType[] iElementTypeArray2 = new IElementType[]{KtTokens.EQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.PERCEQ};
        $this$simple.around(TokenSet.create((IElementType[])iElementTypeArray2)).spaceIf($kotlinCommonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.ANDAND, KtTokens.OROR};
        $this$simple.around(TokenSet.create((IElementType[])iElementTypeArray2)).spaceIf($kotlinCommonSettings.SPACE_AROUND_LOGICAL_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ};
        $this$simple.around(TokenSet.create((IElementType[])iElementTypeArray2)).spaceIf($kotlinCommonSettings.SPACE_AROUND_EQUALITY_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ};
        $this$simple.aroundInside(TokenSet.create((IElementType[])iElementTypeArray2), KtNodeTypes.BINARY_EXPRESSION).spaceIf($kotlinCommonSettings.SPACE_AROUND_RELATIONAL_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.PLUS, KtTokens.MINUS};
        $this$simple.aroundInside(TokenSet.create((IElementType[])iElementTypeArray2), KtNodeTypes.BINARY_EXPRESSION).spaceIf($kotlinCommonSettings.SPACE_AROUND_ADDITIVE_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC};
        $this$simple.aroundInside(TokenSet.create((IElementType[])iElementTypeArray2), KtNodeTypes.BINARY_EXPRESSION).spaceIf($kotlinCommonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
        iElementTypeArray2 = new IElementType[]{KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.MINUS, KtTokens.PLUS, KtTokens.EXCL};
        $this$simple.around(TokenSet.create((IElementType[])iElementTypeArray2)).spaceIf($kotlinCommonSettings.SPACE_AROUND_UNARY_OPERATOR);
        int spacesAroundElvis = $kotlinCustomSettings.SPACE_AROUND_ELVIS ? 1 : 0;
        $this$simple.before((IElementType)KtTokens.ELVIS).spaceIf($kotlinCustomSettings.SPACE_AROUND_ELVIS);
        SpacingBuilder.RuleBuilder ruleBuilder5 = $this$simple.after((IElementType)KtTokens.ELVIS);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder5, (String)"after(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder5, spacesAroundElvis);
        $this_rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$0($this_rules, $kotlinCustomSettings, arg_0)));
        $this$simple.before((IElementType)KtTokens.RANGE).spaceIf($kotlinCustomSettings.SPACE_AROUND_RANGE);
        $this$simple.around((IElementType)KtTokens.RANGE_UNTIL).spaceIf($kotlinCustomSettings.SPACE_AROUND_RANGE);
        $this$simple.after(KtNodeTypes.MODIFIER_LIST).spaces(1);
        $this$simple.beforeInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.CLASS).spaces(1);
        $this$simple.beforeInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.OBJECT_DECLARATION).spaces(1);
        $this$simple.after((IElementType)KtTokens.TYPE_ALIAS_KEYWORD).spaces(1);
        $this$simple.after((IElementType)KtTokens.VAL_KEYWORD).spaces(1);
        $this$simple.after((IElementType)KtTokens.VAR_KEYWORD).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, (IElementType)KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_REFERENCE, (IElementType)KtTokens.DOT, KtNodeTypes.PROPERTY).spacing(0, 0, 0, false, 0);
        $this$simple.betweenInside((IElementType)KtTokens.DOT, (IElementType)KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY).spacing(0, 0, 0, false, 0);
        $this$simple.betweenInside((IElementType)KtTokens.RETURN_KEYWORD, KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.RETURN).spaces(0);
        $this$simple.afterInside((IElementType)KtTokens.RETURN_KEYWORD, KtNodeTypes.RETURN).spaces(1);
        $this$simple.afterInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.RETURN).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, (IElementType)KtTokens.EOL_COMMENT, KtNodeTypes.LABELED_EXPRESSION).spacing(0, Integer.MAX_VALUE, 0, true, $kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, (IElementType)KtTokens.BLOCK_COMMENT, KtNodeTypes.LABELED_EXPRESSION).spacing(0, Integer.MAX_VALUE, 0, true, $kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.LABELED_EXPRESSION).spaces(0);
        $this$simple.afterInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.LABELED_EXPRESSION).spaces(1);
        $this$simple.betweenInside((IElementType)KtTokens.FUN_KEYWORD, KtNodeTypes.VALUE_PARAMETER_LIST, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
        $this$simple.after((IElementType)KtTokens.FUN_KEYWORD).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, KtNodeTypes.TYPE_REFERENCE, KtNodeTypes.FUN).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, (IElementType)KtTokens.IDENTIFIER, KtNodeTypes.FUN).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_REFERENCE, (IElementType)KtTokens.DOT, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
        $this$simple.betweenInside((IElementType)KtTokens.DOT, (IElementType)KtTokens.IDENTIFIER, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
        $this$simple.afterInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
        $this$simple.aroundInside((IElementType)KtTokens.DOT, KtNodeTypes.USER_TYPE).spaces(0);
        $this$simple.around((IElementType)KtTokens.AS_KEYWORD).spaces(1);
        $this$simple.around((IElementType)KtTokens.AS_SAFE).spaces(1);
        $this$simple.around((IElementType)KtTokens.IS_KEYWORD).spaces(1);
        $this$simple.around((IElementType)KtTokens.NOT_IS).spaces(1);
        $this$simple.around((IElementType)KtTokens.IN_KEYWORD).spaces(1);
        $this$simple.around((IElementType)KtTokens.NOT_IN).spaces(1);
        $this$simple.aroundInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.BINARY_EXPRESSION).spaces(1);
        SpacingBuilder.RuleBuilder ruleBuilder6 = $this$simple.after((IElementType)KtTokens.THROW_KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder6, (String)"after(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder6, 1);
        $this$simple.after(KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE).spacing(0, 0, 0, false, 0);
        $this_rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$1($this_rules, arg_0)));
        $this$simple.afterInside((IElementType)KtTokens.CONSTRUCTOR_KEYWORD, KtNodeTypes.PRIMARY_CONSTRUCTOR).spaces(0);
        $this$simple.betweenInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.TYPE_PARAMETER_LIST, KtNodeTypes.CLASS).spaces(0);
        $this$simple.beforeInside((IElementType)KtTokens.DOT, KtNodeTypes.DOT_QUALIFIED_EXPRESSION).spaces(0);
        SpacingBuilder.RuleBuilder ruleBuilder7 = $this$simple.afterInside((IElementType)KtTokens.DOT, KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder7, (String)"afterInside(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder7, 0);
        $this$simple.beforeInside((IElementType)KtTokens.SAFE_ACCESS, KtNodeTypes.SAFE_ACCESS_EXPRESSION).spaces(0);
        SpacingBuilder.RuleBuilder ruleBuilder8 = $this$simple.afterInside((IElementType)KtTokens.SAFE_ACCESS, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder8, (String)"afterInside(...)");
        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder8, 0);
        $this$simple.between(MODIFIERS_LIST_ENTRIES, MODIFIERS_LIST_ENTRIES).spaces(1);
        $this$simple.after((IElementType)KtTokens.LBRACKET).spaces(0);
        $this$simple.before((IElementType)KtTokens.RBRACKET).spaces(0);
        $this$simple.afterInside((IElementType)KtTokens.LPAR, KtNodeTypes.VALUE_PARAMETER_LIST).spaces(0, $kotlinCommonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
        $this$simple.beforeInside((IElementType)KtTokens.RPAR, KtNodeTypes.VALUE_PARAMETER_LIST).spaces(0, $kotlinCommonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
        $this$simple.afterInside((IElementType)KtTokens.LT, KtNodeTypes.TYPE_PARAMETER_LIST).spaces(0);
        $this$simple.beforeInside((IElementType)KtTokens.GT, KtNodeTypes.TYPE_PARAMETER_LIST).spaces(0);
        $this$simple.afterInside((IElementType)KtTokens.LT, KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
        $this$simple.beforeInside((IElementType)KtTokens.GT, KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
        $this$simple.before(KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
        $this$simple.after((IElementType)KtTokens.LPAR).spaces(0);
        $this$simple.before((IElementType)KtTokens.RPAR).spaces(0);
        $this$simple.betweenInside((IElementType)KtTokens.FOR_KEYWORD, (IElementType)KtTokens.LPAR, KtNodeTypes.FOR).spaceIf($kotlinCommonSettings.SPACE_BEFORE_FOR_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.IF_KEYWORD, (IElementType)KtTokens.LPAR, KtNodeTypes.IF).spaceIf($kotlinCommonSettings.SPACE_BEFORE_IF_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.WHILE_KEYWORD, (IElementType)KtTokens.LPAR, KtNodeTypes.WHILE).spaceIf($kotlinCommonSettings.SPACE_BEFORE_WHILE_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.WHILE_KEYWORD, (IElementType)KtTokens.LPAR, KtNodeTypes.DO_WHILE).spaceIf($kotlinCommonSettings.SPACE_BEFORE_WHILE_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.WHEN_KEYWORD, (IElementType)KtTokens.LPAR, KtNodeTypes.WHEN).spaceIf($kotlinCustomSettings.SPACE_BEFORE_WHEN_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.CATCH_KEYWORD, KtNodeTypes.VALUE_PARAMETER_LIST, KtNodeTypes.CATCH).spaceIf($kotlinCommonSettings.SPACE_BEFORE_CATCH_PARENTHESES);
        $this$simple.betweenInside((IElementType)KtTokens.LPAR, KtNodeTypes.VALUE_PARAMETER, KtNodeTypes.FOR).spaces(0);
        $this$simple.betweenInside((IElementType)KtTokens.LPAR, KtNodeTypes.DESTRUCTURING_DECLARATION, KtNodeTypes.FOR).spaces(0);
        $this$simple.betweenInside(KtNodeTypes.LOOP_RANGE, (IElementType)KtTokens.RPAR, KtNodeTypes.FOR).spaces(0);
        $this$simple.afterInside(KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATED_EXPRESSION).spaces(1);
        $this$simple.afterInside((IElementType)KtTokens.COLON, KtNodeTypes.ANNOTATION_ENTRY).spaces(0);
        $this$simple.beforeInside((IElementType)KtTokens.COLON, KtNodeTypes.ANNOTATION_ENTRY).spaces(0);
        $this$simple.before((IElementType)KtTokens.SEMICOLON).spaces(0);
        $this$simple.beforeInside(KtNodeTypes.INITIALIZER_LIST, KtNodeTypes.ENUM_ENTRY).spaces(0);
        $this$simple.beforeInside((IElementType)KtTokens.QUEST, KtNodeTypes.NULLABLE_TYPE).spaces(0);
        SpacingBuilder spacingBuilder = $this$simple;
        KtSingleValueToken ktSingleValueToken = KtTokens.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COLON");
        KotlinSpacingRulesKt.beforeInside(spacingBuilder, (IElementType)ktSingleValueToken, TYPE_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$2($kotlinCustomSettings, arg_0)));
        SpacingBuilder spacingBuilder2 = $this$simple;
        KtSingleValueToken ktSingleValueToken2 = KtTokens.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"COLON");
        KotlinSpacingRulesKt.afterInside(spacingBuilder2, (IElementType)ktSingleValueToken2, TYPE_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$3($kotlinCustomSettings, arg_0)));
        SpacingBuilder spacingBuilder3 = $this$simple;
        KtSingleValueToken ktSingleValueToken3 = KtTokens.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken3, (String)"COLON");
        KotlinSpacingRulesKt.afterInside(spacingBuilder3, (IElementType)ktSingleValueToken3, EXTEND_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$4($kotlinCustomSettings, arg_0)));
        $this$simple.beforeInside((IElementType)KtTokens.ARROW, KtNodeTypes.FUNCTION_LITERAL).spaceIf($kotlinCustomSettings.SPACE_BEFORE_LAMBDA_ARROW);
        $this$simple.aroundInside((IElementType)KtTokens.ARROW, KtNodeTypes.FUNCTION_TYPE).spaceIf($kotlinCustomSettings.SPACE_AROUND_FUNCTION_TYPE_ARROW);
        $this$simple.before(KtNodeTypes.VALUE_ARGUMENT_LIST).spaces(0);
        $this$simple.between(KtNodeTypes.VALUE_ARGUMENT_LIST, KtNodeTypes.LAMBDA_ARGUMENT).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.LAMBDA_ARGUMENT, KtNodeTypes.CALL_EXPRESSION).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_ARGUMENT_LIST, KtNodeTypes.LAMBDA_ARGUMENT, KtNodeTypes.CALL_EXPRESSION).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.STRING_TEMPLATE, KtNodeTypes.LAMBDA_ARGUMENT, KtNodeTypes.CALL_EXPRESSION).spaces(1);
        $this$simple.around((IElementType)KtTokens.COLONCOLON).spaces(0);
        $this$simple.around((IElementType)KtTokens.BY_KEYWORD).spaces(1);
        $this$simple.betweenInside((IElementType)KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY_DELEGATE, KtNodeTypes.PROPERTY).spaces(1);
        $this$simple.betweenInside(KtNodeTypes.TYPE_REFERENCE, KtNodeTypes.PROPERTY_DELEGATE, KtNodeTypes.PROPERTY).spaces(1);
        $this$simple.before(KtNodeTypes.INDICES).spaces(0);
        $this$simple.before((IElementType)KtTokens.WHERE_KEYWORD).spaces(1);
        $this$simple.afterInside((IElementType)KtTokens.GET_KEYWORD, KtNodeTypes.PROPERTY_ACCESSOR).spaces(0);
        $this$simple.afterInside((IElementType)KtTokens.SET_KEYWORD, KtNodeTypes.PROPERTY_ACCESSOR).spaces(0);
        $this$simple.afterInside((IElementType)KtTokens.IF_KEYWORD, KtNodeTypes.WHEN_ENTRY_GUARD).spaces(1);
        $this$simple.before(KtNodeTypes.WHEN_ENTRY_GUARD).spaces(1);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$4$0(KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
        Intrinsics.checkNotNullParameter((Object)$this$custom, (String)"$this$custom");
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, (IElementType)KtTokens.RANGE, null, null, null, null, 61, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$0$0($this_rules, $kotlinCustomSettings, arg_0, arg_1, arg_2)));
        return Unit.INSTANCE;
    }

    private static final Spacing createSpacingBuilder$lambda$0$4$0$0(KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, ASTBlock parent, ASTBlock left, ASTBlock right) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Object object = right.getNode();
        boolean bl = object != null && (object = object.getText()) != null ? StringsKt.startsWith$default((String)object, (String)".", (boolean)false, (int)2, null) : false;
        if (bl) {
            spacing = KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, 0, $this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, $this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE, 6, null);
        } else {
            int minSpaces = $kotlinCustomSettings.SPACE_AROUND_RANGE ? 1 : 0;
            spacing = KotlinSpacingBuilder.createSpacing$default($this_rules, minSpaces, 0, 0, $this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, $this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE, 6, null);
        }
        return spacing;
    }

    private static final Unit createSpacingBuilder$lambda$0$4$1(KotlinSpacingBuilder $this_rules, KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
        Intrinsics.checkNotNullParameter((Object)$this$custom, (String)"$this$custom");
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtNodeTypes.PRIMARY_CONSTRUCTOR, null, null, null, 59, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$4$1$0($this_rules, arg_0, arg_1, arg_2)));
        return Unit.INSTANCE;
    }

    private static final Spacing createSpacingBuilder$lambda$0$4$1$0(KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock r) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ASTNode aSTNode = FormatterUtilKt.requireNode(r).findLeafElementAt(0);
        int spacesCount = !Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.LPAR) ? 1 : 0;
        return KotlinSpacingBuilder.createSpacing$default($this_rules, spacesCount, 0, 0, true, 0, 2, null);
    }

    private static final Unit createSpacingBuilder$lambda$0$4$2(KotlinCodeStyleSettings $kotlinCustomSettings, SpacingBuilder.RuleBuilder $this$beforeInside) {
        Intrinsics.checkNotNullParameter((Object)$this$beforeInside, (String)"$this$beforeInside");
        $this$beforeInside.spaceIf($kotlinCustomSettings.SPACE_BEFORE_TYPE_COLON);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$4$3(KotlinCodeStyleSettings $kotlinCustomSettings, SpacingBuilder.RuleBuilder $this$afterInside) {
        Intrinsics.checkNotNullParameter((Object)$this$afterInside, (String)"$this$afterInside");
        $this$afterInside.spaceIf($kotlinCustomSettings.SPACE_AFTER_TYPE_COLON);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$4$4(KotlinCodeStyleSettings $kotlinCustomSettings, SpacingBuilder.RuleBuilder $this$afterInside) {
        Intrinsics.checkNotNullParameter((Object)$this$afterInside, (String)"$this$afterInside");
        $this$afterInside.spaceIf($kotlinCustomSettings.SPACE_AFTER_EXTEND_COLON);
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$5(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilderUtil $builderUtil, KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
        Intrinsics.checkNotNullParameter((Object)$this$custom, (String)"$this$custom");
        boolean bl = $kotlinCommonSettings.ELSE_ON_NEW_LINE;
        KtKeywordToken ktKeywordToken = KtTokens.ELSE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"ELSE_KEYWORD");
        IElementType iElementType = (IElementType)ktKeywordToken;
        IElementType iElementType2 = KtNodeTypes.IF;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"IF");
        KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine($this$custom, $builderUtil, $this_rules, bl, iElementType, iElementType2, (Function2<? super ASTNode, ? super ASTNode, Boolean>)((Function2)KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$5$2));
        boolean bl2 = $kotlinCommonSettings.WHILE_ON_NEW_LINE;
        KtKeywordToken ktKeywordToken2 = KtTokens.WHILE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken2, (String)"WHILE_KEYWORD");
        IElementType iElementType3 = (IElementType)ktKeywordToken2;
        IElementType iElementType4 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"DO_WHILE");
        KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine($this$custom, $builderUtil, $this_rules, bl2, iElementType3, iElementType4, (Function2<? super ASTNode, ? super ASTNode, Boolean>)((Function2)KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$5$3));
        boolean bl3 = $kotlinCommonSettings.CATCH_ON_NEW_LINE;
        IElementType iElementType5 = KtNodeTypes.CATCH;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"CATCH");
        IElementType iElementType6 = KtNodeTypes.TRY;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"TRY");
        KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$default($this$custom, $builderUtil, $this_rules, bl3, iElementType5, iElementType6, null, 32, null);
        boolean bl4 = $kotlinCommonSettings.FINALLY_ON_NEW_LINE;
        IElementType iElementType7 = KtNodeTypes.FINALLY;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType7, (String)"FINALLY");
        IElementType iElementType8 = KtNodeTypes.TRY;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType8, (String)"TRY");
        KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$default($this$custom, $builderUtil, $this_rules, bl4, iElementType7, iElementType8, null, 32, null);
        Function3 leftBraceRuleIfBlockIsWrapped = (arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$5($builderUtil, $kotlinCustomSettings, $this_rules, arg_0, arg_1, arg_2);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, (IElementType)KtTokens.SEMICOLON, null, null, null, null, 61, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$6($this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.IF, null, KtNodeTypes.THEN, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.IF, null, KtNodeTypes.ELSE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FOR, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHILE, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.DO_WHILE, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.TRY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CATCH, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FINALLY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUN, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.SECONDARY_CONSTRUCTOR, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_INITIALIZER, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.PROPERTY_ACCESSOR, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_ARGUMENT, (IElementType)KtTokens.MUL, null, null, null, null, 60, null).spacing(KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 0, false, 0, 30, null));
        KotlinSpacingBuilder.CustomSpacingBuilder customSpacingBuilder = KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtNodeTypes.CLASS_BODY, null, null, null, 59, null);
        IElementType iElementType9 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType9, (String)"CLASS_BODY");
        customSpacingBuilder.customRule(KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule($builderUtil, $kotlinCustomSettings, $this_rules, iElementType9));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.WHEN_ENTRY, KtNodeTypes.WHEN_ENTRY, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$7($kotlinCustomSettings, $this_rules, $builderUtil, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHEN_ENTRY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$default($builderUtil, $kotlinCustomSettings, $this_rules, null, 8, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHEN, null, (IElementType)KtTokens.LBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$8($builderUtil, $kotlinCustomSettings, $this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, (IElementType)KtTokens.LBRACE, KtNodeTypes.WHEN_ENTRY, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$9($this_rules, arg_0, arg_1, arg_2)));
        int spacesInSimpleFunction = $kotlinCustomSettings.INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD ? 1 : 0;
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, (IElementType)KtTokens.LBRACE, KtNodeTypes.BLOCK, null, null, null, 56, null), spacesInSimpleFunction, false, 2, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, (IElementType)KtTokens.ARROW, KtNodeTypes.BLOCK, null, null, null, 56, null), 1, false, 2, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, (IElementType)KtTokens.LBRACE, (IElementType)KtTokens.RBRACE, null, null, null, 56, null).spacing(KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 1, 0, false, 0, 28, null));
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, null, (IElementType)KtTokens.RBRACE, null, null, null, 58, null), spacesInSimpleFunction, false, 2, null);
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, (IElementType)KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$10($this_rules, spacesInSimpleFunction, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, null, (IElementType)KtTokens.RBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$11($kotlinCommonSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.BLOCK, null, (IElementType)KtTokens.RBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$12(spacesInSimpleFunction, $kotlinCommonSettings, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.BLOCK, (IElementType)KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$13(spacesInSimpleFunction, $kotlinCommonSettings, arg_0, arg_1, arg_2)));
        TokenSet tokenSet = EXTEND_COLON_ELEMENTS;
        IElementType iElementType10 = KtNodeTypes.PRIMARY_CONSTRUCTOR;
        KtSingleValueToken ktSingleValueToken = KtTokens.COLON;
        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, iElementType10, (IElementType)ktSingleValueToken, tokenSet, null, null, 49, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$14($kotlinCustomSettings, $kotlinCommonSettings, $this_rules, arg_0, arg_1, arg_2)));
        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, (IElementType)KtTokens.LBRACE, KtNodeTypes.ENUM_ENTRY, null, null, null, 56, null), 1, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final void createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine(KotlinSpacingBuilder.CustomSpacingBuilder $this$createSpacingBuilder_u24lambda_u240_u245_u24ruleForKeywordOnNewLine, KotlinSpacingBuilderUtil $builderUtil, KotlinSpacingBuilder $this_rules, boolean shouldBeOnNewLine, IElementType keyword, IElementType parent, Function2<? super ASTNode, ? super ASTNode, Boolean> afterBlockFilter) {
        if (shouldBeOnNewLine) {
            KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$createSpacingBuilder_u24lambda_u240_u245_u24ruleForKeywordOnNewLine, parent, null, keyword, null, null, null, 58, null).lineBreakIfLineBreakInParent(1, false);
        } else {
            KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$createSpacingBuilder_u24lambda_u240_u245_u24ruleForKeywordOnNewLine, parent, null, keyword, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)(arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$1($builderUtil, afterBlockFilter, $this_rules, arg_0, arg_1, arg_2)));
        }
    }

    static /* synthetic */ void createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$default(KotlinSpacingBuilder.CustomSpacingBuilder customSpacingBuilder, KotlinSpacingBuilderUtil kotlinSpacingBuilderUtil, KotlinSpacingBuilder kotlinSpacingBuilder, boolean bl, IElementType iElementType, IElementType iElementType2, Function2 function2, int n, Object object) {
        if ((n & 0x20) != 0) {
            function2 = KotlinSpacingRulesKt::createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$0;
        }
        KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine(customSpacingBuilder, kotlinSpacingBuilderUtil, kotlinSpacingBuilder, bl, iElementType, iElementType2, (Function2<? super ASTNode, ? super ASTNode, Boolean>)function2);
    }

    private static final boolean createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$0(ASTNode aSTNode, ASTNode aSTNode2) {
        Intrinsics.checkNotNullParameter((Object)aSTNode, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTNode2, (String)"<unused var>");
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Spacing createSpacingBuilder$lambda$0$5$ruleForKeywordOnNewLine$1(KotlinSpacingBuilderUtil $builderUtil, Function2 $afterBlockFilter, KotlinSpacingBuilder $this_rules, ASTBlock var3_3, ASTBlock var4_4, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        previousLeaf = $builderUtil.getPreviousNonWhitespaceLeaf(FormatterUtilKt.requireNode(right));
        if (previousLeaf == null || !Intrinsics.areEqual((Object)previousLeaf.getElementType(), (Object)KtTokens.RBRACE)) ** GOTO lbl-1000
        v0 = previousLeaf.getTreeParent();
        if (Intrinsics.areEqual((Object)(v0 != null ? v0.getElementType() : null), (Object)KtNodeTypes.BLOCK)) {
            v1 = previousLeaf.getTreeParent();
            v2 = v1;
            Intrinsics.checkNotNull((Object)v1);
        } else lbl-1000:
        // 2 sources

        {
            v2 = leftBlock = null;
        }
        if (leftBlock == null) ** GOTO lbl-1000
        v3 = right.getNode();
        v4 /* !! */  = v3 != null ? v3.getTreeParent() : null;
        Intrinsics.checkNotNull((Object)v4 /* !! */ );
        if (((Boolean)$afterBlockFilter.invoke((Object)v4 /* !! */ , leftBlock)).booleanValue()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        removeLineBreaks = v5;
        return KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, 0, removeLineBreaks == false, 0, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createSpacingBuilder$lambda$0$5$2(ASTNode keywordParent, ASTNode block) {
        Intrinsics.checkNotNullParameter((Object)keywordParent, (String)"keywordParent");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ASTNode aSTNode = block.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.THEN)) return false;
        ASTNode aSTNode2 = block.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getTreeParent() : null), (Object)keywordParent)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createSpacingBuilder$lambda$0$5$3(ASTNode keywordParent, ASTNode block) {
        Intrinsics.checkNotNullParameter((Object)keywordParent, (String)"keywordParent");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ASTNode aSTNode = block.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BODY)) return false;
        ASTNode aSTNode2 = block.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getTreeParent() : null), (Object)keywordParent)) return false;
        return true;
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$spacingForLeftBrace(KotlinSpacingBuilderUtil $builderUtil, KotlinCodeStyleSettings kotlinCustomSettings, KotlinSpacingBuilder $this_rules, ASTNode block, IElementType blockType) {
        ASTNode leftBrace;
        if (block != null && Intrinsics.areEqual((Object)block.getElementType(), (Object)blockType) && (leftBrace = block.findChildByType((IElementType)KtTokens.LBRACE)) != null) {
            ASTNode previousLeaf = $builderUtil.getPreviousNonWhitespaceLeaf(leftBrace);
            boolean isAfterEolComment = previousLeaf != null && Intrinsics.areEqual((Object)previousLeaf.getElementType(), (Object)KtTokens.EOL_COMMENT);
            boolean keepLineBreaks = kotlinCustomSettings.LBRACE_ON_NEXT_LINE || isAfterEolComment;
            int minimumLF = kotlinCustomSettings.LBRACE_ON_NEXT_LINE ? 1 : 0;
            return KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, minimumLF, keepLineBreaks, 0, 2, null);
        }
        return KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, 0, false, 0, 30, null);
    }

    static /* synthetic */ Spacing createSpacingBuilder$lambda$0$5$spacingForLeftBrace$default(KotlinSpacingBuilderUtil kotlinSpacingBuilderUtil, KotlinCodeStyleSettings kotlinCodeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, ASTNode aSTNode, IElementType iElementType, int n, Object object) {
        if ((n & 0x10) != 0) {
            IElementType iElementType2 = KtNodeTypes.BLOCK;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"BLOCK");
            iElementType = iElementType2;
        }
        return KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$spacingForLeftBrace(kotlinSpacingBuilderUtil, kotlinCodeStyleSettings, kotlinSpacingBuilder, aSTNode, iElementType);
    }

    private static final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> createSpacingBuilder$lambda$0$5$leftBraceRule(KotlinSpacingBuilderUtil $builderUtil, KotlinCodeStyleSettings kotlinCustomSettings, KotlinSpacingBuilder $this_rules, IElementType blockType) {
        return (arg_0, arg_1, arg_2) -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule$4(blockType, $builderUtil, kotlinCustomSettings, $this_rules, arg_0, arg_1, arg_2);
    }

    static /* synthetic */ Function3 createSpacingBuilder$lambda$0$5$leftBraceRule$default(KotlinSpacingBuilderUtil kotlinSpacingBuilderUtil, KotlinCodeStyleSettings kotlinCodeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, IElementType iElementType, int n, Object object) {
        if ((n & 8) != 0) {
            IElementType iElementType2 = KtNodeTypes.BLOCK;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"BLOCK");
            iElementType = iElementType2;
        }
        return KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$leftBraceRule(kotlinSpacingBuilderUtil, kotlinCodeStyleSettings, kotlinSpacingBuilder, iElementType);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$leftBraceRule$4(IElementType $blockType, KotlinSpacingBuilderUtil $builderUtil, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$spacingForLeftBrace($builderUtil, $kotlinCustomSettings, $this_rules, right.getNode(), $blockType);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$5(KotlinSpacingBuilderUtil $builderUtil, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$spacingForLeftBrace$default($builderUtil, $kotlinCustomSettings, $this_rules, FormatterUtilKt.requireNode(right).getFirstChildNode(), null, 16, null);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$6(KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock left, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        ASTNode nodeAfterLeft = FormatterUtilKt.requireNode(left).getTreeNext();
        return !(nodeAfterLeft instanceof PsiWhiteSpace) || !((PsiElement)nodeAfterLeft).textContains('\n') ? KotlinSpacingBuilder.createSpacing$default($this_rules, 1, 0, 0, false, 0, 30, null) : null;
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$7(KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder $this_rules, KotlinSpacingBuilderUtil $builderUtil, ASTBlock aSTBlock, ASTBlock left, ASTBlock right) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        int blankLines = $kotlinCustomSettings.BLANK_LINES_AROUND_BLOCK_WHEN_BRANCHES;
        if (blankLines != 0) {
            PsiElement psiElement = FormatterUtilKt.requireNode(left).getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
            KtWhenEntry leftEntry = (KtWhenEntry)psiElement;
            PsiElement psiElement2 = FormatterUtilKt.requireNode(right).getPsi();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
            KtWhenEntry rightEntry = (KtWhenEntry)psiElement2;
            if (leftEntry.getExpression() instanceof KtBlockExpression || rightEntry.getExpression() instanceof KtBlockExpression) {
                return KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, blankLines + 1, false, 0, 26, null);
            }
        }
        if ($kotlinCustomSettings.LINE_BREAK_AFTER_MULTILINE_WHEN_ENTRY) {
            boolean bl = $this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS;
            int n = $this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE;
            TextRange textRange = left.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            DependentSpacingRule dependentSpacingRule = new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, 2);
            Intrinsics.checkNotNullExpressionValue((Object)dependentSpacingRule, (String)"registerData(...)");
            spacing = $builderUtil.createLineFeedDependentSpacing(0, 0, 1, bl, n, textRange, dependentSpacingRule);
        } else {
            spacing = KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1, false, 0, 26, null);
        }
        return spacing;
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$8(KotlinSpacingBuilderUtil $builderUtil, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder $this_rules, ASTBlock parent, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        ASTNode aSTNode = FormatterUtilKt.requireNode(parent);
        IElementType iElementType = KtNodeTypes.WHEN;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"WHEN");
        return KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$5$spacingForLeftBrace($builderUtil, $kotlinCustomSettings, $this_rules, aSTNode, iElementType);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$9(KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock aSTBlock3) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock3, (String)"<unused var>");
        return KotlinSpacingBuilder.createSpacing$default($this_rules, 0, 0, 1, false, 0, 26, null);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$10(KotlinSpacingBuilder $this_rules, int $spacesInSimpleFunction, ASTBlock aSTBlock, ASTBlock aSTBlock2, ASTBlock right) {
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ASTNode rightNode = FormatterUtilKt.requireNode(right);
        IElementType iElementType = rightNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType rightType = iElementType;
        return Intrinsics.areEqual((Object)rightType, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) ? KotlinSpacingBuilder.createSpacing$default($this_rules, $spacesInSimpleFunction, 0, 0, false, 0, 22, null) : KotlinSpacingBuilder.createSpacing$default($this_rules, $spacesInSimpleFunction, 0, 0, false, 0, 30, null);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$11(KotlinCommonCodeStyleSettings $kotlinCommonSettings, ASTBlock parent, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        CommonCodeStyleSettings commonCodeStyleSettings = $kotlinCommonSettings;
        TextRange textRange = parent.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return KotlinSpacingBuilderKt.createSpaceBeforeRBrace(commonCodeStyleSettings, 1, textRange);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$12(int spacesInSimpleFunction, KotlinCommonCodeStyleSettings kotlinCommonSettings, ASTBlock block, ASTBlock left, ASTBlock aSTBlock) {
        PsiElement psiElement = FormatterUtilKt.requireNode(block).getTreeParent().getPsi();
        boolean empty = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(left).getElementType(), (Object)KtTokens.LBRACE);
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof KtDeclarationWithBody) {
            if (((KtDeclarationWithBody)psiElement).getName() != null && !empty) {
                return null;
            }
        } else if (psiElement2 instanceof KtWhenEntry || psiElement2 instanceof KtClassInitializer) {
            if (!empty) {
                return null;
            }
        } else {
            return null;
        }
        int spaces = empty ? 0 : spacesInSimpleFunction;
        return KotlinSpacingBuilderKt.createSpaceBeforeRBrace(kotlinCommonSettings, spaces, PsiUtilsKt.getTextRangeWithoutComments((PsiElement)psiElement));
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$13(int $spacesInSimpleFunction, KotlinCommonCodeStyleSettings $kotlinCommonSettings, ASTBlock parent, ASTBlock aSTBlock, ASTBlock aSTBlock2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        PsiElement psiElement = FormatterUtilKt.requireNode(parent).getTreeParent().getPsi();
        KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
        if (ktFunction == null) {
            return null;
        }
        KtFunction funNode = ktFunction;
        if (funNode.getName() != null) {
            return null;
        }
        return Spacing.createDependentLFSpacing((int)$spacesInSimpleFunction, (int)$spacesInSimpleFunction, (TextRange)PsiUtilsKt.getTextRangeWithoutComments((PsiElement)((PsiElement)funNode)), (boolean)$kotlinCommonSettings.KEEP_LINE_BREAKS, (int)$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static final Spacing createSpacingBuilder$lambda$0$5$14(KotlinCodeStyleSettings $kotlinCustomSettings, KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinSpacingBuilder $this_rules, ASTBlock aSTBlock, ASTBlock left, ASTBlock aSTBlock2) {
        PsiElement rightParenthesis;
        Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<unused var>");
        PsiElement psiElement = FormatterUtilKt.requireNode(left).getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
        KtPrimaryConstructor primaryConstructor = (KtPrimaryConstructor)psiElement;
        KtParameterList ktParameterList = primaryConstructor.getValueParameterList();
        PsiElement psiElement2 = rightParenthesis = ktParameterList != null ? ktParameterList.getRightParenthesis() : null;
        PsiElement prevSibling = psiElement2 != null ? psiElement2.getPrevSibling() : null;
        int spaces = $kotlinCustomSettings.SPACE_BEFORE_EXTEND_COLON ? 1 : 0;
        PsiWhiteSpace psiWhiteSpace = prevSibling instanceof PsiWhiteSpace ? (PsiWhiteSpace)prevSibling : null;
        return (psiWhiteSpace != null ? psiWhiteSpace.textContains('\n') : false) || $kotlinCommonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE ? KotlinSpacingBuilder.createSpacing$default($this_rules, spaces, 0, 0, false, 0, 22, null) : KotlinSpacingBuilder.createSpacing$default($this_rules, spaces, 0, 0, false, 0, 30, null);
    }

    private static final Unit createSpacingBuilder$lambda$0$6(KotlinCommonCodeStyleSettings $kotlinCommonSettings, KotlinCodeStyleSettings $kotlinCustomSettings, KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        $this$simple.afterInside((IElementType)KtTokens.LBRACE, KtNodeTypes.BLOCK).lineBreakInCode();
        $this$simple.beforeInside((IElementType)KtTokens.RBRACE, KtNodeTypes.BLOCK).spacing(1, 0, 1, $kotlinCommonSettings.KEEP_LINE_BREAKS, $kotlinCommonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        $this$simple.between((IElementType)KtTokens.LBRACE, KtNodeTypes.ENUM_ENTRY).spacing(1, 0, 0, true, $kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
        $this$simple.beforeInside((IElementType)KtTokens.RBRACE, KtNodeTypes.WHEN).lineBreakInCode();
        $this$simple.between((IElementType)KtTokens.RPAR, KtNodeTypes.BODY).spaces(1);
        $this$simple.aroundInside((IElementType)KtTokens.ARROW, KtNodeTypes.WHEN_ENTRY).spaceIf($kotlinCustomSettings.SPACE_AROUND_WHEN_ARROW);
        SpacingBuilder spacingBuilder = $this$simple;
        KtSingleValueToken ktSingleValueToken = KtTokens.COLON;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COLON");
        KotlinSpacingRulesKt.beforeInside(spacingBuilder, (IElementType)ktSingleValueToken, EXTEND_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)arg_0 -> KotlinSpacingRulesKt.createSpacingBuilder$lambda$0$6$0($kotlinCustomSettings, arg_0)));
        $this$simple.after((IElementType)KtTokens.EOL_COMMENT).lineBreakInCode();
        return Unit.INSTANCE;
    }

    private static final Unit createSpacingBuilder$lambda$0$6$0(KotlinCodeStyleSettings $kotlinCustomSettings, SpacingBuilder.RuleBuilder $this$beforeInside) {
        Intrinsics.checkNotNullParameter((Object)$this$beforeInside, (String)"$this$beforeInside");
        $this$beforeInside.spaceIf($kotlinCustomSettings.SPACE_BEFORE_EXTEND_COLON);
        return Unit.INSTANCE;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATION, KtNodeTypes.CONTEXT_RECEIVER_LIST};
        tokenSetArray[0] = TokenSet.create((IElementType[])iElementTypeArray);
        tokenSetArray[1] = KtTokens.MODIFIER_KEYWORDS;
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        MODIFIERS_LIST_ENTRIES = tokenSet;
        tokenSetArray = new IElementType[]{KtNodeTypes.TYPE_CONSTRAINT, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.TYPE_PARAMETER, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.SECONDARY_CONSTRUCTOR};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        EXTEND_COLON_ELEMENTS = tokenSet2;
        tokenSetArray = new IElementType[]{KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.SECONDARY_CONSTRUCTOR, KtNodeTypes.CLASS_INITIALIZER};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        DECLARATIONS = tokenSet3;
        tokenSetArray = new IElementType[]{KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.VALUE_PARAMETER, KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY, KtNodeTypes.FUNCTION_LITERAL};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        TYPE_COLON_ELEMENTS = tokenSet4;
    }
}

