/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.formatting.ASTBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000f\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0006\u001a\f\u0010\r\u001a\u00020\f*\u0004\u0018\u00010\u0006\u001a \u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\f\u001a \u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\f\u001a*\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0014\u001a\u001a\u0010\u0017\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005\"\u0015\u0010\u0015\u001a\u00020\f*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"requireNode", "Lcom/intellij/lang/ASTNode;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/formatting/ASTBlock;", "getLineCount", "", "Lcom/intellij/psi/PsiElement;", "getLineCountByDocument", "startOffset", "endOffset", "(Lcom/intellij/psi/PsiElement;II)Ljava/lang/Integer;", "isMultiline", "", "isLineBreak", "leafIgnoringWhitespace", "forward", "skipEmptyElements", "leafIgnoringWhitespaceAndComments", "leaf", "filter", "Lkotlin/Function1;", "isComma", "(Lcom/intellij/psi/PsiElement;)Z", "containsLineBreakInChild", "globalStartOffset", "globalEndOffset", "kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nFormatterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatterUtil.kt\norg/jetbrains/kotlin/idea/util/FormatterUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,59:1\n1#2:60\n1255#3,2:61\n*S KotlinDebug\n*F\n+ 1 FormatterUtil.kt\norg/jetbrains/kotlin/idea/util/FormatterUtilKt\n*L\n59#1:61,2\n*E\n"})
public final class FormatterUtilKt {
    @NotNull
    public static final ASTNode requireNode(@NotNull ASTBlock $this$requireNode) {
        Intrinsics.checkNotNullParameter((Object)$this$requireNode, (String)"<this>");
        ASTNode aSTNode = $this$requireNode.getNode();
        if (aSTNode == null) {
            throw new IllegalStateException("ASTBlock.getNode() returned null".toString());
        }
        return aSTNode;
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getLineCount, (String)"<this>");
        TextRange textRange = $this$getLineCount.getTextRange();
        if (textRange == null) {
            textRange = TextRange.EMPTY_RANGE;
        }
        TextRange spaceRange = textRange;
        Integer n2 = FormatterUtilKt.getLineCountByDocument($this$getLineCount, spaceRange.getStartOffset(), spaceRange.getEndOffset());
        if (n2 != null) {
            n = n2;
        } else {
            String string = $this$getLineCount.getText();
            if (string == null) {
                throw new IllegalStateException("Cannot count number of lines".toString());
            }
            n = StringUtil.getLineBreakCount((CharSequence)string) + 1;
        }
        return n;
    }

    @Nullable
    public static final Integer getLineCountByDocument(@NotNull PsiElement $this$getLineCountByDocument, int startOffset, int endOffset) {
        PsiFile psiFile;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$getLineCountByDocument, (String)"<this>");
                psiFile = $this$getLineCountByDocument.getContainingFile();
                if (psiFile == null) break block4;
                PsiFile it = psiFile;
                boolean bl = false;
                Document document = PsiDocumentManager.getInstance((Project)$this$getLineCountByDocument.getProject()).getDocument(it);
                psiFile = document;
                if (document != null) break block5;
            }
            return null;
        }
        PsiFile doc = psiFile;
        if (endOffset > doc.getTextLength() || startOffset >= endOffset) {
            return null;
        }
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset);
        return endLine - startLine + 1;
    }

    public static final boolean isMultiline(@NotNull PsiElement $this$isMultiline) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiline, (String)"<this>");
        return FormatterUtilKt.getLineCount($this$isMultiline) > 1;
    }

    public static final boolean isLineBreak(@Nullable PsiElement $this$isLineBreak) {
        return $this$isLineBreak instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)((PsiWhiteSpace)$this$isLineBreak).getText());
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespace(@NotNull PsiElement $this$leafIgnoringWhitespace, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespace, (String)"<this>");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespace, forward, (Function1<? super PsiElement, Boolean>)((Function1)arg_0 -> FormatterUtilKt.leafIgnoringWhitespace$lambda$0(skipEmptyElements, arg_0)));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespace$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespace(psiElement, bl, bl2);
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespaceAndComments(@NotNull PsiElement $this$leafIgnoringWhitespaceAndComments, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespaceAndComments, (String)"<this>");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespaceAndComments, forward, (Function1<? super PsiElement, Boolean>)((Function1)arg_0 -> FormatterUtilKt.leafIgnoringWhitespaceAndComments$lambda$0(skipEmptyElements, arg_0)));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespaceAndComments$default(PsiElement psiElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespaceAndComments(psiElement, bl, bl2);
    }

    @Nullable
    public static final PsiElement leaf(@NotNull PsiElement $this$leaf, boolean forward, @NotNull Function1<? super PsiElement, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)$this$leaf, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return forward ? PsiUtilsKt.nextLeaf((PsiElement)$this$leaf, filter) : PsiUtilsKt.prevLeaf((PsiElement)$this$leaf, filter);
    }

    public static /* synthetic */ PsiElement leaf$default(PsiElement psiElement, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return FormatterUtilKt.leaf(psiElement, bl, (Function1<? super PsiElement, Boolean>)function1);
    }

    public static final boolean isComma(@NotNull PsiElement $this$isComma) {
        Intrinsics.checkNotNullParameter((Object)$this$isComma, (String)"<this>");
        return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)$this$isComma), (Object)KtTokens.COMMA);
    }

    public static final boolean containsLineBreakInChild(@NotNull PsiElement $this$containsLineBreakInChild, int globalStartOffset, int globalEndOffset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$containsLineBreakInChild, (String)"<this>");
            Integer n = FormatterUtilKt.getLineCountByDocument($this$containsLineBreakInChild, globalStartOffset, globalEndOffset);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                bl = it > 1;
            } else {
                PsiElement psiElement = $this$containsLineBreakInChild.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
                Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true), arg_0 -> FormatterUtilKt.containsLineBreakInChild$lambda$1(globalStartOffset, arg_0)), arg_0 -> FormatterUtilKt.containsLineBreakInChild$lambda$2(globalEndOffset, arg_0));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it.textContains('\n') || it.textContains('\r'))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean leafIgnoringWhitespace$lambda$0(boolean $skipEmptyElements, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (!$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace);
    }

    private static final boolean leafIgnoringWhitespaceAndComments$lambda$0(boolean $skipEmptyElements, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (!$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment);
    }

    private static final boolean containsLineBreakInChild$lambda$1(int $globalStartOffset, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiUtilsKt.getStartOffset((PsiElement)it) < $globalStartOffset;
    }

    private static final boolean containsLineBreakInChild$lambda$2(int $globalEndOffset, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiUtilsKt.getEndOffset((PsiElement)it) <= $globalEndOffset;
    }
}

