/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.stylelint.StylelintBundle;
import com.intellij.stylelint.StylelintConfiguration;
import com.intellij.stylelint.StylelintExternalRunner;
import com.intellij.stylelint.StylelintFixResult;
import com.intellij.stylelint.StylelintState;
import com.intellij.stylelint.StylelintUtil;
import com.intellij.util.Consumer;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintFixAction
extends JSLinterFixAction {
    @NlsSafe
    private static final String LINTER_NAME = "Stylelint";

    public StylelintFixAction() {
        super(() -> LINTER_NAME, StylelintBundle.messagePointer("action.Stylelint.Fix.description", new Object[0]), JavaScriptLanguageIcons.FileTypes.Stylelint);
    }

    protected boolean needRefreshFilesAfter() {
        return false;
    }

    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file) {
        return file != null && (StylelintUtil.isStylelintConfigFile(file) || PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file));
    }

    public boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            StylelintFixAction.$$$reportNull$$$0(1);
        }
        String pattern = ((StylelintState)StylelintConfiguration.getInstance(project).getExtendedState().getState()).getFilesPattern();
        return GlobPatternUtil.isFileMatchingGlobPattern((Project)project, (String)pattern, (VirtualFile)file);
    }

    @NotNull
    protected JSLinterConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(2);
        }
        StylelintConfiguration stylelintConfiguration = StylelintConfiguration.getInstance(project);
        if (stylelintConfiguration == null) {
            StylelintFixAction.$$$reportNull$$$0(3);
        }
        return stylelintConfiguration;
    }

    protected Task createTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filesToProcess, @NotNull Runnable completeCallback, boolean modalProgress) {
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(4);
        }
        if (filesToProcess == null) {
            StylelintFixAction.$$$reportNull$$$0(5);
        }
        if (completeCallback == null) {
            StylelintFixAction.$$$reportNull$$$0(6);
        }
        final Consumer task = indicator -> {
            for (VirtualFile file : filesToProcess) {
                String newContent;
                indicator.checkCanceled();
                JSLinterInput input = (JSLinterInput)ReadAction.compute(() -> {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    StylelintState state = psiFile != null ? (StylelintState)StylelintConfiguration.getInstance(psiFile.getProject()).getExtendedState().getState() : null;
                    return state != null ? JSLinterInput.create((PsiFile)psiFile, (JSLinterState)state, null) : null;
                });
                if (input == null || (newContent = this.runStylelintFix((JSLinterInput<StylelintState>)input)) == null) continue;
                StylelintFixAction.setFileContent(input.getPsiFile(), newContent);
            }
            completeCallback.run();
        };
        if (modalProgress) {
            return new Task.Modal(this, project, StylelintBundle.message("stylelint.fix.modal.title", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    task.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/stylelint/StylelintFixAction$1", "run"));
                }
            };
        }
        return new Task.Backgroundable(this, project, StylelintBundle.message("stylelint.fix.background.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                task.consume((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/stylelint/StylelintFixAction$2", "run"));
            }
        };
    }

    @Nullable
    public String runStylelintFix(@NotNull JSLinterInput<StylelintState> input) {
        JSLinterAnnotationResult result;
        if (input == null) {
            StylelintFixAction.$$$reportNull$$$0(7);
        }
        return (result = new StylelintExternalRunner(false, true).execute(input)) instanceof StylelintFixResult ? ((StylelintFixResult)result).getNewFileContent() : null;
    }

    private static void setFileContent(@NotNull PsiFile psiFile, @NotNull String fileContent) {
        if (psiFile == null) {
            StylelintFixAction.$$$reportNull$$$0(8);
        }
        if (fileContent == null) {
            StylelintFixAction.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            if (!(document == null || document.getTextLength() == fileContent.length() && document.getText().equals(fileContent))) {
                WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), (String)StylelintBundle.message("stylelint.fix.modal.title", new Object[0]), null, () -> document.setText((CharSequence)fileContent), (PsiFile[])new PsiFile[0]);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintFixAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runStylelintFix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFileContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

