/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.cloud;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.de.GermanTreeSupport;
import ai.grazie.rules.en.EnglishTreeSupport;
import ai.grazie.rules.ru.RussianTreeSupport;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.uk.UkrainianTreeSupport;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.text.exclusions.SentenceWithExclusions;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.cloud.DependencyParser;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.jlanguage.LazyCachingConcurrentDisambiguator;
import com.intellij.grazie.rule.CloudOrLocalBatchParser;
import com.intellij.grazie.rule.SentenceBatcher;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.HunspellUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.language.English;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/grazie/cloud/DependencyParser;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cachedTrees", "", "", "Lai/grazie/rules/tree/Tree;", "getParser", "Lcom/intellij/grazie/rule/SentenceBatcher$AsyncBatchParser;", "text", "Lcom/intellij/grazie/text/TextContent;", "minimal", "", "getLocalParser", "language", "Lai/grazie/nlp/langs/Language;", "getBatcher", "Lcom/intellij/grazie/cloud/DependencyParser$Batcher;", "lang2SupportClass", "", "supports", "Lai/grazie/rules/tree/TreeSupport;", "obtainSupport", "BatcherHolder", "Batcher", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,168:1\n30#2,2:169\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser\n*L\n83#1:169,2\n*E\n"})
public final class DependencyParser {
    @NotNull
    public static final DependencyParser INSTANCE = new DependencyParser();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<String, Tree> cachedTrees;
    @NotNull
    private static final Map<ai.grazie.nlp.langs.Language, String> lang2SupportClass;
    @NotNull
    private static final Map<ai.grazie.nlp.langs.Language, TreeSupport> supports;

    private DependencyParser() {
    }

    @JvmStatic
    @Nullable
    public static final SentenceBatcher.AsyncBatchParser<Tree> getParser(@NotNull TextContent text, boolean minimal) {
        SentenceBatcher.AsyncBatchParser asyncBatchParser;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int stripPrefixLength = HighlightingUtil.stripPrefix(text);
        String string = ((Object)text).toString().substring(stripPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        ai.grazie.nlp.langs.Language language = GrazieUtilsKt.getLanguageIfAvailable(string);
        if (language == null) {
            return null;
        }
        ai.grazie.nlp.langs.Language language2 = language;
        PsiFile psiFile = text.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        if (!GrazieCloudConnector.Companion.seemsCloudConnected()) {
            return INSTANCE.getLocalParser(language2);
        }
        Batcher batcher = INSTANCE.getBatcher(language2);
        if (batcher == null) {
            return null;
        }
        Batcher batcher2 = batcher;
        if (minimal) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            asyncBatchParser = batcher2.minimal(project);
        } else {
            FileViewProvider fileViewProvider = file.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            asyncBatchParser = batcher2.forFile(fileViewProvider);
        }
        SentenceBatcher.AsyncBatchParser cloud = asyncBatchParser;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new CloudOrLocalBatchParser(project, cloud, () -> DependencyParser.getParser$lambda$0(language2));
    }

    private final SentenceBatcher.AsyncBatchParser<Tree> getLocalParser(ai.grazie.nlp.langs.Language language) {
        return new SentenceBatcher.AsyncBatchParser<Tree>(language){
            final /* synthetic */ ai.grazie.nlp.langs.Language $language;
            {
                this.$language = $language;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public Object parseAsync(List<SentenceWithExclusions> sentences, Continuation<? super LinkedHashMap<SentenceWithExclusions, Tree>> $completion) {
                block11: {
                    if (!($completion instanceof getLocalParser.parseAsync.1)) ** GOTO lbl-1000
                    var25_3 = $completion;
                    if ((var25_3.label & -2147483648) != 0) {
                        var25_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            /* synthetic */ Object result;
                            final /* synthetic */ getLocalParser.1 this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.parseAsync((List<SentenceWithExclusions>)null, (Continuation<? super LinkedHashMap<SentenceWithExclusions, Tree>>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var26_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            support = DependencyParser.obtainSupport(this.$language);
                            if (support != null) {
                                v0 = ltLanguage = SentenceBatcher.Companion.findInstalledLTLanguage(this.$language);
                                var5_8 = v0 != null ? v0.getDisambiguator() : null;
                                v1 = var5_8 instanceof LazyCachingConcurrentDisambiguator != false ? (LazyCachingConcurrentDisambiguator)var5_8 : null;
                                if (v1 == null) break;
                                $continuation.L$0 = sentences;
                                $continuation.L$1 = support;
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)ltLanguage);
                                $continuation.label = 1;
                                v2 = v1.ensureInitializedAsync((Continuation<? super Unit>)$continuation);
                                if (v2 == var26_5) {
                                    return var26_5;
                                }
                                break;
                            }
                            break block11;
                        }
                        case 1: {
                            ltLanguage = (Language)$continuation.L$2;
                            support = (TreeSupport)$continuation.L$1;
                            sentences = (List)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break;
                        }
                    }
                    $this$associateWith$iv = sentences;
                    $i$f$associateWith = false;
                    result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    var8_11 = $this$associateWith$iv;
                    destination$iv$iv = result$iv;
                    $i$f$associateWithTo = false;
                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                        var13_16 = (SentenceWithExclusions)element$iv$iv;
                        var22_25 = element$iv$iv;
                        var21_24 = destination$iv$iv;
                        $i$a$-associateWith-DependencyParser$getLocalParser$1$parseAsync$2 = false;
                        var15_18 = DependencyParser.access$getCachedTrees$p();
                        key$iv = it.getSentence();
                        $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            $i$a$-getOrPut-DependencyParser$getLocalParser$1$parseAsync$2$1 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)Tree.createFlatTree((TreeSupport)support, (String)it.getSentence()), (String)"createFlatTree(...)");
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            v3 /* !! */  = answer$iv;
                        } else {
                            v3 /* !! */  = value$iv;
                        }
                        var23_26 = (Tree)v3 /* !! */ ;
                        var21_24.put(var22_25, var23_26);
                    }
                    return (LinkedHashMap)destination$iv$iv;
                }
                return new LinkedHashMap<K, V>();
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    private final Batcher getBatcher(ai.grazie.nlp.langs.Language language) {
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<BatcherHolder> serviceClass$iv = BatcherHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((BatcherHolder)object).getBatchers().get(language);
    }

    @JvmStatic
    @Nullable
    public static final TreeSupport obtainSupport(@NotNull ai.grazie.nlp.langs.Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!lang2SupportClass.containsKey(language)) {
            return null;
        }
        Language language2 = SentenceBatcher.Companion.findInstalledLTLanguage(language);
        if (language2 == null) {
            return null;
        }
        Language ltLanguage = language2;
        return supports.computeIfAbsent(language, arg_0 -> DependencyParser.obtainSupport$lambda$1(arg_0 -> DependencyParser.obtainSupport$lambda$0(language, ltLanguage, arg_0), arg_0));
    }

    private static final SentenceBatcher.AsyncBatchParser getParser$lambda$0(ai.grazie.nlp.langs.Language $language) {
        return INSTANCE.getLocalParser($language);
    }

    private static final TreeSupport obtainSupport$lambda$0(ai.grazie.nlp.langs.Language $language, Language $ltLanguage, ai.grazie.nlp.langs.Language it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (WhenMappings.$EnumSwitchMapping$0[$language.ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)$ltLanguage, (String)"null cannot be cast to non-null type org.languagetool.language.English");
                yield (TreeSupport)new EnglishTreeSupport((English)$ltLanguage, DependencyParser::obtainSupport$lambda$0$0);
            }
            case 2 -> (TreeSupport)new GermanTreeSupport($ltLanguage, () -> DependencyParser.obtainSupport$lambda$0$1(it));
            case 3 -> (TreeSupport)new UkrainianTreeSupport($ltLanguage, () -> DependencyParser.obtainSupport$lambda$0$2(it));
            case 4 -> (TreeSupport)new RussianTreeSupport($ltLanguage, () -> DependencyParser.obtainSupport$lambda$0$3(it));
            default -> throw new UnsupportedOperationException();
        };
    }

    private static final WordListWithFrequency obtainSupport$lambda$0$0() {
        return (WordListWithFrequency)HunspellUtil.obtainEnglish();
    }

    private static final WordListWithFrequency obtainSupport$lambda$0$1(ai.grazie.nlp.langs.Language $it) {
        return (WordListWithFrequency)HunspellUtil.obtainDictionary($it);
    }

    private static final WordListWithFrequency obtainSupport$lambda$0$2(ai.grazie.nlp.langs.Language $it) {
        return (WordListWithFrequency)HunspellUtil.obtainDictionary($it);
    }

    private static final WordListWithFrequency obtainSupport$lambda$0$3(ai.grazie.nlp.langs.Language $it) {
        return (WordListWithFrequency)HunspellUtil.obtainDictionary($it);
    }

    private static final TreeSupport obtainSupport$lambda$1(Function1 $tmp0, Object p0) {
        return (TreeSupport)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getCachedTrees$p() {
        return cachedTrees;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(DependencyParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftKeySoftValueMap(...)");
        cachedTrees = concurrentMap;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ai.grazie.nlp.langs.Language.ENGLISH, (Object)"ai.grazie.rules.en.EnglishTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.GERMAN, (Object)"ai.grazie.rules.de.GermanTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.UKRAINIAN, (Object)"ai.grazie.rules.uk.UkrainianTreeSupport"), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.RUSSIAN, (Object)"ai.grazie.rules.ru.RussianTreeSupport")};
        lang2SupportClass = MapsKt.mapOf((Pair[])pairArray);
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentSoftValueMap(...)");
        supports = concurrentMap2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/cloud/DependencyParser$Batcher;", "Lcom/intellij/grazie/rule/SentenceBatcher;", "Lai/grazie/rules/tree/Tree;", "language", "Lai/grazie/nlp/langs/Language;", "<init>", "(Lai/grazie/nlp/langs/Language;)V", "parse", "", "Lai/grazie/text/exclusions/SentenceWithExclusions;", "sentences", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportStatus", "", "reporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser$Batcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1761#2,3:169\n1563#2:172\n1634#2,3:173\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser$Batcher\n*L\n137#1:169,3\n141#1:172\n141#1:173,3\n*E\n"})
    private static final class Batcher
    extends SentenceBatcher<Tree> {
        public Batcher(@NotNull ai.grazie.nlp.langs.Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            super(language, TreeSupport.CLOUD_BATCH_SIZE, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected Object parse(@NotNull List<SentenceWithExclusions> sentences2, @NotNull Project project, @NotNull Continuation<? super Map<SentenceWithExclusions, ? extends Tree>> $completion) {
            void $this$mapTo$iv$iv;
            Object it;
            boolean bl;
            block6: {
                Iterable $this$any$iv = GrazieCloudConnector.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (GrazieCloudConnector)element$iv;
                        boolean bl2 = false;
                        if (!it.isAfterRecentGecError()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return MapsKt.emptyMap();
            }
            TreeSupport treeSupport = DependencyParser.obtainSupport(this.getLanguage());
            if (treeSupport == null) {
                return MapsKt.emptyMap();
            }
            TreeSupport support = treeSupport;
            Iterable $this$map$iv = sentences2;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                SentenceWithExclusions sentenceWithExclusions = (SentenceWithExclusions)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.getSentence());
            }
            List sentenceStrings = (List)destination$iv$iv;
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<SentenceWithExclusions, ? extends Tree>>, Object>(support, (List<String>)sentenceStrings, sentences2, this, project, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                long J$0;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ TreeSupport $support;
                final /* synthetic */ List<String> $sentenceStrings;
                final /* synthetic */ List<SentenceWithExclusions> $sentences;
                final /* synthetic */ Batcher this$0;
                final /* synthetic */ Project $project;
                {
                    this.$support = $support;
                    this.$sentenceStrings = $sentenceStrings;
                    this.$sentences = $sentences;
                    this.this$0 = $receiver;
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    block14: {
                        var2_2 = (CoroutineScope)this.L$0;
                        var21_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                start = System.currentTimeMillis();
                                asyncLabels = this.$support.needsNer() != false ? BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends SentenceWithNERAnnotations>>, Object>(this.this$0, this.$sentenceStrings, this.$project, null){
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    Object L$4;
                                    int I$0;
                                    int label;
                                    final /* synthetic */ Batcher this$0;
                                    final /* synthetic */ List<String> $sentenceStrings;
                                    final /* synthetic */ Project $project;
                                    {
                                        this.this$0 = $receiver;
                                        this.$sentenceStrings = $sentenceStrings;
                                        this.$project = $project;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        block6: {
                                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    var2_3 = GrazieCloudConnector.Companion.getEP_NAME().getExtensionList();
                                                    var3_4 = this.this$0;
                                                    var4_5 = this.$sentenceStrings;
                                                    var5_6 = this.$project;
                                                    var6_7 = var2_3.iterator();
lbl10:
                                                    // 2 sources

                                                    while (var6_7.hasNext()) {
                                                        it = (GrazieCloudConnector)var6_7.next();
                                                        $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$asyncLabels$1$1 = 0;
                                                        this.L$0 = var3_4;
                                                        this.L$1 = var4_5;
                                                        this.L$2 = var5_6;
                                                        this.L$3 = var6_7;
                                                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                        this.I$0 = $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$asyncLabels$1$1;
                                                        this.label = 1;
                                                        v0 = it.nerAnnotations(var3_4.getLanguage(), var4_5, var5_6, (Continuation<? super List<SentenceWithNERAnnotations>>)this);
                                                        if (v0 == var9_2) {
                                                            return var9_2;
                                                        }
                                                        ** GOTO lbl34
                                                    }
                                                    break;
                                                }
                                                case 1: {
                                                    $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$asyncLabels$1$1 = this.I$0;
                                                    it = (GrazieCloudConnector)this.L$4;
                                                    var6_7 = (Iterator<T>)this.L$3;
                                                    var5_6 = (Project)this.L$2;
                                                    var4_5 = (List)this.L$1;
                                                    var3_4 = (Batcher)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl34:
                                                    // 2 sources

                                                    if ((var7_8 = (List)v0) == null) ** GOTO lbl10
                                                    v1 = var7_8;
                                                    break block6;
                                                }
                                            }
                                            v1 = null;
                                        }
                                        return v1;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super List<SentenceWithNERAnnotations>> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null) : null;
                                var7_6 = GrazieCloudConnector.Companion.getEP_NAME().getExtensionList();
                                var8_7 = this.this$0;
                                var9_8 = this.$support;
                                var10_9 = this.$sentenceStrings;
                                var11_11 = this.$project;
                                var12_14 = var7_6.iterator();
lbl14:
                                // 2 sources

                                while (var12_14.hasNext()) {
                                    it = (GrazieCloudConnector)var12_14.next();
                                    $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$trees$1 = 0;
                                    v0 = var8_7.getLanguage();
                                    v1 = var9_8.getCloudTreeModelName();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getCloudTreeModelName(...)");
                                    v2 = var9_8.getCloudParserOptions();
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCloudParserOptions(...)");
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                    this.L$1 = asyncLabels;
                                    this.L$2 = var8_7;
                                    this.L$3 = var9_8;
                                    this.L$4 = var10_9;
                                    this.L$5 = var11_11;
                                    this.L$6 = var12_14;
                                    this.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                                    this.J$0 = start;
                                    this.I$0 = $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$trees$1;
                                    this.label = 1;
                                    v3 = it.trees(v0, v1, v2, var10_9, var11_11, (Continuation<? super List<SentenceWithTreeDependencies>>)this);
                                    if (v3 == var21_3) {
                                        return var21_3;
                                    }
                                    ** GOTO lbl50
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-firstNotNullOfOrNull-DependencyParser$Batcher$parse$3$trees$1 = this.I$0;
                                start = this.J$0;
                                it = (GrazieCloudConnector)this.L$7;
                                var12_14 = (Iterator<T>)this.L$6;
                                var11_11 = (Project)this.L$5;
                                var10_9 = (List<String>)this.L$4;
                                var9_8 = (TreeSupport)this.L$3;
                                var8_7 = (Batcher)this.L$2;
                                asyncLabels = (Deferred)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl50:
                                // 2 sources

                                if ((it = (List)v3) == null) ** GOTO lbl14
                                v4 = it;
                                break block14;
                            }
                        }
                        v4 = trees = null;
                    }
                    if ((v5 = asyncLabels) == null) ** GOTO lbl-1000
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)asyncLabels);
                    this.L$2 = trees;
                    this.L$3 = null;
                    this.L$4 = null;
                    this.L$5 = null;
                    this.L$6 = null;
                    this.L$7 = null;
                    this.J$0 = start;
                    this.label = 2;
                    v6 = v5.await((Continuation)this);
                    if (v6 == var21_3) {
                        return var21_3;
                    }
                    ** GOTO lbl76
                    {
                        case 2: {
                            start = this.J$0;
                            trees = (List)this.L$2;
                            asyncLabels = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl76:
                            // 2 sources

                            if ((v5 = (List)v6) != null) {
                                $this$associateBy$iv = v5;
                                $i$f$associateBy = false;
                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                                it = $this$associateBy$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                $i$f$associateByTo = false;
                                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                                    var18_27 = (SentenceWithNERAnnotations)element$iv$iv;
                                    var20_29 = destination$iv$iv;
                                    $i$a$-associateBy-DependencyParser$Batcher$parse$3$labels$1 = false;
                                    var20_29.put(it.getText(), element$iv$iv);
                                }
                                v7 = destination$iv$iv;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v7 = MapsKt.emptyMap();
                            }
                            labels = v7;
                            DependencyParser.access$getLOG$p().debug("Parsing servers responded in " + (System.currentTimeMillis() - start) + "ms for " + this.$sentenceStrings.size() + " sentences");
                            if (trees == null) {
                                v8 = MapsKt.emptyMap();
                            } else {
                                var8_7 = CollectionsKt.zip((Iterable)this.$sentences, (Iterable)trees);
                                var9_8 = this.$support;
                                $i$f$associate = false;
                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                capacity$iv = $this$associate$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                $i$f$associateTo = false;
                                for (T element$iv$iv : $this$associateTo$iv$iv) {
                                    var17_26 = destination$iv$iv;
                                    it = (Pair)element$iv$iv;
                                    $i$a$-associate-DependencyParser$Batcher$parse$3$1 = false;
                                    var18_27 = TuplesKt.to((Object)it.getFirst(), (Object)var9_8.buildTree((SentenceWithTreeDependencies)it.getSecond(), (SentenceWithNERAnnotations)labels.get(((SentenceWithExclusions)it.getFirst()).getSentence())));
                                    var17_26.put(var18_27.getFirst(), var18_27.getSecond());
                                }
                                v8 = destination$iv$iv;
                            }
                            return v8;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Map<SentenceWithExclusions, ? extends Tree>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Override
        protected void reportStatus(@NotNull RawProgressReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            super.reportStatus(reporter);
            reporter.text(GrazieBundle.message("progress.text.parsing.natural.language.text", new Object[0]));
        }
    }

    @Service
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/cloud/DependencyParser$BatcherHolder;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "batchers", "", "Lai/grazie/nlp/langs/Language;", "Lcom/intellij/grazie/cloud/DependencyParser$Batcher;", "getBatchers", "()Ljava/util/Map;", "clearCaches", "", "dispose", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nDependencyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser$BatcherHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1869#2,2:169\n1869#2,2:171\n*S KotlinDebug\n*F\n+ 1 DependencyParser.kt\ncom/intellij/grazie/cloud/DependencyParser$BatcherHolder\n*L\n127#1:169,2\n131#1:171,2\n*E\n"})
    private static final class BatcherHolder
    implements Disposable {
        @NotNull
        private final Map<ai.grazie.nlp.langs.Language, Batcher> batchers;

        public BatcherHolder() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ai.grazie.nlp.langs.Language.ENGLISH, (Object)new Batcher(ai.grazie.nlp.langs.Language.ENGLISH)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.GERMAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.GERMAN)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.UKRAINIAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.UKRAINIAN)), TuplesKt.to((Object)ai.grazie.nlp.langs.Language.RUSSIAN, (Object)new Batcher(ai.grazie.nlp.langs.Language.RUSSIAN))};
            this.batchers = MapsKt.mapOf((Pair[])pairArray);
            GrazieConfig.Companion.subscribe(this, (Function1<? super GrazieConfig.State, Unit>)((Function1)arg_0 -> BatcherHolder._init_$lambda$0(this, arg_0)));
            GrazieCloudConnector.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> BatcherHolder._init_$lambda$2(arg_0 -> BatcherHolder._init_$lambda$1(this, arg_0), arg_0));
        }

        @NotNull
        public final Map<ai.grazie.nlp.langs.Language, Batcher> getBatchers() {
            return this.batchers;
        }

        private final void clearCaches() {
            supports.clear();
            Iterable $this$forEach$iv = this.batchers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Batcher it = (Batcher)element$iv;
                boolean bl = false;
                it.clearCache();
            }
        }

        public void dispose() {
            Iterable $this$forEach$iv = this.batchers.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Disposable p0 = (Disposable)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
        }

        private static final Unit _init_$lambda$0(BatcherHolder this$0, GrazieConfig.State it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.clearCaches();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(BatcherHolder this$0, GrazieCloudConnector it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.subscribeToAuthorizationStateEvents(this$0, (Function0<Unit>)((Function0)() -> BatcherHolder.lambda$1$0(this$0)));
            return Unit.INSTANCE;
        }

        private static final Unit lambda$1$0(BatcherHolder this$0) {
            this$0.clearCaches();
            return Unit.INSTANCE;
        }

        private static final void _init_$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ai.grazie.nlp.langs.Language.values().length];
            try {
                nArray[ai.grazie.nlp.langs.Language.ENGLISH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.GERMAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.UKRAINIAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ai.grazie.nlp.langs.Language.RUSSIAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

