/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.configurable;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingComponent;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.toolkit.LanguageToolkit;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.ui.configurable.FeaturedSettings;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurable;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurableKt;
import com.intellij.grazie.ide.ui.configurable.TreeSettings;
import com.intellij.grazie.ide.ui.grammar.tabs.rules.component.GrazieDescriptionComponent;
import com.intellij.grazie.ide.ui.grammar.tabs.rules.component.GrazieTreeComponent;
import com.intellij.grazie.rule.RuleIdeClient;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.grazie.utils.TextUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Font;
import java.awt.Image;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u0012 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00030\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0014J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u0016J\u001c\u0010 \u001a\u00020\u00122\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J$\u0010!\u001a\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0006H\u0002J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J!\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0003J!\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00030\u0003H\u00c6\u0003JM\u0010$\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u00032 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00030\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0004H\u00d6\u0001R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006*"}, d2={"Lcom/intellij/grazie/ide/ui/configurable/Settings;", "", "featuredSettings", "", "", "Lai/grazie/nlp/langs/Language;", "Lcom/intellij/grazie/ide/ui/configurable/FeaturedSettings;", "treeSettings", "Lcom/intellij/grazie/ide/ui/configurable/TreeSettings;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getFeaturedSettings", "()Ljava/util/Map;", "getTreeSettings", "textStyle", "Lai/grazie/rules/settings/TextStyle;", "language", "isModified", "", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "reset", "", "apply", "originalState", "addTextStyle", "filterComponent", "Lcom/intellij/ui/SearchTextField;", "addLanguage", "updateFilter", "option", "clear", "areModifiedFeaturedSettings", "areModifiedTreeSettings", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nStyleConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleConfigurable.kt\ncom/intellij/grazie/ide/ui/configurable/Settings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,568:1\n1761#2,3:569\n1761#2,3:572\n216#3:575\n216#3,2:583\n217#3:585\n216#3:586\n216#3,2:594\n217#3:596\n216#3:604\n216#3:612\n217#3:620\n216#3,2:621\n217#3:623\n188#3,3:624\n188#3,3:627\n536#4:576\n521#4,6:577\n536#4:587\n521#4,6:588\n536#4:597\n521#4,6:598\n536#4:605\n521#4,6:606\n536#4:613\n521#4,6:614\n*S KotlinDebug\n*F\n+ 1 StyleConfigurable.kt\ncom/intellij/grazie/ide/ui/configurable/Settings\n*L\n335#1:569,3\n336#1:572,3\n339#1:575\n341#1:583,2\n339#1:585\n348#1:586\n350#1:594,2\n348#1:596\n358#1:604\n364#1:612\n364#1:620\n397#1:621,2\n358#1:623\n481#1:624,3\n485#1:627,3\n341#1:576\n341#1:577,6\n350#1:587\n350#1:588,6\n357#1:597\n357#1:598,6\n364#1:605\n364#1:606,6\n368#1:613\n368#1:614,6\n*E\n"})
public final class Settings {
    @NotNull
    private final Map<String, Map<Language, FeaturedSettings>> featuredSettings;
    @NotNull
    private final Map<String, Map<Language, TreeSettings>> treeSettings;

    public Settings(@NotNull Map<String, Map<Language, FeaturedSettings>> featuredSettings, @NotNull Map<String, Map<Language, TreeSettings>> treeSettings) {
        Intrinsics.checkNotNullParameter(featuredSettings, (String)"featuredSettings");
        Intrinsics.checkNotNullParameter(treeSettings, (String)"treeSettings");
        this.featuredSettings = featuredSettings;
        this.treeSettings = treeSettings;
    }

    public /* synthetic */ Settings(Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new HashMap();
        }
        if ((n & 2) != 0) {
            map2 = new HashMap();
        }
        this(map, map2);
    }

    @NotNull
    public final Map<String, Map<Language, FeaturedSettings>> getFeaturedSettings() {
        return this.featuredSettings;
    }

    @NotNull
    public final Map<String, Map<Language, TreeSettings>> getTreeSettings() {
        return this.treeSettings;
    }

    @Nullable
    public final FeaturedSettings getFeaturedSettings(@NotNull TextStyle textStyle, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Map<Language, FeaturedSettings> map = this.featuredSettings.get(textStyle.id());
        return map != null ? map.get(language) : null;
    }

    @NotNull
    public final TreeSettings getTreeSettings(@NotNull TextStyle textStyle, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Map<Language, TreeSettings> map = this.treeSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        TreeSettings treeSettings = map.get(language);
        Intrinsics.checkNotNull((Object)treeSettings);
        return treeSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull GrazieConfig.State state) {
        Map it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$any$iv = this.featuredSettings.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (Map)element$iv;
                boolean bl2 = false;
                if (!this.areModifiedFeaturedSettings(it)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = this.treeSettings.values();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (Map)element$iv;
            boolean bl3 = false;
        } while (!this.areModifiedTreeSettings(it, state));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void reset(@NotNull GrazieConfig.State state) {
        Map.Entry<String, Map<Language, FeaturedSettings>> entry;
        Map.Entry<String, Map<Language, Object>> element$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<String, Map<Language, Object>> $this$forEach$iv = this.featuredSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Map<Language, Object>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Iterator $this$filterTo$iv$iv;
            entry = element$iv = iterator.next();
            boolean bl = false;
            String domain = entry.getKey();
            Map featuredSettings = entry.getValue();
            if (!this.areModifiedFeaturedSettings(featuredSettings)) continue;
            Map $this$filter$iv = featuredSettings;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!this.areModifiedFeaturedSettings((FeaturedSettings)it.getValue())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.entrySet().iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry $i$f$filterTo2 = element$iv2 = $this$filterTo$iv$iv.next();
                boolean bl3 = false;
                Language language = (Language)$i$f$filterTo2.getKey();
                FeaturedSettings settings = (FeaturedSettings)$i$f$filterTo2.getValue();
                TextStyle textStyle = StyleConfigurableKt.access$getTextStyle(domain);
                settings.getComponent().loadState(StyleConfigurableKt.access$getSettingsState(language, textStyle), textStyle);
                SettingComponent.SettingState settingState = settings.getComponent().getState();
                Intrinsics.checkNotNullExpressionValue((Object)settingState, (String)"getState(...)");
                settings.setResetState(settingState);
            }
        }
        $this$forEach$iv = this.treeSettings;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv3;
            void $this$filterTo$iv$iv;
            entry = element$iv = iterator.next();
            boolean bl = false;
            Map treesSettings = entry.getValue();
            if (!this.areModifiedTreeSettings(treesSettings, state)) continue;
            Map $this$filter$iv = treesSettings;
            boolean $i$f$filter = false;
            Map $i$f$forEach2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator $i$f$filterTo2 = $this$filterTo$iv$iv.entrySet().iterator();
            while ($i$f$filterTo2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = $i$f$filterTo2.next();
                boolean bl4 = false;
                if (!this.areModifiedTreeSettings((TreeSettings)it.getValue(), state)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry2 = element$iv3 = iterator3.next();
                boolean bl5 = false;
                TreeSettings settings = (TreeSettings)entry2.getValue();
                settings.getTree().reset(state);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull GrazieConfig.State originalState) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalState, (String)"originalState");
        Map<String, Map<Language, TreeSettings>> $this$filter$iv = this.treeSettings;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String domainId = (String)entry.getKey();
            Map treeSettingsMap = (Map)entry.getValue();
            Map<Language, FeaturedSettings> map = this.featuredSettings.get(domainId);
            Intrinsics.checkNotNull(map);
            if (!(this.areModifiedFeaturedSettings(map) || this.areModifiedTreeSettings(treeSettingsMap, originalState))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map $this$forEach$iv2;
            void $this$filterTo$iv$iv2;
            Map.Entry element$iv2;
            Map.Entry entry = element$iv2 = (Map.Entry)object.next();
            boolean bl = false;
            String domainId = (String)entry.getKey();
            Map treeSettingsMap = (Map)entry.getValue();
            TextStyleDomain domain = TextUtilsKt.getTextDomain(StyleConfigurableKt.access$getTextStyle(domainId));
            HashSet userEnabledRules = new HashSet();
            HashSet userDisabledRules = new HashSet();
            HashMap parameters = new HashMap();
            Map $this$filter$iv2 = treeSettingsMap;
            boolean $i$f$filter2 = false;
            Iterator iterator2 = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo22 = false;
            Iterator iterator3 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl2 = false;
                if (!this.areModifiedTreeSettings((TreeSettings)it.getValue(), originalState)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry $i$f$filterTo22 = element$iv = (Map.Entry)iterator2.next();
                boolean bl3 = false;
                Language language = (Language)$i$f$filterTo22.getKey();
                TreeSettings treeSettings = (TreeSettings)$i$f$filterTo22.getValue();
                HashSet<CallSite> userEnabledRulesPerLanguage = new HashSet<CallSite>();
                HashSet<CallSite> userDisabledRulesPerLanguage = new HashSet<CallSite>();
                Object object2 = this.featuredSettings.get(domainId);
                if (object2 != null) {
                    void $this$filterTo$iv$iv3;
                    Map<Language, FeaturedSettings> $this$filter$iv3 = object2;
                    boolean $i$f$filter3 = false;
                    Map<Language, FeaturedSettings> map = $this$filter$iv3;
                    Map destination$iv$iv3 = new LinkedHashMap();
                    boolean $i$f$filterTo3 = false;
                    Iterator iterator4 = $this$filterTo$iv$iv3.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = iterator4.next();
                        boolean bl4 = false;
                        if (!this.areModifiedFeaturedSettings((FeaturedSettings)it.getValue())) continue;
                        destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    object2 = (FeaturedSettings)destination$iv$iv3.get(language);
                    if (object2 != null) {
                        String prefix;
                        Map<Language, FeaturedSettings> featuredSettings = object2;
                        boolean bl5 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)Rule.globalIdPrefix((Language)language), (String)"globalIdPrefix(...)");
                        SettingComponent.SettingState settingsState = ((FeaturedSettings)((Object)featuredSettings)).getComponent().getState();
                        Intrinsics.checkNotNull((Object)settingsState);
                        ((FeaturedSettings)((Object)featuredSettings)).setResetState(settingsState);
                        for (String id : settingsState.enabledRules()) {
                            userEnabledRulesPerLanguage.add((CallSite)((Object)(prefix + id)));
                            userDisabledRulesPerLanguage.remove(prefix + id);
                        }
                        for (String id : settingsState.disabledRules()) {
                            userEnabledRulesPerLanguage.remove(prefix + id);
                            userDisabledRulesPerLanguage.add((CallSite)((Object)(prefix + id)));
                        }
                        ((Map)parameters).put(language, settingsState.paramValues());
                    }
                }
                GrazieConfig.State updatedState = treeSettings.getTree().apply(originalState);
                Set<String> affectedGlobalRules = GrazieUtilsKt.getAffectedGlobalRules(language);
                GrazieConfig.UserChangedRules userChangedRules = updatedState.getUserChangedRules(domain);
                boolean bl6 = false;
                Set<String> enabledRules = userChangedRules.component1();
                Set<String> disabledRules = userChangedRules.component2();
                userEnabledRulesPerLanguage.addAll(SetsKt.minus(enabledRules, (Iterable)affectedGlobalRules));
                userDisabledRulesPerLanguage.addAll(SetsKt.minus(disabledRules, (Iterable)affectedGlobalRules));
                userEnabledRules.addAll(userEnabledRulesPerLanguage);
                userDisabledRules.addAll(userDisabledRulesPerLanguage);
            }
            if (domain == TextStyleDomain.Other) {
                GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)arg_0 -> Settings.apply$lambda$1$2(parameters, arg_0)));
            } else {
                GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)arg_0 -> Settings.apply$lambda$1$3(domain, parameters, arg_0)));
            }
            GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)arg_0 -> Settings.apply$lambda$1$4(domain, userEnabledRules, userDisabledRules, arg_0)));
            $this$forEach$iv2 = treeSettingsMap;
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry it = element$iv = iterator2.next();
                boolean bl7 = false;
                ((TreeSettings)it.getValue()).getTree().reset(GrazieConfig.Companion.get());
            }
        }
    }

    public final void addTextStyle(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull SearchTextField filterComponent2) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)filterComponent2, (String)"filterComponent");
        Map<Language, TreeSettings> settings = this.treeSettings.get(textStyle.id());
        if (settings != null && settings.containsKey(language)) {
            return;
        }
        if (this.featuredSettings.get(textStyle.id()) == null) {
            this.featuredSettings.put(textStyle.id(), new HashMap());
        }
        if (this.treeSettings.get(textStyle.id()) == null) {
            this.treeSettings.put(textStyle.id(), new HashMap());
        }
        this.addLanguage(textStyle, language, filterComponent2);
    }

    public final void addLanguage(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull SearchTextField filterComponent2) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)filterComponent2, (String)"filterComponent");
        Map<Language, FeaturedSettings> map = this.featuredSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        Map<Language, FeaturedSettings> featuredSettingsPerLanguage = map;
        Map<Language, TreeSettings> map2 = this.treeSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map2);
        Map<Language, TreeSettings> treeSettingsPerLanguage = map2;
        if (featuredSettingsPerLanguage.containsKey(language) || treeSettingsPerLanguage.containsKey(language)) {
            return;
        }
        TextStyleDomain domain = TextUtilsKt.getTextDomain(textStyle);
        GrazieDescriptionComponent description = new GrazieDescriptionComponent();
        GrazieTreeComponent tree = new GrazieTreeComponent(description.getListener(), language, domain, filterComponent2);
        treeSettingsPerLanguage.put(language, new TreeSettings(description, tree));
        TreeSettings treeSettings = treeSettingsPerLanguage.get(language);
        Intrinsics.checkNotNull((Object)treeSettings);
        treeSettings.getTree().reset(GrazieConfig.Companion.get());
        if (!StyleConfigurable.Companion.getRuleEngineLanguages().contains(language)) {
            return;
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)language);
        IntelliJSpacingConfiguration spacing = new IntelliJSpacingConfiguration();
        SettingComponent.UI ui2 = new SettingComponent.UI(spacing){
            final /* synthetic */ IntelliJSpacingConfiguration $spacing;
            {
                this.$spacing = $spacing;
            }

            public String getExamplePrefix() {
                return GrazieBundle.message("grazie.settings.style.configurable.example.prefix", new Object[0]);
            }

            public String getCorrectionPrefix() {
                return GrazieBundle.message("grazie.settings.style.configurable.corrected.prefix", new Object[0]);
            }

            public void navigateHyperlink(URL url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                BrowserUtil.browse((URL)url);
            }

            public Image externalLinkArrow() {
                Icon icon = AllIcons.Ide.External_link_arrow;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"External_link_arrow");
                return IconUtil.toBufferedImage((Icon)icon, (boolean)true);
            }

            public JComponent createResetToDefaultComponent(Runnable action2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return StyleConfigurableKt.access$createLinkLabel(GrazieBundle.message("grazie.settings.style.configurable.reset.to.default.link", new Object[0]), action2);
            }

            public JComponent createExpandComponent(boolean examplesOnly, Runnable doExpand) {
                Intrinsics.checkNotNullParameter((Object)doExpand, (String)"doExpand");
                String text = examplesOnly ? GrazieBundle.message("grazie.settings.style.configurable.expand.examples.link", new Object[0]) : GrazieBundle.message("grazie.settings.style.configurable.expand.link", new Object[0]);
                return StyleConfigurableKt.access$createLinkLabel(text, doExpand);
            }

            public JComponent createCollapseComponent(boolean examplesOnly, Runnable doCollapse) {
                Intrinsics.checkNotNullParameter((Object)doCollapse, (String)"doCollapse");
                String text = examplesOnly ? GrazieBundle.message("grazie.settings.style.configurable.collapse.examples.link", new Object[0]) : GrazieBundle.message("grazie.settings.style.configurable.collapse.link", new Object[0]);
                return StyleConfigurableKt.access$createLinkLabel(text, doCollapse);
            }

            public JComponent createGroupHeader(@NlsContexts.Label String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return (JComponent)StyleConfigurableKt.access$createTitledSeparator(name, this.$spacing);
            }

            public void customizeSettingSection(Setting setting, JComponent section) {
                Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
                Intrinsics.checkNotNullParameter((Object)section, (String)"section");
                section.setBorder((Border)new JBEmptyBorder(0, this.$spacing.getHorizontalIndent(), this.$spacing.getVerticalComponentGap(), 0));
            }

            public void customizeRuleDescription(JEditorPane pane) {
                Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
                pane.setFont((Font)JBFont.medium());
                pane.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
            }
        };
        SettingComponent component2 = new SettingComponent(toolkit, (RuleClient)RuleIdeClient.INSTANCE, ui2);
        SettingComponent.SettingState settingState = StyleConfigurableKt.access$getSettingsState(language, textStyle);
        component2.loadState(settingState, textStyle);
        featuredSettingsPerLanguage.put(language, new FeaturedSettings(component2, settingState));
    }

    public final void updateFilter(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Map<Language, FeaturedSettings> map = this.featuredSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        FeaturedSettings featuredSettings = map.get(language);
        Intrinsics.checkNotNull((Object)featuredSettings);
        featuredSettings.getComponent().filter(option);
        Map<Language, TreeSettings> map2 = this.treeSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map2);
        TreeSettings treeSettings = map2.get(language);
        Intrinsics.checkNotNull((Object)treeSettings);
        treeSettings.getTree().filter(option);
    }

    public final void clear() {
        this.featuredSettings.clear();
        this.treeSettings.clear();
    }

    private final boolean areModifiedFeaturedSettings(Map<Language, FeaturedSettings> featuredSettings) {
        boolean bl;
        block3: {
            Map<Language, FeaturedSettings> $this$any$iv = featuredSettings;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<Language, FeaturedSettings>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Language, FeaturedSettings> element$iv;
                    Map.Entry<Language, FeaturedSettings> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!this.areModifiedFeaturedSettings(it.getValue())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean areModifiedTreeSettings(Map<Language, TreeSettings> treeSettings, GrazieConfig.State state) {
        boolean bl;
        block3: {
            Map<Language, TreeSettings> $this$any$iv = treeSettings;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<Language, TreeSettings>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Language, TreeSettings> element$iv;
                    Map.Entry<Language, TreeSettings> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!this.areModifiedTreeSettings(it.getValue(), state)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean areModifiedFeaturedSettings(FeaturedSettings featuredSettings) {
        return !Intrinsics.areEqual((Object)featuredSettings.getComponent().getState(), (Object)featuredSettings.getResetState());
    }

    private final boolean areModifiedTreeSettings(TreeSettings treeSettings, GrazieConfig.State state) {
        return treeSettings.getTree().isModified(state);
    }

    @NotNull
    public final Map<String, Map<Language, FeaturedSettings>> component1() {
        return this.featuredSettings;
    }

    @NotNull
    public final Map<String, Map<Language, TreeSettings>> component2() {
        return this.treeSettings;
    }

    @NotNull
    public final Settings copy(@NotNull Map<String, Map<Language, FeaturedSettings>> featuredSettings, @NotNull Map<String, Map<Language, TreeSettings>> treeSettings) {
        Intrinsics.checkNotNullParameter(featuredSettings, (String)"featuredSettings");
        Intrinsics.checkNotNullParameter(treeSettings, (String)"treeSettings");
        return new Settings(featuredSettings, treeSettings);
    }

    public static /* synthetic */ Settings copy$default(Settings settings, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map = settings.featuredSettings;
        }
        if ((n & 2) != 0) {
            map2 = settings.treeSettings;
        }
        return settings.copy(map, map2);
    }

    @NotNull
    public String toString() {
        return "Settings(featuredSettings=" + this.featuredSettings + ", treeSettings=" + this.treeSettings + ")";
    }

    public int hashCode() {
        int result = ((Object)this.featuredSettings).hashCode();
        result = result * 31 + ((Object)this.treeSettings).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Settings)) {
            return false;
        }
        Settings settings = (Settings)other;
        if (!Intrinsics.areEqual(this.featuredSettings, settings.featuredSettings)) {
            return false;
        }
        return Intrinsics.areEqual(this.treeSettings, settings.treeSettings);
    }

    private static final GrazieConfig.State apply$lambda$1$2(HashMap $parameters, GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, null, null, null, $parameters, null, false, false, 122879, null);
    }

    private static final GrazieConfig.State apply$lambda$1$3(TextStyleDomain $domain, HashMap $parameters, GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, null, null, null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)$domain), (Object)$parameters)), false, false, 114687, null);
    }

    private static final GrazieConfig.State apply$lambda$1$4(TextStyleDomain $domain, HashSet $userEnabledRules, HashSet $userDisabledRules, GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.updateUserRules($domain, $userEnabledRules, $userDisabledRules);
    }

    public Settings() {
        this(null, null, 3, null);
    }
}

