/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.RunDashboardCustomizationBuilderImpl;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.splitApi.CustomLinkDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardAdditionalServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardMainServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardSettingsDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceCustomizationDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceStatusDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u001cJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\n0\nJ\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cJ\u001c\u0010(\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\nJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cJ\u001e\u0010,\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sharedSettings", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardSettingsDto;", "sharedServicesState", "", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardServiceDto;", "sharedServicesCustomizations", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/execution/dashboard/splitApi/ServiceCustomizationDto;", "tagCallbacksByServiceId", "Ljava/util/HashMap;", "Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "Lcom/intellij/platform/execution/dashboard/splitApi/CustomLinkDto;", "Lkotlin/collections/HashMap;", "sharedStatuses", "Lcom/intellij/platform/execution/dashboard/splitApi/ServiceStatusDto;", "getLinkByServiceId", "Ljava/lang/Runnable;", "link", "", "serviceId", "getSettings", "Lkotlinx/coroutines/flow/Flow;", "getServices", "setServices", "", "value", "Lcom/intellij/execution/dashboard/RunDashboardService;", "setSettings", "openRunningConfigInTab", "", "fireStatusUpdated", "backendService", "getStatuses", "fireCustomizationUpdated", "customizers", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "getCustomizations", "createCustomizationDto", "Companion", "intellij.platform.execution.dashboard"})
@SourceDebugExtension(value={"SMAP\nBackendRunDashboardManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunDashboardManagerState.kt\ncom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n295#2,2:127\n1563#2:129\n1634#2,3:130\n*S KotlinDebug\n*F\n+ 1 BackendRunDashboardManagerState.kt\ncom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState\n*L\n28#1:127,2\n41#1:129\n41#1:130,3\n*E\n"})
public final class BackendRunDashboardManagerState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<RunDashboardSettingsDto> sharedSettings;
    @NotNull
    private final MutableStateFlow<List<RunDashboardServiceDto>> sharedServicesState;
    @NotNull
    private final MutableSharedFlow<ServiceCustomizationDto> sharedServicesCustomizations;
    @NotNull
    private final HashMap<RunDashboardServiceId, List<CustomLinkDto>> tagCallbacksByServiceId;
    @NotNull
    private final MutableSharedFlow<ServiceStatusDto> sharedStatuses;

    public BackendRunDashboardManagerState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sharedSettings = StateFlowKt.MutableStateFlow((Object)new RunDashboardSettingsDto(false, 1, null));
        this.sharedServicesState = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.sharedServicesCustomizations = SharedFlowKt.MutableSharedFlow((int)1, (int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.tagCallbacksByServiceId = new HashMap();
        this.sharedStatuses = SharedFlowKt.MutableSharedFlow((int)1, (int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Runnable getLinkByServiceId(@NotNull String link, @NotNull RunDashboardServiceId serviceId) {
        Object v2;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            List<CustomLinkDto> list = this.tagCallbacksByServiceId.get(serviceId);
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CustomLinkDto linkDto = (CustomLinkDto)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)linkDto.getPresentableText(), (Object)link)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        CustomLinkDto customLinkDto = v2;
        object = customLinkDto;
        if (customLinkDto == null) return null;
        Runnable runnable = ((CustomLinkDto)object).getCallback();
        return runnable;
    }

    @NotNull
    public final Flow<RunDashboardSettingsDto> getSettings() {
        return (Flow)FlowKt.asStateFlow(this.sharedSettings);
    }

    @NotNull
    public final Flow<List<RunDashboardServiceDto>> getServices() {
        return (Flow)FlowKt.asStateFlow(this.sharedServicesState);
    }

    /*
     * WARNING - void declaration
     */
    public final void setServices(@NotNull List<? extends List<? extends RunDashboardService>> value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List flattenServices = CollectionsKt.flatten((Iterable)value);
        Iterable iterable = flattenServices;
        MutableStateFlow<List<RunDashboardServiceDto>> mutableStateFlow = this.sharedServicesState;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void backendServiceModel;
            RunDashboardService runDashboardService = (RunDashboardService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.createServiceDto((RunDashboardService)backendServiceModel));
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
        Set effectiveServicesSet = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)flattenServices), BackendRunDashboardManagerState::setServices$lambda$1));
        this.tagCallbacksByServiceId.keySet().retainAll(effectiveServicesSet);
    }

    public final void setSettings(boolean openRunningConfigInTab) {
        this.sharedSettings.setValue((Object)new RunDashboardSettingsDto(openRunningConfigInTab));
    }

    public final void fireStatusUpdated(@NotNull RunDashboardService backendService) {
        Intrinsics.checkNotNullParameter((Object)backendService, (String)"backendService");
        RunDashboardServiceId runDashboardServiceId = backendService.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
        String string = RunDashboardRunConfigurationStatus.getStatus((RunContentDescriptor)backendService.getDescriptor()).getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.sharedStatuses.tryEmit((Object)new ServiceStatusDto(runDashboardServiceId, string));
    }

    @NotNull
    public final Flow<ServiceStatusDto> getStatuses() {
        return (Flow)FlowKt.asSharedFlow(this.sharedStatuses);
    }

    public final void fireCustomizationUpdated(@NotNull RunDashboardService backendService, @NotNull List<? extends RunDashboardCustomizer> customizers) {
        Intrinsics.checkNotNullParameter((Object)backendService, (String)"backendService");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        ServiceCustomizationDto value = this.createCustomizationDto(backendService, customizers);
        ((Map)this.tagCallbacksByServiceId).put(backendService.getUuid(), value.getLinks());
        this.sharedServicesCustomizations.tryEmit((Object)value);
    }

    @NotNull
    public final Flow<ServiceCustomizationDto> getCustomizations() {
        return (Flow)FlowKt.asSharedFlow(this.sharedServicesCustomizations);
    }

    private final ServiceCustomizationDto createCustomizationDto(RunDashboardService backendService, List<? extends RunDashboardCustomizer> customizers) {
        RunDashboardCustomizationBuilderImpl customizationBuilder = new RunDashboardCustomizationBuilderImpl();
        for (RunDashboardCustomizer runDashboardCustomizer : customizers) {
            if (runDashboardCustomizer.updatePresentation((RunDashboardCustomizationBuilder)customizationBuilder, backendService.getConfigurationSettings(), backendService.getDescriptor())) break;
        }
        RunDashboardServiceId runDashboardServiceId = backendService.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
        return customizationBuilder.buildDto$intellij_platform_execution_dashboard(runDashboardServiceId);
    }

    private static final RunDashboardServiceId setServices$lambda$1(RunDashboardService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUuid();
    }

    @JvmStatic
    @NotNull
    public static final RunDashboardServiceDto createServiceDto(@NotNull RunDashboardService backendServiceModel) {
        return Companion.createServiceDto(backendServiceModel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState$Companion;", "", "<init>", "()V", "createServiceDto", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardServiceDto;", "backendServiceModel", "Lcom/intellij/execution/dashboard/RunDashboardService;", "intellij.platform.execution.dashboard"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunDashboardServiceDto createServiceDto(@NotNull RunDashboardService backendServiceModel) {
            Intrinsics.checkNotNullParameter((Object)backendServiceModel, (String)"backendServiceModel");
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = backendServiceModel.getConfigurationSettings();
            Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"getConfigurationSettings(...)");
            RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            Project project = configuration.getProject();
            if (backendServiceModel instanceof RunDashboardManagerImpl.RunDashboardServiceImpl) {
                RunDashboardServiceId runDashboardServiceId = ((RunDashboardManagerImpl.RunDashboardServiceImpl)backendServiceModel).getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
                String string = configuration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Icon icon = RunManagerEx.getInstanceEx((Project)project).getConfigurationIcon(settings);
                Object object = icon != null ? IconIdKt.rpcId((Icon)icon) : null;
                String string2 = configuration.getType().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                String string3 = configuration.getType().getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
                Icon icon2 = configuration.getType().getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getIcon(...)");
                IconId iconId = IconIdKt.rpcId((Icon)icon2);
                String string4 = settings.getFolderName();
                RunContentDescriptor runContentDescriptor = ((RunDashboardManagerImpl.RunDashboardServiceImpl)backendServiceModel).getDescriptor();
                Object object2 = runContentDescriptor != null ? runContentDescriptor.getId() : null;
                Intrinsics.checkNotNull((Object)project);
                boolean bl = RunManager.Companion.getInstance(project).hasSettings(settings);
                String string5 = ((RunDashboardManagerImpl.RunDashboardServiceImpl)backendServiceModel).getServiceViewId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getServiceViewId(...)");
                return new RunDashboardMainServiceDto(runDashboardServiceId, string, (IconId)object, string2, string3, iconId, string4, (RunContentDescriptorId)object2, bl, string5, RunManager.Companion.getInstance(project).hasSettings(settings), settings.isActivateToolWindowBeforeRun(), settings.isFocusToolWindowBeforeRun());
            }
            RunDashboardServiceId runDashboardServiceId = backendServiceModel.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
            String string = configuration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Icon icon = RunManagerEx.getInstanceEx((Project)project).getConfigurationIcon(settings);
            Object object = icon != null ? IconIdKt.rpcId((Icon)icon) : null;
            String string6 = configuration.getType().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getId(...)");
            String string7 = configuration.getType().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getDisplayName(...)");
            Icon icon3 = configuration.getType().getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
            IconId iconId = IconIdKt.rpcId((Icon)icon3);
            String string8 = settings.getFolderName();
            RunContentDescriptor runContentDescriptor = backendServiceModel.getDescriptor();
            Object object3 = runContentDescriptor != null ? runContentDescriptor.getId() : null;
            Intrinsics.checkNotNull((Object)project);
            boolean bl = RunManager.Companion.getInstance(project).hasSettings(settings);
            String string9 = backendServiceModel.getServiceViewId();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getServiceViewId(...)");
            return new RunDashboardAdditionalServiceDto(runDashboardServiceId, string, (IconId)object, string6, string7, iconId, string8, (RunContentDescriptorId)object3, bl, string9, RunManager.Companion.getInstance(project).hasSettings(settings), settings.isActivateToolWindowBeforeRun(), settings.isFocusToolWindowBeforeRun());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

