/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerProxy;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.execution.dashboard.RunDashboardServiceIdKt;
import com.intellij.execution.dashboard.RunDashboardUiManager;
import com.intellij.execution.dashboard.actions.ExecutorAction;
import com.intellij.execution.dashboard.actions.RunDashboardGroupNode;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewContributorHelper;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewDeleteProvider;
import com.intellij.platform.execution.dashboard.RunDashboardTypePanel;
import com.intellij.platform.execution.dashboard.actions.RunDashboardDoubleClickRunAction;
import com.intellij.platform.execution.dashboard.splitApi.CustomLinkDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceCustomizationDto;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardManager;
import com.intellij.platform.execution.dashboard.splitApi.frontend.FrontendRunDashboardService;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardComponentWrapper;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardUiManagerImpl;
import com.intellij.platform.execution.dashboard.splitApi.frontend.RunDashboardUiUtils;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.FolderDashboardGroupingRule;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.FrontendRunConfigurationNode;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.GroupingNode;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.RunDashboardGroupImpl;
import com.intellij.platform.execution.dashboard.splitApi.frontend.tree.RunDashboardStatusFilter;
import com.intellij.platform.execution.serviceView.ServiceViewImplementationChooserKt;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class RunDashboardServiceViewContributor
implements ServiceViewGroupingContributor<FrontendRunConfigurationNode, GroupingNode>,
RunDashboardGroupNode {
    private static final DataProvider TREE_EXPANDER_HIDE_PROVIDER = id -> PlatformDataKeys.TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER.is(id) ? Boolean.valueOf(true) : null;

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(0);
        }
        return new RunDashboardContributorViewDescriptor(project);
    }

    @NotNull
    public @Unmodifiable List<FrontendRunConfigurationNode> getServices(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(1);
        }
        if (!ServiceViewImplementationChooserKt.shouldEnableServicesViewInCurrentEnvironment()) {
            List<FrontendRunConfigurationNode> list = Collections.emptyList();
            if (list == null) {
                RunDashboardServiceViewContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.map(FrontendRunDashboardManager.getInstance(project).getServicePresentations(), value -> new FrontendRunConfigurationNode(project, (FrontendRunDashboardService)value));
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull FrontendRunConfigurationNode node) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(4);
        }
        if (node == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(5);
        }
        return new RunConfigurationServiceViewDescriptor(node);
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull FrontendRunConfigurationNode node) {
        if (node == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(6);
        }
        if (!ServiceViewImplementationChooserKt.shouldEnableServicesViewInCurrentEnvironment()) {
            List<GroupingNode> list = Collections.emptyList();
            if (list == null) {
                RunDashboardServiceViewContributor.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<GroupingNode> result = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardGroupingRule.GROUPING_RULE_EP_NAME.getExtensions()) {
            RunDashboardGroup group = groupingRule.getGroup(node);
            if (group == null) continue;
            GroupingNode groupingNode = new GroupingNode(node.getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group);
            groupingNode.setParent(parentGroupNode);
            result.add(groupingNode);
            parentGroupNode = groupingNode;
        }
        ArrayList<GroupingNode> arrayList = result;
        if (arrayList == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node) {
        RunDashboardGroupImpl dashboardGroup;
        Object t;
        RunDashboardGroup group;
        if (node == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(9);
        }
        if ((group = node.getGroup()) instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
            return new RunDashboardFolderGroupViewDescriptor(node);
        }
        if (group instanceof RunDashboardGroupImpl && (t = (dashboardGroup = (RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
            ConfigurationType type = (ConfigurationType)t;
            return new RunDashboardTypeGroupViewDescriptor(node, type);
        }
        return new RunDashboardGroupViewDescriptor(node);
    }

    @NotNull
    public @NotNull List<@NotNull Object> getChildren(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(10);
        }
        if (e == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(11);
        }
        if (!ServiceViewImplementationChooserKt.shouldEnableServicesViewInCurrentEnvironment()) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                RunDashboardServiceViewContributor.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).getChildrenSafe(e, List.of(this), RunDashboardServiceViewContributor.class);
        if (list == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(){

            @NotNull
            public @NotNull List<? extends @NotNull AnAction> postProcessVisibleChildren(@NotNull AnActionEvent e, @NotNull @NotNull List<? extends @NotNull AnAction> visibleChildren) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (visibleChildren == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<AnAction> list = visibleChildren.stream().filter(o -> !(o instanceof StopAction) && !(o instanceof FakeRerunAction) && !(o instanceof ExecutorAction)).toList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visibleChildren";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "postProcessVisibleChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "postProcessVisibleChildren";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DefaultActionGroup result = new DefaultActionGroup();
        result.add(ActionManager.getInstance().getAction("RunDashboardContentToolbar"));
        result.add((AnAction)actionGroup);
        RunnerLayoutUiImpl ui = RunDashboardUiUtils.getRunnerLayoutUi(descriptor);
        if (ui != null) {
            actionGroup.addAll((Collection)ui.getContentUI().getActions(true));
        } else {
            ActionToolbar toolbar = RunDashboardUiUtils.findActionToolbar(descriptor);
            if (toolbar != null) {
                actionGroup.add((AnAction)toolbar.getActionGroup());
            }
        }
        return result;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("RunDashboardContentToolbar"));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    @Nullable
    private static FrontendRunConfigurationNode getRunConfigurationNode(@NotNull DnDEvent event, @NotNull Project project) {
        if (event == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(14);
        }
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(15);
        }
        try {
            List items = (List)event.getTransferData(ServiceViewDnDDescriptor.LIST_DATA_FLAVOR);
            Object item = ContainerUtil.getOnlyItem((Collection)items);
            if (item == null) {
                return null;
            }
            FrontendRunConfigurationNode node = (FrontendRunConfigurationNode)((Object)ObjectUtils.tryCast((Object)item, FrontendRunConfigurationNode.class));
            if (node != null && !node.getProject().equals((Object)project)) {
                return null;
            }
            return node;
        }
        catch (UnsupportedFlavorException | IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 8, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static final class RunDashboardContributorViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewToolWindowDescriptor {
        private final Project myProject;

        RunDashboardContributorViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(0);
            }
            super("Run Dashboard", AllIcons.Actions.Execute);
            this.myProject = project;
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        public DataProvider getDataProvider() {
            return id -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id) ? new RunDashboardServiceViewDeleteProvider() : TREE_EXPANDER_HIDE_PROVIDER.getData(id);
        }

        @NotNull
        public JComponent getContentComponent() {
            JComponent jComponent = RunDashboardUiManagerImpl.getInstance(this.myProject).getEmptyContent();
            if (jComponent == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = AllIcons.Toolwindows.ToolWindowRun;
            if (icon == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(3);
            }
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String title;
            String string = title = this.getToolWindowId();
            if (string == null) {
                RunDashboardContributorViewDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isExclusionAllowed() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardContributorViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor,
    ServiceViewDnDDescriptor,
    UiDataProvider {
        private final FrontendRunConfigurationNode myNode;

        RunConfigurationServiceViewDescriptor(FrontendRunConfigurationNode node) {
            this.myNode = node;
        }

        public String getId() {
            return this.myNode.getService().getServiceViewId();
        }

        public JComponent getContentComponent() {
            Project project = this.myNode.getProject();
            RunDashboardUiManagerImpl uiManager = RunDashboardUiManagerImpl.getInstance(project);
            RunDashboardComponentWrapper wrapper = uiManager.getContentWrapper();
            Content content = this.myNode.getContent();
            if (content == null || content.getManager() != uiManager.getDashboardContentManager()) {
                wrapper.setContent(uiManager.getEmptyContent());
            } else {
                ContentManager contentManager = content.getManager();
                if (contentManager == null) {
                    return null;
                }
                wrapper.setContent(contentManager.getComponent());
            }
            return wrapper;
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content = this.myNode.getContent();
            if (content != null) {
                return new PresentationData(content.getDisplayName(), null, content.getIcon(), null);
            }
            RunDashboardServiceDto service = this.myNode.getService();
            IconId iconId = service.getIconId();
            Icon icon = iconId == null ? null : IconIdKt.icon((IconId)iconId);
            return new PresentationData(service.getName(), null, icon, null);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(this.myNode.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myNode.getPresentation();
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public DataProvider getDataProvider() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return TREE_EXPANDER_HIDE_PROVIDER;
            }
            DataProvider componentProvider = DataManagerImpl.getDataProviderEx((Object)content.getComponent());
            return id -> {
                Object data = TREE_EXPANDER_HIDE_PROVIDER.getData(id);
                if (data != null) {
                    return data;
                }
                return componentProvider == null ? null : componentProvider.getData(id);
            };
        }

        public void onNodeSelected(List<Object> selectedServices) {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            RunDashboardUiManager.getInstance((Project)this.myNode.getProject()).setSelectedContent(content);
        }

        public void onNodeUnselected() {
            Content content = this.myNode.getContent();
            if (content == null) {
                return;
            }
            RunDashboardUiManager.getInstance((Project)this.myNode.getProject()).removeFromSelection(content);
        }

        public Navigatable getNavigatable() {
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    RunDashboardServiceViewContributorHelper.scheduleNavigateToService(myNode.getProject(), (FrontendRunDashboardService)myNode.getValue(), requestFocus);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return this.canNavigate();
                }
            };
        }

        @Nullable
        public Object getPresentationTag(Object fragment) {
            if (fragment instanceof String) {
                String stringFragment = (String)fragment;
                RunDashboardServiceId uuid = ((FrontendRunDashboardService)this.myNode.getValue()).getRunDashboardServiceDto().getUuid();
                ServiceCustomizationDto customization = FrontendRunDashboardManager.getInstance(this.myNode.getProject()).getCustomizationById(uuid);
                if (customization == null) {
                    return null;
                }
                CustomLinkDto tagDto = (CustomLinkDto)ContainerUtil.find(customization.getLinks(), it -> it.getPresentableText().equals(stringFragment));
                if (tagDto == null) {
                    return null;
                }
                return () -> RunDashboardServiceViewContributorHelper.scheduleNodeLinkNavigation(this.myNode.getProject(), tagDto.getPresentableText(), this.myNode);
            }
            return null;
        }

        @Nullable
        public Runnable getRemover() {
            if (((FrontendRunDashboardService)this.myNode.getValue()).getRunDashboardServiceDto().isRemovable()) {
                return () -> RunDashboardServiceViewContributorHelper.scheduleRemoveService(this.myNode.getProject(), (FrontendRunDashboardService)this.myNode.getValue());
            }
            return null;
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                return RunDashboardServiceViewContributor.getRunConfigurationNode(event, this.myNode.getProject()) != null;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project;
            FrontendRunConfigurationNode node;
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(3);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(4);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO && (node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project = this.myNode.getProject())) != null) {
                this.reorderConfigurations(project, node, position);
            }
        }

        private void reorderConfigurations(Project project, FrontendRunConfigurationNode node, ServiceViewDnDDescriptor.Position position) {
            RunDashboardServiceViewContributorHelper.scheduleReorderConfigurations(project, this.myNode, node, position);
        }

        public boolean isVisible() {
            RunDashboardStatusFilter statusFilter = FrontendRunDashboardManager.getInstance(this.myNode.getProject()).getStatusFilter();
            return statusFilter.isVisible(this.myNode);
        }

        public boolean handleDoubleClick(@NotNull MouseEvent event) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(5);
            }
            if (!RunDashboardDoubleClickRunAction.Companion.isDoubleClickRunEnabled$intellij_platform_execution_dashboard()) {
                return super.handleDoubleClick(event);
            }
            RunDashboardServiceViewContributorHelper.scheduleRerunConfiguration(this.myNode.getProject(), (FrontendRunDashboardService)this.myNode.getValue());
            return true;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(6);
            }
            sink.set(RunDashboardServiceIdKt.SELECTED_DASHBOARD_SERVICE_ID, (Object)((FrontendRunDashboardService)this.myNode.getValue()).getRunDashboardServiceDto().getUuid());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDrop";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleDoubleClick";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class RunDashboardFolderGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor
    implements ServiceViewDnDDescriptor {
        RunDashboardFolderGroupViewDescriptor(GroupingNode node) {
            super(node);
        }

        @Override
        public Runnable getRemover() {
            return () -> RunDashboardServiceViewContributorHelper.scheduleRemoveFolderGroup(this.myNode.getProject(), ((RunDashboardGroup)((Pair)this.myNode.getValue()).second).getName());
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return position == ServiceViewDnDDescriptor.Position.INTO && RunDashboardServiceViewContributor.getRunConfigurationNode(event, ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject()) != null;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project;
            FrontendRunConfigurationNode node;
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(3);
            }
            if ((node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject())) == null) {
                return;
            }
            RunDashboardServiceViewContributorHelper.scheduleDropRunConfigurationNodeOnFolderNode(project, (FrontendRunDashboardService)node.getValue(), this.myGroup);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardFolderGroupViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDashboardTypeGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor {
        private final ConfigurationType myType;

        RunDashboardTypeGroupViewDescriptor(GroupingNode node, ConfigurationType type) {
            super(node);
            this.myType = type;
        }

        public void onNodeSelected(List<Object> selectedServices) {
            RunDashboardUiManagerImpl.getInstance(this.myNode.getProject()).getTypeContent().setType(this.myType);
        }

        public void onNodeUnselected() {
            RunDashboardUiManagerImpl.getInstance(this.myNode.getProject()).getTypeContent().setType(null);
        }

        @Override
        @NotNull
        public JComponent getContentComponent() {
            RunDashboardTypePanel runDashboardTypePanel = RunDashboardUiManagerImpl.getInstance(this.myNode.getProject()).getTypeContent();
            if (runDashboardTypePanel == null) {
                RunDashboardTypeGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return runDashboardTypePanel;
        }

        @Override
        @Nullable
        public DataProvider getDataProvider() {
            return dataId -> {
                if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                    RunDashboardTypePanel typeContent = RunDashboardUiManagerImpl.getInstance(this.myNode.getProject()).getTypeContent();
                    return typeContent.getTreeExpander();
                }
                return TREE_EXPANDER_HIDE_PROVIDER.getData(dataId);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardTypeGroupViewDescriptor", "getContentComponent"));
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        protected final RunDashboardGroup myGroup;
        protected final GroupingNode myNode;
        private final PresentationData myPresentationData;

        protected RunDashboardGroupViewDescriptor(GroupingNode node) {
            this.myNode = node;
            this.myGroup = node.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myPresentationData;
            if (presentationData == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public int getWeight() {
            Object value = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value instanceof WeighedItem) {
                return ((WeighedItem)value).getWeight();
            }
            return 0;
        }

        @Nullable
        public Runnable getRemover() {
            ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)this.myGroup).getValue(), ConfigurationType.class);
            if (type != null) {
                return () -> {
                    RunDashboardManager runDashboardManager = RunDashboardManagerProxy.getInstance((Project)this.myNode.getProject());
                    HashSet types = new HashSet(runDashboardManager.getTypes());
                    types.remove(type.getId());
                    runDashboardManager.setTypes(types);
                };
            }
            return null;
        }

        @NotNull
        public JComponent getContentComponent() {
            JComponent jComponent = RunDashboardUiManagerImpl.getInstance(this.myNode.getProject()).getEmptyContent();
            if (jComponent == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        private static String getId(GroupingNode node) {
            AbstractTreeNode parent = node.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node.getGroup());
        }

        private static String getId(RunDashboardGroup group) {
            Object value;
            if (group instanceof RunDashboardGroupImpl && (value = ((RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value).getId();
            }
            return group.getName();
        }

        @Nullable
        public DataProvider getDataProvider() {
            return TREE_EXPANDER_HIDE_PROVIDER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/platform/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardGroupViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

