/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.Discovery;
import io.kubernetes.client.apimachinery.GroupVersionKind;
import io.kubernetes.client.apimachinery.GroupVersionResource;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.Strings;
import io.kubernetes.client.util.Yaml;
import io.kubernetes.client.util.exception.IncompleteDiscoveryException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMapper {
    private static final Logger logger = LoggerFactory.getLogger(ModelMapper.class);
    public static final Duration DEFAULT_DISCOVERY_REFRESH_INTERVAL = Duration.ofMinutes(30L);
    private static Map<GroupVersionKind, Class<?>> preBuiltClassesByGVK = new HashMap();
    private static Map<String, String> preBuiltApiGroups = new HashMap<String, String>();
    private static List<String> preBuiltApiVersions = new ArrayList<String>();
    private static BiDirectionalMap<GroupVersionKind, Class<?>> classesByGVK = new BiDirectionalMap();
    private static BiDirectionalMap<GroupVersionResource, Class<?>> classesByGVR = new BiDirectionalMap();
    private static Map<Class<?>, Boolean> isNamespacedByClasses = new ConcurrentHashMap();
    private static Set<Discovery.APIResource> lastAPIDiscovery = new HashSet<Discovery.APIResource>();
    private static volatile long nextDiscoveryRefreshTimeMillis = 0L;

    @Deprecated
    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        String[] parts = apiGroupVersion.split("/");
        if (parts.length <= 1) {
            ModelMapper.addModelMap("", apiGroupVersion, kind, clazz);
        } else {
            ModelMapper.addModelMap(parts[0], parts[1], kind, clazz);
        }
    }

    @Deprecated
    public static void addModelMap(String group, String version, String kind, Class<?> clazz) {
        ModelMapper.preBuiltAddModelMap(group, version, kind, clazz);
    }

    public static void addModelMap(String group, String version, String kind, String resourceNamePlural, Class<? extends KubernetesObject> objClass, Class<? extends KubernetesListObject> objListClass) {
        classesByGVK.add(new GroupVersionKind(group, version, kind), objClass);
        classesByGVR.add(new GroupVersionResource(group, version, resourceNamePlural), objClass);
        if (objListClass != null) {
            classesByGVK.add(new GroupVersionKind(group, version, kind + "List"), objListClass);
        }
    }

    public static void addModelMap(String group, String version, String kind, String resourceNamePlural, Boolean isNamespacedResource, Class<? extends KubernetesObject> objClass) {
        ModelMapper.addModelMap(group, version, kind, resourceNamePlural, objClass, null);
        isNamespacedByClasses.put(objClass, isNamespacedResource);
    }

    public static void addModelMap(String group, String version, String kind, String resourceNamePlural, Boolean isNamespacedResource, Class<? extends KubernetesObject> objClass, Class<? extends KubernetesListObject> objListClass) {
        ModelMapper.addModelMap(group, version, kind, resourceNamePlural, objClass, objListClass);
        isNamespacedByClasses.put(objClass, isNamespacedResource);
    }

    public static Class<?> getApiTypeClass(String apiGroupVersion, String kind) {
        String apiVersion;
        String apiGroup;
        String[] parts = apiGroupVersion.split("/");
        if (parts.length == 1) {
            apiGroup = "";
            apiVersion = apiGroupVersion;
        } else {
            apiGroup = parts[0];
            apiVersion = parts[1];
        }
        return ModelMapper.getApiTypeClass(apiGroup, apiVersion, kind);
    }

    public static Class<?> getApiTypeClass(String group, String version, String kind) {
        Class<?> clazz = classesByGVK.getByK(new GroupVersionKind(group, version, kind));
        if (clazz != null) {
            return clazz;
        }
        return ModelMapper.preBuiltGetApiTypeClass(group, version, kind);
    }

    public static GroupVersionKind getGroupVersionKindByClass(Class<?> clazz) {
        return classesByGVK.getByV(clazz);
    }

    public static GroupVersionResource getGroupVersionResourceByClass(Class<?> clazz) {
        return classesByGVR.getByV(clazz);
    }

    public static Set<Discovery.APIResource> refresh(Discovery discovery) throws ApiException {
        return ModelMapper.refresh(discovery, DEFAULT_DISCOVERY_REFRESH_INTERVAL);
    }

    public static Set<Discovery.APIResource> refresh(Discovery discovery, Duration refreshInterval) throws ApiException {
        long nowMillis = System.currentTimeMillis();
        if (nowMillis < nextDiscoveryRefreshTimeMillis) {
            return lastAPIDiscovery;
        }
        Set<Discovery.APIResource> apiResources = null;
        try {
            apiResources = discovery.findAll();
        }
        catch (IncompleteDiscoveryException e) {
            logger.warn("Error while getting all api resources, some api resources will not be refreshed", (Throwable)e);
            apiResources = e.getDiscoveredResources();
        }
        for (Discovery.APIResource apiResource : apiResources) {
            for (String version : apiResource.getVersions()) {
                Class<?> objClass = ModelMapper.getApiTypeClass(apiResource.getGroup(), version, apiResource.getKind());
                if (objClass == null) continue;
                Class<?> objListClass = ModelMapper.getApiTypeClass(apiResource.getGroup(), version, apiResource.getKind() + "List");
                ModelMapper.addModelMap(apiResource.getGroup(), version, apiResource.getKind(), apiResource.getResourcePlural(), apiResource.getNamespaced(), objClass, objListClass);
            }
        }
        lastAPIDiscovery = apiResources;
        nextDiscoveryRefreshTimeMillis = refreshInterval.toMillis() + nowMillis;
        return lastAPIDiscovery;
    }

    public static boolean isApiDiscoveryRefreshed() {
        return nextDiscoveryRefreshTimeMillis != 0L;
    }

    static void preBuiltAddModelMap(String group, String version, String kind, Class<?> clazz) {
        preBuiltClassesByGVK.put(new GroupVersionKind(group, version, kind), clazz);
    }

    public static Class<?> preBuiltGetApiTypeClass(String group, String version, String kind) {
        Class<?> clazz = preBuiltClassesByGVK.get(new GroupVersionKind(group, version, kind));
        if (clazz != null) {
            return clazz;
        }
        return preBuiltClassesByGVK.get(new GroupVersionKind("", version, kind));
    }

    public static Optional<GroupVersionKind> preBuiltGetGroupVersionKindByClass(Class<?> clazz) {
        return preBuiltClassesByGVK.entrySet().stream().filter(e -> clazz.equals(e.getValue())).map(Map.Entry::getKey).findFirst();
    }

    public static Boolean isNamespaced(Class<?> clazz) {
        return isNamespacedByClasses.get(clazz);
    }

    public static GroupVersionKind groupVersionKindFromApiVersionAndKind(String apiVersion, String kind) {
        int ix = apiVersion.indexOf("/");
        String group = ix == -1 ? "" : apiVersion.substring(0, ix);
        String version = apiVersion.substring(ix + 1);
        return new GroupVersionKind(group, version, kind);
    }

    public static Discovery.APIResource findApiResourceByGroupVersionKind(GroupVersionKind gvk) {
        HashMap<String, Discovery.APIResource> apiResourcesByKey = new HashMap<String, Discovery.APIResource>();
        for (Discovery.APIResource apiResource : lastAPIDiscovery) {
            for (String version : apiResource.getVersions()) {
                String key = apiResource.getKind() + "/" + apiResource.getGroup() + "/" + version;
                apiResourcesByKey.put(key, apiResource);
            }
        }
        String key = gvk.getKind() + "/" + gvk.getGroup() + "/" + gvk.getVersion();
        return (Discovery.APIResource)apiResourcesByKey.get(key);
    }

    private static void initApiGroupMap() {
        preBuiltApiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        preBuiltApiGroups.put("Apiextensions", "apiextensions.k8s.io");
        preBuiltApiGroups.put("Apiregistration", "apiregistration.k8s.io");
        preBuiltApiGroups.put("Apps", "apps");
        preBuiltApiGroups.put("Authentication", "authentication.k8s.io");
        preBuiltApiGroups.put("Authorization", "authorization.k8s.io");
        preBuiltApiGroups.put("Autoscaling", "autoscaling");
        preBuiltApiGroups.put("Batch", "batch");
        preBuiltApiGroups.put("Certificates", "certificates.k8s.io");
        preBuiltApiGroups.put("Core", "");
        preBuiltApiGroups.put("Extensions", "extensions");
        preBuiltApiGroups.put("Events", "events.k8s.io");
        preBuiltApiGroups.put("FlowControl", "flowcontrol.apiserver.k8s.io");
        preBuiltApiGroups.put("Networking", "networking.k8s.io");
        preBuiltApiGroups.put("Policy", "policy");
        preBuiltApiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        preBuiltApiGroups.put("Scheduling", "scheduling.k8s.io");
        preBuiltApiGroups.put("Settings", "settings.k8s.io");
        preBuiltApiGroups.put("Storage", "storage.k8s.io");
    }

    private static void initApiVersionList() {
        preBuiltApiVersions.add("V2beta1");
        preBuiltApiVersions.add("V2beta2");
        preBuiltApiVersions.add("V2alpha1");
        preBuiltApiVersions.add("V1beta2");
        preBuiltApiVersions.add("V1beta1");
        preBuiltApiVersions.add("V1alpha1");
        preBuiltApiVersions.add("V1");
        preBuiltApiVersions.add("V2");
    }

    private static void initModelMap() throws IOException {
        ModelMapper.initApiGroupMap();
        ModelMapper.initApiVersionList();
        for (String classInfo : ModelMapper.getClassNamesFromPackage(Yaml.class.getClassLoader(), "io.kubernetes.client.openapi.models")) {
            Class<?> clazz = ModelMapper.loadClass(classInfo, Yaml.class.getClassLoader());
            if (!KubernetesObject.class.isAssignableFrom(clazz) && !KubernetesListObject.class.isAssignableFrom(clazz)) continue;
            Pair<String, String> groupAndOther = ModelMapper.getApiGroup(clazz.getSimpleName());
            Pair<String, String> versionAndOther = ModelMapper.getApiVersion((String)groupAndOther.getRight());
            String group = Strings.nullToEmpty((String)groupAndOther.getLeft());
            String version = (String)versionAndOther.getLeft();
            String kind = (String)versionAndOther.getRight();
            preBuiltClassesByGVK.put(new GroupVersionKind(group, version, kind), clazz);
        }
        if (preBuiltClassesByGVK.size() == 0) {
            logger.warn("No kubernetes api model classes found from classloader, this may break automatic api discovery");
        }
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) {
        try {
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Pair<String, String> getApiGroup(String name) {
        return (Pair)preBuiltApiGroups.entrySet().stream().filter(e -> name.startsWith((String)e.getKey())).map(e -> new ImmutablePair((Object)((String)e.getValue()), (Object)name.substring(((String)e.getKey()).length()))).findFirst().orElse(new ImmutablePair(null, (Object)name));
    }

    private static Pair<String, String> getApiVersion(String name) {
        return (Pair)preBuiltApiVersions.stream().filter(v -> name.startsWith((String)v)).map(v -> new ImmutablePair((Object)v.toLowerCase(), (Object)name.substring(v.length()))).findFirst().orElse(new ImmutablePair(null, (Object)name));
    }

    private static List<String> getClassNamesFromPackage(ClassLoader classLoader, String pkg) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        String packageName = pkg.replace(".", "/");
        URL packageURL = classLoader.getResource(packageName);
        if (packageURL.getProtocol().equals("jar")) {
            ModelMapper.processJarPackage(packageURL, packageName, pkg, names);
        } else {
            ModelMapper.processFilePackage(packageURL, pkg, names);
        }
        return names;
    }

    private static void processJarPackage(URL packageURL, String packageName, String pkg, ArrayList<String> names) throws IOException {
        String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
        jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
        logger.info("Loading classes from jar {}", (Object)jarFileName);
        try (JarFile jf = new JarFile(jarFileName);){
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                ModelMapper.processJarEntry(jarEntries.nextElement(), packageName, pkg, names);
            }
        }
    }

    private static void processJarEntry(JarEntry jarEntry, String packageName, String pkg, ArrayList<String> names) {
        String entryName = jarEntry.getName();
        if (entryName.startsWith(packageName) && entryName.length() > packageName.length() + 5) {
            entryName = entryName.substring(packageName.length() + 1, entryName.lastIndexOf(46));
            names.add(pkg + "." + entryName);
        }
    }

    private static void processFilePackage(URL packageURL, String pkg, ArrayList<String> names) {
        URI uri = URI.create(packageURL.toString());
        File folder = new File(uri.getPath());
        File[] contenuti = folder.listFiles();
        if (contenuti == null) {
            logger.warn("No files to load found in {}", (Object)folder.getPath());
            return;
        }
        for (File actual : contenuti) {
            ModelMapper.processFileEntry(actual, pkg, names);
        }
    }

    private static void processFileEntry(File actual, String pkg, ArrayList<String> names) {
        String entryName = actual.getName();
        entryName = entryName.substring(0, entryName.lastIndexOf(46));
        names.add(pkg + "." + entryName);
    }

    static {
        try {
            ModelMapper.initModelMap();
        }
        catch (Exception ex) {
            logger.error("Unexpected exception while loading classes", (Throwable)ex);
        }
    }

    static class BiDirectionalMap<K, V> {
        private Map<K, V> kvMap = new ConcurrentHashMap();
        private Map<V, K> vkMap = new ConcurrentHashMap<V, K>();

        BiDirectionalMap() {
        }

        void add(K k, V v) {
            this.kvMap.put(k, v);
            this.vkMap.put(v, k);
        }

        V getByK(K k) {
            return this.kvMap.get(k);
        }

        K getByV(V v) {
            return this.vkMap.get(v);
        }
    }
}

