/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.ui.StudioMigPanel;
import com.intellij.liquibase.common.config.ChangelogDiffType;
import com.intellij.liquibase.common.gui.DiffChangeLogCreationDialog;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/liquibase/common/gui/GenerateDdlFromConsoleDialog;", "Lcom/intellij/liquibase/common/gui/DiffChangeLogCreationDialog;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "getSourceDiffType", "Lcom/intellij/liquibase/common/config/ChangelogDiffType;", "getTargetDiffType", "TargetDbActionListener", "intellij.liquibase.common"})
public final class GenerateDdlFromConsoleDialog
extends DiffChangeLogCreationDialog {
    @NotNull
    private final Project project;

    public GenerateDdlFromConsoleDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.setTitle(JpaModelBundle.message((String)"generate.ddl.by.entities", (Object[])new Object[0]));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JEditorPane jEditorPane;
        CC labelConstraints = new CC();
        CC fieldConstraints = new CC().growX().width("100%").wrap();
        CC separatorConstraints = new CC().spanX().growX();
        AC aC = new AC().index(0).grow().size("50%").index(2).grow();
        Intrinsics.checkNotNullExpressionValue((Object)aC, (String)"grow(...)");
        StudioMigPanel mainPanel = new StudioMigPanel(null, aC, null, 5, null);
        JEditorPane $this$createCenterPanel_u24lambda_u240 = jEditorPane = new JEditorPane();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        $this$createCenterPanel_u24lambda_u240.setEditable(false);
        $this$createCenterPanel_u24lambda_u240.setOpaque(false);
        $this$createCenterPanel_u24lambda_u240.setBorder(null);
        $this$createCenterPanel_u24lambda_u240.setMargin((Insets)JBUI.emptyInsets());
        $this$createCenterPanel_u24lambda_u240.setText(LiquibaseResourceBundle.message("db.not.synchronized", new Object[0]));
        JEditorPane editorPane = jEditorPane;
        this.initDbField(this.getTargetDbField());
        this.getSourceModelField().init();
        mainPanel.add((Component)editorPane, (Object)separatorConstraints);
        mainPanel.add((Component)new TitledSeparator(JpaModelBundle.messageWithColon((String)"entities", (Object[])new Object[0])), (Object)separatorConstraints);
        mainPanel.add((Component)new JBLabel(JpaModelBundle.messageWithColon((String)"EntityPropertiesPanel.persistenceUnit", (Object[])new Object[0])), (Object)labelConstraints);
        mainPanel.add((Component)((Object)this.getSourceModelField()), (Object)fieldConstraints);
        mainPanel.add((Component)new JBLabel(JpaModelBundle.messageWithColon((String)"source.scope", (Object[])new Object[0])), (Object)labelConstraints);
        mainPanel.add((Component)((Object)this.getDiffScopeComboBox()), (Object)fieldConstraints);
        mainPanel.add((Component)new TitledSeparator(JpaModelBundle.messageWithColon((String)"database", (Object[])new Object[0])), (Object)separatorConstraints);
        mainPanel.add((Component)new JBLabel(JpaModelBundle.messageWithColon((String)"db.connection", (Object[])new Object[0])), (Object)labelConstraints);
        mainPanel.add((Component)this.getTargetDbField(), (Object)fieldConstraints);
        TargetDbActionListener targetDbActionListener = new TargetDbActionListener();
        this.getTargetDbField().getField().addActionListener((ActionListener)targetDbActionListener);
        mainPanel.add((Component)new JBLabel(), (Object)labelConstraints);
        mainPanel.add((Component)this.getDefaultDbConnectionCheckBox(), (Object)fieldConstraints);
        this.applySettingsValues();
        return (JComponent)mainPanel;
    }

    @Override
    @NotNull
    public ChangelogDiffType getSourceDiffType() {
        return ChangelogDiffType.MODEL;
    }

    @Override
    @NotNull
    public ChangelogDiffType getTargetDiffType() {
        return ChangelogDiffType.DB;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/gui/GenerateDdlFromConsoleDialog$TargetDbActionListener;", "Ljava/awt/event/ActionListener;", "<init>", "(Lcom/intellij/liquibase/common/gui/GenerateDdlFromConsoleDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.liquibase.common"})
    public final class TargetDbActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            String persistenceUnitName;
            if (!GenerateDdlFromConsoleDialog.this.getDefaultDbConnectionCheckBox().isVisible()) {
                return;
            }
            AbstractRdbmsStore targetDbValue = GenerateDdlFromConsoleDialog.this.getTargetDbValue();
            OrmUnit ormUnit = GenerateDdlFromConsoleDialog.this.getPersistenceUnit();
            String string = persistenceUnitName = ormUnit != null ? ormUnit.getName() : null;
            if (persistenceUnitName == null || targetDbValue == null) {
                GenerateDdlFromConsoleDialog.this.getDefaultDbConnectionCheckBox().setSelected(false);
                return;
            }
            String dbConnectionId = GenerateDdlFromConsoleDialog.this.getDataSourceConfig().findDbConnectionIdByPersistenceUnitName(persistenceUnitName);
            GenerateDdlFromConsoleDialog.this.getDefaultDbConnectionCheckBox().setSelected(Intrinsics.areEqual((Object)dbConnectionId, (Object)targetDbValue.getId()));
        }
    }
}

