/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.presentation.ChangeOnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.InlayButtonPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.kubernetes.ContainerPortInlayCollector;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.KubernetesInlayHintsService;
import com.intellij.kubernetes.KubernetesPortForwardingInlayProviderKt;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.database.DatabaseCredentials;
import com.intellij.kubernetes.database.KubernetesCredentialExtractor;
import com.intellij.kubernetes.database.KubernetesDatabaseIntegration;
import com.intellij.kubernetes.database.KubernetesDatabaseTypes;
import com.intellij.kubernetes.database.KubernetesPortForwardingDataSourceConfig;
import com.intellij.kubernetes.database.KubernetesPortForwardingDatabaseType;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.view.execution.KubernetesObjectInfo;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingServiceKt;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.kubernetes.view.execution.PortForwardingUtils;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JH\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010$\u001a\u00020\u0006H\u0002JP\u0010(\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020'H\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0002J0\u0010-\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0\u001f2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001f\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010/J@\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00102\u001a\u00020 2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u00104\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0015H\u0002J*\u00105\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\"H\u0002J,\u00109\u001a\u00020#2\u0006\u00108\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006:"}, d2={"Lcom/intellij/kubernetes/ContainerPortInlayCollector;", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "<init>", "()V", "getCachedKubernetesObject", "Lkotlinx/coroutines/Deferred;", "Lio/kubernetes/client/common/KubernetesObject;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "project", "Lcom/intellij/openapi/project/Project;", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isValidElement", "isUnderEphemeralContainers", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "findActivePortForwarding", "Lcom/intellij/kubernetes/view/execution/PortForwardingProcess;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "objectInfo", "Lcom/intellij/kubernetes/view/execution/KubernetesObjectInfo;", "portValue", "", "determineActiveForwardingHint", "Lkotlin/Pair;", "", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "kubernetesObject", "activeForwarding", "detectDatabaseImage", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDatabaseType;", "createDatabaseDataSourceHint", "detectedDbType", "createDatabaseDataSource", "dataSourceConfig", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDataSourceConfig;", "createOpenInBrowserHint", "findLocalPort", "(Lcom/intellij/kubernetes/view/execution/PortForwardingProcess;I)Ljava/lang/Integer;", "addInlayPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "hintText", "hintAction", "isSupportedMetatype", "createAndShowPopup", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "e", "showContextMenu", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingInlayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/ContainerPortInlayCollector\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,544:1\n66#2,2:545\n66#2,2:553\n295#3,2:547\n2746#3,3:550\n774#3:555\n865#3,2:556\n295#3:558\n1761#3,3:559\n296#3:562\n19#4:549\n30#5,2:563\n13#6:565\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/ContainerPortInlayCollector\n*L\n148#1:545,2\n214#1:553,2\n156#1:547,2\n212#1:550,3\n235#1:555\n235#1:556,2\n237#1:558\n238#1:559,3\n237#1:562\n211#1:549\n118#1:563,2\n323#1:565\n*E\n"})
final class ContainerPortInlayCollector
implements InlayHintsCollector {
    private final Deferred<KubernetesObject> getCachedKubernetesObject(YAMLDocument document, Project project) {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)document, () -> ContainerPortInlayCollector.getCachedKubernetesObject$lambda$0(project, document));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Deferred)object;
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        PortForwardingProcess portForwardingProcess;
        KubernetesApiModelInterface apiModel2;
        Object v6;
        KubernetesObject kubernetesObjectFromCache;
        int portValue;
        Project project;
        YAMLScalar value;
        block10: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!this.isValidElement(element)) {
                return true;
            }
            YAMLValue yAMLValue = ((YAMLKeyValue)element).getValue();
            Intrinsics.checkNotNull((Object)yAMLValue, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLScalar");
            value = (YAMLScalar)yAMLValue;
            Project project2 = editor.getProject();
            if (project2 == null) {
                return true;
            }
            project = project2;
            String string = value.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return true;
            }
            portValue = n;
            KubernetesApiProviderInterface kubernetesApi = KubernetesApiProvider.Companion.getInstance(project);
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            YAMLDocument yAMLDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLDocument.class, (boolean)true);
            if (yAMLDocument == null) {
                return true;
            }
            YAMLDocument document = yAMLDocument;
            Deferred<KubernetesObject> cacheData = this.getCachedKubernetesObject(document, project);
            if (!cacheData.isCompleted()) {
                return true;
            }
            KubernetesObject kubernetesObject = (KubernetesObject)cacheData.getCompleted();
            if (kubernetesObject == null) {
                return true;
            }
            kubernetesObjectFromCache = kubernetesObject;
            Iterable $this$firstOrNull$iv = kubernetesApi.getApiModels();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KubernetesApiModelInterface it = (KubernetesApiModelInterface)element$iv;
                boolean bl = false;
                if (!it.isSelectedAsCurrentCluster()) continue;
                v6 = element$iv;
                break block10;
            }
            v6 = null;
        }
        KubernetesApiModelInterface kubernetesApiModelInterface = apiModel2 = (KubernetesApiModelInterface)v6;
        if (kubernetesApiModelInterface != null) {
            KubernetesApiModelInterface api = kubernetesApiModelInterface;
            boolean bl = false;
            String string = kubernetesObjectFromCache.getKind();
            Intrinsics.checkNotNull((Object)string);
            String kind = string;
            KubernetesEntity kubernetesEntity = KubernetesEntity.Companion.findByKind(kind);
            Intrinsics.checkNotNull((Object)kubernetesEntity);
            KubernetesEntity entity = kubernetesEntity;
            String string2 = kubernetesObjectFromCache.getMetadata().getName();
            Intrinsics.checkNotNull((Object)string2);
            String name = string2;
            Object object = kubernetesObjectFromCache.getMetadata();
            if (object == null || (object = object.getNamespace()) == null) {
                object = api.getNamespace();
            }
            Object namespace = object;
            portForwardingProcess = this.findActivePortForwarding(api, new KubernetesObjectInfo(entity, (String)namespace, name), portValue);
        } else {
            portForwardingProcess = null;
        }
        PortForwardingProcess activeForwarding = portForwardingProcess;
        Pair pair = apiModel2 == null ? TuplesKt.to((Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.title", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.collect$lambda$2(project, this, editor, arg_0)) : (activeForwarding != null ? this.determineActiveForwardingHint(editor, kubernetesObjectFromCache, apiModel2, activeForwarding, portValue) : TuplesKt.to((Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.title", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.collect$lambda$3(kubernetesObjectFromCache, apiModel2, arg_0)));
        String hintText = (String)pair.component1();
        Function1 hintAction = (Function1)pair.component2();
        InlayPresentation referencePresentation = this.addInlayPresentation(editor, hintText, (Function1<? super MouseEvent, Unit>)hintAction, apiModel2, activeForwarding);
        sink.addInlineElement(value.getTextRange().getEndOffset(), true, referencePresentation, true);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isValidElement(PsiElement element) {
        block10: {
            if (!(element instanceof YAMLKeyValue)) {
                return false;
            }
            var4_2 = ((YAMLKeyValue)element).getValue();
            v0 = var4_2 instanceof YAMLScalar != false ? (YAMLScalar)var4_2 : null;
            if (v0 == null) {
                return false;
            }
            value = v0;
            if (!this.isSupportedMetatype((YAMLKeyValue)element)) {
                return false;
            }
            v1 = YamlUtilKt.getTopLevelMapping((PsiElement)element);
            if (v1 == null || (v1 = YamlUtilKt.get((YAMLMapping)v1, (String)"kind")) == null) ** GOTO lbl-1000
            $this$asSafely$iv = v1;
            $i$f$asSafely = false;
            v2 = $this$asSafely$iv;
            if (!(v2 instanceof YAMLScalar)) {
                v2 = null;
            }
            if ((v1 = (YAMLScalar)v2) != null) {
                v3 = v1.getTextValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            kind = v3;
            $this$none$iv = PortForwardingUtils.INSTANCE.getSupportedEntities();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v4 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (KubernetesEntity)element$iv;
                    $i$a$-none-ContainerPortInlayCollector$isValidElement$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getKind(), (Object)kind)) continue;
                    v4 = false;
                    break block10;
                }
                v4 = true;
            }
        }
        if (v4) {
            return false;
        }
        $this$parentOfType_u24default$iv = (PsiElement)value;
        withSelf$iv = false;
        $i$f$parentOfType = false;
        v5 = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLMapping.class, (boolean)true);
        var6_10 = v5 != null ? YamlUtilKt.get((YAMLMapping)v5, (String)"protocol") : null;
        v6 = var6_10 instanceof YAMLScalar != false ? (YAMLScalar)var6_10 : null;
        v7 = protocol = v6 != null ? v6.getTextValue() : null;
        return (v7 != null ? !StringsKt.equals((String)v7, (String)"TCP", (boolean)true) : false) == false;
    }

    private final boolean isUnderEphemeralContainers(YAMLKeyValue element) {
        for (PsiElement current = element.getParent(); current != null; current = current.getParent()) {
            YAMLKeyValue kv;
            PsiElement psiElement = current;
            YAMLKeyValue yAMLKeyValue = kv = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
            if (kv == null || !Intrinsics.areEqual((Object)kv.getKeyText(), (Object)"ephemeralContainers")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final PortForwardingProcess findActivePortForwarding(KubernetesApiModelInterface apiModel2, KubernetesObjectInfo objectInfo, int portValue) {
        Object v3;
        block8: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            KubernetesPortForwardingService portForwardingService = KubernetesPortForwardingService.Companion.getInstance();
            Iterable iterable = portForwardingService.getPortForwardingProcesses(apiModel2);
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PortForwardingProcess it = (PortForwardingProcess)element$iv$iv;
                boolean bl = false;
                if (!(KubernetesPortForwardingServiceKt.isActive((PortForwardingProcess)it) && Intrinsics.areEqual((Object)it.getPortForwarding().getObjectInfo(), (Object)objectInfo))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List activeForwardings = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = activeForwardings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block7: {
                    PortForwardingProcess forwarding = (PortForwardingProcess)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = forwarding.getPortForwarding().getMappings();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            boolean bl3;
                            String mapping = (String)element$iv2;
                            boolean bl4 = false;
                            String[] stringArray = new String[]{":"};
                            List parts = StringsKt.split$default((CharSequence)mapping, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                            if (parts.size() == 2 && !Intrinsics.areEqual(parts.get(0), (Object)"")) {
                                Integer remotePort;
                                Integer n = remotePort = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                                int n2 = portValue;
                                bl3 = n != null && n == n2;
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        return v3;
    }

    private final Pair<String, Function1<MouseEvent, Unit>> determineActiveForwardingHint(Editor editor, KubernetesObject kubernetesObject, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding, int portValue) {
        Pair<String, Function1<MouseEvent, Unit>> pair;
        KubernetesPortForwardingDatabaseType detectedDatabaseImage = this.detectDatabaseImage(kubernetesObject);
        if (detectedDatabaseImage != null) {
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            pair = this.createDatabaseDataSourceHint(project, kubernetesObject, apiModel2, activeForwarding, portValue, detectedDatabaseImage);
        } else {
            pair = this.createOpenInBrowserHint(activeForwarding, portValue);
        }
        return pair;
    }

    private final KubernetesPortForwardingDatabaseType detectDatabaseImage(KubernetesObject kubernetesObject) {
        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType;
        block30: {
            KubernetesObject kubernetesObject2 = kubernetesObject;
            if (kubernetesObject2 instanceof V1Pod) {
                Object object = ((V1Pod)kubernetesObject).getSpec();
                if (object != null && (object = object.getContainers()) != null) {
                    for (V1Container container : (Iterable)object) {
                        boolean bl = false;
                        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType2 = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage());
                        if (kubernetesPortForwardingDatabaseType2 == null) continue;
                        kubernetesPortForwardingDatabaseType = kubernetesPortForwardingDatabaseType2;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1Deployment) {
                Object object = ((V1Deployment)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1ReplicaSet) {
                Object object = ((V1ReplicaSet)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1Job) {
                Object object = ((V1Job)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1DaemonSet) {
                Object object = ((V1DaemonSet)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1ReplicationController) {
                Object object = ((V1ReplicationController)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (V1Container container : (Iterable)object) {
                        boolean bl = false;
                        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType3 = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage());
                        if (kubernetesPortForwardingDatabaseType3 == null) continue;
                        kubernetesPortForwardingDatabaseType = kubernetesPortForwardingDatabaseType3;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else {
                kubernetesPortForwardingDatabaseType = null;
            }
        }
        return kubernetesPortForwardingDatabaseType;
    }

    private final Pair<String, Function1<MouseEvent, Unit>> createDatabaseDataSourceHint(Project project, KubernetesObject kubernetesObject, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding, int portValue, KubernetesPortForwardingDatabaseType detectedDbType) {
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.create.database", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TuplesKt.to((Object)string, arg_0 -> ContainerPortInlayCollector.createDatabaseDataSourceHint$lambda$0(this, activeForwarding, portValue, project, detectedDbType, kubernetesObject, apiModel2, arg_0));
    }

    private final void createDatabaseDataSource(Project project, KubernetesPortForwardingDataSourceConfig dataSourceConfig) {
        KubernetesDatabaseIntegration databaseIntegration = (KubernetesDatabaseIntegration)CollectionsKt.firstOrNull((List)KubernetesDatabaseIntegration.Companion.getEP_NAME().getExtensionList());
        if (databaseIntegration != null) {
            databaseIntegration.createDatabaseDataSource(project, dataSourceConfig);
            return;
        }
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.provider.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        String string2 = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.database.plugin.required", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        Notification notification = NotificationsKt.getKubernetesNotificationGroup().createNotification(title, message, NotificationType.WARNING);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.install.database.plugin", (Object[])new Object[0]), () -> ContainerPortInlayCollector.createDatabaseDataSource$lambda$0(project)));
        notification.notify(project);
    }

    private final Pair<String, Function1<MouseEvent, Unit>> createOpenInBrowserHint(PortForwardingProcess activeForwarding, int portValue) {
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.open.browser", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TuplesKt.to((Object)string, arg_0 -> ContainerPortInlayCollector.createOpenInBrowserHint$lambda$0(this, activeForwarding, portValue, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Integer findLocalPort(PortForwardingProcess activeForwarding, int portValue) {
        Integer n;
        Integer n2;
        Iterator iterator = ((Iterable)activeForwarding.getPortForwarding().getMappings()).iterator();
        do {
            if (!iterator.hasNext()) return null;
            String mapping = (String)iterator.next();
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)mapping, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 2) {
                Integer n3 = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                int n4 = portValue;
                if (n3 != null && n3 == n4) {
                    n = StringsKt.toIntOrNull((String)((String)parts.get(0)));
                    continue;
                }
            }
            n = null;
        } while ((n2 = n) == null);
        Integer n5 = n2;
        return n5;
    }

    private final InlayPresentation addInlayPresentation(Editor editor, String hintText, Function1<? super MouseEvent, Unit> hintAction, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding) {
        PresentationFactory factory = new PresentationFactory(editor);
        InlayButtonPresentationFactory inlayButtonPresentationFactory = new InlayButtonPresentationFactory(editor, factory, null, null, null, 28, null);
        String string = hintText;
        Icon icon = Intrinsics.areEqual((Object)string, (Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.open.browser", (Object[])new Object[0])) ? KubernetesIcons.PpWeb : (Intrinsics.areEqual((Object)string, (Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.create.database", (Object[])new Object[0])) ? KubernetesIcons.Dbms : KubernetesIcons.ForwardPorts);
        Intrinsics.checkNotNull((Object)icon);
        Icon iconToUse = icon;
        InlayPresentation defaultButton = inlayButtonPresentationFactory.iconAndText(iconToUse, hintText).build();
        InlayPresentation hoveredButton = inlayButtonPresentationFactory.iconAndText(iconToUse, hintText).buildHovered();
        ChangeOnHoverPresentation buttonWithHoverEffect = new ChangeOnHoverPresentation(defaultButton, () -> ContainerPortInlayCollector.addInlayPresentation$lambda$0(hoveredButton), null, 4, null);
        StaticDelegatePresentation rightClickSupport2 = new StaticDelegatePresentation(buttonWithHoverEffect, hintAction, this, editor, apiModel2, activeForwarding){
            final /* synthetic */ Function1<MouseEvent, Unit> $hintAction;
            final /* synthetic */ ContainerPortInlayCollector this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ KubernetesApiModelInterface $apiModel;
            final /* synthetic */ PortForwardingProcess $activeForwarding;
            {
                this.$hintAction = $hintAction;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$apiModel = $apiModel;
                this.$activeForwarding = $activeForwarding;
                super((InlayPresentation)$buttonWithHoverEffect);
            }

            public void mousePressed(MouseEvent event, Point translated) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                switch (event.getButton()) {
                    case 1: {
                        this.$hintAction.invoke((Object)event);
                        break;
                    }
                    case 3: {
                        ContainerPortInlayCollector.access$showContextMenu(this.this$0, event, this.$editor, this.$apiModel, this.$activeForwarding);
                    }
                }
            }
        };
        InlayPresentation referencePresentation = factory.referenceOnHover((InlayPresentation)rightClickSupport2, (arg_0, arg_1) -> ContainerPortInlayCollector.addInlayPresentation$lambda$1(rightClickSupport2, arg_0, arg_1));
        return referencePresentation;
    }

    private final boolean isSupportedMetatype(YAMLKeyValue element) {
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)element);
        String typeName = yamlMetaType != null ? yamlMetaType.getTypeName() : null;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy(element);
        String fieldName = metaTypeProxy != null && (metaTypeProxy = metaTypeProxy.getField()) != null ? metaTypeProxy.getName() : null;
        return Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.core.v1.ContainerPort") && Intrinsics.areEqual((Object)fieldName, (Object)"containerPort") && !this.isUnderEphemeralContainers(element) || Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.core.v1.ServicePort") && Intrinsics.areEqual((Object)fieldName, (Object)"port");
    }

    private final void createAndShowPopup(Editor editor, Project project, DefaultActionGroup actionGroup, MouseEvent e) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor).add(CommonDataKeys.PROJECT, (Object)project).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        popup.showInScreenCoordinates((Component)editor.getContentComponent(), e.getLocationOnScreen());
    }

    private final void showContextMenu(MouseEvent e, Editor editor, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding) {
        List popupActions = InlayHintsUtils.INSTANCE.getDefaultInlayHintsProviderPopupActions(KubernetesPortForwardingInlayProviderKt.access$getKEY$p(), ContainerPortInlayCollector::showContextMenu$lambda$0);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        PortForwardingProcess portForwardingProcess = activeForwarding;
        boolean bl = portForwardingProcess != null ? KubernetesPortForwardingServiceKt.isActive((PortForwardingProcess)portForwardingProcess) : false;
        if (bl && apiModel2 != null) {
            KubernetesApiModelInterface model2 = apiModel2;
            PortForwardingProcess forwarding = activeForwarding;
            actionGroup.add((AnAction)DumbAwareAction.create((String)KubernetesBundle.message((String)"action.Kubernetes.StopPortForwarding.text", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.showContextMenu$lambda$2(arg_0 -> ContainerPortInlayCollector.showContextMenu$lambda$1(model2, forwarding, arg_0), arg_0)));
        } else {
            actionGroup.addAll((Collection)popupActions);
        }
        this.createAndShowPopup(editor, editor.getProject(), actionGroup, e);
    }

    private static final CachedValueProvider.Result getCachedKubernetesObject$lambda$0(Project $project, YAMLDocument $document) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<KubernetesInlayHintsService> serviceClass$iv = KubernetesInlayHintsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((KubernetesInlayHintsService)object).getCoroutineScope();
        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KubernetesObject>, Object>(coroutineScope, $document, $project, null){
            int label;
            final /* synthetic */ CoroutineScope $coroutineScope;
            final /* synthetic */ YAMLDocument $document;
            final /* synthetic */ Project $project;
            {
                this.$coroutineScope = $coroutineScope;
                this.$document = $document;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(org.jetbrains.yaml.psi.YAMLDocument ), ()Ljava/lang/String;)((YAMLDocument)this.$document), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        documentText = (String)v0;
                        Intrinsics.checkNotNull((Object)documentText);
                        result = KubernetesResourceMapperKt.yamlToKubernetesObject((String)documentText);
                        BuildersKt.launch$default((CoroutineScope)this.$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                            int label;
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            {
                                                this.$project = $project;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        InlayHintsPassFactoryInternal.Companion.restartDaemonUpdatingHints(this.$project, "KubernetesPortForwardingInlayProvider.kubernetesObjectComputed");
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return result;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super KubernetesObject> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(YAMLDocument $document) {
                return $document.getText();
            }
        }), (int)3, null);
        Object[] objectArray = new Object[]{$document};
        return CachedValueProvider.Result.create((Object)deferred2, (Object[])objectArray);
    }

    private static final Unit collect$lambda$2(Project $project, ContainerPortInlayCollector this$0, Editor $editor, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ActionManager actionManager = ActionManager.getInstance();
        KubernetesApiProviderInterface apiProvider = KubernetesApiProvider.Companion.getInstance($project);
        AnAction actionForPopup = !((Collection)apiProvider.getExistingContexts()).isEmpty() ? actionManager.getAction("Kubernetes.SetCurrentContext") : actionManager.getAction("Kubernetes.AddContexts");
        AnAction[] anActionArray = new AnAction[]{actionForPopup};
        this$0.createAndShowPopup($editor, $project, new DefaultActionGroup(anActionArray), e);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit collect$lambda$3(KubernetesObject $kubernetesObjectFromCache, KubernetesApiModelInterface $apiModel, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        V1ObjectMeta v1ObjectMeta = $kubernetesObjectFromCache.getMetadata();
        String originalNamespace = v1ObjectMeta != null ? v1ObjectMeta.getNamespace() : null;
        V1ObjectMeta v1ObjectMeta2 = $kubernetesObjectFromCache.getMetadata();
        if (v1ObjectMeta2 != null) {
            String string = originalNamespace;
            if (string == null) {
                string = $apiModel.getNamespace();
            }
            v1ObjectMeta2.setNamespace(string);
        }
        try {
            KubernetesPortForwardingDialog.Companion.show$default((KubernetesPortForwardingDialog.Companion)KubernetesPortForwardingDialog.Companion, (KubernetesApiModelInterface)$apiModel, (KubernetesObject)$kubernetesObjectFromCache, null, (boolean)true, (boolean)false, (int)16, null);
        }
        finally {
            V1ObjectMeta v1ObjectMeta3 = $kubernetesObjectFromCache.getMetadata();
            if (v1ObjectMeta3 != null) {
                v1ObjectMeta3.setNamespace(originalNamespace);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createDatabaseDataSourceHint$lambda$0(ContainerPortInlayCollector this$0, PortForwardingProcess $activeForwarding, int $portValue, Project $project, KubernetesPortForwardingDatabaseType $detectedDbType, KubernetesObject $kubernetesObject, KubernetesApiModelInterface $apiModel, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Integer localPort = this$0.findLocalPort($activeForwarding, $portValue);
        if (localPort != null) {
            DatabaseCredentials databaseCredentials;
            try {
                ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)$project);
                Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(...)");
                String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.extracting.database.credentials", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                TaskCancellation.Cancellable cancellable = TaskCancellation.Companion.cancellable();
                String string2 = KubernetesBundle.message((String)"modal.progress.title.skip", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                databaseCredentials = (DatabaseCredentials)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)string, (TaskCancellation)((TaskCancellation)cancellable.withButtonText(string2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DatabaseCredentials>, Object>($kubernetesObject, $apiModel, $detectedDbType, null){
                    int label;
                    final /* synthetic */ KubernetesObject $kubernetesObject;
                    final /* synthetic */ KubernetesApiModelInterface $apiModel;
                    final /* synthetic */ KubernetesPortForwardingDatabaseType $detectedDbType;
                    {
                        this.$kubernetesObject = $kubernetesObject;
                        this.$apiModel = $apiModel;
                        this.$detectedDbType = $detectedDbType;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = KubernetesCredentialExtractor.INSTANCE.extractCredentials(this.$kubernetesObject, this.$apiModel, this.$detectedDbType, (Continuation<? super DatabaseCredentials>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super DatabaseCredentials> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            catch (Exception e) {
                if (!(e instanceof CancellationException)) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ContainerPortInlayCollector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error((Throwable)e);
                }
                databaseCredentials = null;
            }
            DatabaseCredentials credentials2 = databaseCredentials;
            String string = (String)CollectionsKt.firstOrNull((List)$activeForwarding.getPortForwarding().getAddresses());
            if (string == null) {
                string = "localhost";
            }
            int n = localPort;
            String string3 = $kubernetesObject.getMetadata().getName();
            if (string3 == null) {
                string3 = "unknown";
            }
            KubernetesPortForwardingDataSourceConfig dataSourceConfig = new KubernetesPortForwardingDataSourceConfig(string, n, $portValue, $detectedDbType, string3, $activeForwarding.getPortForwarding().getObjectInfo().getEntity().getKind(), $activeForwarding.getPortForwarding().getObjectInfo().getNamespace(), $apiModel.getCurrentContextObject().getName(), credentials2);
            this$0.createDatabaseDataSource($project, dataSourceConfig);
        }
        return Unit.INSTANCE;
    }

    private static final void createDatabaseDataSource$lambda$0(Project $project) {
        String pluginSearch = "Database Tools and SQL";
        try {
            ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "preferences.pluginManager", pluginSearch);
        }
        catch (Throwable throwable) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.install.database.all.plugins.page", (Object[])new Object[0]));
        }
    }

    private static final Unit createOpenInBrowserHint$lambda$0(ContainerPortInlayCollector this$0, PortForwardingProcess $activeForwarding, int $portValue, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Integer localPort = this$0.findLocalPort($activeForwarding, $portValue);
        if (localPort != null) {
            String string = (String)CollectionsKt.firstOrNull((List)$activeForwarding.getPortForwarding().getAddresses());
            if (string == null) {
                string = "localhost";
            }
            String address = string;
            BrowserUtil.browse((String)("http://" + address + ":" + localPort));
        }
        return Unit.INSTANCE;
    }

    private static final InlayPresentation addInlayPresentation$lambda$0(InlayPresentation $hoveredButton) {
        return $hoveredButton;
    }

    private static final void addInlayPresentation$lambda$1(addInlayPresentation.rightClickSupport.1 $rightClickSupport, MouseEvent event, Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (event.getButton() != 1) {
            $rightClickSupport.mousePressed(event, translated);
        }
    }

    private static final String showContextMenu$lambda$0() {
        return KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.provider.name", (Object[])new Object[0]);
    }

    private static final Unit showContextMenu$lambda$1(KubernetesApiModelInterface $model, PortForwardingProcess $forwarding, AnActionEvent it) {
        BuildersKt.launch$default((CoroutineScope)$model.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($model, $forwarding, null){
            int label;
            final /* synthetic */ KubernetesApiModelInterface $model;
            final /* synthetic */ PortForwardingProcess $forwarding;
            {
                this.$model = $model;
                this.$forwarding = $forwarding;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.backgroundWriteAction(() -> showContextMenu.1.1.invokeSuspend$lambda$0(this.$model, this.$forwarding), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(KubernetesApiModelInterface $model, PortForwardingProcess $forwarding) {
                KubernetesPortForwardingService.Companion.getInstance().stopPortForwarding($model.getCurrentContextObject(), $forwarding.getPortForwarding(), false);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void showContextMenu$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$showContextMenu(ContainerPortInlayCollector $this, MouseEvent e, Editor editor, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding) {
        $this.showContextMenu(e, editor, apiModel2, activeForwarding);
    }
}

