/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.kubernetes.ContainerPortInlayCollector;
import com.intellij.kubernetes.KubernetesInlayHintsService;
import com.intellij.kubernetes.KubernetesPortForwardingInlayProviderKt;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/kubernetes/KubernetesPortForwardingInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "<init>", "()V", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isVisibleInSettings", "", "()Z", "enabled", "getEnabled", "createSettings", "name", "", "getName", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingInlayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/KubernetesPortForwardingInlayProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,544:1\n30#2,2:545\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/KubernetesPortForwardingInlayProvider\n*L\n71#1:545,2\n*E\n"})
public final class KubernetesPortForwardingInlayProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String previewText;
    @NotNull
    public static final String PROVIDER_ID = "kubernetes.port.forwarding";

    public KubernetesPortForwardingInlayProvider() {
        this.name = "Kubernetes Port Forwarding";
        this.previewText = "apiVersion: v1\nkind: Pod\nspec:\n  containers:\n    - name: app\n      ports:\n        - containerPort: 8080\n          protocol: TCP";
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!this.getEnabled()) {
            return null;
        }
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!this.isLanguageSupported(language)) {
            return null;
        }
        if (!UtilsKt.isPlainKubernetesFile(file)) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<KubernetesInlayHintsService> serviceClass$iv = KubernetesInlayHintsService.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        KubernetesApiProviderInterface kubernetesApi = KubernetesApiProvider.Companion.getInstance(project2);
        if (!kubernetesApi.getInitialized()) {
            return null;
        }
        return new ContainerPortInlayCollector();
    }

    public boolean isVisibleInSettings() {
        return this.getEnabled();
    }

    private final boolean getEnabled() {
        return Registry.Companion.is("kubernetes.inlays.port.forwarding.enabled");
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return KubernetesPortForwardingInlayProviderKt.access$getKEY$p();
    }

    @NotNull
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JPanel createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof YAMLLanguage;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/KubernetesPortForwardingInlayProvider$Companion;", "", "<init>", "()V", "PROVIDER_ID", "", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

