/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.json.JsonFileType;
import com.intellij.kubernetes.K8sYamlMappings;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.model.InlinePatchType;
import com.intellij.kubernetes.model.KubernetesBasicDefinitionsKt;
import com.intellij.kubernetes.model.KubernetesLabelContainer;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesModelDefinition;
import com.intellij.kubernetes.model.KustomizeInlinePatchMixin;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u000f\u001a\u00020\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0015\u001a\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a\u0010\u0010\u0018\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0019\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0007*\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$*\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\f\u0010%\u001a\u0004\u0018\u00010&*\u00020\u0007\u001a\f\u0010%\u001a\u0004\u0018\u00010&*\u00020\r\u001a\f\u0010'\u001a\u0004\u0018\u00010&*\u00020\r\u001a\u000e\u0010+\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"\u001a\u0010\u00105\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020 H\u0002\u001a\n\u00106\u001a\u00020\u0001*\u000207\u001a\n\u00108\u001a\u00020\u0001*\u000207\u001a \u0010D\u001a\u0004\u0018\u0001HE\"\n\b\u0000\u0010E\u0018\u0001*\u000207*\u00020AH\u0086\b\u00a2\u0006\u0002\u0010F\u001a \u0010K\u001a\u0004\u0018\u0001HE\"\n\b\u0000\u0010E\u0018\u0001*\u000207*\u00020&H\u0086\b\u00a2\u0006\u0002\u0010L\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0017\u0010(\u001a\u0004\u0018\u00010\u000b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u001a\u0010,\u001a\u00070-\u00a2\u0006\u0002\b.*\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u00109\u001a\u0004\u0018\u00010:*\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\"\u001c\u0010>\u001a\t\u0018\u00010?\u00a2\u0006\u0002\b@*\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\"\u0017\u0010D\u001a\u0004\u0018\u000107*\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010F\"\u001c\u0010H\u001a\t\u0018\u00010?\u00a2\u0006\u0002\b@*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\"\u0017\u0010K\u001a\u0004\u0018\u000107*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010L\"\u0017\u0010N\u001a\u0004\u0018\u00010:*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006Q"}, d2={"isKubernetesYaml", "", "file", "Lcom/intellij/psi/PsiFile;", "hasJsonSchemaAttached", "isKubernetesDocument", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "hasApiVersionKey", "doc", "getDeclaredResourceId", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "mapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "isKustomizationPsiFile", "computeIsKustomization", "psiFile", "isKustomizationVirtualFile", "vfsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKustomizationYamlName", "isNonKustomizationK8sFile", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "isJsonOrNonK8sFile", "isKustomizeStrategicMergePatch", "k8sModel", "Lcom/intellij/kubernetes/model/KubernetesModel;", "Lcom/intellij/openapi/project/Project;", "getK8sModel", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/kubernetes/model/KubernetesModel;", "findDocumentByK8sResourceName", "Lorg/jetbrains/yaml/psi/YAMLFile;", "name", "", "findDocumentsByK8sResourceName", "", "findK8sResourceObjectName", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "findK8sResourceKind", "k8sResourceId", "getK8sResourceId", "(Lorg/jetbrains/yaml/psi/YAMLMapping;)Lcom/intellij/kubernetes/model/ResourceIdentity;", "isMapResourceEntryNameValid", "yamlPsiModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/PsiManager;", "getYamlPsiModificationTracker", "(Lcom/intellij/psi/PsiManager;)Lcom/intellij/openapi/util/ModificationTracker;", "resourceNameRegex", "Lkotlin/text/Regex;", "isResourceNameValid", "hasNoK8sDirective", "isKubernetesLabelContainer", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "isObjectMeta", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "Lcom/intellij/codeInspection/ProblemsHolder;", "getMetaTypeProvider", "(Lcom/intellij/codeInspection/ProblemsHolder;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "k8sMetaTypeProxy", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getK8sMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "k8sMetaType", "T", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "getK8sMetaType", "valueK8sMetaTypeProxy", "getValueK8sMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "valueK8sMetaType", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "getValueK8sMetaType", "k8sMetaTypeProvider", "getK8sMetaTypeProvider", "(Lcom/intellij/psi/PsiFile;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesUtil.kt\ncom/intellij/kubernetes/KubernetesUtilKt\n+ 2 YamlUtil.kt\ncom/intellij/kubernetes/YamlUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,286:1\n266#1:292\n275#1:293\n63#2:287\n65#2:288\n774#3:289\n865#3,2:290\n1761#3,3:296\n30#4,2:294\n30#4,2:299\n*S KotlinDebug\n*F\n+ 1 KubernetesUtil.kt\ncom/intellij/kubernetes/KubernetesUtilKt\n*L\n268#1:292\n277#1:293\n187#1:287\n190#1:288\n190#1:289\n190#1:290,2\n34#1:296,3\n285#1:294,2\n144#1:299,2\n*E\n"})
public final class KubernetesUtilKt {
    @NotNull
    private static final Regex resourceNameRegex = new Regex("[a-z0-9\\-.]*");

    public static final boolean isKubernetesYaml(@Nullable PsiFile file) {
        return file instanceof YAMLFile ? !KubeConfig.isKubeConfig((PsiFile)file) && !Chart.Companion.isChartFile(YamlUtilKt.getVfsFile((PsiElement)((PsiElement)file))) && !KubernetesUtilKt.hasJsonSchemaAttached(file) && ((Boolean)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> KubernetesUtilKt.isKubernetesYaml$lambda$0(file))).booleanValue() : false;
    }

    public static final boolean hasJsonSchemaAttached(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        if (file.getVirtualFile() == null) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration attachedMapping = JsonSchemaMappingsProjectConfiguration.getInstance((Project)file.getProject()).findMappingForFile(file.getVirtualFile());
        return attachedMapping != null;
    }

    private static final boolean isKubernetesDocument(YAMLDocument document) {
        return KubernetesUtilKt.hasApiVersionKey(document) || KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)((PsiElement)document))) || KustomizeInlinePatchMixin.Companion.getInlinePatchTypeByInjectedPsi(document.getContainingFile()) == InlinePatchType.STRATEGIC_MERGE;
    }

    private static final boolean hasApiVersionKey(YAMLDocument doc) {
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((YAMLDocument)doc);
        return (yAMLMapping != null ? YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"apiVersion") : null) != null;
    }

    @Nullable
    public static final ResourceIdentity getDeclaredResourceId(@Nullable YAMLDocument document) {
        YAMLDocument yAMLDocument = document;
        YAMLValue yAMLValue = yAMLDocument != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping topMapping = yAMLMapping;
        return KubernetesUtilKt.getDeclaredResourceId(topMapping);
    }

    @Nullable
    public static final ResourceIdentity getDeclaredResourceId(@Nullable YAMLMapping mapping) {
        if (mapping == null) {
            return null;
        }
        YAMLKeyValue yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)mapping, (String)"kind");
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue kindKeyVal = yAMLKeyValue;
        YAMLKeyValue yAMLKeyValue2 = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)mapping, (String)"apiVersion");
        if (yAMLKeyValue2 == null) {
            return null;
        }
        YAMLKeyValue apiVersionKeyVal = yAMLKeyValue2;
        return ResourceIdentity.Companion.create(YamlUtilKt.getEffectiveValueText((YAMLKeyValue)apiVersionKeyVal), YamlUtilKt.getEffectiveValueText((YAMLKeyValue)kindKeyVal));
    }

    public static final boolean isKustomizationPsiFile(@Nullable PsiFile file) {
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = psiFile.getManager()) == null) {
            return false;
        }
        PsiFile psiManager = psiFile;
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> KubernetesUtilKt.isKustomizationPsiFile$lambda$0(file, (PsiManager)psiManager));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final boolean computeIsKustomization(PsiFile psiFile) {
        if (!(psiFile instanceof YAMLFile)) {
            return false;
        }
        if (KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)((PsiElement)psiFile)))) {
            return true;
        }
        List list = ((YAMLFile)psiFile).getDocuments();
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getDeclaredResourceId((YAMLDocument)(list != null ? (YAMLDocument)CollectionsKt.firstOrNull((List)list) : null));
        if (resourceIdentity == null) {
            return false;
        }
        ResourceIdentity declaredResourceId = resourceIdentity;
        Project project = ((YAMLFile)psiFile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KubernetesModelAccessor.Companion.getInstance(project).getModel().isKustomizeResource(declaredResourceId);
    }

    public static final boolean isKustomizationVirtualFile(@Nullable VirtualFile vfsFile) {
        return vfsFile != null && !(vfsFile instanceof VirtualFileWindow) && KubernetesUtilKt.isKustomizationYamlName(vfsFile);
    }

    public static final boolean isKustomizationYamlName(@NotNull VirtualFile vfsFile) {
        Intrinsics.checkNotNullParameter((Object)vfsFile, (String)"vfsFile");
        return StringUtil.equals((CharSequence)FileUtilRt.getNameWithoutExtension((CharSequence)vfsFile.getNameSequence()), (CharSequence)"kustomization") && FileTypeManager.getInstance().isFileOfType(vfsFile, (FileType)YAMLFileType.YML);
    }

    public static final boolean isNonKustomizationK8sFile(@Nullable PsiFileSystemItem item) {
        if (!(item instanceof YAMLFile)) {
            return false;
        }
        List list = ((YAMLFile)item).getDocuments();
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getDeclaredResourceId((YAMLDocument)(list != null ? (YAMLDocument)CollectionsKt.firstOrNull((List)list) : null));
        if (resourceIdentity == null) {
            return false;
        }
        ResourceIdentity declaredResourceId = resourceIdentity;
        Project project = ((YAMLFile)item).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return !KubernetesModelAccessor.Companion.getInstance(project).getModel().isKustomizeResource(declaredResourceId);
    }

    public static final boolean isJsonOrNonK8sFile(@Nullable PsiFile file) {
        PsiFile psiFile;
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)file));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vfile = virtualFile;
        FileTypeManager fileTypeManager = FileTypeManagerEx.getInstance();
        return fileTypeManager.isFileOfType(vfile, (FileType)JsonFileType.INSTANCE) || YamlUtilKt.isYamlFile((VirtualFile)vfile) && !KubernetesUtilKt.isKubernetesYaml((PsiFile)((psiFile = file) instanceof YAMLFile ? (YAMLFile)psiFile : null));
    }

    @RequiresReadLock
    public static final boolean isKustomizeStrategicMergePatch(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        if (!(file instanceof YAMLFile)) {
            return false;
        }
        PsiManager psiManager = ((YAMLFile)file).getManager();
        VirtualFile vfsFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)file));
        if (vfsFile instanceof VirtualFileWindow) {
            PsiFile psiFile = psiManager.findFile(((VirtualFileWindow)vfsFile).getDelegate());
            YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
            if (yAMLFile == null) {
                return false;
            }
            YAMLFile hostPsiFile = yAMLFile;
            return KubernetesUtilKt.isKustomizationPsiFile((PsiFile)hostPsiFile);
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> KubernetesUtilKt.isKustomizeStrategicMergePatch$lambda$0(psiManager, file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    @NotNull
    public static final KubernetesModel getK8sModel(@NotNull Project $this$k8sModel) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sModel, (String)"<this>");
        return KubernetesModelAccessor.Companion.getInstance($this$k8sModel).getModel();
    }

    @Nullable
    public static final YAMLDocument findDocumentByK8sResourceName(@NotNull YAMLFile $this$findDocumentByK8sResourceName, @NotNull String name) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findDocumentByK8sResourceName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            YAMLFile $this$findDocument$iv = $this$findDocumentByK8sResourceName;
            boolean $i$f$findDocument = false;
            List list = $this$findDocument$iv.getDocuments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
            for (Object t : (Iterable)list) {
                YAMLDocument it = (YAMLDocument)t;
                boolean bl = false;
                YAMLKeyValue yAMLKeyValue = KubernetesUtilKt.findK8sResourceObjectName(it);
                if (!Intrinsics.areEqual((Object)(yAMLKeyValue != null ? YamlUtilKt.getEffectiveValueText((YAMLKeyValue)yAMLKeyValue) : null), (Object)name)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<YAMLDocument> findDocumentsByK8sResourceName(@NotNull YAMLFile $this$findDocumentsByK8sResourceName, @NotNull String name) {
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findDocumentsByK8sResourceName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        YAMLFile $this$findDocuments$iv = $this$findDocumentsByK8sResourceName;
        boolean $i$f$findDocuments = false;
        List list = $this$findDocuments$iv.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
        Iterable $this$filter$iv$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            YAMLDocument it = (YAMLDocument)element$iv$iv$iv;
            boolean bl = false;
            YAMLKeyValue yAMLKeyValue = KubernetesUtilKt.findK8sResourceObjectName(it);
            if (!Intrinsics.areEqual((Object)(yAMLKeyValue != null ? YamlUtilKt.getEffectiveValueText((YAMLKeyValue)yAMLKeyValue) : null), (Object)name)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceObjectName(@NotNull YAMLDocument $this$findK8sResourceObjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceObjectName, (String)"<this>");
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((YAMLDocument)$this$findK8sResourceObjectName);
        return yAMLMapping != null ? KubernetesUtilKt.findK8sResourceObjectName(yAMLMapping) : null;
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceObjectName(@NotNull YAMLMapping $this$findK8sResourceObjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceObjectName, (String)"<this>");
        String[] stringArray = new String[]{"metadata", "name"};
        return YamlUtilKt.findKeyValue((YAMLMapping)$this$findK8sResourceObjectName, (String[])stringArray);
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceKind(@NotNull YAMLMapping $this$findK8sResourceKind) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceKind, (String)"<this>");
        String[] stringArray = new String[]{"kind"};
        return YamlUtilKt.findKeyValue((YAMLMapping)$this$findK8sResourceKind, (String[])stringArray);
    }

    @Nullable
    public static final ResourceIdentity getK8sResourceId(@NotNull YAMLMapping $this$k8sResourceId) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sResourceId, (String)"<this>");
        return KubernetesUtilKt.getDeclaredResourceId($this$k8sResourceId);
    }

    public static final boolean isMapResourceEntryNameValid(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return KubernetesLabelUtilKt.isLabelTextValid(name, true);
    }

    @NotNull
    public static final ModificationTracker getYamlPsiModificationTracker(@NotNull PsiManager $this$yamlPsiModificationTracker) {
        Intrinsics.checkNotNullParameter((Object)$this$yamlPsiModificationTracker, (String)"<this>");
        ModificationTracker modificationTracker = $this$yamlPsiModificationTracker.getModificationTracker().forLanguage((Language)YAMLLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    public static final boolean isResourceNameValid(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = name.length();
        if (!(1 <= n ? n < 254 : false)) {
            return false;
        }
        if (!resourceNameRegex.matches((CharSequence)name)) {
            return false;
        }
        return Character.isLetterOrDigit(StringsKt.first((CharSequence)name)) && Character.isLetterOrDigit(StringsKt.last((CharSequence)name));
    }

    private static final boolean hasNoK8sDirective(YAMLFile file) {
        Ref.BooleanRef found2 = new Ref.BooleanRef();
        PsiTreeUtil.processElements((PsiElement)((PsiElement)file), LeafPsiElement.class, (PsiElementProcessor)new PsiElementProcessor(found2){
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$found = $found;
            }

            public final boolean execute(LeafPsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!CollectionsKt.contains((Iterable)K8sYamlMappings.INSTANCE.getNO_K8S_ANALYZED_TOKENS(), (Object)it.getNode().getElementType())) {
                    return false;
                }
                if (it instanceof PsiComment) {
                    String string = ((PsiComment)it).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence charSequence = string;
                    if (K8sYamlMappings.INSTANCE.getNO_K8S_DIRECTIVE_REGEX().containsMatchIn(charSequence)) {
                        this.$found.element = true;
                        return false;
                    }
                }
                return true;
            }
        });
        return found2.element;
    }

    public static final boolean isKubernetesLabelContainer(@NotNull YamlMetaType $this$isKubernetesLabelContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$isKubernetesLabelContainer, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isKubernetesLabelContainer, (Object)KubernetesLabelContainer.INSTANCE);
    }

    public static final boolean isObjectMeta(@NotNull YamlMetaType $this$isObjectMeta) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectMeta, (String)"<this>");
        return $this$isObjectMeta instanceof KubernetesModelDefinition && Intrinsics.areEqual((Object)KubernetesBasicDefinitionsKt.getShortTypeName((KubernetesModelDefinition)$this$isObjectMeta), (Object)"ObjectMeta");
    }

    @Nullable
    public static final YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder $this$metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$metaTypeProvider, (String)"<this>");
        PsiFile psiFile = $this$metaTypeProvider.getFile().getViewProvider().getPsi((Language)YAMLLanguage.INSTANCE);
        return psiFile != null ? KubernetesUtilKt.getK8sMetaTypeProvider(psiFile) : null;
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getK8sMetaTypeProxy(@NotNull YAMLPsiElement $this$k8sMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$k8sMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = KubernetesUtilKt.getK8sMetaTypeProvider(psiFile)) != null ? psiFile.getMetaTypeProxy((PsiElement)$this$k8sMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T k8sMetaType(YAMLPsiElement $this$k8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaType, (String)"<this>");
        boolean $i$f$k8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final YamlMetaType getK8sMetaType(@NotNull YAMLPsiElement $this$k8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaType, (String)"<this>");
        YAMLPsiElement $this$k8sMetaType$iv = $this$k8sMetaType;
        boolean $i$f$k8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType$iv);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        if (!(object instanceof YamlMetaType)) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getValueK8sMetaTypeProxy(@NotNull YAMLKeyValue $this$valueK8sMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$valueK8sMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = KubernetesUtilKt.getK8sMetaTypeProvider(psiFile)) != null ? psiFile.getKeyValueMetaType($this$valueK8sMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T valueK8sMetaType(YAMLKeyValue $this$valueK8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaType, (String)"<this>");
        boolean $i$f$valueK8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy($this$valueK8sMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final YamlMetaType getValueK8sMetaType(@NotNull YAMLKeyValue $this$valueK8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaType, (String)"<this>");
        YAMLKeyValue $this$valueK8sMetaType$iv = $this$valueK8sMetaType;
        boolean $i$f$valueK8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy($this$valueK8sMetaType$iv);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        if (!(object instanceof YamlMetaType)) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final YamlMetaTypeProvider getK8sMetaTypeProvider(@NotNull PsiFile $this$k8sMetaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaTypeProvider, (String)"<this>");
        if (!KubernetesUtilKt.isKubernetesYaml($this$k8sMetaTypeProvider)) {
            return null;
        }
        Project project = $this$k8sMetaTypeProvider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesModelAccessor> serviceClass$iv = KubernetesModelAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((KubernetesModelAccessor)((Object)object)).getMetaTypeProvider($this$k8sMetaTypeProvider);
    }

    /*
     * Unable to fully structure code
     */
    private static final CachedValueProvider.Result isKubernetesYaml$lambda$0(PsiFile $file) {
        block5: {
            if (KubernetesUtilKt.hasNoK8sDirective((YAMLFile)$file)) ** GOTO lbl-1000
            v0 = ((YAMLFile)$file).getDocuments();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDocuments(...)");
            $this$any$iv = v0;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (YAMLDocument)element$iv;
                    $i$a$-any-KubernetesUtilKt$isKubernetesYaml$1$value$1 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!KubernetesUtilKt.isKubernetesDocument(it)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = false;
            }
        }
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        value = v2;
        var2_1 = new Object[]{$file};
        return new CachedValueProvider.Result((Object)value, var2_1);
    }

    private static final CachedValueProvider.Result isKustomizationPsiFile$lambda$0(PsiFile $file, PsiManager $psiManager) {
        Object[] objectArray = new Object[]{KubernetesUtilKt.getYamlPsiModificationTracker($psiManager)};
        return new CachedValueProvider.Result((Object)KubernetesUtilKt.computeIsKustomization($file), objectArray);
    }

    private static final CachedValueProvider.Result isKustomizeStrategicMergePatch$lambda$0(PsiManager $psiManager, PsiFile $file) {
        Project project = $psiManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Boolean bl = ((KubernetesResolver)object).findKustomizeStrategicMergePatchReferences((YAMLFile)$file).findAny() != null;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)$psiManager);
        objectArray[0] = KubernetesUtilKt.getYamlPsiModificationTracker($psiManager);
        return new CachedValueProvider.Result((Object)bl, objectArray);
    }
}

