/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.logs.ILogItem;
import com.intellij.kubernetes.logs.KubernetesContextLogInterface;
import com.intellij.kubernetes.logs.KubernetesContextLogsModelKt;
import com.intellij.kubernetes.logs.KubernetesEventLog;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.settings.KubernetesLogsSettings;
import com.intellij.util.AnsiCsiUtil;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.time.Instant;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u0000 %2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002:\u0001%B!\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u001d\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0096\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010$\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\"\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "Lcom/intellij/kubernetes/logs/KubernetesContextLogInterface;", "Lcom/intellij/kubernetes/logs/ILogItem;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Ljava/time/Instant;", "timestamp", "message", "", "sourceObject", "<init>", "(Ljava/time/Instant;Ljava/lang/String;Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;)V", "getTimestamp", "()Ljava/time/Instant;", "getMessage", "()Ljava/lang/String;", "getSourceObject", "()Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "source", "getSource", "prettyTimestamp", "getPrettyTimestamp", "toString", "options", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "toString$intellij_clouds_kubernetes_backend", "size", "", "getSize", "()I", "compareTo", "other", "equals", "", "", "isEvent", "()Z", "hashCode", "Companion", "intellij.clouds.kubernetes.backend"})
public class KubernetesContextLog
implements KubernetesContextLogInterface,
ILogItem<KubernetesContainerObject, Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final String message;
    @NotNull
    private final KubernetesContainerObject sourceObject;
    @NotNull
    private final String prettyTimestamp;
    private final boolean isEvent;
    @NotNull
    private static final Comparator<KubernetesContextLog> comparator;

    protected KubernetesContextLog(@NotNull Instant timestamp, @NotNull String message, @NotNull KubernetesContainerObject sourceObject) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sourceObject, (String)"sourceObject");
        this.timestamp = timestamp;
        this.message = message;
        this.sourceObject = sourceObject;
        this.prettyTimestamp = KubernetesContextLogsModelKt.prettyFormatInstant(this.getTimestamp());
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public KubernetesContainerObject getSourceObject() {
        return this.sourceObject;
    }

    @NotNull
    public String getSource() {
        V1ObjectMeta v1ObjectMeta = this.getSourceObject().getParentPod().getMetadata();
        return (v1ObjectMeta != null ? v1ObjectMeta.getName() : null) + " " + this.getSourceObject().getName();
    }

    @NotNull
    public final String getPrettyTimestamp() {
        return this.prettyTimestamp;
    }

    @NotNull
    public final String toString$intellij_clouds_kubernetes_backend(@NotNull KubernetesLogPresentationSettings options) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (options.getShowTimestamp()) {
            $this$toString_u24lambda_u240.append("[" + this.prettyTimestamp + "]");
        }
        if (options.getShowTimestamp() && options.getShowSource()) {
            $this$toString_u24lambda_u240.append("\t");
        }
        if (options.getShowSource()) {
            $this$toString_u24lambda_u240.append("(" + this.getSource() + ")");
        }
        if ((options.getShowSource() || options.getShowTimestamp()) && options.getShowMessage()) {
            $this$toString_u24lambda_u240.append("\t");
        }
        if (options.getShowMessage()) {
            $this$toString_u24lambda_u240.append(this.getMessage());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return "[" + this.prettyTimestamp + "]\t(" + this.getSource() + ")\t" + this.getMessage();
    }

    public final int getSize() {
        return 1 + this.prettyTimestamp.length() + 3 + this.getSource().length() + 2 + this.getMessage().length() + 1;
    }

    public int compareTo(@NotNull ILogItem<KubernetesContainerObject, Instant> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other instanceof KubernetesContextLog ? comparator.compare(this, (KubernetesContextLog)other) : this.getTimestamp().compareTo((Instant)other.getTimestamp());
    }

    public boolean equals(@Nullable Object other) {
        KubernetesContextLog kubernetesContextLog = other instanceof KubernetesContextLog ? (KubernetesContextLog)other : null;
        if (kubernetesContextLog == null) {
            return false;
        }
        return this.compareTo((ILogItem<KubernetesContainerObject, Instant>)((ILogItem)kubernetesContextLog)) == 0;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.isEvent());
        result2 = 31 * result2 + this.getTimestamp().hashCode();
        result2 = 31 * result2 + this.getMessage().hashCode();
        result2 = 31 * result2 + this.getSourceObject().hashCode();
        result2 = 31 * result2 + this.prettyTimestamp.hashCode();
        result2 = 31 * result2 + this.getSize();
        result2 = 31 * result2 + this.getSource().hashCode();
        return result2;
    }

    static {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                KubernetesContextLog it = (KubernetesContextLog)a;
                boolean bl = false;
                Comparable comparable = it.getTimestamp();
                it = (KubernetesContextLog)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTimestamp());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    KubernetesContextLog it = (KubernetesContextLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSource());
                    it = (KubernetesContextLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSource())));
                }
                return n;
            }
        };
        KubernetesContextLog.comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    KubernetesContextLog it = (KubernetesContextLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getMessage());
                    it = (KubernetesContextLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMessage())));
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0010j\b\u0012\u0004\u0012\u00020\u0005`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLog$Companion;", "", "<init>", "()V", "fromString", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "rawInput", "", "source", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "fromEvent", "event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "context", "Lcom/intellij/kubernetes/api/Context;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesContextLog fromString(@NotNull String rawInput, @NotNull KubernetesContainerObject source) {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)rawInput, (String)"rawInput");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String input = KubernetesLogsSettings.Companion.getInstance().getDropAnsi() ? AnsiCsiUtil.stripAnsi((String)rawInput) : rawInput;
            int index = StringsKt.indexOf$default((CharSequence)input, (char)' ', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            String string = input.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String timestamp = string;
            String string2 = input.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String message = string2;
            try {
                instant = Instant.parse(timestamp);
            }
            catch (Exception e) {
                KubernetesContextLogsModelKt.access$getLOG$p().warnWithDebug("Failed to parse timestamp from raw input: " + input + ". Exception: " + e.getMessage(), (Throwable)e);
                return null;
            }
            Instant instant2 = instant;
            Intrinsics.checkNotNull((Object)instant2);
            return new KubernetesContextLog(instant2, message, source);
        }

        @NotNull
        public final KubernetesContextLog fromEvent(@NotNull CoreV1Event event, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new KubernetesEventLog(event, context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

