/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.ConstantsKt;
import com.intellij.kubernetes.model.EmbeddedSpecInfo;
import com.intellij.kubernetes.model.ExternalSpecInfo;
import com.intellij.kubernetes.model.KubernetesDocumentationModel;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesModelSettings;
import com.intellij.kubernetes.model.KubernetesYamlModelBuilder;
import com.intellij.kubernetes.model.ModelData;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.model.RootField;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.kubernetes.model.openapi.GroupVersionKind;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 T2\u00020\u0001:\u0003STUB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u00106\u001a\u0004\u0018\u00010\r2\u0006\u00107\u001a\u000208H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\r2\u0006\u0010:\u001a\u00020;H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\f2\u0006\u00107\u001a\u000208H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\r2\u0006\u0010?\u001a\u00020\fH\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020\u0012H\u0016J\u001c\u0010C\u001a\u0004\u0018\u00010\u00122\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010?\u001a\u00020\fH\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010B\u001a\u00020\u0012H\u0002J\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\f0RH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0014j\b\u0012\u0004\u0012\u00020\u0012`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0014j\b\u0012\u0004\u0012\u00020\u0012`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\f0$j\b\u0012\u0004\u0012\u00020\f`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060(R\u00020\u00000'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b,\u0010 R!\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010.\u001a\u0004\b0\u0010 R\u0014\u00102\u001a\u000203X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020\f0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010 R\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010 R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010 R\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010 \u00a8\u0006V"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "Lcom/intellij/kubernetes/model/KubernetesModel;", "modelData", "Lcom/intellij/kubernetes/model/ModelData;", "modelId", "", "errorHandler", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "<init>", "(Lcom/intellij/kubernetes/model/ModelData;ILcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;)V", "resourceModels", "Ljava/util/HashMap;", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "Lorg/jetbrains/yaml/meta/model/Field;", "Lkotlin/collections/HashMap;", "generalUndefined", "allResourcesByApiVersion", "Lcom/intellij/util/containers/MultiMap;", "", "_versions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "_groups", "mainSpecInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "getMainSpecInfo$annotations", "()V", "getMainSpecInfo", "()Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "editableResources", "", "getEditableResources", "()Ljava/util/Set;", "nonEditableResources", "getNonEditableResources", "kustomizationResources", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "kindsByApi", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl;", "documentationModel", "Lcom/intellij/kubernetes/model/KubernetesDocumentationModel;", "editableFullApiVersions", "getEditableFullApiVersions", "editableFullApiVersions$delegate", "Lkotlin/Lazy;", "nonEditableFullApiVersions", "getNonEditableFullApiVersions", "nonEditableFullApiVersions$delegate", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getMetaTypeProvider", "()Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getRoot", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "getResourceModel", "mapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "getResourceId", "resourceIds", "getResourceIds", "resourceId", "getKinds", "Lcom/intellij/kubernetes/model/KubernetesModel$Kinds;", "apiVersion", "getDescription", "type", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "field", "isKustomizeResource", "", "versions", "getVersions", "groups", "getGroups", "fullApiVersions", "getFullApiVersions", "getAllKindNames", "toApiVersions", "keys", "", "ErrorHandler", "Companion", "KindsImpl", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1869#2,2:232\n1563#2:234\n1634#2,3:235\n1563#2:240\n1634#2,3:241\n1563#2:244\n1634#2,3:245\n133#3:238\n1#4:239\n*S KotlinDebug\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel\n*L\n162#1:232,2\n174#1:234\n174#1:235,3\n227#1:240\n227#1:241,3\n229#1:244\n229#1:245,3\n188#1:238\n*E\n"})
public final class RegularKubernetesModel
implements KubernetesModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int modelId;
    @NotNull
    private final HashMap<ResourceIdentity, Field> resourceModels;
    @NotNull
    private final Field generalUndefined;
    @NotNull
    private final MultiMap<String, ResourceIdentity> allResourcesByApiVersion;
    @NotNull
    private final HashSet<String> _versions;
    @NotNull
    private final HashSet<String> _groups;
    @NotNull
    private final SchemaSpecInfo mainSpecInfo;
    @NotNull
    private final Set<ResourceIdentity> editableResources;
    @NotNull
    private final Set<ResourceIdentity> nonEditableResources;
    @NotNull
    private final ArrayList<ResourceIdentity> kustomizationResources;
    @NotNull
    private final ConcurrentMap<String, KindsImpl> kindsByApi;
    @NotNull
    private final KubernetesDocumentationModel documentationModel;
    @NotNull
    private final Lazy editableFullApiVersions$delegate;
    @NotNull
    private final Lazy nonEditableFullApiVersions$delegate;
    @NotNull
    private final YamlMetaTypeProvider metaTypeProvider;
    @NotNull
    private static final ResourceIdentity _kustomizationResourceId = ResourceIdentity.Companion.create(new GroupVersionKind("kustomize.config.k8s.io", "v1beta1", "Kustomization"));
    @NotNull
    public static final String kustomizeConfigurationDefinition = "io.k8s.config.kustomize.Configuration";

    /*
     * WARNING - void declaration
     */
    private RegularKubernetesModel(ModelData modelData, int modelId, ErrorHandler errorHandler) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        this.modelId = modelId;
        this.resourceModels = new HashMap();
        this.allResourcesByApiVersion = new MultiMap();
        this._versions = new HashSet();
        this._groups = new HashSet();
        this.kustomizationResources = new ArrayList();
        this.kindsByApi = new ConcurrentHashMap();
        this.documentationModel = new KubernetesDocumentationModel();
        this.mainSpecInfo = ((ModelData.DefinitionInfo)CollectionsKt.first((Iterable)modelData.getMainSpecData().getDefinitions())).getSpecInfo();
        this.resourceModels.putAll(new KubernetesYamlModelBuilder(modelData, this.documentationModel, errorHandler).build());
        Field field2 = this.resourceModels.remove(ResourceIdentity.Companion.getUNDEFINED());
        Intrinsics.checkNotNull((Object)field2);
        this.generalUndefined = field2;
        this.generalUndefined.getDefaultType().setDisplayName(KubernetesBundle.message((String)"KubernetesResourceKindType.validation.unknown.resource.kind", (Object[])new Object[0]));
        Set<ResourceIdentity> set = this.resourceModels.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ResourceIdentity it = (ResourceIdentity)element$iv2;
            boolean bl = false;
            this.allResourcesByApiVersion.putValue((Object)it.getApiVersion(), (Object)it);
            this._versions.add(it.getVersion());
            this._groups.add(it.getGroup());
        }
        this.editableResources = CollectionsKt.intersect((Iterable)modelData.getEditableResources(), (Iterable)this.getResourceIds());
        this.nonEditableResources = CollectionsKt.subtract((Iterable)this.getResourceIds(), (Iterable)this.getEditableResources());
        ModelData.DefinitionInfo definitionInfo = modelData.getMergedDefinitions().get(kustomizeConfigurationDefinition);
        Intrinsics.checkNotNull((Object)definitionInfo);
        $this$forEach$iv = definitionInfo.getDefinition().getGroupVersionKinds();
        ResourceIdentity.Companion companion = ResourceIdentity.Companion;
        ArrayList<ResourceIdentity> arrayList = this.kustomizationResources;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GroupVersionKind groupVersionKind = (GroupVersionKind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.create((GroupVersionKind)p0));
        }
        arrayList.addAll((List)destination$iv$iv);
        this.editableFullApiVersions$delegate = LazyKt.lazy(() -> RegularKubernetesModel.editableFullApiVersions_delegate$lambda$0(this));
        this.nonEditableFullApiVersions$delegate = LazyKt.lazy(() -> RegularKubernetesModel.nonEditableFullApiVersions_delegate$lambda$0(this));
        this.metaTypeProvider = new YamlMetaTypeProvider(this::getRoot, () -> this.modelId);
    }

    @Override
    @NotNull
    public SchemaSpecInfo getMainSpecInfo() {
        return this.mainSpecInfo;
    }

    public static /* synthetic */ void getMainSpecInfo$annotations() {
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getEditableResources() {
        return this.editableResources;
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getNonEditableResources() {
        return this.nonEditableResources;
    }

    @Override
    @NotNull
    public Set<String> getEditableFullApiVersions() {
        Lazy lazy = this.editableFullApiVersions$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<String> getNonEditableFullApiVersions() {
        Lazy lazy = this.nonEditableFullApiVersions$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public YamlMetaTypeProvider getMetaTypeProvider() {
        return this.metaTypeProvider;
    }

    private final Field getRoot(YAMLDocument document) {
        ResourceIdentity resourceIdentity = this.getResourceId(document);
        if (resourceIdentity == null) {
            Field field2;
            boolean condition$iv = KubernetesUtilKt.isKubernetesYaml(document.getContainingFile());
            boolean $i$f$doIf = false;
            if (condition$iv) {
                boolean bl = false;
                field2 = this.generalUndefined;
            } else {
                field2 = null;
            }
            return field2;
        }
        ResourceIdentity resourceId = resourceIdentity;
        Field field3 = this.getResourceModel(resourceId);
        if (field3 == null) {
            field3 = this.generalUndefined;
        }
        return field3;
    }

    @Override
    @Nullable
    public Field getResourceModel(@NotNull YAMLMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getK8sResourceId(mapping);
        if (resourceIdentity == null) {
            return null;
        }
        Field field2 = this.getResourceModel(resourceIdentity);
        if (field2 == null) {
            field2 = this.generalUndefined;
        }
        return field2;
    }

    @Override
    @Nullable
    public ResourceIdentity getResourceId(@NotNull YAMLDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = YamlUtilKt.getTopLevelMapping((YAMLDocument)document);
        if (object == null || (object = KubernetesUtilKt.getK8sResourceId(object)) == null) {
            ResourceIdentity resourceIdentity;
            ResourceIdentity it = resourceIdentity = _kustomizationResourceId;
            boolean bl = false;
            object = KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)((PsiElement)document))) ? resourceIdentity : null;
        }
        return object;
    }

    @NotNull
    public final Set<ResourceIdentity> getResourceIds() {
        Set<ResourceIdentity> set = this.resourceModels.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @Override
    @Nullable
    public Field getResourceModel(@NotNull ResourceIdentity resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        return this.resourceModels.get(resourceId);
    }

    @Override
    @Nullable
    public KubernetesModel.Kinds getKinds(@NotNull String apiVersion) {
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        if (!this.allResourcesByApiVersion.containsKey((Object)apiVersion)) {
            return null;
        }
        return this.kindsByApi.computeIfAbsent(apiVersion, arg_0 -> RegularKubernetesModel.getKinds$lambda$1(arg_0 -> RegularKubernetesModel.getKinds$lambda$0(this, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getDescription(@NotNull YamlMetaType type, @Nullable Field field2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KubernetesDocumentationModel kubernetesDocumentationModel = this.documentationModel;
        YamlMetaType yamlMetaType = type;
        Field field3 = field2;
        if (field3 != null) {
            void it;
            Field field4;
            Field field5 = field4 = field3;
            YamlMetaType yamlMetaType2 = yamlMetaType;
            KubernetesDocumentationModel kubernetesDocumentationModel2 = kubernetesDocumentationModel;
            boolean bl = false;
            boolean bl2 = !(it instanceof RootField);
            kubernetesDocumentationModel = kubernetesDocumentationModel2;
            yamlMetaType = yamlMetaType2;
            object = bl2 ? field4 : null;
        } else {
            object = null;
        }
        return kubernetesDocumentationModel.getDescription(yamlMetaType, (Field)object);
    }

    @Override
    public boolean isKustomizeResource(@NotNull ResourceIdentity resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        return this.kustomizationResources.contains(resourceId);
    }

    @NotNull
    public final Set<String> getVersions() {
        return this._versions;
    }

    @NotNull
    public final Set<String> getGroups() {
        return this._groups;
    }

    @Override
    @NotNull
    public Set<String> getFullApiVersions() {
        Set set = this.allResourcesByApiVersion.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllKindNames(String apiVersion) {
        void $this$mapTo$iv$iv;
        Collection collection = this.allResourcesByApiVersion.get((Object)apiVersion);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceIdentity resourceIdentity = (ResourceIdentity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getKind());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toApiVersions(Collection<ResourceIdentity> keys) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceIdentity resourceIdentity = (ResourceIdentity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getApiVersion());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Set editableFullApiVersions_delegate$lambda$0(RegularKubernetesModel this$0) {
        return this$0.toApiVersions((Collection<ResourceIdentity>)this$0.getEditableResources());
    }

    private static final Set nonEditableFullApiVersions_delegate$lambda$0(RegularKubernetesModel this$0) {
        return CollectionsKt.subtract((Iterable)this$0.getFullApiVersions(), (Iterable)this$0.getEditableFullApiVersions());
    }

    private static final KindsImpl getKinds$lambda$0(RegularKubernetesModel this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.new KindsImpl(it);
    }

    private static final KindsImpl getKinds$lambda$1(Function1 $tmp0, Object p0) {
        return (KindsImpl)$tmp0.invoke(p0);
    }

    public /* synthetic */ RegularKubernetesModel(ModelData modelData, int modelId, ErrorHandler errorHandler, DefaultConstructorMarker $constructor_marker) {
        this(modelData, modelId, errorHandler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0003R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$Companion;", "", "<init>", "()V", "load", "Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "mainApiVersion", "", "externalSpecs", "", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "settings", "Lcom/intellij/kubernetes/model/KubernetesModelSettings;", "modelId", "", "errorHandler", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "_kustomizationResourceId", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "get_kustomizationResourceId$annotations", "kustomizeConfigurationDefinition", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final RegularKubernetesModel load(@NotNull String mainApiVersion, @NotNull List<ExternalSpecInfo> externalSpecs) {
            Intrinsics.checkNotNullParameter((Object)mainApiVersion, (String)"mainApiVersion");
            Intrinsics.checkNotNullParameter(externalSpecs, (String)"externalSpecs");
            return this.load(new KubernetesModelSettings(mainApiVersion, null, EmbeddedSpecInfo.Companion.getListOfCommonSpecs(ConstantsKt.getDEFAULT_KUSTOMIZE_VERSION()), externalSpecs), 0, null);
        }

        public static /* synthetic */ RegularKubernetesModel load$default(Companion companion, String string, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.load(string, list);
        }

        @NotNull
        public final RegularKubernetesModel load(@NotNull KubernetesModelSettings settings, int modelId, @Nullable ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new RegularKubernetesModel(ModelData.Companion.load(settings, (Function2<? super ExternalSpecInfo, ? super Exception, Unit>)((Function2)(arg_0, arg_1) -> Companion.load$lambda$0(errorHandler, arg_0, arg_1))), modelId, errorHandler, null);
        }

        private static /* synthetic */ void get_kustomizationResourceId$annotations() {
        }

        private static final Unit load$lambda$0(ErrorHandler $errorHandler, ExternalSpecInfo specInfo, Exception error) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)specInfo, (String)"specInfo");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                ErrorHandler errorHandler = $errorHandler;
                if (errorHandler == null) break block0;
                errorHandler.handleFileError(specInfo, error);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\fH&J \u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "", "handleFileError", "", "specInfo", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleUnresolvedDefinition", "typeName", "", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "handleGenericError", "message", "intellij.clouds.kubernetes.backend"})
    public static interface ErrorHandler {
        public void handleFileError(@NotNull ExternalSpecInfo var1, @NotNull Exception var2);

        public void handleUnresolvedDefinition(@NotNull String var1, @NotNull SchemaSpecInfo var2);

        public void handleGenericError(@NotNull String var1, @NotNull SchemaSpecInfo var2, @NotNull String var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl;", "Lcom/intellij/kubernetes/model/KubernetesModel$Kinds;", "apiVersion", "", "<init>", "(Lcom/intellij/kubernetes/model/RegularKubernetesModel;Ljava/lang/String;)V", "allKinds", "", "getAllKinds", "()Ljava/util/Set;", "validKinds", "", "getValidKinds", "()Ljava/util/Collection;", "deprecatedKinds", "getDeprecatedKinds", "nonEditableKinds", "getNonEditableKinds", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nKubernetesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n774#2:232\n865#2,2:233\n1563#2:235\n1634#2,3:236\n774#2:239\n865#2,2:240\n1563#2:242\n1634#2,3:243\n1563#2:246\n1634#2,3:247\n*S KotlinDebug\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl\n*L\n137#1:232\n137#1:233,2\n139#1:235\n139#1:236,3\n140#1:239\n140#1:240,2\n142#1:242\n142#1:243,3\n143#1:246\n143#1:247,3\n*E\n"})
    private final class KindsImpl
    implements KubernetesModel.Kinds {
        @NotNull
        private final Set<String> allKinds;
        @NotNull
        private final Collection<String> validKinds;
        @NotNull
        private final Collection<String> deprecatedKinds;
        @NotNull
        private final Collection<String> nonEditableKinds;

        /*
         * WARNING - void declaration
         */
        public KindsImpl(String apiVersion) {
            Iterable $this$mapTo$iv$iv;
            ResourceIdentity it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            this.allKinds = RegularKubernetesModel.this.getAllKindNames(apiVersion);
            Collection collection2 = RegularKubernetesModel.this.allResourcesByApiVersion.get((Object)apiVersion);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            Collection allApiResources = collection2;
            Iterable iterable = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)RegularKubernetesModel.this.getEditableResources());
            RegularKubernetesModel regularKubernetesModel = RegularKubernetesModel.this;
            KindsImpl kindsImpl = this;
            boolean $i$f$filter22 = false;
            void var7_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ResourceIdentity resourceId = (ResourceIdentity)element$iv$iv2;
                boolean bl = false;
                Field field2 = (Field)regularKubernetesModel.resourceModels.get(resourceId);
                if (!(!(field2 != null ? field2.isDeprecated() : false))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            void $i$f$filter22 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                element$iv$iv2 = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.validKinds = (List)destination$iv$iv2;
            $this$map$iv = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)SetsKt.plus(RegularKubernetesModel.this.getEditableResources(), (Iterable)RegularKubernetesModel.this.getNonEditableResources()));
            RegularKubernetesModel $i$f$map22 = RegularKubernetesModel.this;
            kindsImpl = this;
            boolean $i$f$filter32 = false;
            destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ResourceIdentity resourceId = (ResourceIdentity)element$iv$iv2;
                boolean bl = false;
                Field field3 = (Field)$i$f$map22.resourceModels.get(resourceId);
                if (!(field3 != null ? field3.isDeprecated() : false)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            Iterable $i$f$filter32 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv$iv2 = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.deprecatedKinds = (List)destination$iv$iv2;
            $this$map$iv = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)RegularKubernetesModel.this.getNonEditableResources());
            kindsImpl = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.nonEditableKinds = (List)destination$iv$iv2;
        }

        @Override
        @NotNull
        public Set<String> getAllKinds() {
            return this.allKinds;
        }

        @Override
        @NotNull
        public Collection<String> getValidKinds() {
            return this.validKinds;
        }

        @Override
        @NotNull
        public Collection<String> getDeprecatedKinds() {
            return this.deprecatedKinds;
        }

        @Override
        @NotNull
        public Collection<String> getNonEditableKinds() {
            return this.nonEditableKinds;
        }
    }
}

