/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.jshell.JShellBundle;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.protocol.CodeSnippet;
import com.intellij.execution.jshell.protocol.Endpoint;
import com.intellij.execution.jshell.protocol.Event;
import com.intellij.execution.jshell.protocol.Message;
import com.intellij.execution.jshell.protocol.MessageReader;
import com.intellij.execution.jshell.protocol.MessageWriter;
import com.intellij.execution.jshell.protocol.Request;
import com.intellij.execution.jshell.protocol.Response;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JShellHandler {
    private static final Logger LOG = Logger.getInstance(JShellHandler.class);
    private static final int DEBUG_PORT = -1;
    public static final Key<JShellHandler> MARKER_KEY = Key.create((String)"JShell console key");
    private static final Charset ourCharset = StandardCharsets.UTF_8;
    private static final Executor EXECUTOR = DefaultRunExecutor.getRunExecutorInstance();
    private static final String JSHELL_FRONTEND_JAR = "jshell-frontend.jar";
    @NotNull
    private final Project myProject;
    @NotNull
    private final RunContentDescriptor myRunContent;
    @NotNull
    private final ConsoleViewImpl myConsoleView;
    @NotNull
    private final OSProcessHandler myProcessHandler;
    @NotNull
    private final MessageReader<Response> myMessageReader;
    @NotNull
    private final MessageWriter<Request> myMessageWriter;
    @NotNull
    private final ExecutorService myTaskQueue;
    private final AtomicReference<Collection<String>> myEvalClasspathRef;

    private JShellHandler(@NotNull Project project, @NotNull RunContentDescriptor descriptor, @NotNull ConsoleViewImpl consoleView, final @NotNull VirtualFile contentFile, @NotNull OSProcessHandler processHandler) throws Exception {
        if (project == null) {
            JShellHandler.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            JShellHandler.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            JShellHandler.$$$reportNull$$$0(2);
        }
        if (contentFile == null) {
            JShellHandler.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            JShellHandler.$$$reportNull$$$0(4);
        }
        this.myTaskQueue = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)JShellBundle.message("jshell.command.queue", new Object[0]));
        this.myEvalClasspathRef = new AtomicReference<Object>(null);
        this.myProject = project;
        this.myRunContent = descriptor;
        this.myConsoleView = consoleView;
        this.myProcessHandler = processHandler;
        PipedInputStream is = new PipedInputStream();
        final OutputStreamWriter readerSink = new OutputStreamWriter((OutputStream)new PipedOutputStream(is), StandardCharsets.UTF_8);
        this.myMessageReader = new MessageReader((InputStream)is, Response.class);
        this.myMessageWriter = new MessageWriter(processHandler.getProcessInput());
        processHandler.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    try {
                        readerSink.write(event.getText());
                        readerSink.flush();
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                } else {
                    JShellHandler.this.myConsoleView.print(event.getText(), outputType == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (JShellHandler.getAssociatedHandler(contentFile) == JShellHandler.this) {
                    contentFile.putUserData(MARKER_KEY, null);
                    try {
                        readerSink.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/jshell/JShellHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (file.equals(contentFile)) {
                    JShellHandler.this.stop();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/jshell/JShellHandler$2";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        contentFile.putUserData(MARKER_KEY, (Object)this);
        consoleView.attachToProcess((ProcessHandler)processHandler);
    }

    @Nullable
    public static JShellHandler getAssociatedHandler(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            JShellHandler.$$$reportNull$$$0(5);
        }
        return (JShellHandler)virtualFile.getUserData(MARKER_KEY);
    }

    @RequiresEdt
    @NotNull
    public static JShellHandler create(@NotNull Project project, @NotNull VirtualFile contentFile, @Nullable Module module, @Nullable Sdk alternateSdk) throws Exception {
        if (project == null) {
            JShellHandler.$$$reportNull$$$0(6);
        }
        if (contentFile == null) {
            JShellHandler.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        final OSProcessHandler processHandler = JShellHandler.launchProcess(project, module, alternateSdk);
        String title = "JShell " + contentFile.getNameWithoutExtension();
        MyConsoleView consoleView = new MyConsoleView(project);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, (ProcessHandler)processHandler, (JComponent)new JPanel(new BorderLayout()), title);
        final JShellHandler jshellHandler = new JShellHandler(project, descriptor, consoleView, contentFile, processHandler);
        LinkedHashSet cp = new LinkedHashSet();
        Computable orderEnumerator = module != null ? () -> ModuleRootManager.getInstance((Module)module).orderEntries() : () -> ProjectRootManager.getInstance((Project)project).orderEntries();
        ApplicationManager.getApplication().runReadAction(() -> cp.addAll(((OrderEnumerator)orderEnumerator.compute()).recursively().withoutSdk().getPathsList().getPathList()));
        if (!cp.isEmpty()) {
            jshellHandler.myEvalClasspathRef.set(cp);
        }
        JComponent consoleViewComponent = consoleView.getComponent();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll(consoleView.createConsoleActions());
        actionGroup.add((AnAction)new CloseAction(EXECUTOR, descriptor, project){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                jshellHandler.stop();
                if (!processHandler.waitFor(10000L)) {
                    processHandler.destroyProcess();
                }
                super.actionPerformed(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/jshell/JShellHandler$3", "actionPerformed"));
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("JShellHandler", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent(consoleViewComponent);
        JComponent ui = descriptor.getComponent();
        ui.add((Component)consoleViewComponent, "Center");
        ui.add((Component)toolbar.getComponent(), "West");
        processHandler.startNotify();
        RunContentManager.getInstance((Project)project).showRunContent(EXECUTOR, descriptor);
        JShellHandler jShellHandler = jshellHandler;
        if (jShellHandler == null) {
            JShellHandler.$$$reportNull$$$0(8);
        }
        return jShellHandler;
    }

    private static OSProcessHandler launchProcess(@NotNull Project project, @Nullable Module module, @Nullable Sdk alternateSdk) throws Exception {
        SdkTypeId sdkTypeId;
        Sdk sdk;
        if (project == null) {
            JShellHandler.$$$reportNull$$$0(9);
        }
        Sdk sdk2 = alternateSdk != null ? alternateSdk : (sdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : ProjectRootManager.getInstance((Project)project).getProjectSdk());
        if (sdk == null || !((sdkTypeId = sdk.getSdkType()) instanceof JavaSdkType)) {
            throw new ExecException((sdk != null ? "Expected Java SDK" : " SDK is not configured") + (module != null ? " for module " + module.getName() : " for project " + project.getName()));
        }
        JavaSdkType javaSdkType = (JavaSdkType)sdkTypeId;
        JavaSdkVersion sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)sdk);
        if (sdkVersion == null) {
            throw new ExecException("Cannot determine version for JDK " + sdk.getName() + ". Please re-configure the JDK.");
        }
        if (!sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            throw new ExecException("JDK version is " + sdkVersion.getDescription() + ". JDK 9 or higher is needed to run JShell.");
        }
        String vmExePath = javaSdkType.getVMExecutablePath(sdk);
        if (vmExePath == null) {
            throw new ExecException("Cannot determine path to VM executable for JDK " + sdk.getName() + ". Please re-configure the JDK.");
        }
        File executableFile = new File(vmExePath);
        String frontEndPath = JShellHandler.findFrontEndLibrary();
        if (frontEndPath == null) {
            throw new ExecException("Library jshell-frontend.jar not found in IDE classpath");
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(executableFile.getAbsolutePath());
        cmdLine.setWorkDirectory(executableFile.getParent());
        cmdLine.setCharset(ourCharset);
        StringBuilder launchCp = new StringBuilder().append(frontEndPath);
        String protocolJar = JShellHandler.getLibPath(Endpoint.class);
        if (protocolJar != null) {
            launchCp.append(File.pathSeparator).append(protocolJar);
        }
        if (!launchCp.isEmpty()) {
            cmdLine.addParameter("-classpath");
            cmdLine.addParameter(launchCp.toString());
        }
        cmdLine.addParameter("com.intellij.execution.jshell.frontend.Main");
        OSProcessHandler processHandler = new OSProcessHandler(cmdLine);
        return processHandler;
    }

    private static String findFrontEndLibrary() {
        String path = PathManager.getResourceRoot((ClassLoader)JShellHandler.class.getClassLoader(), (String)"com/intellij/execution/jshell/frontend/Marker.class");
        return path != null ? path : JSHELL_FRONTEND_JAR;
    }

    private static String getLibPath(Class<?> aClass) {
        return PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
    }

    public void stop() {
        this.myProcessHandler.destroyProcess();
        RunContentManager.getInstance((Project)this.myProject).removeRunContent(EXECUTOR, this.myRunContent);
    }

    public void toFront() {
        RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(EXECUTOR, this.myRunContent);
    }

    @Nullable
    public Future<Response> evaluate(@NotNull String code) {
        if (code == null) {
            JShellHandler.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmptyOrSpaces((String)code) ? null : this.myTaskQueue.submit(() -> this.sendInput(new Request(JShellHandler.nextUid(), Request.Command.EVAL, code)));
    }

    public void dropState() {
        this.myTaskQueue.execute(() -> this.sendInput(new Request(JShellHandler.nextUid(), Request.Command.DROP_STATE, null)));
    }

    private static String nextUid() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Response sendInput(Request request) {
        boolean alive;
        boolean bl = alive = !this.myProcessHandler.isProcessTerminating() && !this.myProcessHandler.isProcessTerminated();
        if (alive) {
            Collection cp = this.myEvalClasspathRef.getAndSet(null);
            if (cp != null) {
                for (Object path : cp) {
                    request.addClasspathItem((String)path);
                }
            }
            UIUtil.invokeLaterIfNeeded(() -> this.myConsoleView.performWhenNoDeferredOutput(() -> {
                try {
                    this.myMessageWriter.send((Message)request);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }));
        }
        StringBuilder stdOut = new StringBuilder();
        Response response = null;
        try {
            Object path;
            path = response = (Response)this.myMessageReader.receive(unparsedText -> stdOut.append((String)unparsedText));
            return path;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.renderResponse(request, response, stdOut.toString());
        }
        return null;
    }

    private void renderResponse(Request request, @Nullable Response response, String stdOut) {
        List events;
        if (response != null && (events = response.getEvents()) != null) {
            if (request.getCommand() == Request.Command.DROP_STATE) {
                int droppedCount = 0;
                for (Event event : events) {
                    CodeSnippet.Status prevStatus = event.getPreviousStatus();
                    CodeSnippet.Status status = event.getStatus();
                    if (event.getSnippet() == null || prevStatus == status || status != CodeSnippet.Status.DROPPED) continue;
                    ++droppedCount;
                }
                JShellDiagnostic.notifyInfo(JShellBundle.message("jshell.dropped.x.code.snippets", droppedCount), this.myProject);
            } else {
                for (Event event : events) {
                    CodeSnippet snippet;
                    String value;
                    String descr;
                    String diagnostic;
                    if (event.getCauseSnippet() != null) continue;
                    String exception = event.getExceptionText();
                    if (!StringUtil.isEmptyOrSpaces((String)exception)) {
                        this.myConsoleView.print("\n" + exception, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(diagnostic = event.getDiagnostic()))) {
                        this.myConsoleView.print("\n" + diagnostic, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(descr = JShellHandler.getEventDescription(event)))) {
                        this.myConsoleView.print("\n" + descr, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if ((value = (snippet = event.getSnippet()) != null && !snippet.getSubKind().hasValue() ? null : event.getValue()) == null) continue;
                    this.myConsoleView.print(" = " + (value.isEmpty() ? "\"\"" : value), ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
        }
        if (!StringUtil.isEmpty((String)stdOut)) {
            this.myConsoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            if (!"\n".equals(stdOut)) {
                this.myConsoleView.print(stdOut, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }
    }

    private static String getEventDescription(Event event) {
        CodeSnippet snippet = event.getSnippet();
        if (event.getCauseSnippet() != null || snippet == null) {
            return "";
        }
        CodeSnippet.Status status = event.getStatus();
        CodeSnippet.Kind kind = snippet.getKind();
        CodeSnippet.SubKind subKind = snippet.getSubKind();
        String presentation = snippet.getPresentation();
        if (presentation == null || subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
            presentation = StringUtil.trim((String)snippet.getCodeText());
        }
        String actionLabel = event.getPreviousStatus() == CodeSnippet.Status.NONEXISTENT && status.isDefined() ? (subKind == CodeSnippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND || !subKind.isExecutable() ? "Defined" : "") : (status == CodeSnippet.Status.REJECTED ? "Rejected" : (status == CodeSnippet.Status.DROPPED ? "Dropped" : (status == CodeSnippet.Status.OVERWRITTEN ? "Overwritten" : "")));
        String kindLabel = kind == CodeSnippet.Kind.TYPE_DECL ? (subKind == CodeSnippet.SubKind.INTERFACE_SUBKIND ? "interface" : (subKind == CodeSnippet.SubKind.ENUM_SUBKIND ? "enum" : (subKind == CodeSnippet.SubKind.RECORD_SUBKIND ? "record" : (subKind == CodeSnippet.SubKind.ANNOTATION_TYPE_SUBKIND ? "annotation" : "class")))) : (kind == CodeSnippet.Kind.VAR ? (subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND ? "" : "field") : (kind == CodeSnippet.Kind.METHOD ? "method" : (kind == CodeSnippet.Kind.IMPORT ? (subKind == CodeSnippet.SubKind.STATIC_IMPORT_ON_DEMAND_SUBKIND || subKind == CodeSnippet.SubKind.SINGLE_STATIC_IMPORT_SUBKIND ? "static import" : "import") : "")));
        StringBuilder descr = new StringBuilder();
        descr.append(actionLabel);
        if (!actionLabel.isEmpty()) {
            descr.append(" ");
        }
        if (!kindLabel.isEmpty()) {
            descr.append(kindLabel).append(" ");
        }
        descr.append(presentation);
        return descr.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jshell/JShellHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jshell/JShellHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "launchProcess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static class MyConsoleView
    extends ConsoleViewImpl {
        MyConsoleView(Project project) {
            super(project, GlobalSearchScope.allScope((Project)project), true, (ConsoleState)new ConsoleState.NotStartedStated(){

                @NotNull
                public ConsoleState attachTo(@NotNull ConsoleViewImpl console, @NotNull ProcessHandler processHandler) {
                    if (console == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (processHandler == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new ConsoleViewRunningState(console, processHandler, (ConsoleState)this, false, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "console";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "processHandler";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/jshell/JShellHandler$MyConsoleView$1";
                    objectArray[2] = "attachTo";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
        }
    }

    private static final class ExecException
    extends Exception {
        ExecException(String message) {
            super(message);
        }

        ExecException(String message, Throwable cause) {
            super(message, cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

