/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.jshell.DropJShellStateAction;
import com.intellij.execution.jshell.ExecuteJShellAction;
import com.intellij.execution.jshell.JShellBundle;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.JShellRootType;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SnippetEditorDecorator
implements EditorNotificationProvider {
    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SnippetEditorDecorator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SnippetEditorDecorator.$$$reportNull$$$0(1);
        }
        if (ScratchFileService.findRootType((VirtualFile)file) instanceof JShellRootType) {
            return editor -> new ConfigurationPane(project, file, (FileEditor)editor);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/jshell/SnippetEditorDecorator";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ConfigurationPane
    extends EditorHeaderComponent {
        private static final Key<ConfigurationPane> EDITOR_TOOLBAR_KEY = Key.create((String)"jshell.editor.toolbar");
        private final Alarm myUpdateAlarm;
        @NotNull
        private final FileEditor myFileEditor;
        @NotNull
        private final JrePathEditor myJreEditor;
        @NotNull
        private final ConfigurationModuleSelector myModuleSelector;
        @NotNull
        private final @NotNull Callable<@NotNull JShellHandler> myJShellHandlerGetter;
        private MessageBusConnection myBusConnection;

        ConfigurationPane(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull FileEditor fileEditor) {
            if (project == null) {
                ConfigurationPane.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                ConfigurationPane.$$$reportNull$$$0(1);
            }
            if (fileEditor == null) {
                ConfigurationPane.$$$reportNull$$$0(2);
            }
            this.myUpdateAlarm = new Alarm();
            this.myFileEditor = fileEditor;
            DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{ExecuteJShellAction.getSharedInstance(), DropJShellStateAction.getSharedInstance()});
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("JShellSnippetEditor", (ActionGroup)actions, true);
            this.myJreEditor = new JrePathEditor(DefaultJreSelector.projectSdk((Project)project));
            this.myJreEditor.setToolTipText(ExecutionBundle.message((String)"alternative.jre.to.run.jshell", (Object[])new Object[0]));
            this.myJreEditor.setPathOrName(null, true);
            LabeledComponent modulePane = new LabeledComponent();
            ModulesComboBox modulesCombo = new ModulesComboBox();
            modulePane.setComponent((JComponent)modulesCombo);
            modulePane.setLabelLocation("West");
            modulePane.setText(ExecutionBundle.message((String)"use.classpath.of", (Object[])new Object[0]));
            this.myModuleSelector = new ConfigurationModuleSelector(project, modulesCombo, JShellBundle.message("whole.project", new Object[0]));
            JPanel mainPane = new JPanel(new GridBagLayout());
            mainPane.add((Component)toolbar.getComponent(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            mainPane.add((Component)modulePane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            mainPane.add((Component)this.myJreEditor, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)15, (int)0, (int)0), 0, 0));
            this.add(mainPane, "Center");
            this.myJShellHandlerGetter = () -> {
                JShellHandler handler = JShellHandler.getAssociatedHandler(virtualFile);
                if (handler != null) {
                    return handler;
                }
                return JShellHandler.create(project, virtualFile, this.myModuleSelector.getModule(), this.getRuntimeSdk());
            };
        }

        @RequiresEdt
        @NotNull
        JShellHandler getJShellHandler() throws Exception {
            ThreadingAssertions.assertEventDispatchThread();
            JShellHandler jShellHandler = this.myJShellHandlerGetter.call();
            if (jShellHandler == null) {
                ConfigurationPane.$$$reportNull$$$0(3);
            }
            return jShellHandler;
        }

        public void addNotify() {
            super.addNotify();
            this.myFileEditor.putUserData(EDITOR_TOOLBAR_KEY, (Object)this);
            Project project = this.myModuleSelector.getProject();
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    this.myJShellHandlerGetter.call();
                }
                catch (Exception e) {
                    JShellDiagnostic.notifyError(e, project);
                }
            }, ModalityState.stateForComponent((Component)((Object)this)), project.getDisposed());
            this.myBusConnection = project.getMessageBus().connect();
            this.myBusConnection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

                public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (modules == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.reloadModules();
                }

                public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (module == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.reloadModules();
                }

                public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull com.intellij.util.Function<? super Module, String> oldNameProvider) {
                    if (project == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (modules == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (oldNameProvider == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    this.reloadModules();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "modules";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldNameProvider";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator$ConfigurationPane$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modulesAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleRemoved";
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modulesRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.reloadModules();
        }

        public void removeNotify() {
            super.removeNotify();
            this.myFileEditor.putUserData(EDITOR_TOOLBAR_KEY, null);
            MessageBusConnection conn = this.myBusConnection;
            if (conn != null) {
                this.myBusConnection = null;
                conn.disconnect();
                this.myUpdateAlarm.cancelAllRequests();
            }
        }

        private void reloadModules() {
            this.myUpdateAlarm.cancelAllRequests();
            this.myUpdateAlarm.addRequest(() -> this.myModuleSelector.reset(), 300L);
        }

        @Nullable
        private Sdk getRuntimeSdk() {
            String pathOrName = this.myJreEditor.getJrePathOrName();
            if (pathOrName != null) {
                JavaSdk javaSdkType = JavaSdk.getInstance();
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                Sdk sdkByName = jdkTable.findJdk(pathOrName, javaSdkType.getName());
                if (sdkByName != null) {
                    return sdkByName;
                }
                for (Sdk sdk : jdkTable.getSdksOfType((SdkTypeId)javaSdkType)) {
                    if (!FileUtil.pathsEqual((String)pathOrName, (String)sdk.getHomePath())) continue;
                    return sdk;
                }
                if (javaSdkType.isValidSdkHome(pathOrName)) {
                    return javaSdkType.createJdk(javaSdkType.suggestSdkName("JShell JDK", pathOrName), pathOrName, false);
                }
            }
            return null;
        }

        @Nullable
        public static ConfigurationPane getJShellConfiguration(@NotNull FileEditor editor) {
            if (editor == null) {
                ConfigurationPane.$$$reportNull$$$0(4);
            }
            return (ConfigurationPane)((Object)editor.getUserData(EDITOR_TOOLBAR_KEY));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/jshell/SnippetEditorDecorator$ConfigurationPane";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator$ConfigurationPane";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJShellHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getJShellConfiguration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

