/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.toc;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Manager$collectHeaders$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Manager", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nGenerateTableOfContentsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,128:1\n7#2,6:129\n*S KotlinDebug\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction\n*L\n38#1:129,6\n*E\n"})
public final class GenerateTableOfContentsAction
extends AnAction {
    public GenerateTableOfContentsAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), GenerateTableOfContentsAction::_init_$lambda$0);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(CommonDataKeys.PSI_FILE);
        MarkdownFile markdownFile = object instanceof MarkdownFile ? (MarkdownFile)object : null;
        if (markdownFile == null) {
            return;
        }
        MarkdownFile file = markdownFile;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        String content2 = Manager.INSTANCE.obtainToc(file);
        int caretOffset = editor3.getCaretModel().getPrimaryCaret().getOffset();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        List existingRanges = SequencesKt.toList(Manager.INSTANCE.findExistingTocs(file));
        ActionsKt.runWriteAction(() -> GenerateTableOfContentsAction.actionPerformed$lambda$0(project, editor3, existingRanges, caretOffset, content2));
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(CommonDataKeys.PSI_FILE);
        MarkdownFile file = object instanceof MarkdownFile ? (MarkdownFile)object : null;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (file == null || editor2 == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        if (SequencesKt.any(Manager.INSTANCE.findExistingTocs(file))) {
            event.getPresentation().setText(MarkdownBundle.message("action.Markdown.GenerateTableOfContents.update.text", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final String _init_$lambda$0() {
        return MarkdownBundle.message("action.Markdown.GenerateTableOfContents.insert.popup.text", new Object[0]);
    }

    private static final Unit actionPerformed$lambda$0(Project $project, Editor $editor, List $existingRanges, int $caretOffset, String $content) {
        Project project$iv = $project;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($editor, $existingRanges, $caretOffset, $content){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ List $existingRanges$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.$editor$inlined = editor2;
                this.$existingRanges$inlined = list2;
                this.$caretOffset$inlined = n;
                this.$content$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                Document document = this.$editor$inlined.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                if (CollectionsKt.none((Iterable)this.$existingRanges$inlined)) {
                    document2.insertString(this.$caretOffset$inlined, (CharSequence)this.$content$inlined);
                } else {
                    Iterable $this$forEach$iv = CollectionsKt.asReversed((List)this.$existingRanges$inlined);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        TextRange it = (TextRange)element$iv;
                        boolean bl2 = false;
                        Manager.INSTANCE.replaceString$intellij_markdown(document2, it, this.$content$inlined);
                    }
                }
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u0007*\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Manager;", "", "<init>", "()V", "sectionDelimiter", "", "replaceString", "", "Lcom/intellij/openapi/editor/Document;", "range", "Lcom/intellij/openapi/util/TextRange;", "replacement", "replaceString$intellij_markdown", "findExistingTocs", "Lkotlin/sequences/Sequence;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "isTocBlock", "", "element", "Lcom/intellij/psi/PsiElement;", "buildToc", "obtainToc", "collectTopLevelElements", "collectHeaders", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "appendHeader", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "header", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nGenerateTableOfContentsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Manager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,128:1\n1#2:129\n477#3:130\n*S KotlinDebug\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Manager\n*L\n111#1:130\n*E\n"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();
        @NlsSafe
        @NotNull
        private static final String sectionDelimiter = "<!-- TOC -->";

        private Manager() {
        }

        public final void replaceString$intellij_markdown(@NotNull Document $this$replaceString, @NotNull TextRange range, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)$this$replaceString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            $this$replaceString.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        @NotNull
        public final Sequence<TextRange> findExistingTocs(@NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Sequence<PsiElement> elements2 = this.collectTopLevelElements(file);
            Sequence blockElements2 = SequencesKt.windowed$default((Sequence)SequencesKt.filter(elements2, (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)this){

                public final Boolean invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Manager.access$isTocBlock((Manager)this.receiver, p0);
                }
            })), (int)2, (int)2, (boolean)false, (int)4, null);
            return SequencesKt.map((Sequence)blockElements2, Manager::findExistingTocs$lambda$0);
        }

        private final boolean isTocBlock(PsiElement element2) {
            block2: {
                Object object;
                block4: {
                    block3: {
                        PsiElement psiElement;
                        IElementType iElementType = MarkdownElementTypes.HTML_BLOCK;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"HTML_BLOCK");
                        if (!PsiUtilsKt.hasType(element2, iElementType)) break block2;
                        object = element2.getFirstChild();
                        if (object == null) break block3;
                        PsiElement it = psiElement = object;
                        boolean bl = false;
                        IElementType iElementType2 = MarkdownTokenTypes.HTML_BLOCK_CONTENT;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"HTML_BLOCK_CONTENT");
                        object = PsiUtilsKt.hasType(it, iElementType2) ? psiElement : null;
                        if (object != null) break block4;
                    }
                    return false;
                }
                PsiElement child = object;
                return child.textMatches((CharSequence)sectionDelimiter);
            }
            return false;
        }

        private final String buildToc(MarkdownFile file) {
            StringBuilder stringBuilder;
            Sequence<MarkdownHeader> headers = this.collectHeaders(file);
            StringBuilder $this$buildToc_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$buildToc_u24lambda_u240.append(sectionDelimiter).append('\n');
            for (MarkdownHeader header : headers) {
                INSTANCE.appendHeader($this$buildToc_u24lambda_u240, header);
                $this$buildToc_u24lambda_u240.append('\n');
            }
            $this$buildToc_u24lambda_u240.append(sectionDelimiter);
            return stringBuilder.toString();
        }

        @NotNull
        public final String obtainToc(@NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> Manager.obtainToc$lambda$0(file));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (String)object;
        }

        private final Sequence<PsiElement> collectTopLevelElements(MarkdownFile file) {
            PsiElement psiElement = file.getFirstChild();
            Sequence elements2 = psiElement != null ? PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true) : null;
            Sequence sequence = elements2;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            return sequence;
        }

        private final Sequence<MarkdownHeader> collectHeaders(MarkdownFile file) {
            Sequence<PsiElement> topLevelElements;
            Sequence<PsiElement> $this$filterIsInstance$iv = topLevelElements = this.collectTopLevelElements(file);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)Manager$collectHeaders$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return sequence;
        }

        private final void appendHeader(StringBuilder $this$appendHeader, MarkdownHeader header) {
            String string = header.buildVisibleText(false);
            if (string == null) {
                return;
            }
            String text2 = string;
            String string2 = header.getAnchorText();
            if (string2 == null) {
                return;
            }
            String reference = string2;
            int n = header.getLevel() - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                $this$appendHeader.append("  ");
            }
            $this$appendHeader.append("* [");
            $this$appendHeader.append(text2);
            $this$appendHeader.append("](#");
            $this$appendHeader.append(reference);
            $this$appendHeader.append(")");
        }

        private static final TextRange findExistingTocs$lambda$0(List list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"<destruct>");
            PsiElement begin = (PsiElement)list2.get(0);
            PsiElement end = (PsiElement)list2.get(1);
            return new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)begin), PsiTreeUtilKt.getEndOffset((PsiElement)end));
        }

        private static final CachedValueProvider.Result obtainToc$lambda$0(MarkdownFile $file) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)INSTANCE.buildToc($file), (Object[])objectArray);
        }

        public static final /* synthetic */ boolean access$isTocBlock(Manager $this, PsiElement element2) {
            return $this.isTocBlock(element2);
        }
    }
}

