/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00052\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/run/ui/FloatingPagingManager;", "", "<init>", "()V", "AdjustmentResult", "Companion", "intellij.grid.impl"})
public final class FloatingPagingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<Boolean> AVAILABLE_FOR_GRID_TYPE;
    @NotNull
    private static final Key<Boolean> PRESENT_IN_GRID;

    @JvmStatic
    public static final boolean shouldBePresent(@NotNull DataGrid grid) {
        return Companion.shouldBePresent(grid);
    }

    @JvmStatic
    public static final boolean isPresent(@NotNull DataGrid grid) {
        return Companion.isPresent(grid);
    }

    @JvmStatic
    public static final void installOn(@NotNull DataGrid grid, @NotNull TableResultPanel.LayeredPaneWithSizer targetPane) {
        Companion.installOn(grid, targetPane);
    }

    @JvmStatic
    public static final void uninstallFrom(@NotNull DataGrid grid, @NotNull TableResultPanel.LayeredPaneWithSizer targetPane) {
        Companion.uninstallFrom(grid, targetPane);
    }

    @JvmStatic
    @NotNull
    public static final AdjustmentResult adjustAction(@NotNull AnActionEvent e) {
        return Companion.adjustAction(e);
    }

    static {
        Key key = Key.create((String)"FloatingPaging.AvailableForGridType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        AVAILABLE_FOR_GRID_TYPE = key;
        Key key2 = Key.create((String)"FloatingPaging.PresentInGrid");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        PRESENT_IN_GRID = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/run/ui/FloatingPagingManager$AdjustmentResult;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_AFFECTED", "HIDDEN", "ADJUSTED", "intellij.grid.impl"})
    public static final class AdjustmentResult
    extends Enum<AdjustmentResult> {
        public static final /* enum */ AdjustmentResult NOT_AFFECTED = new AdjustmentResult();
        public static final /* enum */ AdjustmentResult HIDDEN = new AdjustmentResult();
        public static final /* enum */ AdjustmentResult ADJUSTED = new AdjustmentResult();
        private static final /* synthetic */ AdjustmentResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AdjustmentResult[] values() {
            return (AdjustmentResult[])$VALUES.clone();
        }

        public static AdjustmentResult valueOf(String value) {
            return Enum.valueOf(AdjustmentResult.class, value);
        }

        @NotNull
        public static EnumEntries<AdjustmentResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = adjustmentResultArray = new AdjustmentResult[]{AdjustmentResult.NOT_AFFECTED, AdjustmentResult.HIDDEN, AdjustmentResult.ADJUSTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R#\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/run/ui/FloatingPagingManager$Companion;", "", "<init>", "()V", "AVAILABLE_FOR_GRID_TYPE", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PRESENT_IN_GRID", "getPRESENT_IN_GRID", "()Lcom/intellij/openapi/util/Key;", "shouldBePresent", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isPresent", "installOn", "", "targetPane", "Lcom/intellij/database/run/ui/TableResultPanel$LayeredPaneWithSizer;", "uninstallFrom", "adjustAction", "Lcom/intellij/database/run/ui/FloatingPagingManager$AdjustmentResult;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "FloatingToolbarPanel", "RoundedCornersJBPanel", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nFloatingPagingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingPagingManager.kt\ncom/intellij/database/run/ui/FloatingPagingManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n4225#3,11:148\n1869#4,2:159\n*S KotlinDebug\n*F\n+ 1 FloatingPagingManager.kt\ncom/intellij/database/run/ui/FloatingPagingManager$Companion\n*L\n93#1:148,11\n93#1:159,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getPRESENT_IN_GRID() {
            return PRESENT_IN_GRID;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean shouldBePresent(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            DataGridSettings settings = GridUtil.getSettings(grid);
            if (!Intrinsics.areEqual((Object)grid.getUserData(AVAILABLE_FOR_GRID_TYPE), (Object)true)) return false;
            DataGridSettings dataGridSettings = settings;
            if ((dataGridSettings != null ? dataGridSettings.getPagingDisplayMode() : null) == DataGridSettings.PagingDisplayMode.DATA_EDITOR_TOOLBAR) return false;
            return true;
        }

        @JvmStatic
        public final boolean isPresent(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            return Intrinsics.areEqual((Object)grid.getUserData(this.getPRESENT_IN_GRID()), (Object)true);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void installOn(@NotNull DataGrid grid, @NotNull TableResultPanel.LayeredPaneWithSizer targetPane) {
            void $this$installOn_u24lambda_u240;
            MoreActionGroup moreActionGroup;
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)((Object)targetPane), (String)"targetPane");
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("Console.TableResult.Pagination.Floating.Group");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup actions = (ActionGroup)anAction;
            AnAction anAction2 = actionManager.getAction("Console.TableResult.Pagination.Floating.MoreGroup");
            Intrinsics.checkNotNull((Object)anAction2, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup moreActions = (ActionGroup)anAction2;
            AnAction[] anActionArray = new AnAction[3];
            anActionArray[0] = actions;
            anActionArray[1] = Separator.getInstance();
            MoreActionGroup moreActionGroup2 = moreActionGroup = new MoreActionGroup();
            int n = 2;
            AnAction[] anActionArray2 = anActionArray;
            String string = "GridFloatingPagingToolbar";
            ActionManager actionManager2 = actionManager;
            boolean bl = false;
            $this$installOn_u24lambda_u240.addAll(moreActions);
            Unit unit = Unit.INSTANCE;
            anActionArray2[n] = moreActionGroup;
            AnAction[] anActionArray3 = anActionArray;
            ActionToolbar actionToolbar2 = actionManager2.createActionToolbar(string, (ActionGroup)new DefaultActionGroup(anActionArray3), true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar2;
            toolbar.setTargetComponent((JComponent)((Object)targetPane));
            toolbar.getComponent().setOpaque(true);
            FloatingToolbarPanel toolbarComponent = new FloatingToolbarPanel(toolbar);
            DataGridSettings dataGridSettings = GridUtil.getSettings(grid);
            if (dataGridSettings == null || (dataGridSettings = dataGridSettings.getPagingDisplayMode()) == null) {
                dataGridSettings = DataGridSettings.PagingDisplayMode.GRID_CENTER_FLOATING;
            }
            DataGridSettings position = dataGridSettings;
            targetPane.add((Component)((Object)toolbarComponent));
            Component component = (Component)((Object)toolbarComponent);
            Integer n2 = JLayeredPane.PALETTE_LAYER;
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"PALETTE_LAYER");
            targetPane.setLayer(component, ((Number)n2).intValue());
            ClientProperty.put((JComponent)((JComponent)((Object)toolbarComponent)), TableResultPanel.LayeredPaneWithSizer.SIZER, arg_0 -> Companion.installOn$lambda$1(toolbarComponent, (DataGridSettings.PagingDisplayMode)position, arg_0));
            grid.putUserData(this.getPRESENT_IN_GRID(), true);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void uninstallFrom(@NotNull DataGrid grid, @NotNull TableResultPanel.LayeredPaneWithSizer targetPane) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)((Object)targetPane), (String)"targetPane");
            Component[] componentArray = targetPane.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$filterIsInstance$iv = componentArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FloatingToolbarPanel)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FloatingToolbarPanel it = (FloatingToolbarPanel)((Object)element$iv);
                boolean bl = false;
                targetPane.remove((Component)((Object)it));
            }
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)grid), this.getPRESENT_IN_GRID());
        }

        @JvmStatic
        @NotNull
        public final AdjustmentResult adjustAction(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (grid == null) {
                return AdjustmentResult.NOT_AFFECTED;
            }
            if (Intrinsics.areEqual((Object)"EditorToolbar", (Object)e.getPlace())) {
                if (this.isPresent(grid)) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return AdjustmentResult.HIDDEN;
                }
                return AdjustmentResult.NOT_AFFECTED;
            }
            e.getPresentation().putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
            return AdjustmentResult.ADJUSTED;
        }

        private static final Unit installOn$lambda$1(FloatingToolbarPanel $toolbarComponent, DataGridSettings.PagingDisplayMode $position, TableResultPanel.LayeredPaneWithSizer pane) {
            Dimension prefSize = $toolbarComponent.getPreferredSize();
            $toolbarComponent.setSize(prefSize);
            Dimension containerSize = pane.getSize();
            int y = containerSize.height - prefSize.height - JBUI.scale((int)12);
            int x = switch (WhenMappings.$EnumSwitchMapping$0[$position.ordinal()]) {
                case 1 -> throw new IllegalStateException("Floating paging should not be drawn on grid if DATA_EDITOR_TOOLBAR mode is selected");
                case 2 -> (containerSize.width - prefSize.width) / 2;
                case 3 -> JBUI.scale((int)12);
                case 4 -> containerSize.width - prefSize.width - JBUI.scale((int)22);
                default -> throw new NoWhenBranchMatchedException();
            };
            $toolbarComponent.setLocation(x, y);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/run/ui/FloatingPagingManager$Companion$FloatingToolbarPanel;", "Lcom/intellij/database/run/ui/FloatingPagingManager$Companion$RoundedCornersJBPanel;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionToolbar;)V", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.grid.impl"})
        public static final class FloatingToolbarPanel
        extends RoundedCornersJBPanel {
            public FloatingToolbarPanel(@NotNull ActionToolbar toolbar) {
                Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
                toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)JBUI.scale((int)22)));
                toolbar.getComponent().setBorder(JBUI.Borders.empty((int)JBUI.scale((int)6)));
                toolbar.getComponent().setOpaque(false);
                this.add(toolbar.getComponent(), "Center");
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/database/run/ui/FloatingPagingManager$Companion$RoundedCornersJBPanel;", "Lcom/intellij/ui/components/JBPanel;", "<init>", "()V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.grid.impl"})
        public static class RoundedCornersJBPanel
        extends JBPanel<RoundedCornersJBPanel> {
            public RoundedCornersJBPanel() {
                super((LayoutManager)new BorderLayout());
                this.setOpaque(false);
            }

            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                g.setColor(JBUI.CurrentTheme.Popup.toolbarPanelColor());
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                int cornerRadius = JBUI.scale((int)16);
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, cornerRadius, cornerRadius);
                g.setColor((Color)new JBColor((Color)Gray._235, (Color)Gray._64));
                g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, cornerRadius, cornerRadius);
                config.restore();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DataGridSettings.PagingDisplayMode.values().length];
                try {
                    nArray[DataGridSettings.PagingDisplayMode.DATA_EDITOR_TOOLBAR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataGridSettings.PagingDisplayMode.GRID_CENTER_FLOATING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataGridSettings.PagingDisplayMode.GRID_LEFT_FLOATING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataGridSettings.PagingDisplayMode.GRID_RIGHT_FLOATING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

