/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.spring.metadata.SpringStereotypeQualifierMetaData;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class SpringResourceProvider
implements StandardResourceProvider,
MetaDataContributor {
    SpringResourceProvider() {
    }

    public void registerResources(ResourceRegistrar registrar) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            registrar.addStdResource("http://www.springframework.org/dtd/spring-beans.dtd", "resources/dtd/spring-beans.dtd", this.getClass().getClassLoader());
            registrar.addStdResource("http://www.springframework.org/dtd/spring-beans-2.0.dtd", "resources/dtd/spring-beans-2.0.dtd", this.getClass().getClassLoader());
        }
    }

    public void contributeMetaData(@NotNull MetaDataRegistrar registrar) {
        if (registrar == null) {
            SpringResourceProvider.$$$reportNull$$$0(0);
        }
        registrar.registerMetaData(new ElementFilter(this){

            public boolean isAcceptable(Object element, PsiElement context) {
                Module module;
                if (element instanceof PsiAnnotation && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
                    for (PsiClass psiClass : JamAnnotationTypeUtil.getInstance((Project)module.getProject()).getQualifierAnnotationTypesWithChildren(module)) {
                        PsiAnnotation annotation = (PsiAnnotation)element;
                        if (!Objects.equals(annotation.getQualifiedName(), psiClass.getQualifiedName())) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return PsiAnnotation.class.isAssignableFrom(hintClass);
            }
        }, SpringStereotypeQualifierMetaData.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/SpringResourceProvider", "contributeMetaData"));
    }
}

