/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.spring.SpringBundle;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0018\u0010\u0015\u001a\f0\u0007\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spring/model/highlighting/jam/MethodParametersRemovingFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "method", "Lcom/intellij/psi/PsiMethod;", "<init>", "(Lcom/intellij/psi/PsiMethod;)V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "methodName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getText", "startInWriteAction", "", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nScheduledMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduledMethodInspection.kt\ncom/intellij/spring/model/highlighting/jam/MethodParametersRemovingFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,88:1\n67#2:89\n*S KotlinDebug\n*F\n+ 1 ScheduledMethodInspection.kt\ncom/intellij/spring/model/highlighting/jam/MethodParametersRemovingFix\n*L\n77#1:89\n*E\n"})
public final class MethodParametersRemovingFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String methodName;

    public MethodParametersRemovingFix(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        super((PsiElement)method);
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.methodName = string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringBundle.message("method.parameters.removing.fix.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiMethod finalMethod = (PsiMethod)startElement;
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)finalMethod)) && !FileModificationService.getInstance().prepareFileForWrite(finalMethod.getContainingFile())) {
            return;
        }
        try {
            ChangeSignatureProcessor changeSignatureProcessor = new ChangeSignatureProcessor(project, finalMethod, false, null, finalMethod.getName(), finalMethod.getReturnType(), new ParameterInfoImpl[0]);
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)finalMethod))) {
                changeSignatureProcessor.run();
            } else {
                JavaChangeSignatureUsageProcessor.processPrimaryMethod((JavaChangeInfo)((JavaChangeInfo)changeSignatureProcessor.getChangeInfo()), (PsiMethod)finalMethod, null, (boolean)true);
            }
        }
        catch (IncorrectOperationException e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LocalQuickFixOnPsiElement.LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        PsiElement psiElement = previewDescriptor.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getStartElement(...)");
        PsiElement psiElement2 = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiMethod.class, (boolean)false);
        if (psiMethod == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiMethod startElement = psiMethod;
        PsiFile psiFile = startElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        this.invoke(project, psiFile, (PsiElement)startElement, (PsiElement)startElement);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.methodName};
        String string = SpringBundle.message("method.parameters.removing.fix.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

