/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.override;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.testContexts.override.SpringTestingContextBean;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringTestingBeansInjectAnnotator
extends SpringAnnotatorBase
implements DumbAware {
    private static final List<String> ANNOTATIONS = Arrays.asList("org.springframework.test.context.bean.override.mockito.MockitoBean", "org.springframework.test.context.bean.override.mockito.MockitoSpyBean", "org.springframework.test.context.bean.override.convention.TestBean");

    public String getId() {
        return "SpringTestingBeansInjectAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.testing.inject.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.ShowAutowiredDependencies;
        if (icon == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        UElement element;
        if (psiElement == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(2);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) instanceof UField) {
            SpringTestingBeansInjectAnnotator.annotateField(result2, (UField)element);
        } else if (element instanceof UClass) {
            SpringTestingBeansInjectAnnotator.annotateClass(result2, ((UClass)element).getJavaPsi());
        }
    }

    private static void annotateField(Collection<? super RelatedItemLineMarkerInfo<?>> result2, UField uField) {
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)uField.getUastAnchor());
        if (identifier == null) {
            return;
        }
        PsiField field = (PsiField)UElementKt.getAsJavaPsiElement((UElement)uField, PsiField.class);
        if (field == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)field);
        if (module == null) {
            return;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, ANNOTATIONS, (int)0)) {
            SpringTestingBeansInjectAnnotator.processVariable(field.getContainingClass(), field, result2, identifier);
        }
    }

    private static void processVariable(@Nullable PsiClass containingClass, @NotNull PsiField psiField, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiElement identifier) {
        if (psiField == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(5);
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(() -> {
            CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(containingClass);
            if (model == null) {
                return Collections.emptyList();
            }
            List elements = SemService.getSemService((Project)psiField.getProject()).getSemElements(SpringTestingContextBean.TESTING_CONTEXT_BEAN_JAM_KEY, (PsiElement)psiField);
            return elements.isEmpty() ? Collections.emptyList() : SpringTestingBeansInjectAnnotator.getMockedBeans(elements, (PsiMember)psiField, model);
        }, result2, identifier, SpringBundle.message("spring.core.testing.annotator.navigate.to.overridden", new Object[0]));
    }

    private static void annotateClass(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @Nullable PsiClass psiClass) {
        if (result2 == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(6);
        }
        for (PsiAnnotation psiAnnotation : AnnotationUtil.findAnnotations((PsiModifierListOwner)psiClass, ANNOTATIONS)) {
            if (psiAnnotation == null) {
                return;
            }
            UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)psiAnnotation, UAnnotation.class);
            if (uAnnotation == null) {
                return;
            }
            UIdentifier uastAnchor = uAnnotation.getUastAnchor();
            if (uastAnchor == null) {
                return;
            }
            PsiElement identifier = uastAnchor.getSourcePsi();
            if (identifier == null) {
                return;
            }
            NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(() -> {
                CommonSpringModel model = SpringAutowireUtil.getProcessingSpringModel(psiClass);
                if (model == null) {
                    return Collections.emptyList();
                }
                List elements = SemService.getSemService((Project)psiAnnotation.getProject()).getSemElements(SpringTestingContextBean.TESTING_CONTEXT_REPEATABLE_ANNO_JAM_KEY, (PsiElement)psiAnnotation);
                return SpringTestingBeansInjectAnnotator.getMockedBeans(elements, (PsiMember)psiClass, model);
            }, result2, identifier, SpringBundle.message("spring.core.testing.annotator.navigate.to.overridden", new Object[0]));
        }
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> getMockedBeans(List<SpringTestingContextBean> elements, PsiMember psiMember, CommonSpringModel model) {
        HashSet beans = new HashSet();
        for (SpringTestingContextBean testingContextBean : elements) {
            String name = testingContextBean.getTestingBeanName();
            if (name != null) {
                beans.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (String)name));
                continue;
            }
            beans.addAll(SpringTestingBeansInjectAnnotator.findBeansByType(psiMember, model, testingContextBean));
        }
        HashSet hashSet = beans;
        if (hashSet == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static Set<SpringBeanPointer<?>> findBeansByType(@NotNull PsiMember psiMember, CommonSpringModel model, SpringTestingContextBean testingContextBean) {
        Set<SpringBeanPointer<?>> beansByType;
        if (psiMember == null) {
            SpringTestingBeansInjectAnnotator.$$$reportNull$$$0(8);
        }
        if ((beansByType = testingContextBean.getTestingTypes().stream().flatMap(testingType -> SpringAutowireUtil.getAutowiredBeansFor((PsiModifierListOwner)psiMember, SpringAutowireUtil.getAutowiredType(testingType), model).stream()).collect(Collectors.toSet())).size() > 1) {
            String defaultBeanName = SpringTestingBeansInjectAnnotator.getDefaultBeanName(testingContextBean);
            if (defaultBeanName == null) {
                return beansByType;
            }
            SpringBeanPointer defaultBean = (SpringBeanPointer)ContainerUtil.find(beansByType, pointer -> defaultBeanName.equals(pointer.getName()));
            if (defaultBean != null) {
                return Collections.singleton(defaultBean);
            }
        }
        return beansByType;
    }

    @Nullable
    @NlsSafe
    private static String getDefaultBeanName(SpringTestingContextBean testingContextBean) {
        PsiMember element = testingContextBean.getPsiElement();
        if (element instanceof PsiField) {
            return element.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/override/SpringTestingBeansInjectAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/override/SpringTestingBeansInjectAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockedBeans";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBeansByType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

