/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical;

import com.intellij.lang.java.logical.PsiClassLogicalElementProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.extensions.mapStruct.SpringMapStructMapper;
import com.intellij.spring.model.logical.OneOrManySpringBeansLogicalModel;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.logical.SpringBeansParentLogicalModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/model/structure/logical/SpringBeanLogicalStructureProvider;", "Lcom/intellij/lang/java/logical/PsiClassLogicalElementProvider;", "Lcom/intellij/spring/model/logical/OneOrManySpringBeansLogicalModel;", "<init>", "()V", "convert", "p", "Lcom/intellij/psi/PsiClass;", "getUniqSpringBeans", "", "Lcom/intellij/spring/model/CommonSpringBean;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanLogicalStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanLogicalStructureProvider.kt\ncom/intellij/spring/model/structure/logical/SpringBeanLogicalStructureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1788#2,4:40\n774#2:44\n865#2,2:45\n*S KotlinDebug\n*F\n+ 1 SpringBeanLogicalStructureProvider.kt\ncom/intellij/spring/model/structure/logical/SpringBeanLogicalStructureProvider\n*L\n33#1:40,4\n34#1:44\n34#1:45,2\n*E\n"})
public final class SpringBeanLogicalStructureProvider
extends PsiClassLogicalElementProvider<OneOrManySpringBeansLogicalModel> {
    @Nullable
    public OneOrManySpringBeansLogicalModel convert(@NotNull PsiClass p) {
        PsiType psiType;
        PsiClassType psiClassType;
        CommonSpringBean springBean;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Project project = p.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        List<CommonSpringBean> springBeans = this.getUniqSpringBeans(p);
        if (springBeans.isEmpty()) {
            return null;
        }
        if (springBeans.size() == 1 && (springBean = (CommonSpringBean)CollectionsKt.first(springBeans)).isValid() && Intrinsics.areEqual((Object)((psiClassType = (psiType = springBean.getBeanType()) instanceof PsiClassType ? (PsiClassType)psiType : null) != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : null), (Object)p.getQualifiedName())) {
            return (OneOrManySpringBeansLogicalModel)new SpringBeanLogicalModel((PsiElement)p, springBean);
        }
        return (OneOrManySpringBeansLogicalModel)new SpringBeansParentLogicalModel((PsiModifierListOwner)p, springBeans);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommonSpringBean> getUniqSpringBeans(PsiClass p) {
        int n;
        List result2 = SpringCommonUtils.getSpringBeans((PsiClass)p);
        if (result2.size() < 2) {
            Intrinsics.checkNotNull((Object)result2);
            return result2;
        }
        Intrinsics.checkNotNull((Object)result2);
        Iterable $this$count$iv = result2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CommonSpringBean it = (CommonSpringBean)element$iv;
                boolean bl = false;
                if (!(it instanceof SpringMapStructMapper) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n < ((Collection)result2).size()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = result2;
            boolean $i$f$filter = false;
            Iterable count$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CommonSpringBean it = (CommonSpringBean)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof SpringMapStructMapper))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return result2;
    }
}

