/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.quic.QuicClientStreamTransportKt;
import com.intellij.platform.split.connection.network.quic.QuicStreamTransport;
import com.intellij.platform.split.connection.network.quic.QuicTimeoutException;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.intellij.platform.split.connection.network.quic.QuicheCommon;
import com.intellij.platform.split.connection.network.quic.QuicheConfig;
import com.intellij.platform.split.connection.network.quic.QuicheSockAddrKt;
import com.intellij.platform.split.connection.network.quic.SockAddrI;
import com.intellij.platform.split.connection.y.D;
import com.intellij.platform.split.connection.y.Q;
import com.intellij.platform.split.connection.y.R;
import com.intellij.platform.split.connection.y.Z;
import com.intellij.platform.split.connection.y.f;
import com.intellij.platform.split.connection.y.j;
import com.jetbrains.quiche.stubs.quiche_recv_info;
import com.jetbrains.quiche.stubs.quiche_send_info;
import com.jetbrains.rd.platform.codeWithMe.util.ThreadUtil;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0014\u0010\"\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport;", "Lcom/intellij/platform/split/connection/network/quic/QuicStreamTransport;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "localSocket", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "peer", "Ljava/net/InetSocketAddress;", "hostName", "", "idleTimeout", "Ljava/time/Duration;", "QuicClientStreamTransport", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;Ljava/net/InetSocketAddress;Ljava/lang/String;Ljava/time/Duration;)V", "name", "getName", "()Ljava/lang/String;", "connection", "Lcom/sun/jna/ptr/PointerByReference;", "myConnectionState", "Lcom/intellij/platform/split/connection/y/D;", "socketReceivedDatagrams", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Pair;", "", "receivedQueue", "Ljava/util/concurrent/BlockingDeque;", "getReceivedQueue", "()Ljava/util/concurrent/BlockingDeque;", "toSendQueue", "getToSendQueue", "wakeupQueue", "", "getWakeupQueue", "connected", "getConnected", "()Lcom/intellij/platform/split/connection/y/D;", "localSockAddress", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "peerSockAddr", "quicConnection", "quicThread", "", "addToSendQueue", "arr", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nQuicClientStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n67#2,4:310\n67#2,4:314\n67#2,4:318\n67#2,4:322\n67#2,4:326\n67#2,4:330\n67#2,4:334\n67#2,4:338\n67#2,4:342\n67#2,4:346\n67#2,4:350\n67#2,4:354\n67#2,4:358\n67#2,4:362\n67#2,4:366\n*S KotlinDebug\n*F\n+ 1 QuicClientStreamTransport.kt\ncom/intellij/platform/split/connection/network/quic/QuicClientStreamTransport\n*L\n92#1:310,4\n128#1:314,4\n147#1:318,4\n162#1:322,4\n199#1:326,4\n222#1:330,4\n239#1:334,4\n251#1:338,4\n264#1:342,4\n269#1:346,4\n277#1:350,4\n280#1:354,4\n77#1:358,4\n83#1:362,4\n96#1:366,4\n*E\n"})
public final class QuicClientStreamTransport
extends QuicStreamTransport {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IDatagramSocketWrapper localSocket;
    @NotNull
    private final InetSocketAddress peer;
    @NotNull
    private final String hostName;
    @NotNull
    private final Duration idleTimeout;
    @NotNull
    private final String name;
    @NotNull
    private final PointerByReference connection;
    @NotNull
    private final D myConnectionState;
    @NotNull
    private final LinkedBlockingQueue<Pair<InetSocketAddress, byte[]>> socketReceivedDatagrams;
    @NotNull
    private final BlockingDeque<byte[]> receivedQueue;
    @NotNull
    private final BlockingDeque<byte[]> toSendQueue;
    @NotNull
    private final BlockingDeque<Boolean> wakeupQueue;
    @NotNull
    private final SockAddrI localSockAddress;
    @NotNull
    private final SockAddrI peerSockAddr;
    private static final String[] c;
    private static final String[] d;

    public QuicClientStreamTransport(@NotNull Lifetime lifetime, @NotNull IDatagramSocketWrapper localSocket, @NotNull InetSocketAddress peer, @NotNull String hostName, @NotNull Duration idleTimeout) {
        boolean bl;
        Object object;
        int n2;
        long l2;
        block5: {
            block6: {
                l2 = 139413778105310L;
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)QuicClientStreamTransport.b(-860343480 - -((char)-25715), -860343480 - -((char)-25488), (int)l2));
                Intrinsics.checkNotNullParameter((Object)localSocket, (String)QuicClientStreamTransport.b(-860343480 - -((char)-25716), 860343480 - 29817, (int)l2));
                Intrinsics.checkNotNullParameter((Object)peer, (String)QuicClientStreamTransport.b(-860343480 - -((char)-25713), -860343480 - -((char)-29036), (int)l2));
                Intrinsics.checkNotNullParameter((Object)hostName, (String)QuicClientStreamTransport.b(-860343480 - -((char)-25714), 860343480 - 20932, (int)l2));
                Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)QuicClientStreamTransport.b(-860343480 - -((char)-25719), -860343480 - -((char)-24268), (int)l2));
                this.lifetime = lifetime;
                this.localSocket = localSocket;
                this.peer = peer;
                this.hostName = hostName;
                this.idleTimeout = idleTimeout;
                this.name = QuicClientStreamTransport.b(-860343480 - -((char)-25720), 860343480 - 24013, (int)l2) + this.peer + ")";
                this.myConnectionState = new D();
                this.socketReceivedDatagrams = new LinkedBlockingQueue();
                int n3 = QuicStreamTransport.g();
                this.receivedQueue = new LinkedBlockingDeque();
                this.toSendQueue = new LinkedBlockingDeque();
                this.wakeupQueue = new LinkedBlockingDeque();
                InetSocketAddress inetSocketAddress = this.localSocket.getLocalAddress();
                Intrinsics.checkNotNull((Object)inetSocketAddress);
                this.localSockAddress = QuicheSockAddrKt.getQuicheSockAddr(inetSocketAddress);
                this.peerSockAddr = QuicheSockAddrKt.getQuicheSockAddr(this.peer);
                SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)this.lifetime, (arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$0(this, arg_0, arg_1));
                this.localSocket.adviseOnSpecificAddressPackets(this.lifetime, this.peer, (Function1<? super byte[], Unit>)((Function1)arg_0 -> QuicClientStreamTransport._init_$lambda$1(this, arg_0)));
                n2 = n3;
                this.localSocket.adviseOnRemainingPackets(this.lifetime, (Function2<? super InetSocketAddress, ? super byte[], Unit>)((Function2)(arg_0, arg_1) -> QuicClientStreamTransport._init_$lambda$2(this, arg_0, arg_1)));
                this.getWakeupQueue().add(true);
                this.connection = this.quicConnection();
                object = QuicClientStreamTransportKt.access$getLogger$p();
                boolean bl2 = false;
                try {
                    bl = object.isTraceEnabled();
                    if (n2 != 0) break block5;
                    if (!bl) break block6;
                }
                catch (RuntimeException runtimeException) {
                    throw QuicClientStreamTransport.a(runtimeException);
                }
                Logger logger = object;
                boolean bl3 = false;
                logger.trace(this.getName() + QuicClientStreamTransport.b(-860343480 - -((char)-25717), 860343480 - 21247, (int)l2));
            }
            bl = false;
        }
        object = ThreadsKt.thread$default((boolean)bl, (boolean)true, null, (String)(QuicClientStreamTransport.b(-860343480 - -((char)-25718), 860343480 - 27869, (int)l2) + this.peer), (int)10, () -> QuicClientStreamTransport._init_$lambda$4(this), (int)5, null);
        try {
            this.lifetime.onTermination(() -> QuicClientStreamTransport._init_$lambda$5((Thread)object, this));
            if (Q.y() != null) {
                QuicStreamTransport.y(++n2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw QuicClientStreamTransport.a(runtimeException);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getReceivedQueue() {
        return this.receivedQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<byte[]> getToSendQueue() {
        return this.toSendQueue;
    }

    @Override
    @NotNull
    protected BlockingDeque<Boolean> getWakeupQueue() {
        return this.wakeupQueue;
    }

    @NotNull
    public D getConnected() {
        return this.myConnectionState;
    }

    private final PointerByReference quicConnection() {
        QuicheConfig quicheConfig;
        long l2 = 39817003003899L;
        byte[] byArray = Random.Default.nextBytes(16);
        QuicheConfig quicheConfig2 = quicheConfig = new QuicheConfig();
        boolean bl = false;
        quicheConfig2.setCommonSensibleOptions(this.idleTimeout);
        String[] stringArray = new String[]{QuicClientStreamTransport.b(-1638768210 + -((char)-16714), -1638768210 + -27506, (int)l2), QuicClientStreamTransport.b(-1638768210 + -((char)-16715), -1638768210 + -30548, (int)l2)};
        quicheConfig2.setSupportedProtocols(stringArray);
        QuicheConfig quicheConfig3 = quicheConfig;
        PointerByReference pointerByReference = Quiche.INSTANCE.getLibrary().quiche_connect(this.hostName, byArray, new NativeSize((long)byArray.length), this.localSockAddress.getQuicheSockAddr(), this.localSockAddress.getNativeSize(), this.peerSockAddr.getQuicheSockAddr(), this.peerSockAddr.getNativeSize(), quicheConfig3.getPointer());
        Intrinsics.checkNotNullExpressionValue((Object)pointerByReference, (String)QuicClientStreamTransport.b(-1638768210 + -((char)-16716), 1638768210 + (char)-25147, (int)l2));
        return pointerByReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void quicThread() {
        block145: {
            block138: {
                block109: {
                    var1_1 = 16990611100815L;
                    var4_2 = new Memory(512L);
                    var3_3 = QuicStreamTransport.g();
                    try {
                        var5_4 = ByteBuffer.allocate(65536);
                        var6_8 = ByteBuffer.allocate(1);
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30491), -279572310 - -((char)-28929), (int)var1_1));
                        block94: while (D.g.g(this.myConnectionState)) {
                            block129: {
                                block128: {
                                    block126: {
                                        block127: {
                                            block123: {
                                                block124: {
                                                    block121: {
                                                        block154: {
                                                            block122: {
                                                                block152: {
                                                                    block117: {
                                                                        block118: {
                                                                            block119: {
                                                                                block120: {
                                                                                    block115: {
                                                                                        block116: {
                                                                                            block114: {
                                                                                                block113: {
                                                                                                    block112: {
                                                                                                        block149: {
                                                                                                            block148: {
                                                                                                                block110: {
                                                                                                                    block111: {
                                                                                                                        block108: {
                                                                                                                            var7_10 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                                                            var8_11 = false;
                                                                                                                            if (var3_3 != 0) break block108;
                                                                                                                            try {
                                                                                                                                block146: {
                                                                                                                                    v0 = var7_10;
                                                                                                                                    if (var3_3 != 0) break block109;
                                                                                                                                    break block146;
                                                                                                                                    catch (IOException v1) {
                                                                                                                                        throw QuicClientStreamTransport.a(v1);
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (!v0.isTraceEnabled()) break block108;
                                                                                                                            }
                                                                                                                            catch (IOException v2) {
                                                                                                                                throw QuicClientStreamTransport.a(v2);
                                                                                                                            }
                                                                                                                            var20_45 = var7_10;
                                                                                                                            var9_13 = false;
                                                                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30498), -279572310 - -((char)-26907), (int)var1_1) + Quiche.INSTANCE.getLibrary().quiche_conn_timeout_as_millis(this.connection) + QuicClientStreamTransport.b(-279572310 - -((char)-30497), 279572310 - (char)-26403, (int)var1_1));
                                                                                                                        }
                                                                                                                        var7_9 = Quiche.INSTANCE.getLibrary().quiche_conn_timeout_as_nanos(this.connection);
                                                                                                                        v3 = var7_9;
                                                                                                                        if (var3_3 != 0) break block110;
                                                                                                                        try {
                                                                                                                            block147: {
                                                                                                                                if (v3 >= 0L) break block111;
                                                                                                                                break block147;
                                                                                                                                catch (IOException v4) {
                                                                                                                                    throw QuicClientStreamTransport.a(v4);
                                                                                                                                }
                                                                                                                            }
                                                                                                                            v3 = 1000000000L;
                                                                                                                            break block110;
                                                                                                                        }
                                                                                                                        catch (IOException v5) {
                                                                                                                            throw QuicClientStreamTransport.a(v5);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    v3 = var7_9;
                                                                                                                }
                                                                                                                var9_12 = v3;
                                                                                                                this.getWakeupQueue().poll(var9_12, TimeUnit.NANOSECONDS);
                                                                                                                if (var3_3 != 0) break block112;
                                                                                                                if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) ** GOTO lbl71
                                                                                                                break block148;
                                                                                                                catch (IOException v6) {
                                                                                                                    throw QuicClientStreamTransport.a(v6);
                                                                                                                }
                                                                                                            }
                                                                                                            v7 = D.g;
                                                                                                            if (var3_3 != 0) break block113;
                                                                                                            break block149;
                                                                                                            catch (IOException v8) {
                                                                                                                throw QuicClientStreamTransport.a(v8);
                                                                                                            }
                                                                                                        }
                                                                                                        try {
                                                                                                            block150: {
                                                                                                                if (v7.g(this.myConnectionState)) ** GOTO lbl80
                                                                                                                break block150;
                                                                                                                catch (IOException v9) {
                                                                                                                    throw QuicClientStreamTransport.a(v9);
                                                                                                                }
                                                                                                            }
                                                                                                            QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30496), -279572310 - -((char)-16805), (int)var1_1) + this.myConnectionState.y() + QuicClientStreamTransport.b(-279572310 - -((char)-30495), -279572310 - -((char)-30614), (int)var1_1) + RLifetimeKt.isAlive((Lifetime)this.lifetime));
                                                                                                        }
                                                                                                        catch (IOException v10) {
                                                                                                            throw QuicClientStreamTransport.a(v10);
                                                                                                        }
                                                                                                    }
                                                                                                    try {
                                                                                                        if (var3_3 == 0) break;
lbl80:
                                                                                                        // 3 sources

                                                                                                        while (true) {
                                                                                                            v7 = this.socketReceivedDatagrams.poll();
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    catch (IOException v11) {
                                                                                                        throw QuicClientStreamTransport.a(v11);
                                                                                                    }
                                                                                                }
                                                                                                try {
                                                                                                    if (v7 != null) break block114;
                                                                                                    break block115;
                                                                                                }
                                                                                                catch (IOException v12) {
                                                                                                    throw QuicClientStreamTransport.a(v12);
                                                                                                }
                                                                                            }
                                                                                            var11_15 = v13;
                                                                                            var12_20 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                            var13_23 = false;
                                                                                            try {
                                                                                                if (var3_3 != 0 || !var12_20.isTraceEnabled()) break block116;
                                                                                            }
                                                                                            catch (IOException v14) {
                                                                                                throw QuicClientStreamTransport.a(v14);
                                                                                            }
                                                                                            var20_45 = var12_20;
                                                                                            var14_27 = false;
                                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30486), -279572310 - -((char)-22043), (int)var1_1) + IPrintableKt.printToString((Object)var11_15.getFirst()) + QuicClientStreamTransport.b(-279572310 - -((char)-30485), 279572310 - (char)-29632, (int)var1_1) + QuicheCommon.INSTANCE.toNativeSize(((byte[])var11_15.getSecond()).length));
                                                                                        }
                                                                                        var12_20 = new quiche_recv_info(this.peerSockAddr.getQuicheSockAddr(), this.peerSockAddr.size(), this.localSockAddress.getQuicheSockAddr(), this.localSockAddress.size());
                                                                                        var13_22 /* !! */  = Quiche.INSTANCE.getLibrary().quiche_conn_recv(this.connection, ByteBuffer.wrap((byte[])var11_15.getSecond()), QuicheCommon.INSTANCE.toNativeSize(((byte[])var11_15.getSecond()).length), (quiche_recv_info)var12_20);
                                                                                        var14_28 = var13_22 /* !! */ .longValue();
                                                                                        QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(-279572310 - -((char)-30484), -279572310 - -((char)-8873), (int)var1_1), var14_28);
                                                                                        if (var3_3 == 0) ** continue;
                                                                                    }
                                                                                    try {
                                                                                        Quiche.INSTANCE.getLibrary().quiche_conn_on_timeout(this.connection);
                                                                                        v15 = Intrinsics.areEqual((Object)this.myConnectionState.y(), (Object)f.I);
                                                                                        if (var3_3 != 0) break block117;
                                                                                        if (!v15) break block118;
                                                                                    }
                                                                                    catch (IOException v16) {
                                                                                        throw QuicClientStreamTransport.a(v16);
                                                                                    }
                                                                                    var11_16 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_established(this.connection));
                                                                                    var12_20 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                                    var13_24 = false;
                                                                                    try {
                                                                                        v15 = var12_20.isTraceEnabled();
                                                                                        if (var3_3 != 0) break block119;
                                                                                        if (!v15) break block120;
                                                                                    }
                                                                                    catch (IOException v17) {
                                                                                        throw QuicClientStreamTransport.a(v17);
                                                                                    }
                                                                                    var20_45 = var12_20;
                                                                                    var14_29 = false;
                                                                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30483), -279572310 - -((char)-30243), (int)var1_1) + var11_16);
                                                                                }
                                                                                v15 = var11_16;
                                                                            }
                                                                            if (var3_3 != 0) break block117;
                                                                            try {
                                                                                block151: {
                                                                                    if (!v15) break block118;
                                                                                    break block151;
                                                                                    catch (IOException v18) {
                                                                                        throw QuicClientStreamTransport.a(v18);
                                                                                    }
                                                                                }
                                                                                this.myConnectionState.g(j.I);
                                                                            }
                                                                            catch (IOException v19) {
                                                                                throw QuicClientStreamTransport.a(v19);
                                                                            }
                                                                        }
                                                                        v15 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_closed(this.connection));
                                                                    }
                                                                    try {
                                                                        if (var3_3 != 0) break block121;
                                                                        if (v15) {
                                                                        }
                                                                        ** GOTO lbl195
                                                                    }
                                                                    catch (IOException v20) {
                                                                        throw QuicClientStreamTransport.a(v20);
                                                                    }
                                                                    var11_17 = this.myConnectionState.y();
                                                                    v15 = Intrinsics.areEqual((Object)var11_17, (Object)j.I);
                                                                    if (var3_3 != 0) break block122;
                                                                    if (!v15) ** GOTO lbl175
                                                                    break block152;
                                                                    catch (IOException v21) {
                                                                        throw QuicClientStreamTransport.a(v21);
                                                                    }
                                                                }
                                                                try {
                                                                    block153: {
                                                                        this.myConnectionState.g(Z.I);
                                                                        if (var3_3 == 0) break;
                                                                        break block153;
                                                                        catch (IOException v22) {
                                                                            throw QuicClientStreamTransport.a(v22);
                                                                        }
                                                                    }
                                                                    v15 = Intrinsics.areEqual((Object)var11_17, (Object)f.I);
                                                                }
                                                                catch (IOException v23) {
                                                                    throw QuicClientStreamTransport.a(v23);
                                                                }
                                                            }
                                                            if (var3_3 != 0) break block121;
                                                            if (!v15) ** GOTO lbl195
                                                            break block154;
                                                            catch (IOException v24) {
                                                                throw QuicClientStreamTransport.a(v24);
                                                            }
                                                        }
                                                        try {
                                                            block155: {
                                                                this.myConnectionState.g(new R(new QuicTimeoutException(QuicClientStreamTransport.b(-279572310 - -((char)-30490), 279572310 - (char)-15612, (int)var1_1))));
                                                                if (var3_3 == 0) break;
                                                                break block155;
                                                                catch (IOException v25) {
                                                                    throw QuicClientStreamTransport.a(v25);
                                                                }
                                                            }
                                                            v15 = D.g.y(this.myConnectionState);
                                                        }
                                                        catch (IOException v26) {
                                                            throw QuicClientStreamTransport.a(v26);
                                                        }
                                                    }
                                                    try {
                                                        if (var3_3 != 0) break block123;
                                                        if (!v15) break block124;
                                                    }
                                                    catch (IOException v27) {
                                                        throw QuicClientStreamTransport.a(v27);
                                                    }
                                                    var11_18 = Quiche.INSTANCE.getLibrary().quiche_conn_readable(this.connection);
                                                    try {
                                                        block125: {
                                                            block96: while (true) {
                                                                var12_20 = new LongByReference();
                                                                if (!QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_stream_iter_next(var11_18, (LongByReference)var12_20))) break block124;
                                                                var13_25 = Quiche.INSTANCE.getLibrary().quiche_conn_stream_recv(this.connection, var12_20.getValue(), var5_4, QuicheCommon.INSTANCE.toNativeSize(var5_4.capacity()), var6_8).longValue();
                                                                QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(-279572310 - -((char)-30489), -279572310 - -((char)-7698), (int)var1_1), var13_25);
                                                                do {
                                                                    var15_33 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                    var16_38 = false;
                                                                    v28 = var15_33.isTraceEnabled();
                                                                    if (var3_3 == 0) {
                                                                        if (v28) {
                                                                            var20_45 = var15_33;
                                                                            var17_40 = false;
                                                                            var21_46 = var13_25;
                                                                            var23_47 = var12_20.getValue();
                                                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30488), 279572310 - (char)-16069, (int)var1_1) + var23_47 + " " + var21_46 + QuicClientStreamTransport.b(-279572310 - -((char)-30487), -279572310 - -((char)-29801), (int)var1_1));
                                                                        }
                                                                        this.getReceivedQueue().add(Arrays.copyOf(var5_4.array(), (int)var13_25));
                                                                        v28 = QuicheCommon.INSTANCE.toBoolean(var6_8.get(0));
                                                                    }
                                                                    if (!v28) continue block96;
                                                                    QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30478), 279572310 - 29951, (int)var1_1));
                                                                    var15_34 = Quiche.INSTANCE.getLibrary().quiche_conn_close(this.connection, QuicheCommon.INSTANCE.toByte(true), 0L, Pointer.NULL, QuicheCommon.INSTANCE.toNativeSize(0));
                                                                } while (var3_3 != 0);
                                                                break;
                                                            }
                                                            if (var3_3 != 0) break block124;
                                                            try {
                                                                block156: {
                                                                    if (var15_34 >= 0) break block125;
                                                                    break block156;
                                                                    catch (IOException v29) {
                                                                        throw QuicClientStreamTransport.a(v29);
                                                                    }
                                                                }
                                                                QuicClientStreamTransportKt.access$getLogger$p().warn(QuicClientStreamTransport.b(-279572310 - -((char)-30477), 279572310 - (char)-10801, (int)var1_1) + QuicheCommon.INSTANCE.getQuicheErrorName(var15_34));
                                                            }
                                                            catch (IOException v30) {
                                                                throw QuicClientStreamTransport.a(v30);
                                                            }
                                                        }
                                                        this.myConnectionState.g(Z.I);
                                                    }
                                                    finally {
                                                        Quiche.INSTANCE.getLibrary().quiche_stream_iter_free(var11_18);
                                                    }
                                                }
                                                v15 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_established(this.connection));
                                            }
                                            var11_14 = v15;
                                            var12_19 = QuicheCommon.INSTANCE.toBoolean(Quiche.INSTANCE.getLibrary().quiche_conn_is_in_early_data(this.connection));
                                            var13_22 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                            var14_30 = false;
                                            try {
                                                v31 = var13_22 /* !! */ .isTraceEnabled();
                                                if (var3_3 != 0) break block126;
                                                if (!v31) break block127;
                                            }
                                            catch (IOException v32) {
                                                throw QuicClientStreamTransport.a(v32);
                                            }
                                            var20_45 = var13_22 /* !! */ ;
                                            var15_35 = false;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30476), 279572310 - (char)-14487, (int)var1_1) + var11_14 + QuicClientStreamTransport.b(-279572310 - -((char)-30475), 279572310 - (char)-6780, (int)var1_1) + var12_19);
                                        }
                                        try {
                                            if (var3_3 != 0) break block128;
                                            v31 = var11_14;
                                        }
                                        catch (IOException v33) {
                                            throw QuicClientStreamTransport.a(v33);
                                        }
                                    }
                                    if (v31) break block128;
                                    try {
                                        block157: {
                                            v34 = var12_19;
                                            if (var3_3 != 0) ** GOTO lbl381
                                            break block157;
                                            catch (IOException v35) {
                                                throw QuicClientStreamTransport.a(v35);
                                            }
                                        }
                                        if (!v34) break block129;
                                    }
                                    catch (IOException v36) {
                                        throw QuicClientStreamTransport.a(v36);
                                    }
                                }
                                while (true) {
                                    block136: {
                                        block137: {
                                            block134: {
                                                block135: {
                                                    block131: {
                                                        block132: {
                                                            block133: {
                                                                block130: {
                                                                    try {
                                                                        if (this.getToSendQueue().poll() != null) break block130;
                                                                        break block129;
                                                                    }
                                                                    catch (IOException v37) {
                                                                        throw QuicClientStreamTransport.a(v37);
                                                                    }
                                                                }
                                                                var13_22 /* !! */  = (Logger)v38;
                                                                var14_31 = Quiche.INSTANCE.getLibrary().quiche_conn_stream_send(this.connection, 4L, (byte[])var13_22 /* !! */ , QuicheCommon.INSTANCE.toNativeSize(((Logger)var13_22 /* !! */ ).length), QuicheCommon.INSTANCE.toByte(false));
                                                                var15_36 = var14_31.longValue();
                                                                try {
                                                                    v39 = QuicheCommon.INSTANCE.isQuicheErrDone(var15_36);
                                                                    if (var3_3 != 0) break block131;
                                                                    if (v39 != 0) {
                                                                    }
                                                                    ** GOTO lbl329
                                                                }
                                                                catch (IOException v40) {
                                                                    throw QuicClientStreamTransport.a(v40);
                                                                }
                                                                var17_41 = QuicClientStreamTransportKt.access$getLogger$p();
                                                                var18_43 = 0;
                                                                try {
                                                                    if (var3_3 != 0) break block132;
                                                                    if (!var17_41.isTraceEnabled()) break block133;
                                                                }
                                                                catch (IOException v41) {
                                                                    throw QuicClientStreamTransport.a(v41);
                                                                }
                                                                var20_45 = var17_41;
                                                                var19_44 = false;
                                                                var20_45.trace(QuicClientStreamTransport.b(-279572310 - -((char)-30482), -279572310 - -((char)-6859), (int)var1_1) + ((Logger)var13_22 /* !! */ ).length + ")");
                                                            }
                                                            this.addToSendQueue((byte[])var13_22 /* !! */ );
                                                        }
                                                        try {
                                                            if (var3_3 == 0) break block129;
lbl329:
                                                            // 2 sources

                                                            QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(-279572310 - -((char)-30481), -279572310 - -((char)-6852), (int)var1_1), var15_36);
                                                            cfr_temp_0 = var15_36 - (long)((Logger)var13_22 /* !! */ ).length;
                                                            v39 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                                                        }
                                                        catch (IOException v42) {
                                                            throw QuicClientStreamTransport.a(v42);
                                                        }
                                                    }
                                                    try {
                                                        if (var3_3 != 0) break block134;
                                                        if (v39 <= 0) break block135;
                                                    }
                                                    catch (IOException v43) {
                                                        throw QuicClientStreamTransport.a(v43);
                                                    }
                                                    var25_53 = ((Logger)var13_22 /* !! */ ).length;
                                                    var26_54 = var15_36;
                                                    throw new IOException(QuicClientStreamTransport.b(-279572310 - -((char)-30480), -279572310 - -((char)-15923), (int)var1_1) + var26_54 + QuicClientStreamTransport.b(-279572310 - -((char)-30479), -279572310 - -((char)-10887), (int)var1_1) + var25_53 + ")");
                                                }
                                                cfr_temp_1 = var15_36 - (long)((Logger)var13_22 /* !! */ ).length;
                                                v39 = cfr_temp_1 == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                                            }
                                            if (v39 >= 0) continue;
                                            var17_41 = QuicClientStreamTransportKt.access$getLogger$p();
                                            var18_43 = 0;
                                            try {
                                                v44 = var17_41.isTraceEnabled();
                                                if (var3_3 != 0) break block136;
                                                if (!v44) break block137;
                                            }
                                            catch (IOException v45) {
                                                throw QuicClientStreamTransport.a(v45);
                                            }
                                            var20_45 = var17_41;
                                            var19_44 = false;
                                            var28_48 = ((Logger)var13_22 /* !! */ ).length;
                                            var29_49 = var15_36;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30470), -279572310 - -((char)-24163), (int)var1_1) + var29_49 + QuicClientStreamTransport.b(-279572310 - -((char)-30469), -279572310 - -((char)-22254), (int)var1_1) + var28_48 + ")");
                                        }
                                        this.addToSendQueue(ArraysKt.copyOfRange((byte[])var13_22 /* !! */ , (int)((int)var15_36), (int)((Logger)var13_22 /* !! */ ).length));
                                        cfr_temp_2 = var15_36 - 0L;
                                        v44 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                                    }
                                    if (!v44) break;
                                }
                                if (var3_3 == 0) {
                                }
                            }
                            while (true) {
                                block143: {
                                    block141: {
                                        block142: {
                                            block139: {
                                                block140: {
                                                    var5_4.rewind();
                                                    var13_22 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                                    var14_30 = false;
                                                    v34 = var13_22 /* !! */ .isTraceEnabled();
lbl381:
                                                    // 2 sources

                                                    if (v34) {
                                                        var20_45 = var13_22 /* !! */ ;
                                                        var15_37 = false;
                                                        try {
                                                            v46 = this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30468), 279572310 - (char)-25717, (int)var1_1) + var5_4.capacity() + QuicClientStreamTransport.b(-279572310 - -((char)-30467), -279572310 - -((char)-24812), (int)var1_1) + IPrintableKt.printToString((Object)var5_4);
                                                            v0 = var20_45;
                                                            if (var3_3 != 0) break block138;
                                                            v0.trace(v46);
                                                        }
                                                        catch (IOException v47) {
                                                            throw QuicClientStreamTransport.a(v47);
                                                        }
                                                    }
                                                    var13_22 /* !! */  = new quiche_send_info((Pointer)var4_2);
                                                    var14_26 = Quiche.INSTANCE.getLibrary().quiche_conn_send(this.connection, var5_4, QuicheCommon.INSTANCE.toNativeSize(var5_4.capacity()), (quiche_send_info)var13_22 /* !! */ );
                                                    var15_32 = var14_26.longValue();
                                                    var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                                    var18_43 = 0;
                                                    try {
                                                        v48 = var17_39 /* !! */ .isTraceEnabled();
                                                        if (var3_3 != 0) break block139;
                                                        if (!v48) break block140;
                                                    }
                                                    catch (IOException v49) {
                                                        throw QuicClientStreamTransport.a(v49);
                                                    }
                                                    var20_45 = var17_39 /* !! */ ;
                                                    var19_44 = false;
                                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30474), 279572310 - 31601, (int)var1_1) + var15_32 + QuicClientStreamTransport.b(-279572310 - -((char)-30473), 279572310 - (char)-24189, (int)var1_1));
                                                }
                                                v48 = QuicheCommon.INSTANCE.isQuicheErrDone(var15_32);
                                            }
                                            if (var3_3 != 0) break block141;
                                            try {
                                                block158: {
                                                    if (!v48) break block142;
                                                    break block158;
                                                    catch (IOException v50) {
                                                        throw QuicClientStreamTransport.a(v50);
                                                    }
                                                }
                                                if (var3_3 == 0) continue block94;
                                            }
                                            catch (IOException v51) {
                                                throw QuicClientStreamTransport.a(v51);
                                            }
                                        }
                                        QuicheCommon.INSTANCE.assertQuicheError(QuicClientStreamTransport.b(-279572310 - -((char)-30472), 279572310 - 31688, (int)var1_1), var15_32);
                                        var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                        var18_43 = 0;
                                        v48 = var17_39 /* !! */ .isTraceEnabled();
                                    }
                                    try {
                                        if (var3_3 == 0) {
                                            if (!v48) break block143;
                                        }
                                        ** GOTO lbl454
                                    }
                                    catch (IOException v52) {
                                        throw QuicClientStreamTransport.a(v52);
                                    }
                                    var20_45 = var17_39 /* !! */ ;
                                    var19_44 = false;
                                    var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30471), -279572310 - -((char)-30066), (int)var1_1) + var15_32 + QuicClientStreamTransport.b(-279572310 - -((char)-30462), -279572310 - -((char)-32558), (int)var1_1));
                                }
                                try {
                                    block144: {
                                        var17_39 /* !! */  = QuicClientStreamTransportKt.access$getLogger$p();
                                        var18_43 = 0;
                                        try {
                                            if (var3_3 != 0) break block144;
                                            v48 = var17_39 /* !! */ .isTraceEnabled();
                                        }
                                        catch (IOException v53) {
                                            throw QuicClientStreamTransport.a(v53);
                                        }
lbl454:
                                        // 2 sources

                                        if (v48) {
                                            var20_45 = var17_39 /* !! */ ;
                                            var19_44 = false;
                                            var31_50 = IPrintableKt.printToString((Object)this.peer);
                                            var32_51 = IPrintableKt.printToString((Object)this.localSocket.getLocalAddress());
                                            var33_52 = var15_32;
                                            var20_45.trace(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30461), -279572310 - -((char)-17475), (int)var1_1) + var33_52 + QuicClientStreamTransport.b(-279572310 - -((char)-30460), 279572310 - (char)-21523, (int)var1_1) + var32_51 + QuicClientStreamTransport.b(-279572310 - -((char)-30459), 279572310 - (char)-17700, (int)var1_1) + var31_50);
                                        }
                                    }
                                    v54 = var5_4.array();
                                    Intrinsics.checkNotNullExpressionValue((Object)v54, (String)QuicClientStreamTransport.b(-279572310 - -((char)-30466), -279572310 - -((char)-26366), (int)var1_1));
                                    var17_39 /* !! */  = (Logger)v54;
                                    var18_43 = (int)var15_32;
                                    v55 = Arrays.copyOf((byte[])var17_39 /* !! */ , var18_43);
                                    Intrinsics.checkNotNullExpressionValue((Object)v55, (String)QuicClientStreamTransport.b(-279572310 - -((char)-30465), -279572310 - -((char)-5854), (int)var1_1));
                                    this.localSocket.send(v55, this.peer);
                                    continue;
                                }
                                catch (IOException var17_42) {
                                    QuicClientStreamTransportKt.access$getLogger$p().warn(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30464), -279572310 - -((char)-10259), (int)var1_1) + var17_42.getMessage(), (Throwable)var17_42);
                                    if (var3_3 != 0) break block94;
                                    continue;
                                }
                                break;
                            }
                        }
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                    }
                    catch (InterruptedException var5_5) {
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30454), 279572310 - (char)-23040, (int)var1_1));
                        break block145;
                    }
                    catch (Throwable var5_6) {
                        QuicClientStreamTransportKt.access$getLogger$p().warn(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30452), -279572310 - -29821, (int)var1_1) + var5_6.getMessage(), var5_6);
                        this.myConnectionState.g(new R(var5_6));
                        {
                            catch (Throwable var5_7) {
                                throw var5_7;
                            }
                        }
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                        var4_2.clear();
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30453), -279572310 - -((char)-27645), (int)var1_1));
                        break block145;
                    }
                    finally {
                        Quiche.INSTANCE.getLibrary().quiche_conn_free(this.connection);
                        var4_2.clear();
                        QuicClientStreamTransportKt.access$getLogger$p().info(this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30453), -279572310 - -((char)-27645), (int)var1_1));
                    }
                    var4_2.clear();
                    v0 = QuicClientStreamTransportKt.access$getLogger$p();
                }
                v46 = this.getName() + QuicClientStreamTransport.b(-279572310 - -((char)-30463), 279572310 - (char)-6366, (int)var1_1);
            }
            v0.info(v46);
        }
    }

    private final void addToSendQueue(byte[] arr) {
        this.getToSendQueue().addFirst(arr);
        this.getWakeupQueue().add(true);
    }

    private static final Unit _init_$lambda$0(QuicClientStreamTransport this$0, Maybe previous, Q current) {
        long l2 = 40865462912718L;
        Intrinsics.checkNotNullParameter((Object)previous, (String)QuicClientStreamTransport.b(-1150925670 - -((char)-30884), 1150925670 - 15321, (int)l2));
        Intrinsics.checkNotNullParameter((Object)current, (String)QuicClientStreamTransport.b(-1150925670 - -((char)-30889), 1150925670 - (char)-30169, (int)l2));
        QuicClientStreamTransportKt.access$getLogger$p().info(this$0.y((Q)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(QuicClientStreamTransport this$0, byte[] datagramBytes) {
        block2: {
            boolean bl;
            block3: {
                long l2 = 8599726687392L;
                int n2 = QuicStreamTransport.g();
                Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)QuicClientStreamTransport.b(1202174040 + 4422, -1202174040 - -612, (int)l2));
                int n3 = n2;
                Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
                boolean bl2 = false;
                try {
                    bl = logger.isTraceEnabled();
                    if (n3 != 0) break block2;
                    if (!bl) break block3;
                }
                catch (RuntimeException runtimeException) {
                    throw QuicClientStreamTransport.a(runtimeException);
                }
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace(this$0.getName() + QuicClientStreamTransport.b(1202174040 + 4421, -1202174040 + -10873, (int)l2) + IPrintableKt.printToString((Object)this$0.peer) + QuicClientStreamTransport.b(1202174040 + 4420, -1202174040 + -3695, (int)l2) + datagramBytes.length);
            }
            this$0.socketReceivedDatagrams.add((Pair<InetSocketAddress, byte[]>)TuplesKt.to((Object)this$0.peer, (Object)datagramBytes));
            bl = this$0.getWakeupQueue().add(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(QuicClientStreamTransport this$0, InetSocketAddress address, byte[] datagramBytes) {
        block2: {
            long l2 = 110046881591359L;
            int n2 = QuicStreamTransport.y();
            Intrinsics.checkNotNullParameter((Object)address, (String)QuicClientStreamTransport.b(1229567670 - 14762, 1229567670 - 14618, (int)l2));
            int n3 = n2;
            Intrinsics.checkNotNullParameter((Object)datagramBytes, (String)QuicClientStreamTransport.b(1229567670 - 14761, -1229567670 - -24149, (int)l2));
            Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
            boolean bl = false;
            try {
                if (n3 == 0 || !logger.isTraceEnabled()) break block2;
            }
            catch (RuntimeException runtimeException) {
                throw QuicClientStreamTransport.a(runtimeException);
            }
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace(this$0.getName() + QuicClientStreamTransport.b(1229567670 - 14760, 1229567670 - 30951, (int)l2) + IPrintableKt.printToString((Object)address) + QuicClientStreamTransport.b(1229567670 - 14771, -1229567670 - -17500, (int)l2) + datagramBytes.length);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(QuicClientStreamTransport this$0) {
        this$0.quicThread();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Thread $quicThread, QuicClientStreamTransport this$0) {
        block2: {
            boolean bl;
            block3: {
                long l2 = 19890557556463L;
                Logger logger = QuicClientStreamTransportKt.access$getLogger$p();
                boolean bl2 = false;
                int n2 = QuicStreamTransport.g();
                try {
                    bl = logger.isTraceEnabled();
                    if (n2 != 0) break block2;
                    if (!bl) break block3;
                }
                catch (RuntimeException runtimeException) {
                    throw QuicClientStreamTransport.a(runtimeException);
                }
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace(this$0.getName() + QuicClientStreamTransport.b(563994210 + 32125, 563994210 + 16527, (int)l2));
            }
            ThreadUtil.INSTANCE.gracefullyJoinThread($quicThread);
            bl = this$0.myConnectionState.y(Z.I);
        }
        return Unit.INSTANCE;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[60];
                var3_1 = 0;
                var2_2 = "\u00c2_\u00e0\u009d\u00da\u00b8e\u0003\u000b\u0081\u00ea\u008d\u00e9\u00ca\u0088~~%\u009a\u0081\u0004RunB\b\u00feX\u00f6\u00aa\u0095e\u00f1\u00b1\u000b\u00e1K+\u00b3\u00c8}\u0003\u00bb\u00cc\u00f48\u001b3\rkJ5\u008aG&o\u00d1\u0007\u00a1\u00e5\u00cb6(\u00c7\u0081\u0092\u0097\r\u00dbp\t\u0010Ga\u0015\u0090\u0002}O?{\u001b\u00ceCe\u00e5\u00c5%\u00ad\u00d1\u00e9I\u00e21\u00aa\"\u0010\u00ba\u00b5Z]\u0013H\u0080]\u00ffRh\u00ef\u0089\u00daO\u0082\u0005\u0004\u009d\u00f7\u0089Y\bo\u009d\u00c3n\u00b5(\u00fb?\u0013\u001a\u0005JO}(<\u009a_\rP\u007fa\u00fb>\u00a8\u00fb\u0087\u00a5\u0013[v\u00185\u001bPgRh!\u00bd0\u00b4\u00e7\u0087j\u00e5\u00f9k\u001b\u00e0uNk\u00fd#\u009d0o\u0080\u00c9\u0087\u00e3k\u00f5F\u00ef\u00fe\\\u0019\u00b13\u009e\u00e1v\u00e1\u009b\u0003\u00afd\u009d:\u008b:\u0002\u00bcXa\u000ft~\u00f0\u0010\u00a2\u00fcS\u008f\u00be\u00ea\u0014f\u00a4\u00ce\u001e\u009bP\u0080G\u0015d@\u00ab\u00a3\u0001\u00efd\u00054X\u0004\u0017B\u00a8\u00aaA\u00ba\u00d1\u00c0\u009f\u00d5\u00cf\u00a5X[\f\u000f\u00a4`a\u00e6\u0016\u001a\u0091*\u00c7\r\u001e\u008f\u00d7,eE\u0095\u00e3\u00bb\u001eq\u008dy>\u00a5\u00ech\u001f\u00e0\u007fh\u00e2\u00fc\u009dDo\u0003\u0093h\u00c6\u00c0\u00ce\f\u0011W\f\u00b7\u00b6s~R\u001aL6\u00849`u\u0091\t(kx\u0098\u00ce\u00f5\u0017\u00aa\u00f4\u0010\u000e\u00cc\u00c8v-\u000f6~\u001e\u0091x\u00d6u\u00a2\u00c4\u00e8\u0019\u00bd\u00f0\u00f9{\u009b\u0084\u00b2\u00ee\u0010\u000e\u0093\u0019d\u00ec,\u00b4\u0018\u0011K\u00f5N\u00b3C\u00a8\u00027\u00c7\u00e1Y\u00aa\u0012\u00b5*>\r\"\u0017\u0017(\u00a7\u00f67\\\u009e\u001d3\u00d0\u0080h\u001d\u00e6\u00fb,\u0097\u00abJ\u00a3F=\u00f9\u00bcX\u00b7\u00b7^\u00a2\u00ff\u00b8jTZP\u0092\u001c\u00b6!\u00f4\u00b4ux\u00f0\u0017P\u0017\u0003\rT`\u0019\u0093\u00fb,\u00c4a\u00e3E&4\u00a6u\u00de\u00b7\u00a3\u009c\u00c8\u001a\u00d4*\u00e4i(\u00e0\u0013\b\u00bd\u00d7n\u00b4\u00a3n\u00e3o\u0017\u0087\u00a4Vm\u00901p\u00d5{\u0006\u00a5\u001f\u00d6\u00ee\u00f1\u00ff-x=d\u00e9\u00ca\u009b\u00a0)\u0088G\u00e2\u009dTR\u00df\u00db#U\u0099\u00c9PDi%\u0091\u00cf\u00ba\u00d3\u008c3\u0013\u00fb\u00f2\u00f5\u00eb!5z\u001d\u0091\u00c8&JR\\\u00199\n.\u00ae\u00f1\u0014\u00ad\u001dm\u00fd\u0016[\u00a9\u001a`\u00d2\u00d40.\u00fb\u00d7\u0019\u00b7\u00a4\u00bd \u00fel\u00b1\u00c8\u0096\u009e\u0011\u00a3\u008b\u0000G\u00f4\u0085\u00f78\u009b\u00ad\u000e\u000f\u00ac\u001f\u001d\u009c\u0004\u00e5\u00df\u0085~\u00fd\u00cds&&7\u00c9!?.\u00f4@\u00c1N\u00ad\u00d5\u00cc\u00fd\u00f6J`\u0010\u00ce0\u00d0ex\u00cbDd\u00f4\u00e1r\u00b2l,\u001b\u00af\u008d\u00c0\u00a8\u00dbG-n\u00e7\u00e0\u0013(\u00a3\u00e9\u00fb{4\u0011\u00fa\u0005\u00bd\u0013S\u00c1\u00d5\u00d8g\u00e2\u00ad\u00c9\u00a2\u00af\u00c5\u001b\u0002~\u00db[q)\u00b6\u0005\n\u00ca5\u00d4Op3\u0096\u00e6-\u0017\u00c6x\u00d1\u00e0\u000e\u00ddR$\u0092\u00da\u00e9\u00bfF\u009e\u0092O0\u001a\f[\u00f9-\u0091U\u00b7\u00d1n8\u00ed\u008f\u0097;\u00ba\u0082\u00f1\t\u00e6%j\"9\u00a1\u00d8\u0083\u000f\ty\u0015\u0015kH\u0089\u0080\b\u0087\u00eb\u0090H\\\u00f41\u00e0\u0019\u00a2\u0084\u000b\u00fc\u00fcISp\u00b2\u001a\u00e0\u00c9n\t\u00f4\u009f\u0098\u0090\u00d5|O&\u0013[\u00efD\u00a8\u00e5\u00a7\u00cc<@x\u00e7\u0098\u008b'\u0085u\u00a1\"\u00b2/P\u00cf\u00ff\u001e\u00cb\nk\u000fP\u00a2\u00e2,\u00e3\u0080\u0083\u00b5\u00a3\u0081\u00a8\u00b9w:\u00c5e\u00f8\u00f0W\u00fbL&Q\u00c0\u009c\u00dbA\t\u00b5[\u00c9J\u00c7{\u00e5\u0001\u00116I\u00c0\u001c\u00e4x\u00d4\u0019\u00ce.|\u0006\u00d5a\u0004\u00afj/\u00c5e\u000e\u00b6\u00be\\k\u00118\u00d8\u0001\u00a1:\u00ccD\"\u009byQ.X\u0091\u00e4\u00f1\u001b\u00e6\u00a7\u00ea\u009c\u00fa\u00be\u00bb\u001e\u00af\u00c7C;\u001ew\u00ca\u00fc\u0017\u00a2\u00a1\u00bcL(\u008c\u00fa4\u008c\u00b1M\u00bf\u00cb\u00faR}\n\u00f3\t\u009b\u0087*(A\u00b3\u00eb+\u0092\u00c4!\u0081:9\u00c1Ej\u0085\u00a2\u0084\u0095|-\u00c7\u00fbC\u00a1\u0003 3\u0092s\u00a9\u00f5&V\u00a6dhQD\u00c9\u009c\u00c3H\u00ae\u0011\u0080\u00ee\u0098\u00fd\b\rw\u00c3\u00e3S^0\u00c3#\u00ec<\u00e9\u000b\u0087A\b+\u00bavj\u00ecL\u00ef\u00dd\u0012x\u00c5\u00c6`\u00dc\u00ba\u0000-J\u009b\u008c\u00bb\u008c\u00df\u0014\u00e1\u00fd\u00b6\u0003\u0006\u00c0=z\u00aadw\u0010\u009dE\u00baGc)\u00ff\u00ba'\t_\u00c5\u0090\u00c0T\u00b6\t\u00b4]\u00e8\u00ab\u00a8\u0014:\u0094\u00c7\u0014\u0096\u00c8\u00b0\u0014=\u00a0\u00e7H\u00b4\u00ec\u0016\u00e5\u00c6\u00f9\u00c4w\u00d9PI\u00d3\t0Ax(\u00badx\u009a\u008f\bZ\u00db)v\u000e\u00ec\u009b\u0095\u0004\u00fd\u00b7\u009a\t\n\u00db\u00e4{\u00962\u001c\u0097\u00b54K\u000b3w&B\u00ed\u00d3\u009a\u00cbS\u0083\u00ff\u001cTI\u00fe\u0000.\u00c1\u001e\u00eaI\u00ec\r(\u0089\r\u000f\u008d4%\u00c2\u00a5\u00e3\u00fe\u00c2\u00f7\u009a\u00cc@\u00b3\u0010\u00d2\u00f5)E=^\u00a3\u0093\u00f9\u0000\u00ac5\u00ee#\u0090f\u001d\u00b9{D\u0094\u0090d\u0016\u00d4[\u00e4c(\u00a1\u0013 \u00bd\u00d2i\b\u00ebb\u0002\u007f\u00b90\u0094\u00e4w\u0006\u0010\u00dc\f\u00e8z\u0005\u00b9\u00a4o\u0019\u009f\u00b0\u00c6m]\u00e0\u00a9\u0013\u0006\u00d9\u00b3\u00c0n\u00ee\u00c9\u0085\u00b7\u00d3\u000bp\u00b5\u001a\u0094\u00d5\u0087Uk\bd\u00da\u00a8F\u00ad\u00b4-R\u0007\u0000\u001eB=\t^5\rD\u0011+Y\u00e0\u00bf_\u0093\u00e7\u00f4\u00d5\u00b5\u0098\u0016\u0091\u008bL]=f\u00b1\u00d8\u00e9\u00cd\u00f2\u00e4\u00e8\u0013B\u0013\u009e\u00a9\u009d[K\u00fc\t\u00a8\u00f1h\u00cb\u00cc\u009fW\u00e7\u00fc\u0007p\u00fd\u0018r\u0096\u00aa\u00c1\r\u00cd\u00a3\u001a\u000f\u00c6u\u009b\u00ca\u007f\u00df\u00c6\u00d0\u00fa";
                var4_3 = "\u00c2_\u00e0\u009d\u00da\u00b8e\u0003\u000b\u0081\u00ea\u008d\u00e9\u00ca\u0088~~%\u009a\u0081\u0004RunB\b\u00feX\u00f6\u00aa\u0095e\u00f1\u00b1\u000b\u00e1K+\u00b3\u00c8}\u0003\u00bb\u00cc\u00f48\u001b3\rkJ5\u008aG&o\u00d1\u0007\u00a1\u00e5\u00cb6(\u00c7\u0081\u0092\u0097\r\u00dbp\t\u0010Ga\u0015\u0090\u0002}O?{\u001b\u00ceCe\u00e5\u00c5%\u00ad\u00d1\u00e9I\u00e21\u00aa\"\u0010\u00ba\u00b5Z]\u0013H\u0080]\u00ffRh\u00ef\u0089\u00daO\u0082\u0005\u0004\u009d\u00f7\u0089Y\bo\u009d\u00c3n\u00b5(\u00fb?\u0013\u001a\u0005JO}(<\u009a_\rP\u007fa\u00fb>\u00a8\u00fb\u0087\u00a5\u0013[v\u00185\u001bPgRh!\u00bd0\u00b4\u00e7\u0087j\u00e5\u00f9k\u001b\u00e0uNk\u00fd#\u009d0o\u0080\u00c9\u0087\u00e3k\u00f5F\u00ef\u00fe\\\u0019\u00b13\u009e\u00e1v\u00e1\u009b\u0003\u00afd\u009d:\u008b:\u0002\u00bcXa\u000ft~\u00f0\u0010\u00a2\u00fcS\u008f\u00be\u00ea\u0014f\u00a4\u00ce\u001e\u009bP\u0080G\u0015d@\u00ab\u00a3\u0001\u00efd\u00054X\u0004\u0017B\u00a8\u00aaA\u00ba\u00d1\u00c0\u009f\u00d5\u00cf\u00a5X[\f\u000f\u00a4`a\u00e6\u0016\u001a\u0091*\u00c7\r\u001e\u008f\u00d7,eE\u0095\u00e3\u00bb\u001eq\u008dy>\u00a5\u00ech\u001f\u00e0\u007fh\u00e2\u00fc\u009dDo\u0003\u0093h\u00c6\u00c0\u00ce\f\u0011W\f\u00b7\u00b6s~R\u001aL6\u00849`u\u0091\t(kx\u0098\u00ce\u00f5\u0017\u00aa\u00f4\u0010\u000e\u00cc\u00c8v-\u000f6~\u001e\u0091x\u00d6u\u00a2\u00c4\u00e8\u0019\u00bd\u00f0\u00f9{\u009b\u0084\u00b2\u00ee\u0010\u000e\u0093\u0019d\u00ec,\u00b4\u0018\u0011K\u00f5N\u00b3C\u00a8\u00027\u00c7\u00e1Y\u00aa\u0012\u00b5*>\r\"\u0017\u0017(\u00a7\u00f67\\\u009e\u001d3\u00d0\u0080h\u001d\u00e6\u00fb,\u0097\u00abJ\u00a3F=\u00f9\u00bcX\u00b7\u00b7^\u00a2\u00ff\u00b8jTZP\u0092\u001c\u00b6!\u00f4\u00b4ux\u00f0\u0017P\u0017\u0003\rT`\u0019\u0093\u00fb,\u00c4a\u00e3E&4\u00a6u\u00de\u00b7\u00a3\u009c\u00c8\u001a\u00d4*\u00e4i(\u00e0\u0013\b\u00bd\u00d7n\u00b4\u00a3n\u00e3o\u0017\u0087\u00a4Vm\u00901p\u00d5{\u0006\u00a5\u001f\u00d6\u00ee\u00f1\u00ff-x=d\u00e9\u00ca\u009b\u00a0)\u0088G\u00e2\u009dTR\u00df\u00db#U\u0099\u00c9PDi%\u0091\u00cf\u00ba\u00d3\u008c3\u0013\u00fb\u00f2\u00f5\u00eb!5z\u001d\u0091\u00c8&JR\\\u00199\n.\u00ae\u00f1\u0014\u00ad\u001dm\u00fd\u0016[\u00a9\u001a`\u00d2\u00d40.\u00fb\u00d7\u0019\u00b7\u00a4\u00bd \u00fel\u00b1\u00c8\u0096\u009e\u0011\u00a3\u008b\u0000G\u00f4\u0085\u00f78\u009b\u00ad\u000e\u000f\u00ac\u001f\u001d\u009c\u0004\u00e5\u00df\u0085~\u00fd\u00cds&&7\u00c9!?.\u00f4@\u00c1N\u00ad\u00d5\u00cc\u00fd\u00f6J`\u0010\u00ce0\u00d0ex\u00cbDd\u00f4\u00e1r\u00b2l,\u001b\u00af\u008d\u00c0\u00a8\u00dbG-n\u00e7\u00e0\u0013(\u00a3\u00e9\u00fb{4\u0011\u00fa\u0005\u00bd\u0013S\u00c1\u00d5\u00d8g\u00e2\u00ad\u00c9\u00a2\u00af\u00c5\u001b\u0002~\u00db[q)\u00b6\u0005\n\u00ca5\u00d4Op3\u0096\u00e6-\u0017\u00c6x\u00d1\u00e0\u000e\u00ddR$\u0092\u00da\u00e9\u00bfF\u009e\u0092O0\u001a\f[\u00f9-\u0091U\u00b7\u00d1n8\u00ed\u008f\u0097;\u00ba\u0082\u00f1\t\u00e6%j\"9\u00a1\u00d8\u0083\u000f\ty\u0015\u0015kH\u0089\u0080\b\u0087\u00eb\u0090H\\\u00f41\u00e0\u0019\u00a2\u0084\u000b\u00fc\u00fcISp\u00b2\u001a\u00e0\u00c9n\t\u00f4\u009f\u0098\u0090\u00d5|O&\u0013[\u00efD\u00a8\u00e5\u00a7\u00cc<@x\u00e7\u0098\u008b'\u0085u\u00a1\"\u00b2/P\u00cf\u00ff\u001e\u00cb\nk\u000fP\u00a2\u00e2,\u00e3\u0080\u0083\u00b5\u00a3\u0081\u00a8\u00b9w:\u00c5e\u00f8\u00f0W\u00fbL&Q\u00c0\u009c\u00dbA\t\u00b5[\u00c9J\u00c7{\u00e5\u0001\u00116I\u00c0\u001c\u00e4x\u00d4\u0019\u00ce.|\u0006\u00d5a\u0004\u00afj/\u00c5e\u000e\u00b6\u00be\\k\u00118\u00d8\u0001\u00a1:\u00ccD\"\u009byQ.X\u0091\u00e4\u00f1\u001b\u00e6\u00a7\u00ea\u009c\u00fa\u00be\u00bb\u001e\u00af\u00c7C;\u001ew\u00ca\u00fc\u0017\u00a2\u00a1\u00bcL(\u008c\u00fa4\u008c\u00b1M\u00bf\u00cb\u00faR}\n\u00f3\t\u009b\u0087*(A\u00b3\u00eb+\u0092\u00c4!\u0081:9\u00c1Ej\u0085\u00a2\u0084\u0095|-\u00c7\u00fbC\u00a1\u0003 3\u0092s\u00a9\u00f5&V\u00a6dhQD\u00c9\u009c\u00c3H\u00ae\u0011\u0080\u00ee\u0098\u00fd\b\rw\u00c3\u00e3S^0\u00c3#\u00ec<\u00e9\u000b\u0087A\b+\u00bavj\u00ecL\u00ef\u00dd\u0012x\u00c5\u00c6`\u00dc\u00ba\u0000-J\u009b\u008c\u00bb\u008c\u00df\u0014\u00e1\u00fd\u00b6\u0003\u0006\u00c0=z\u00aadw\u0010\u009dE\u00baGc)\u00ff\u00ba'\t_\u00c5\u0090\u00c0T\u00b6\t\u00b4]\u00e8\u00ab\u00a8\u0014:\u0094\u00c7\u0014\u0096\u00c8\u00b0\u0014=\u00a0\u00e7H\u00b4\u00ec\u0016\u00e5\u00c6\u00f9\u00c4w\u00d9PI\u00d3\t0Ax(\u00badx\u009a\u008f\bZ\u00db)v\u000e\u00ec\u009b\u0095\u0004\u00fd\u00b7\u009a\t\n\u00db\u00e4{\u00962\u001c\u0097\u00b54K\u000b3w&B\u00ed\u00d3\u009a\u00cbS\u0083\u00ff\u001cTI\u00fe\u0000.\u00c1\u001e\u00eaI\u00ec\r(\u0089\r\u000f\u008d4%\u00c2\u00a5\u00e3\u00fe\u00c2\u00f7\u009a\u00cc@\u00b3\u0010\u00d2\u00f5)E=^\u00a3\u0093\u00f9\u0000\u00ac5\u00ee#\u0090f\u001d\u00b9{D\u0094\u0090d\u0016\u00d4[\u00e4c(\u00a1\u0013 \u00bd\u00d2i\b\u00ebb\u0002\u007f\u00b90\u0094\u00e4w\u0006\u0010\u00dc\f\u00e8z\u0005\u00b9\u00a4o\u0019\u009f\u00b0\u00c6m]\u00e0\u00a9\u0013\u0006\u00d9\u00b3\u00c0n\u00ee\u00c9\u0085\u00b7\u00d3\u000bp\u00b5\u001a\u0094\u00d5\u0087Uk\bd\u00da\u00a8F\u00ad\u00b4-R\u0007\u0000\u001eB=\t^5\rD\u0011+Y\u00e0\u00bf_\u0093\u00e7\u00f4\u00d5\u00b5\u0098\u0016\u0091\u008bL]=f\u00b1\u00d8\u00e9\u00cd\u00f2\u00e4\u00e8\u0013B\u0013\u009e\u00a9\u009d[K\u00fc\t\u00a8\u00f1h\u00cb\u00cc\u009fW\u00e7\u00fc\u0007p\u00fd\u0018r\u0096\u00aa\u00c1\r\u00cd\u00a3\u001a\u000f\u00c6u\u009b\u00ca\u007f\u00df\u00c6\u00d0\u00fa".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 75;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "4\u0011\u0086p\u001a\u00bd+\u00dd\u00c4\u0013+E\u00e1\u00d7\u00de\u00a4\u00b7p\u00b3XZ\u0005+\u00c7&\u00ec\u00ab\u0090E9,_A4n\u0086\u00c1Z\u007f@\u0098\u00d4O;aD\u00ef2\u00c9z3\u00c1\u00e9:\u00ab\u0084\u00ac\u0084\u0012\u00d3@\u0085\u00dd*2\u00d3a\u0003_~8\u00ab\u00f9;0(<Jz v\u009d\u0091\u00f8\u0012\u00f3";
                    var4_3 = "4\u0011\u0086p\u001a\u00bd+\u00dd\u00c4\u0013+E\u00e1\u00d7\u00de\u00a4\u00b7p\u00b3XZ\u0005+\u00c7&\u00ec\u00ab\u0090E9,_A4n\u0086\u00c1Z\u007f@\u0098\u00d4O;aD\u00ef2\u00c9z3\u00c1\u00e9:\u00ab\u0084\u00ac\u0084\u0012\u00d3@\u0085\u00dd*2\u00d3a\u0003_~8\u00ab\u00f9;0(<Jz v\u009d\u0091\u00f8\u0012\u00f3".length();
                    var1_4 = 33;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 59;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 115;
                            break;
                        }
                        case 1: {
                            v15 = 1;
                            break;
                        }
                        case 2: {
                            v15 = 115;
                            break;
                        }
                        case 3: {
                            v15 = 85;
                            break;
                        }
                        case 4: {
                            v15 = 84;
                            break;
                        }
                        case 5: {
                            v15 = 35;
                            break;
                        }
                        default: {
                            v15 = 1;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        QuicClientStreamTransport.c = var5;
        QuicClientStreamTransport.d = new String[60];
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x4D0B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 184;
                case 1 -> 152;
                case 2 -> 40;
                case 3 -> 154;
                case 4 -> 190;
                case 5 -> 163;
                case 6 -> 35;
                case 7 -> 144;
                case 8 -> 192;
                case 9 -> 104;
                case 10 -> 207;
                case 11 -> 219;
                case 12 -> 85;
                case 13 -> 97;
                case 14 -> 157;
                case 15 -> 58;
                case 16 -> 105;
                case 17 -> 32;
                case 18 -> 65;
                case 19 -> 167;
                case 20 -> 49;
                case 21 -> 31;
                case 22 -> 141;
                case 23 -> 217;
                case 24 -> 215;
                case 25 -> 88;
                case 26 -> 198;
                case 27 -> 136;
                case 28 -> 57;
                case 29 -> 117;
                case 30 -> 175;
                case 31 -> 142;
                case 32 -> 95;
                case 33 -> 158;
                case 34 -> 153;
                case 35 -> 48;
                case 36 -> 21;
                case 37 -> 173;
                case 38 -> 24;
                case 39 -> 110;
                case 40 -> 131;
                case 41 -> 80;
                case 42 -> 34;
                case 43 -> 39;
                case 44 -> 0;
                case 45 -> 245;
                case 46 -> 240;
                case 47 -> 26;
                case 48 -> 236;
                case 49 -> 183;
                case 50 -> 74;
                case 51 -> 77;
                case 52 -> 100;
                case 53 -> 28;
                case 54 -> 71;
                case 55 -> 78;
                case 56 -> 150;
                case 57 -> 195;
                case 58 -> 42;
                case 59 -> 2;
                case 60 -> 115;
                case 61 -> 239;
                case 62 -> 138;
                case 63 -> 61;
                case 64 -> 120;
                case 65 -> 54;
                case 66 -> 250;
                case 67 -> 83;
                case 68 -> 72;
                case 69 -> 20;
                case 70 -> 140;
                case 71 -> 149;
                case 72 -> 122;
                case 73 -> 66;
                case 74 -> 176;
                case 75 -> 197;
                case 76 -> 193;
                case 77 -> 251;
                case 78 -> 25;
                case 79 -> 205;
                case 80 -> 214;
                case 81 -> 18;
                case 82 -> 113;
                case 83 -> 3;
                case 84 -> 79;
                case 85 -> 90;
                case 86 -> 73;
                case 87 -> 98;
                case 88 -> 213;
                case 89 -> 52;
                case 90 -> 87;
                case 91 -> 196;
                case 92 -> 23;
                case 93 -> 121;
                case 94 -> 238;
                case 95 -> 221;
                case 96 -> 9;
                case 97 -> 166;
                case 98 -> 164;
                case 99 -> 227;
                case 100 -> 62;
                case 101 -> 248;
                case 102 -> 133;
                case 103 -> 145;
                case 104 -> 254;
                case 105 -> 43;
                case 106 -> 232;
                case 107 -> 102;
                case 108 -> 204;
                case 109 -> 143;
                case 110 -> 171;
                case 111 -> 67;
                case 112 -> 41;
                case 113 -> 252;
                case 114 -> 19;
                case 115 -> 191;
                case 116 -> 209;
                case 117 -> 129;
                case 118 -> 203;
                case 119 -> 37;
                case 120 -> 216;
                case 121 -> 194;
                case 122 -> 201;
                case 123 -> 10;
                case 124 -> 148;
                case 125 -> 125;
                case 126 -> 178;
                case 127 -> 253;
                case 128 -> 30;
                case 129 -> 56;
                case 130 -> 50;
                case 131 -> 244;
                case 132 -> 243;
                case 133 -> 99;
                case 134 -> 60;
                case 135 -> 4;
                case 136 -> 46;
                case 137 -> 139;
                case 138 -> 222;
                case 139 -> 84;
                case 140 -> 11;
                case 141 -> 155;
                case 142 -> 230;
                case 143 -> 29;
                case 144 -> 233;
                case 145 -> 255;
                case 146 -> 33;
                case 147 -> 106;
                case 148 -> 5;
                case 149 -> 185;
                case 150 -> 44;
                case 151 -> 63;
                case 152 -> 81;
                case 153 -> 170;
                case 154 -> 199;
                case 155 -> 159;
                case 156 -> 134;
                case 157 -> 17;
                case 158 -> 22;
                case 159 -> 202;
                case 160 -> 111;
                case 161 -> 14;
                case 162 -> 137;
                case 163 -> 89;
                case 164 -> 224;
                case 165 -> 45;
                case 166 -> 53;
                case 167 -> 177;
                case 168 -> 223;
                case 169 -> 6;
                case 170 -> 186;
                case 171 -> 91;
                case 172 -> 235;
                case 173 -> 112;
                case 174 -> 101;
                case 175 -> 237;
                case 176 -> 168;
                case 177 -> 116;
                case 178 -> 174;
                case 179 -> 247;
                case 180 -> 75;
                case 181 -> 109;
                case 182 -> 179;
                case 183 -> 181;
                case 184 -> 86;
                case 185 -> 12;
                case 186 -> 162;
                case 187 -> 64;
                case 188 -> 130;
                case 189 -> 151;
                case 190 -> 160;
                case 191 -> 82;
                case 192 -> 96;
                case 193 -> 38;
                case 194 -> 128;
                case 195 -> 231;
                case 196 -> 135;
                case 197 -> 16;
                case 198 -> 124;
                case 199 -> 119;
                case 200 -> 249;
                case 201 -> 226;
                case 202 -> 13;
                case 203 -> 188;
                case 204 -> 70;
                case 205 -> 27;
                case 206 -> 146;
                case 207 -> 225;
                case 208 -> 1;
                case 209 -> 147;
                case 210 -> 126;
                case 211 -> 114;
                case 212 -> 118;
                case 213 -> 228;
                case 214 -> 246;
                case 215 -> 180;
                case 216 -> 8;
                case 217 -> 242;
                case 218 -> 103;
                case 219 -> 47;
                case 220 -> 211;
                case 221 -> 59;
                case 222 -> 7;
                case 223 -> 206;
                case 224 -> 165;
                case 225 -> 69;
                case 226 -> 229;
                case 227 -> 161;
                case 228 -> 94;
                case 229 -> 220;
                case 230 -> 172;
                case 231 -> 169;
                case 232 -> 123;
                case 233 -> 93;
                case 234 -> 241;
                case 235 -> 108;
                case 236 -> 200;
                case 237 -> 68;
                case 238 -> 212;
                case 239 -> 76;
                case 240 -> 187;
                case 241 -> 127;
                case 242 -> 182;
                case 243 -> 210;
                case 244 -> 92;
                case 245 -> 15;
                case 246 -> 36;
                case 247 -> 55;
                case 248 -> 132;
                case 249 -> 156;
                case 250 -> 208;
                case 251 -> 107;
                case 252 -> 189;
                case 253 -> 234;
                case 254 -> 218;
                default -> 51;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            QuicClientStreamTransport.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }
}

