/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "mapRangeTypeToPrimitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rangeType", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nRangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeTo.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class RangeTo
extends IntrinsicMethod {
    @NotNull
    public static final RangeTo INSTANCE = new RangeTo();

    private RangeTo() {
    }

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen, @NotNull BlockInfo data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JvmMethodSignature signature = codegen.getMethodSignatureMapper().mapSignatureSkipGeneric(((IrFunctionSymbol)expression2.getSymbol()).getOwner());
        Type type = signature.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getReturnType(...)");
        Type argType = this.mapRangeTypeToPrimitiveType(type);
        ExpressionCodegen $this$invoke_u24lambda_u240 = codegen;
        boolean bl = false;
        $this$invoke_u24lambda_u240.markLineNumber((IrElement)expression2, true);
        InstructionAdapter v = codegen.getMv();
        v.anew(signature.getReturnType());
        v.dup();
        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = expression2.getArguments();
        IrExpression arg0 = (IrExpression)((List)valueArgumentsList).get(0);
        IrExpression arg1 = (IrExpression)((List)valueArgumentsList).get(1);
        IrExpression irExpression = arg0;
        Intrinsics.checkNotNull((Object)irExpression);
        PromisedValueKt.materializeAt((PromisedValue)irExpression.accept((IrVisitor)codegen, (Object)data), argType, arg0.getType());
        IrExpression irExpression2 = arg1;
        Intrinsics.checkNotNull((Object)irExpression2);
        PromisedValueKt.materializeAt((PromisedValue)irExpression2.accept((IrVisitor)codegen, (Object)data), argType, arg1.getType());
        Type[] typeArray = new Type[]{argType, argType};
        v.invokespecial(signature.getReturnType().getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])typeArray), false);
        Type type2 = signature.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getReturnType(...)");
        return new MaterialValue(codegen, type2, expression2.getType());
    }

    private final Type mapRangeTypeToPrimitiveType(Type rangeType) {
        Type type;
        String fqName = rangeType.getInternalName();
        Intrinsics.checkNotNull((Object)fqName);
        switch (StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)fqName, (String)"kotlin/ranges/", null, (int)2, null), (String)"Range", null, (int)2, null)) {
            case "Double": {
                Type type2 = Type.DOUBLE_TYPE;
                type = type2;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"DOUBLE_TYPE");
                break;
            }
            case "Float": {
                Type type3 = Type.FLOAT_TYPE;
                type = type3;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"FLOAT_TYPE");
                break;
            }
            case "Long": {
                Type type4 = Type.LONG_TYPE;
                type = type4;
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"LONG_TYPE");
                break;
            }
            case "Int": {
                Type type5 = Type.INT_TYPE;
                type = type5;
                Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"INT_TYPE");
                break;
            }
            case "Short": {
                Type type6 = Type.SHORT_TYPE;
                type = type6;
                Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"SHORT_TYPE");
                break;
            }
            case "Char": {
                Type type7 = Type.CHAR_TYPE;
                type = type7;
                Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"CHAR_TYPE");
                break;
            }
            case "Byte": {
                Type type8 = Type.BYTE_TYPE;
                type = type8;
                Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"BYTE_TYPE");
                break;
            }
            default: {
                throw new IllegalStateException("RangeTo intrinsic can only work for primitive types: " + fqName);
            }
        }
        return type;
    }
}

