/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBlock;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBuilder;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrTypeParameterBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMetadataSourceOwner;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@PhaseDescription(name="FunctionReference")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0001\u0018\u0000 L2\u00020\u00012\u00020\u0002:\u0002KLB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\fH\u0002J \u0010!\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J \u0010.\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020$H\u0002J$\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020)2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001c03H\u0002J,\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u001e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001c03H\u0002J,\u0010=\u001a\u00020>2\u0006\u00105\u001a\u00020-2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010?\u001a\u00020@2\b\b\u0002\u0010A\u001a\u00020@H\u0002J\u0014\u0010B\u001a\u00020C*\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\u001a\u0010G\u001a\u00020H*\u00020D2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020F0JH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0010\u0012\f\u0012\n <*\u0004\u0018\u00010;0;0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "crossinlineLambdas", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "isIgnored", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "isSuspendFunctionReference", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldGenerateIndySamConversions", "shouldGenerateIndyLambdas", "getShouldGenerateIndyLambdas", "()Z", "shouldGenerateLightweightLambdas", "getShouldGenerateLightweightLambdas", "isJavaSamConversionWithEqualsHashCode", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "processBlock", "forceSerializability", "wrapLambdaReferenceWithIndySamConversion", "reference", "lambdaMetafactoryArguments", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/LambdaMetafactoryArguments;", "visitFunctionReference", "getDeclarationParentForDelegatingLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "createProxyLocalFunctionForIndySamConversion", "canGenerateIndySamConversionOnFunctionalExpression", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "wrapSamDelegatingLambdaWithIndySamConversion", "lambdaBlock", "Lorg/jetbrains/kotlin/backend/jvm/lower/indy/SamDelegatingLambdaBlock;", "wrapSamConversionArgumentWithIndySamConversion", "produceSamConversion", "Lkotlin/Function1;", "wrapFunctionReferenceInsideBlockWithIndySamConversion", "samType", "block", "jvmIndyLambdaMetafactoryIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "specialNullabilityAnnotationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm.PlatformType", "wrapWithIndySamConversion", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "startOffset", "", "endOffset", "irRawFunctionRef", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrRawFunctionReferenceImpl;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irFun", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irVarargOfRawFunctionRefs", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrVarargImpl;", "irFuns", "", "FunctionReferenceBuilder", "Companion", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n+ 2 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocatorKt\n+ 3 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,926:1\n251#2,11:927\n47#3,4:938\n2791#4,3:942\n1914#4,2:945\n1914#4,2:947\n1660#4,3:958\n1585#4:963\n1660#4,3:964\n269#5,4:949\n363#5,4:967\n406#6,5:953\n411#6:961\n1#7:962\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n*L\n60#1:927,11\n65#1:938,4\n78#1:942,3\n98#1:945,2\n163#1:947,2\n311#1:958,3\n430#1:963\n430#1:964,3\n253#1:949,4\n288#1:967,4\n311#1:953,5\n311#1:961\n*E\n"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashSet<IrSimpleFunction> crossinlineLambdas;
    private final boolean shouldGenerateIndySamConversions;
    private final boolean isJavaSamConversionWithEqualsHashCode;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Set<FqName> specialNullabilityAnnotationsFqNames;

    public FunctionReferenceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.crossinlineLambdas = new HashSet();
        this.shouldGenerateIndySamConversions = this.context.getConfig().getSamConversionsScheme() == JvmClosureGenerationScheme.INDY;
        this.isJavaSamConversionWithEqualsHashCode = this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
        this.jvmIndyLambdaMetafactoryIntrinsic = this.context.getSymbols().getIndyLambdaMetafactoryIntrinsic();
        Object[] objectArray = new FqName[]{JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION};
        this.specialNullabilityAnnotationsFqNames = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return !IrTypeUtilsKt.isFunctionOrKFunction((IrType)$this$isIgnored.getType()) && !this.isSuspendFunctionReference($this$isIgnored) || Intrinsics.areEqual((Object)$this$isIgnored.getOrigin(), (Object)IrStatementOrigin.Companion.getINLINE_LAMBDA());
    }

    private final boolean isSuspendFunctionReference(IrFunctionReference $this$isSuspendFunctionReference) {
        return IrUtilsKt.isSuspend((IrFunctionReference)$this$isSuspendFunctionReference) && ($this$isSuspendFunctionReference.getOrigin() == null || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()) || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()));
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrFile irFile) {
        void this_$iv;
        IrElementTransformerVoidWithContext $this$findInlineLambdas$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrFile irFile2 = irFile;
        JvmBackendContext context$iv = this.context;
        boolean $i$f$findInlineLambdas = false;
        $this$findInlineLambdas$iv.accept((IrVisitor)new IrInlineReferenceLocator(context$iv, this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = functionReferenceLowering;
                super($context);
            }

            /*
             * WARNING - void declaration
             */
            public void visitInlineLambda(IrFunctionReference argument, IrFunction callee, IrValueParameter parameter, IrDeclaration scope) {
                void parameter2;
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                IrValueParameter irValueParameter = parameter;
                IrFunctionReference argument2 = argument;
                boolean bl = false;
                if (parameter2.isCrossinline()) {
                    HashSet hashSet = FunctionReferenceLowering.access$getCrossinlineLambdas$p(this.this$0);
                    IrFunction irFunction = ((IrFunctionSymbol)argument2.getSymbol()).getOwner();
                    Intrinsics.checkNotNull((Object)irFunction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                    hashSet.add((IrSimpleFunction)irFunction);
                }
            }
        }, null);
        $this$findInlineLambdas$iv = this;
        IrSymbolOwner declaration$iv = (IrSymbolOwner)irFile;
        boolean $i$f$withinScope = false;
        IrElementTransformerVoidWithContext.access$unsafeEnterScope((IrElementTransformerVoidWithContext)this_$iv, (IrSymbolOwner)declaration$iv);
        boolean bl = false;
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        Unit result$iv = Unit.INSTANCE;
        IrElementTransformerVoidWithContext.access$unsafeLeaveScope((IrElementTransformerVoidWithContext)this_$iv);
        this.crossinlineLambdas.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldGenerateIndyLambdas() {
        IrMetadataSourceOwner irMetadataSourceOwner;
        if (this.context.getConfig().getLambdasScheme() != JvmClosureGenerationScheme.INDY) return false;
        Iterable $this$none$iv = this.getAllScopes();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ScopeWithIr it = (ScopeWithIr)element$iv;
            boolean bl = false;
            IrElement irElement = it.getIrElement();
            irMetadataSourceOwner = irElement instanceof IrMetadataSourceOwner ? (IrMetadataSourceOwner)irElement : null;
        } while (!((irMetadataSourceOwner != null ? irMetadataSourceOwner.getMetadata() : null) instanceof MetadataSource.CodeFragment));
        return false;
    }

    private final boolean getShouldGenerateLightweightLambdas() {
        return this.getShouldGenerateIndyLambdas() && this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.LightweightLambdas);
    }

    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.processBlock(expression2, false);
    }

    private final IrExpression processBlock(IrBlock expression2, boolean forceSerializability) {
        MetafactoryArgumentsResult lambdaMetafactoryArguments;
        if (!IrUtilsKt.isLambda((IrStatementOrigin)expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        Object object = CollectionsKt.last((List)expression2.getStatements());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        IrFunctionReference reference = (IrFunctionReference)object;
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform((IrTransformer)this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)reference), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        if (this.getShouldGenerateIndyLambdas() && (lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference, reference.getType(), true, forceSerializability)) instanceof LambdaMetafactoryArguments) {
            return (IrExpression)this.wrapLambdaReferenceWithIndySamConversion(expression2, reference, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
        }
        return new FunctionReferenceBuilder(this, reference, null, 2, null).build();
    }

    private final IrBlock wrapLambdaReferenceWithIndySamConversion(IrBlock expression2, IrFunctionReference reference, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = FunctionReferenceLowering.wrapWithIndySamConversion$default(this, reference.getType(), lambdaMetafactoryArguments, 0, 0, 12, null);
        expression2.getStatements().set(expression2.getStatements().size() - 1, indySamConversion);
        expression2.setType(indySamConversion.getType());
        return expression2;
    }

    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(this, expression2, null, 2, null).build();
    }

    private final IrDeclarationParent getDeclarationParentForDelegatingLambda() {
        for (ScopeWithIr s : CollectionsKt.asReversedMutable((List)this.getAllScopes())) {
            IrSymbolOwner scopeOwner = s.getScope().getScopeOwnerSymbol().getOwner();
            if (!(scopeOwner instanceof IrDeclarationParent)) continue;
            return (IrDeclarationParent)scopeOwner;
        }
        throw new AssertionError((Object)("No IrDeclarationParent found in scopes:\n" + CollectionsKt.joinToString$default((Iterable)this.getAllScopes(), (CharSequence)"\n", null, null, (int)0, null, FunctionReferenceLowering::getDeclarationParentForDelegatingLambda$lambda$0, (int)30, null)));
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return super.visitTypeOperator(expression2);
        }
        IrType samSuperType = expression2.getTypeOperand();
        IrExpression invokable = expression2.getArgument();
        if (invokable instanceof IrFunctionReference) {
            irFunctionReference = (IrFunctionReference)invokable;
        } else if (invokable instanceof IrBlock && IrUtilsKt.isLambda((IrStatementOrigin)((IrBlock)invokable).getOrigin()) && CollectionsKt.last((List)((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
            Iterable $this$forEach$iv = CollectionsKt.dropLast((List)((IrBlock)invokable).getStatements(), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                it.transform((IrTransformer)this, null);
            }
            Object object = CollectionsKt.last((List)((IrBlock)invokable).getStatements());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            irFunctionReference = (IrFunctionReference)object;
        } else {
            if (this.shouldGenerateIndySamConversions && this.canGenerateIndySamConversionOnFunctionalExpression(samSuperType, invokable)) {
                SamDelegatingLambdaBuilder samDelegatingLambdaBuilder = new SamDelegatingLambdaBuilder(this.context);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                SamDelegatingLambdaBlock lambdaBlock = samDelegatingLambdaBuilder.build(invokable, samSuperType, scopeWithIr.getScope().getScopeOwnerSymbol(), this.getDeclarationParentForDelegatingLambda());
                MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(lambdaBlock.getRef(), samSuperType, false, false);
                if (!(lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments)) {
                    return super.visitTypeOperator(expression2);
                }
                if (invokable instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)invokable).getOperator() == IrTypeOperator.IMPLICIT_CAST && ((IrTypeOperatorCall)invokable).getArgument() instanceof IrBlock) {
                    IrTypeOperatorCall irTypeOperatorCall = (IrTypeOperatorCall)invokable;
                    IrExpression irExpression = ((IrTypeOperatorCall)invokable).getArgument();
                    Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlock");
                    irTypeOperatorCall.setArgument(this.processBlock((IrBlock)irExpression, ((LambdaMetafactoryArguments)lambdaMetafactoryArguments).getShouldBeSerializable()));
                } else {
                    this.transformChildrenVoid((IrElement)invokable);
                }
                return this.wrapSamDelegatingLambdaWithIndySamConversion(samSuperType, lambdaBlock, (LambdaMetafactoryArguments)lambdaMetafactoryArguments);
            }
            return super.visitTypeOperator(expression2);
        }
        IrFunctionReference reference = irFunctionReference;
        this.transformChildrenVoid((IrElement)reference);
        if (this.shouldGenerateIndySamConversions) {
            MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(reference, samSuperType, false, false);
            if (lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceLowering.visitTypeOperator$lambda$1(this, lambdaMetafactoryArguments, expression2, arg_0)));
            }
            if (lambdaMetafactoryArguments instanceof MetafactoryArgumentsResult.Failure.FunctionHazard) {
                IrBlock proxyLocalFunBlock = this.createProxyLocalFunctionForIndySamConversion(reference);
                Object e = proxyLocalFunBlock.getStatements().get(proxyLocalFunBlock.getStatements().size() - 1);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference proxyLocalFunRef = (IrFunctionReference)e;
                MetafactoryArgumentsResult proxyLambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(proxyLocalFunRef, samSuperType, false, false);
                if (proxyLambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
                    return this.wrapSamConversionArgumentWithIndySamConversion(expression2, (Function1<? super IrType, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceLowering.visitTypeOperator$lambda$2(proxyLocalFunBlock, this, proxyLambdaMetafactoryArguments, arg_0)));
                }
            }
        }
        IrType erasedSamSuperType = JvmIrUtilsKt.rawType(IrTypeErasureUtilsKt.getErasedUpperBound((IrType)samSuperType), this.context);
        return new FunctionReferenceBuilder(this, reference, erasedSamSuperType).build();
    }

    /*
     * WARNING - void declaration
     */
    private final IrBlock createProxyLocalFunctionForIndySamConversion(IrFunctionReference reference) {
        IrBlockBody irBlockBody;
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        int startOffset = reference.getStartOffset();
        int endOffset = reference.getEndOffset();
        IrFunction targetFun = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        ArrayList<IrVariable> temporaryVals = new ArrayList<IrVariable>();
        IrFunction irFunction = targetFun;
        if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner((IrCallImpl.Companion)IrCallImpl.Companion, (int)startOffset, (int)endOffset, (IrSimpleFunctionSymbol)((IrSimpleFunction)targetFun).getSymbol());
        } else if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)startOffset, (int)endOffset, (IrType)targetFun.getReturnType(), (IrConstructorSymbol)((IrConstructor)targetFun).getSymbol(), null, (int)16, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression targetCall = irFunctionAccessExpression;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = false;
        Name name = Name.identifier((String)(targetFun.getName().asString() + "__proxy"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setName(name);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setReturnType(IrTypeErasureUtilsKt.eraseTypeParameters((IrType)targetFun.getReturnType()));
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setModality(Modality.FINAL);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setSuspend(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setInline(false);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u240.setOrigin(targetFun.isInline() || VarargLoweringKt.isArrayOf(targetFun) ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getPROXY_FUN_FOR_METAFACTORY() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_PROXY_FUN_FOR_METAFACTORY());
        IrFactory proxyFun = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
        boolean bl2 = false;
        IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
        if (irDeclarationParent == null) {
            throw new AssertionError((Object)("No declaration parent when processing " + reference));
        }
        proxyFun.setParent(irDeclarationParent);
        Ref.IntRef temporaryValIndex = new Ref.IntRef();
        Ref.IntRef proxyParameterIndex = new Ref.IntRef();
        List $i$a$-buildFun-FunctionReferenceLowering$createProxyLocalFunctionForIndySamConversion$proxyFun$22 = (List)targetCall.getArguments();
        Collection other$iv = CollectionsKt.zip((Iterable)((Iterable)reference.getArguments()), (Iterable)targetFun.getParameters());
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            IrExpression boundValue = (IrExpression)pair.component1();
            IrValueParameter parameter = (IrValueParameter)pair.component2();
            collection.add(FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$1$getTargetCallArgument(startOffset, endOffset, temporaryValIndex, (IrSimpleFunction)proxyFun, temporaryVals, proxyParameterIndex, boundValue, parameter));
        }
        int n = ((Collection)targetFun.getTypeParameters()).size();
        for (int typeParameterIndex = 0; typeParameterIndex < n; ++typeParameterIndex) {
            targetCall.getTypeArguments().set(typeParameterIndex, reference.getTypeArguments().get(typeParameterIndex));
        }
        IrBlockBody it = irBlockBody = this.context.getIrFactory().createBlockBody(startOffset, endOffset);
        boolean bl4 = false;
        proxyFun.setBody((IrBody)it);
        IrBlockBody proxyFunBody = irBlockBody;
        boolean bl5 = IrTypePredicatesKt.isUnit((IrType)targetFun.getReturnType()) ? proxyFunBody.getStatements().add(targetCall) : proxyFunBody.getStatements().add(new IrReturnImpl(startOffset, endOffset, this.context.getIrBuiltIns().getNothingType(), (IrReturnTargetSymbol)proxyFun.getSymbol(), (IrExpression)targetCall));
        IrFactory proxyFun2 = $this$buildFun$iv;
        IrFunctionReferenceImpl proxyFunRef = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrFunctionReferenceImpl$default((int)startOffset, (int)endOffset, (IrType)reference.getType(), (IrFunctionSymbol)((IrFunctionSymbol)proxyFun2.getSymbol()), (int)0, null, null, (int)96, null);
        return (IrBlock)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl((int)startOffset, (int)endOffset, (IrType)reference.getType(), null, (List)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)temporaryVals, (Object)proxyFun2), (Object)proxyFunRef));
    }

    private final boolean canGenerateIndySamConversionOnFunctionalExpression(IrType samSuperType, IrExpression expression2) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)samSuperType);
        if (irClassSymbol == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render$default((IrType)samSuperType, null, (int)1, null)));
        }
        IrClassSymbol samClass = irClassSymbol;
        if (!IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)samClass.getOwner())) || this.isJavaSamConversionWithEqualsHashCode) {
            return false;
        }
        return !(expression2 instanceof IrBlock) || !Intrinsics.areEqual((Object)((IrBlock)expression2).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
    }

    private final IrExpression wrapSamDelegatingLambdaWithIndySamConversion(IrType samSuperType, SamDelegatingLambdaBlock lambdaBlock, LambdaMetafactoryArguments lambdaMetafactoryArguments) {
        IrCall indySamConversion = FunctionReferenceLowering.wrapWithIndySamConversion$default(this, samSuperType, lambdaMetafactoryArguments, 0, 0, 12, null);
        lambdaBlock.replaceRefWith((IrExpression)indySamConversion);
        return (IrExpression)lambdaBlock.getBlock();
    }

    private final IrExpression wrapSamConversionArgumentWithIndySamConversion(IrTypeOperatorCall expression2, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression irExpression;
        IrType samType = expression2.getTypeOperand();
        IrExpression argument = expression2.getArgument();
        if (argument instanceof IrFunctionReference) {
            irExpression = (IrExpression)produceSamConversion.invoke((Object)samType);
        } else if (argument instanceof IrBlock) {
            irExpression = this.wrapFunctionReferenceInsideBlockWithIndySamConversion(samType, (IrBlock)argument, produceSamConversion);
        } else {
            throw new AssertionError((Object)("Block or function reference expected: " + RenderIrElementKt.render$default((IrElement)((IrElement)expression2), null, (int)1, null)));
        }
        return irExpression;
    }

    private final IrExpression wrapFunctionReferenceInsideBlockWithIndySamConversion(IrType samType, IrBlock block, Function1<? super IrType, ? extends IrExpression> produceSamConversion) {
        IrExpression indySamConversion = (IrExpression)produceSamConversion.invoke((Object)samType);
        block.getStatements().set(block.getStatements().size() - 1, indySamConversion);
        block.setType(indySamConversion.getType());
        return (IrExpression)block;
    }

    private final IrCall wrapWithIndySamConversion(IrType samType, LambdaMetafactoryArguments lambdaMetafactoryArguments, int startOffset, int endOffset) {
        IrCall irCall;
        IrType notNullSamType = IrTypesKt.removeAnnotations((IrType)IrTypesKt.makeNotNull((IrType)samType), arg_0 -> FunctionReferenceLowering.wrapWithIndySamConversion$lambda$0(this, arg_0));
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        JvmIrBuilder $this$wrapWithIndySamConversion_u24lambda_u241 = JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
        boolean bl = false;
        IrCall $this$wrapWithIndySamConversion_u24lambda_u241_u240 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)((IrBuilder)$this$wrapWithIndySamConversion_u24lambda_u241), (IrSimpleFunctionSymbol)this.jvmIndyLambdaMetafactoryIntrinsic, (IrType)notNullSamType, (int)0, null, (int)12, null);
        boolean bl2 = false;
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getTypeArguments().set(0, notNullSamType);
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getArguments().set(0, (Object)this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u241, (IrFunction)lambdaMetafactoryArguments.getSamMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getArguments().set(1, (Object)lambdaMetafactoryArguments.getImplMethodReference());
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getArguments().set(2, (Object)this.irRawFunctionRef($this$wrapWithIndySamConversion_u24lambda_u241, (IrFunction)lambdaMetafactoryArguments.getFakeInstanceMethod()));
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getArguments().set(3, (Object)this.irVarargOfRawFunctionRefs($this$wrapWithIndySamConversion_u24lambda_u241, lambdaMetafactoryArguments.getExtraOverriddenMethods()));
        $this$wrapWithIndySamConversion_u24lambda_u241_u240.getArguments().set(4, (Object)ExpressionHelpersKt.irBoolean((IrBuilder)((IrBuilder)$this$wrapWithIndySamConversion_u24lambda_u241), (boolean)lambdaMetafactoryArguments.getShouldBeSerializable()));
        return irCall;
    }

    static /* synthetic */ IrCall wrapWithIndySamConversion$default(FunctionReferenceLowering functionReferenceLowering, IrType irType, LambdaMetafactoryArguments lambdaMetafactoryArguments, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        return functionReferenceLowering.wrapWithIndySamConversion(irType, lambdaMetafactoryArguments, n, n2);
    }

    private final IrRawFunctionReferenceImpl irRawFunctionRef(IrBuilderWithScope $this$irRawFunctionRef, IrFunction irFun) {
        return ExpressionHelpersKt.irRawFunctionReference((IrBuilder)((IrBuilder)$this$irRawFunctionRef), (IrType)$this$irRawFunctionRef.getContext().getIrBuiltIns().getAnyType(), (IrFunctionSymbol)irFun.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrVarargImpl irVarargOfRawFunctionRefs(IrBuilderWithScope $this$irVarargOfRawFunctionRefs, List<? extends IrFunction> irFuns) {
        Collection<IrRawFunctionReferenceImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = irFuns;
        IrType irType = $this$irVarargOfRawFunctionRefs.getContext().getIrBuiltIns().getAnyType();
        IrBuilder irBuilder = (IrBuilder)$this$irVarargOfRawFunctionRefs;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrFunction irFunction = (IrFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.irRawFunctionRef($this$irVarargOfRawFunctionRefs, (IrFunction)it));
        }
        collection = (List)destination$iv$iv;
        return ExpressionHelpersKt.irVararg((IrBuilder)irBuilder, (IrType)irType, (List)collection);
    }

    private static final CharSequence getDeclarationParentForDelegatingLambda$lambda$0(ScopeWithIr it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + RenderIrElementKt.render$default((IrElement)((IrElement)it.getScope().getScopeOwnerSymbol().getOwner()), null, (int)1, null);
    }

    private static final IrExpression visitTypeOperator$lambda$1(FunctionReferenceLowering this$0, MetafactoryArgumentsResult $lambdaMetafactoryArguments, IrTypeOperatorCall $expression, IrType samType) {
        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
        return (IrExpression)this$0.wrapWithIndySamConversion(samType, (LambdaMetafactoryArguments)$lambdaMetafactoryArguments, $expression.getStartOffset(), $expression.getEndOffset());
    }

    private static final IrExpression visitTypeOperator$lambda$2(IrBlock $proxyLocalFunBlock, FunctionReferenceLowering this$0, MetafactoryArgumentsResult $proxyLambdaMetafactoryArguments, IrType samType) {
        Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
        $proxyLocalFunBlock.getStatements().set($proxyLocalFunBlock.getStatements().size() - 1, FunctionReferenceLowering.wrapWithIndySamConversion$default(this$0, samType, (LambdaMetafactoryArguments)$proxyLambdaMetafactoryArguments, 0, 0, 12, null));
        $proxyLocalFunBlock.setType(samType);
        return (IrExpression)$proxyLocalFunBlock;
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$1$addAndGetTemporaryVal(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, IrExpression initializer) {
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        IrVariableSymbol irVariableSymbol = (IrVariableSymbol)new IrVariableSymbolImpl(null, 1, null);
        int n = temporaryValIndex.element;
        temporaryValIndex.element = n + 1;
        Name name = Name.identifier((String)("tmp_proxy_" + n));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        IrVariableImpl tmpVal = BuildersKt.IrVariableImpl((int)startOffset, (int)endOffset, (IrDeclarationOrigin)irDeclarationOrigin, (IrVariableSymbol)irVariableSymbol, (Name)name, (IrType)initializer.getType(), (boolean)false, (boolean)false, (boolean)false);
        tmpVal.setInitializer(initializer);
        tmpVal.setParent($proxyFun.getParent());
        temporaryVals.add((IrVariable)tmpVal);
        return (IrGetValue)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default((int)startOffset, (int)endOffset, (IrValueSymbol)((IrValueSymbol)tmpVal.getSymbol()), null, (int)8, null);
    }

    private static final IrGetValue createProxyLocalFunctionForIndySamConversion$lambda$1$addAndGetProxyValueParameter(IrSimpleFunction $proxyFun, int startOffset, int endOffset, Ref.IntRef proxyParameterIndex, IrValueParameter originalParameter) {
        IrValueParameter irValueParameter;
        IrDeclaration declaration$iv = (IrDeclaration)$proxyFun;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u240 = $this$buildValueParameter_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u240.updateFrom(originalParameter);
        Name name = Name.identifier((String)("" + 'p' + proxyParameterIndex.element + '$' + originalParameter.getName().asString()));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u240.setName(name);
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u240.setType(IrTypeErasureUtilsKt.eraseTypeParameters((IrType)originalParameter.getType()));
        int n = proxyParameterIndex.element;
        proxyParameterIndex.element = n + 1;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u240.setKind(IrParameterKind.Regular);
        IrValueParameter $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u241 = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)declaration$iv.getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((IrDeclarationParent)declaration$iv));
        boolean bl3 = false;
        $this$createProxyLocalFunctionForIndySamConversion_u24lambda_u241_u24addAndGetProxyValueParameter_u241.setParent((IrDeclarationParent)$proxyFun);
        IrValueParameter proxyParameter = irValueParameter;
        $proxyFun.setParameters(CollectionsKt.plus((Collection)$proxyFun.getParameters(), (Object)proxyParameter));
        return (IrGetValue)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default((int)startOffset, (int)endOffset, (IrValueSymbol)((IrValueSymbol)proxyParameter.getSymbol()), null, (int)8, null);
    }

    private static final IrExpression createProxyLocalFunctionForIndySamConversion$lambda$1$getTargetCallArgument(int startOffset, int endOffset, Ref.IntRef temporaryValIndex, IrSimpleFunction $proxyFun, ArrayList<IrVariable> temporaryVals, Ref.IntRef proxyParameterIndex, IrExpression boundValue, IrValueParameter originalParameter) {
        return boundValue != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$1$addAndGetTemporaryVal(startOffset, endOffset, temporaryValIndex, $proxyFun, temporaryVals, boundValue) : (originalParameter != null ? (IrExpression)FunctionReferenceLowering.createProxyLocalFunctionForIndySamConversion$lambda$1$addAndGetProxyValueParameter($proxyFun, startOffset, endOffset, proxyParameterIndex, originalParameter) : null);
    }

    private static final boolean wrapWithIndySamConversion$lambda$0(FunctionReferenceLowering this$0, IrConstructorCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.specialNullabilityAnnotationsFqNames.contains(IrTypesKt.getClassFqName((IrType)it.getType()));
    }

    public static final /* synthetic */ HashSet access$getCrossinlineLambdas$p(FunctionReferenceLowering $this) {
        return $this.crossinlineLambdas;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0019\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "<init>", "()V", "calculateOwnerKClass", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "calculateOwnerKClass$backend_jvm_lower", "getReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getReceiverField$backend_jvm_lower", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,926:1\n75#2,4:927\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n*L\n917#1:927,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$calculateOwnerKClass), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            return (IrExpression)JvmIrUtilsKt.kClassReference($this$calculateOwnerKClass, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(irContainer, $this$calculateOwnerKClass.getBackendContext()));
        }

        @NotNull
        public final IrField getReceiverField$backend_jvm_lower(@NotNull IrClass $this$getReceiverField, @NotNull JvmBackendContext context) {
            IrField irField;
            Intrinsics.checkNotNullParameter((Object)$this$getReceiverField, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            IrFactory $this$buildField$iv = context.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$getReceiverField_u24lambda_u240 = $this$buildField_u24lambda_u241$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"receiver");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            $this$getReceiverField_u24lambda_u240.setName(name);
            $this$getReceiverField_u24lambda_u240.setType(context.getIrBuiltIns().getAnyNType());
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
            $this$getReceiverField_u24lambda_u240.setVisibility(descriptorVisibility);
            IrField $this$getReceiverField_u24lambda_u241 = irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u241$iv);
            boolean bl3 = false;
            $this$getReceiverField_u24lambda_u241.setParent((IrDeclarationParent)$this$getReceiverField);
            return irField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u00172\u0006\u00100\u001a\u00020(H\u0002J\u0006\u00101\u001a\u00020\u0015J\u0016\u00102\u001a\u000203*\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0002J\b\u00107\u001a\u000208H\u0002J-\u00109\u001a\u000203*\u0002042\u0006\u0010:\u001a\u00020\"2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00150<\u00a2\u0006\u0002\b>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0011H\u0002J\b\u0010B\u001a\u00020@H\u0002J\b\u0010C\u001a\u00020\rH\u0002J\u0012\u0010D\u001a\u00020 2\b\u0010E\u001a\u0004\u0018\u00010FH\u0002J\f\u0010G\u001a\u000203*\u00020 H\u0002J\f\u0010H\u001a\u000203*\u00020 H\u0002J\u0016\u0010I\u001a\u000203*\u00020 2\b\u0010J\u001a\u0004\u0018\u00010FH\u0002J\u0018\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020 H\u0002J\u0014\u0010R\u001a\u00020\u0015*\u0002042\u0006\u0010S\u001a\u00020TH\u0002J\u0014\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020V0\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00050\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010N\u001a\u00020O*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "isLambda", "", "isLightweightLambda", "isHeavyweightLambda", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "parameterTypes", "", "argumentTypes", "referenceReturnType", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "superMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "adapteeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "adaptedReferenceOriginalTarget", "isFunInterfaceConstructorReference", "constructedFunInterfaceSymbol", "isAdaptedReference", "samInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isKotlinFunInterface", "needToGenerateSamEqualsHashCodeMethods", "superType", "functionReferenceClass", "createFakeFormalTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "sourceTypeParameters", "irClass", "build", "generateSamEqualsHashCodeMethods", "", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "boundReceiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "generateConstructorCallArguments", "call", "generateBoundReceiver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "Lkotlin/ExtensionFunctionType;", "getFunctionReferenceFlags", "", "callableReferenceTarget", "getAdaptedCallableReferenceFlags", "hasVarargMappedToElement", "createInvokeMethod", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createLambdaInvokeMethod", "createFunInterfaceConstructorInvokeMethod", "createFunctionReferenceInvokeMethod", "receiver", "inlineAdapterCallIfPossible", "expression", "invokeMethod", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "createFakeBoundReceiverForJvmStaticInObject", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,926:1\n1585#2:927\n1660#2,3:928\n1585#2:935\n1660#2,2:936\n1662#2:942\n1299#2,2:943\n1314#2,4:945\n1585#2:949\n1660#2,3:950\n1806#2,3:1002\n1204#2,2:1025\n1281#2,4:1027\n51#3,4:931\n406#3,4:938\n321#3:969\n315#3,13:970\n281#3:1005\n275#3:1006\n269#3,10:1007\n331#3,8:1017\n369#3,7:1031\n363#3,4:1038\n379#4,13:953\n423#4,5:995\n133#5,2:966\n1#6:968\n350#7,12:983\n350#7,12:1042\n76#8,2:1000\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n*L\n449#1:927\n449#1:928,3\n559#1:935\n559#1:936,2\n559#1:942\n565#1:943,2\n565#1:945,4\n568#1:949\n568#1:950,3\n709#1:1002,3\n738#1:1025,2\n738#1:1027,4\n523#1:931,4\n560#1:938,4\n616#1:969\n616#1:970,13\n712#1:1005\n712#1:1006\n712#1:1007,10\n720#1:1017,8\n757#1:1031,7\n897#1:1038,4\n575#1:953,13\n652#1:995,5\n575#1:966,2\n645#1:983,12\n605#1:1042,12\n652#1:1000,2\n*E\n"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        private final boolean isLambda;
        private final boolean isLightweightLambda;
        private final boolean isHeavyweightLambda;
        @NotNull
        private final IrFunction callee;
        @Nullable
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @NotNull
        private final IrType referenceReturnType;
        @NotNull
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        @NotNull
        private final IrClassSymbol functionSuperClass;
        @NotNull
        private final IrSimpleFunction superMethod;
        @Nullable
        private final IrFunctionAccessExpression adapteeCall;
        @Nullable
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isFunInterfaceConstructorReference;
        @Nullable
        private final IrClassSymbol constructedFunInterfaceSymbol;
        private final boolean isAdaptedReference;
        @Nullable
        private final IrClass samInterface;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        @NotNull
        private final IrType superType;
        @NotNull
        private final IrClass functionReferenceClass;
        final /* synthetic */ FunctionReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@NotNull FunctionReferenceLowering this$0, @Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$functionReferenceClass_u24lambda_u241;
            void $this$functionReferenceClass_u24lambda_u240;
            IrClassSymbol irClassSymbol;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunctionAccessExpression irFunctionAccessExpression2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = IrUtilsKt.isLambda((IrStatementOrigin)this.irFunctionReference.getOrigin());
            this.isLightweightLambda = this.isLambda && this.this$0.getShouldGenerateLightweightLambdas() && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner()), (FqName)JvmStandardClassIds.JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME);
            this.isHeavyweightLambda = this.isLambda && !this.isLightweightLambda;
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)this.callee) ? this.createFakeBoundReceiverForJvmStaticInObject() : (Pair)CollectionsKt.singleOrNull((List)IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)((IrMemberAccessExpression)this.irFunctionReference)));
            IrType irType = this.irFunctionReference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Iterable iterable = ((IrSimpleType)irType).getArguments();
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrType irType2;
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var14_21 = it;
                if (var14_21 instanceof IrTypeProjection) {
                    irType2 = ((IrTypeProjection)it).getType();
                } else if (var14_21 instanceof IrStarProjection) {
                    irType2 = functionReferenceLowering.context.getIrBuiltIns().getAnyNType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(irType2);
            }
            functionReferenceBuilder.parameterTypes = (List)destination$iv$iv;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.referenceReturnType = (IrType)CollectionsKt.last(this.parameterTypes);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap((IrFunctionReference)this.irFunctionReference);
            IrType irType3 = this.samSuperType;
            if (irType3 == null || (irType3 = IrTypesKt.getClassOrNull((IrType)irType3)) == null) {
                irType3 = IrUtilsKt.isSuspend((IrFunctionReference)this.irFunctionReference) ? this.this$0.context.getIrBuiltIns().suspendFunctionN(this.argumentTypes.size()).getSymbol() : this.this$0.context.getIrBuiltIns().functionN(this.argumentTypes.size()).getSymbol();
            }
            this.functionSuperClass = irType3;
            IrSimpleFunction irSimpleFunction = JvmIrUtilsKt.getSingleAbstractMethod((IrClass)this.functionSuperClass.getOwner());
            if (irSimpleFunction == null) {
                throw new AssertionError((Object)("Not a SAM class: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.functionSuperClass.getOwner()), null, (int)1, null)));
            }
            this.superMethod = irSimpleFunction;
            if (Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE())) {
                IrStatement call;
                IrStatement irStatement;
                IrBody irBody = this.callee.getBody();
                Intrinsics.checkNotNull((Object)irBody);
                IrStatement statement = (IrStatement)CollectionsKt.single((List)IrUtilsKt.getStatements((IrBody)irBody));
                if (statement instanceof IrTypeOperatorCall) {
                    boolean bl = $i$f$map = ((IrTypeOperatorCall)statement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                    if (_Assertions.ENABLED && !$i$f$map) {
                        functionReferenceBuilder = this;
                        boolean $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = false;
                        FunctionReferenceBuilder functionReferenceBuilder2 = functionReferenceBuilder;
                        String $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22 = "Unexpected type operator in ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.callee), null, (int)1, null);
                        throw new AssertionError((Object)$i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$22);
                    }
                    irStatement = (IrStatement)((IrTypeOperatorCall)statement).getArgument();
                } else {
                    irStatement = call = statement instanceof IrReturn ? (IrStatement)((IrReturn)statement).getValue() : statement;
                }
                if (!(call instanceof IrFunctionAccessExpression)) {
                    throw new UnsupportedOperationException("Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.callee), null, (int)1, null));
                }
                irFunctionAccessExpression2 = (IrFunctionAccessExpression)call;
            } else {
                irFunctionAccessExpression2 = null;
            }
            this.adaptedReferenceOriginalTarget = (irFunctionAccessExpression = (this.adapteeCall = irFunctionAccessExpression2)) != null && (irFunctionAccessExpression = (IrFunctionSymbol)irFunctionAccessExpression.getSymbol()) != null ? irFunctionAccessExpression.getOwner() : null;
            this.isFunInterfaceConstructorReference = Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR());
            if (this.isFunInterfaceConstructorReference) {
                irClassSymbol = IrTypesKt.getClassOrNull((IrType)this.callee.getReturnType());
                if (irClassSymbol == null) {
                    throw new AssertionError((Object)("Fun interface type expected: " + RenderIrElementKt.render$default((IrType)this.callee.getReturnType(), null, (int)1, null)));
                }
            } else {
                irClassSymbol = null;
            }
            this.constructedFunInterfaceSymbol = irClassSymbol;
            this.isAdaptedReference = this.isFunInterfaceConstructorReference || this.adaptedReferenceOriginalTarget != null;
            IrType irType4 = this.samSuperType;
            this.samInterface = irType4 != null ? IrTypesKt.getClass((IrType)irType4) : null;
            this.isKotlinFunInterface = this.samInterface != null && !IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)this.samInterface));
            this.needToGenerateSamEqualsHashCodeMethods = !(!this.isKotlinFunInterface && !this.this$0.isJavaSamConversionWithEqualsHashCode || !this.isAdaptedReference && this.isLambda);
            IrType irType5 = this.samSuperType;
            if (irType5 == null) {
                irType5 = (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)(this.isLightweightLambda ? this.this$0.context.getSymbols().getAny() : (this.isHeavyweightLambda ? this.this$0.context.getSymbols().getLambdaClass() : (this.isFunInterfaceConstructorReference ? this.this$0.context.getSymbols().getFunInterfaceConstructorReferenceClass() : (this.isAdaptedReference ? this.this$0.context.getSymbols().getAdaptedFunctionReference() : this.this$0.context.getSymbols().getFunctionReferenceImpl()))))));
            }
            this.superType = irType5;
            IrFactory $this$buildClass$iv = this.this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            Object $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl = false;
            destination$iv$iv = $this$buildClass_u24lambda_u241$iv;
            functionReferenceBuilder = this;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$functionReferenceClass_u24lambda_u240), (IrElement)((IrElement)this.irFunctionReference));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
            $this$functionReferenceClass_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$functionReferenceClass_u24lambda_u240.setOrigin(this.isLambda ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL());
            $this$functionReferenceClass_u24lambda_u240.setName(SpecialNames.NO_NAME_PROVIDED);
            iterable = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            FunctionReferenceLowering functionReferenceLowering2 = this.this$0;
            $this$buildClass_u24lambda_u241$iv = iterable;
            boolean bl3 = false;
            IrDeclarationParent irDeclarationParent = functionReferenceLowering2.getCurrentDeclarationParent();
            if (irDeclarationParent == null) {
                throw new IllegalStateException(("No current declaration parent at " + DumpIrTreeKt.dump$default((IrElement)((IrElement)this.irFunctionReference), null, (int)1, null)).toString());
            }
            $this$functionReferenceClass_u24lambda_u241.setParent(irDeclarationParent);
            Object[] objectArray = new IrType[]{this.superType, this.samSuperType == null ? IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.functionSuperClass), this.parameterTypes) : null, this.needToGenerateSamEqualsHashCodeMethods ? IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)functionReferenceLowering2.context.getSymbols().getFunctionAdapter())) : null};
            $this$functionReferenceClass_u24lambda_u241.setSuperTypes(CollectionsKt.listOfNotNull((Object[])objectArray));
            if (this.samInterface != null && Intrinsics.areEqual((Object)$this$functionReferenceClass_u24lambda_u241.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL())) {
                $this$functionReferenceClass_u24lambda_u241.setTypeParameters(this.createFakeFormalTypeParameters(this.samInterface.getTypeParameters(), (IrClass)$this$functionReferenceClass_u24lambda_u241));
            }
            IrUtilsKt.createThisReceiverParameter((IrClass)$this$functionReferenceClass_u24lambda_u241);
            IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$functionReferenceClass_u24lambda_u241), (IrElement)((IrElement)this.irFunctionReference), (boolean)false, (int)2, null);
            if (this.isHeavyweightLambda) {
                $this$functionReferenceClass_u24lambda_u241.setMetadata(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner().getMetadata());
            }
            functionReferenceBuilder.functionReferenceClass = iterable;
        }

        public /* synthetic */ FunctionReferenceBuilder(FunctionReferenceLowering functionReferenceLowering, IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(functionReferenceLowering, irFunctionReference, irType);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrTypeParameter> createFakeFormalTypeParameters(List<? extends IrTypeParameter> sourceTypeParameters, IrClass irClass) {
            Iterable $this$associateWithTo$iv$iv;
            IrTypeParameterBuilder $this$buildTypeParameter_u24lambda_u241$iv;
            IrTypeParametersContainer parent$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            if (sourceTypeParameters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = sourceTypeParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                parent$iv = (IrTypeParametersContainer)irClass;
                boolean $i$f$buildTypeParameter = false;
                $this$buildTypeParameter_u24lambda_u241$iv = new IrTypeParameterBuilder();
                boolean bl2 = false;
                IrTypeParameterBuilder $this$createFakeFormalTypeParameters_u24lambda_u240_u240 = $this$buildTypeParameter_u24lambda_u241$iv;
                boolean bl3 = false;
                $this$createFakeFormalTypeParameters_u24lambda_u240_u240.updateFrom((IrTypeParameter)it);
                $this$createFakeFormalTypeParameters_u24lambda_u240_u240.setName(it.getName());
                collection.add(DeclarationBuildersKt.buildTypeParameter((IrFactory)parent$iv.getFactory(), (IrTypeParameterBuilder)$this$buildTypeParameter_u24lambda_u241$iv, (IrDeclarationParent)((IrDeclarationParent)parent$iv)));
            }
            List fakeTypeParameters = (List)destination$iv$iv;
            Iterable $this$associateWith$iv = sourceTypeParameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $i$f$mapTo22 = $this$associateWith$iv;
            Map destination$iv$iv2 = result$iv;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                parent$iv = (IrTypeParameter)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl = false;
                IrTypeParameter irTypeParameter = (IrTypeParameter)fakeTypeParameters.get(it.getIndex());
                map.put(t, irTypeParameter);
            }
            Map map = destination$iv$iv2;
            IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(map);
            for (IrTypeParameter fakeTypeParameter : fakeTypeParameters) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                IrTypeParameter sourceTypeParameter = sourceTypeParameters.get(fakeTypeParameter.getIndex());
                $this$associateWithTo$iv$iv = sourceTypeParameter.getSuperTypes();
                collection = fakeTypeParameter;
                boolean $i$f$map2 = false;
                void $i$f$associateWithTo2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    $this$buildTypeParameter_u24lambda_u241$iv = (IrType)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl = false;
                    collection2.add(typeRemapper.remapType((IrType)it));
                }
                collection.setSuperTypes((List)destination$iv$iv3);
            }
            return fakeTypeParameters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            IrConstructorCall irConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            JvmBackendContext jvmBackendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder $this$build_u24lambda_u240 = JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr);
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u240;
            int n = this.irFunctionReference.getStartOffset();
            int endOffset$iv = this.irFunctionReference.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u240_u240 = this_$iv$iv;
            boolean bl2 = false;
            IrConstructor constructor = this.createConstructor();
            IrVariable boundReceiverVar = this.samSuperType != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$build_u24lambda_u240_u240), (IrExpression)((IrExpression)this.boundReceiver.getSecond()), null, null, (boolean)false, null, (int)30, null) : null;
            this.createInvokeMethod((IrValueDeclaration)boundReceiverVar);
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                this.generateSamEqualsHashCodeMethods($this$build_u24lambda_u240, boundReceiverVar);
            }
            if (this.isKotlinFunInterface) {
                IrUtilsKt.addFakeOverrides((IrClass)this.functionReferenceClass, (IrTypeSystemContext)$this$build_u24lambda_u240.getBackendContext().getTypeSystem());
            }
            $this$build_u24lambda_u240_u240.unaryPlus((IrStatement)this.functionReferenceClass);
            IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$build_u24lambda_u240_u240), (IrConstructorSymbol)constructor.getSymbol());
            void var17_17 = $this$build_u24lambda_u240_u240;
            boolean bl3 = false;
            if (!((Collection)constructor.getParameters()).isEmpty()) {
                void $this$build_u24lambda_u240_u240_u240;
                IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$build_u24lambda_u240_u240_u240.getArguments();
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                valueArgumentsList.set(0, pair.getSecond());
            }
            var17_17.unaryPlus((IrStatement)irConstructorCall);
            return (IrExpression)this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, IrVariable boundReceiverVar) {
            if (this.samSuperType == null) {
                boolean bl = false;
                String string = "equals/hashCode can only be generated for fun interface wrappers: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.callee), null, (int)1, null);
                throw new IllegalStateException(string.toString());
            }
            new SamEqualsHashCodeMethodsGenerator((CommonBackendContext)$this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (arg_0, arg_1) -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$1(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVar, arg_0, arg_1)).generate();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$createConstructor_u24lambda_u241_u241;
            IrConstructor it;
            IrConstructor irConstructor;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u240.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_MEMBER_IN_CALLABLE_REFERENCE());
            $this$createConstructor_u24lambda_u240.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)this.functionReferenceClass));
            $this$createConstructor_u24lambda_u240.setPrimary(true);
            $this$addConstructor_u24lambda_u240$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
            IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u241$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
            IrFactory irFactory = $this$buildConstructor$iv$iv;
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            IrFactory $this$createConstructor_u24lambda_u241 = irFactory;
            boolean bl5 = false;
            if (this.samSuperType == null && this.boundReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$createConstructor_u24lambda_u241), (String)"receiver", (IrType)functionReferenceLowering.context.getIrBuiltIns().getAnyNType(), null, (int)4, null);
            }
            if (this.isFunInterfaceConstructorReference) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getSymbols().getFunInterfaceConstructorReferenceClass().getOwner())));
            } else if (this.samSuperType != null) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner())));
            } else {
                int expectedArity = this.isLightweightLambda && !this.isAdaptedReference ? 0 : (this.isHeavyweightLambda && !this.isAdaptedReference ? 1 : 1 + (this.boundReceiver != null ? 1 : 0) + 4);
                IrClass irClass = IrTypesKt.getClass((IrType)this.superType);
                Intrinsics.checkNotNull((Object)irClass);
                Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)irClass);
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (IrConstructor)element$iv;
                    boolean bl6 = false;
                    if (!(it.getParameters().size() == expectedArity)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor = single$iv;
            }
            IrConstructor constructor = irConstructor;
            JvmIrBuilder $this$single$iv = JvmIrBuilderKt.createJvmIrBuilder$default(functionReferenceLowering.context, (IrSymbol)$this$createConstructor_u24lambda_u241.getSymbol(), 0, 0, 6, null);
            IrFactory irFactory2 = $this$createConstructor_u24lambda_u241;
            boolean bl7 = false;
            IrBuilderWithScope single$iv = (IrBuilderWithScope)$this$createConstructor_u24lambda_u241_u241;
            int found$iv = $this$createConstructor_u24lambda_u241_u241.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u241_u241.getEndOffset();
            boolean $i$f$irBlockBody = false;
            it = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$createConstructor_u24lambda_u241_u241_u240 = this_$iv$iv;
            boolean bl8 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)((IrBuilder)$this$createConstructor_u24lambda_u241_u241_u240), (IrConstructor)constructor);
            void var20_34 = $this$createConstructor_u24lambda_u241_u241_u240;
            boolean bl9 = false;
            if (this.samSuperType == null) {
                void call;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$createConstructor_u24lambda_u241_u241, (IrFunctionAccessExpression)call, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceBuilder.createConstructor$lambda$1$1$0$0$0((IrConstructor)$this$createConstructor_u24lambda_u241, arg_0)));
            }
            var20_34.unaryPlus((IrStatement)irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u241_u241_u240.unaryPlus((IrStatement)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrInstanceInitializerCallImpl((int)$this$createConstructor_u24lambda_u241_u241_u240.getStartOffset(), (int)$this$createConstructor_u24lambda_u241_u241_u240.getEndOffset(), (IrClassSymbol)this.functionReferenceClass.getSymbol(), (IrType)$this$createConstructor_u24lambda_u241_u241_u240.getContext().getIrBuiltIns().getUnitType()));
            irFactory2.setBody((IrBody)this_$iv$iv.doBuild());
            return irFactory;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call, Function1<? super IrBuilder, ? extends IrExpression> generateBoundReceiver) {
            if (this.isFunInterfaceConstructorReference) {
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                IrClassSymbol irClassSymbol = this.constructedFunInterfaceSymbol;
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrClassReference funInterfaceKClassRef = JvmIrUtilsKt.kClassReference(irBuilderWithScope, (IrType)IrUtilsKt.getDefaultType((IrClass)((IrClass)irClassSymbol.getOwner())));
                IrCall funInterfaceJavaClassRef = JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, (IrExpression)funInterfaceKClassRef);
                call.getArguments().set(0, (Object)funInterfaceJavaClassRef);
            } else {
                int index = 0;
                if (!this.isLightweightLambda) {
                    call.getArguments().set(index++, (Object)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$generateConstructorCallArguments), (int)(this.argumentTypes.size() + (IrUtilsKt.isSuspend((IrFunctionReference)this.irFunctionReference) ? 1 : 0)), null, (int)2, null));
                }
                if (this.boundReceiver != null) {
                    call.getArguments().set(index++, generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments));
                }
                if (!this.isLambda) {
                    IrFunction irFunction = this.adaptedReferenceOriginalTarget;
                    if (irFunction == null) {
                        irFunction = this.callee;
                    }
                    IrFunction callableReferenceTarget = irFunction;
                    IrExpression owner = Companion.calculateOwnerKClass$backend_jvm_lower($this$generateConstructorCallArguments, callableReferenceTarget.getParent());
                    call.getArguments().set(index++, (Object)JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, owner));
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = call.getArguments();
                    int n = index++;
                    IrBuilder irBuilder = (IrBuilder)$this$generateConstructorCallArguments;
                    String string = this.getOriginalName(callableReferenceTarget).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    valueArgumentsList.set(n, (Object)ExpressionHelpersKt.irString((IrBuilder)irBuilder, (String)string));
                    call.getArguments().set(index++, (Object)this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                    call.getArguments().set(index, (Object)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$generateConstructorCallArguments), (int)this.getFunctionReferenceFlags(callableReferenceTarget), null, (int)2, null));
                }
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = JvmIrUtilsKt.getCallableReferenceTopLevelFlag((IrDeclaration)callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.hasVarargMappedToElement() ? 1 : 0;
            int isSuspendConvertedBit = !AdditionalIrUtilsKt.isSuspend((IrFunction)this.adaptedReferenceOriginalTarget) && AdditionalIrUtilsKt.isSuspend((IrFunction)this.callee) ? 1 : 0;
            int isCoercedToUnitBit = !IrTypePredicatesKt.isUnit((IrType)this.adaptedReferenceOriginalTarget.getReturnType()) && IrTypePredicatesKt.isUnit((IrType)this.callee.getReturnType()) ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasVarargMappedToElement() {
            boolean bl;
            IrFunctionAccessExpression irFunctionAccessExpression = this.adapteeCall;
            List list = (List)(irFunctionAccessExpression != null ? irFunctionAccessExpression.getArguments() : null);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                IrExpression arg = (IrExpression)element$iv;
                boolean bl2 = false;
                if (arg instanceof IrVararg) {
                    boolean bl3;
                    Iterable $this$any$iv2 = ((IrVararg)arg).getElements();
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            IrVarargElement it = (IrVarargElement)element$iv2;
                            boolean bl4 = false;
                            if (!(it instanceof IrGetValue)) continue;
                            return true;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            void $this$createInvokeMethod_u24lambda_u241_u240;
            IrSimpleFunction irSimpleFunction;
            void $this$addFunction$iv$iv;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory irFactory = $this$addFunction$iv.getFactory();
            IrDeclarationContainer klass$iv$iv = (IrDeclarationContainer)$this$addFunction$iv;
            boolean $i$f$addFunction2 = false;
            IrSimpleFunction $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$createInvokeMethod_u24lambda_u240), (IrElement)(this.isLambda ? (IrElement)this.callee : (IrElement)this.irFunctionReference));
            $this$createInvokeMethod_u24lambda_u240.setName(this.superMethod.getName());
            $this$createInvokeMethod_u24lambda_u240.setReturnType(this.referenceReturnType);
            $this$createInvokeMethod_u24lambda_u240.setSuspend(AdditionalIrUtilsKt.isSuspend((IrFunction)this.callee));
            IrSimpleFunction function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
            klass$iv$iv.getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)klass$iv$iv);
            IrSimpleFunction $this$createInvokeMethod_u24lambda_u241 = irSimpleFunction = $this$buildFun$iv$iv$iv;
            boolean bl3 = false;
            $this$createInvokeMethod_u24lambda_u241.setMetadata(this.functionReferenceClass.getMetadata());
            $this$createInvokeMethod_u24lambda_u241.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u241.getOverriddenSymbols(), (Object)this.superMethod.getSymbol()));
            IrDeclaration $this$buildReceiverParameter$iv = (IrDeclaration)$this$createInvokeMethod_u24lambda_u241;
            boolean $i$f$buildReceiverParameter = false;
            IrValueParameterBuilder $this$buildReceiverParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
            boolean bl4 = false;
            $this$buildReceiverParameter_u24lambda_u240$iv.setName(SpecialNames.THIS);
            $this$buildReceiverParameter_u24lambda_u240$iv.setKind(IrParameterKind.DispatchReceiver);
            $this$buildReceiverParameter_u24lambda_u240$iv.setStartOffset(((IrElement)$this$buildReceiverParameter$iv).getStartOffset());
            $this$buildReceiverParameter_u24lambda_u240$iv.setEndOffset(((IrElement)$this$buildReceiverParameter$iv).getEndOffset());
            IrValueParameterBuilder $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$buildReceiverParameter_u24lambda_u240$iv;
            IrSimpleFunction irSimpleFunction2 = $this$createInvokeMethod_u24lambda_u241;
            boolean bl5 = false;
            $this$createInvokeMethod_u24lambda_u241_u240.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER());
            $this$createInvokeMethod_u24lambda_u241_u240.setType((IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.functionReferenceClass.getSymbol())));
            irSimpleFunction2.setParameters(CollectionsKt.listOf((Object)DeclarationBuildersKt.buildValueParameter((IrFactory)$this$buildReceiverParameter$iv.getFactory(), (IrValueParameterBuilder)$this$buildReceiverParameter_u24lambda_u240$iv, (IrDeclarationParent)((IrDeclarationParent)$this$buildReceiverParameter$iv))));
            if (this.isLambda) {
                this.createLambdaInvokeMethod($this$createInvokeMethod_u24lambda_u241);
            } else if (this.isFunInterfaceConstructorReference) {
                this.createFunInterfaceConstructorInvokeMethod($this$createInvokeMethod_u24lambda_u241);
            } else {
                this.createFunctionReferenceInvokeMethod($this$createInvokeMethod_u24lambda_u241, receiverVar);
            }
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = this.callee.getParameters();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IrValueParameter param = (IrValueParameter)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)param, (Object)IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)((IrFunction)$this$createLambdaInvokeMethod), null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (IrParameterKind)IrParameterKind.Regular, null, (int)12286, null));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setParameters(CollectionsKt.plus((Collection)$this$createLambdaInvokeMethod.getParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)this.callee, (IrFunction)((IrFunction)$this$createLambdaInvokeMethod), (Map)valueParameterMap));
        }

        private final void createFunInterfaceConstructorInvokeMethod(IrSimpleFunction $this$createFunInterfaceConstructorInvokeMethod) {
            IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull((List)this.callee.getParameters());
            if (irValueParameter == null) {
                throw new AssertionError((Object)("Single value parameter expected: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.callee), null, (int)1, null)));
            }
            IrValueParameter adapterValueParameter = irValueParameter;
            IrValueParameter invokeValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)adapterValueParameter, (IrFunction)((IrFunction)$this$createFunInterfaceConstructorInvokeMethod), null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16382, null);
            Map valueParameterMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)adapterValueParameter, (Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setParameters(CollectionsKt.plus((Collection)$this$createFunInterfaceConstructorInvokeMethod.getParameters(), (Object)invokeValueParameter));
            $this$createFunInterfaceConstructorInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)this.callee, (IrFunction)((IrFunction)$this$createFunInterfaceConstructorInvokeMethod), (Map)valueParameterMap));
            this.callee.setBody(null);
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u241;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrValueParameter irValueParameter;
            Iterator iterator2 = ((Iterable)this.argumentTypes).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                IrType argumentType = (IrType)iterator2.next();
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
                boolean bl = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u240 = $this$addValueParameter_u24lambda_u240$iv;
                boolean bl2 = false;
                Name name = Name.identifier((String)("" + 'p' + index));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u240.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u240.setType(argumentType);
                $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u240$iv, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv));
                boolean bl3 = false;
                $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), (Object)valueParameter$iv));
            }
            JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.this$0.context, (IrSymbol)$this$createFunctionReferenceInvokeMethod.getSymbol(), $this$createFunctionReferenceInvokeMethod.getStartOffset(), $this$createFunctionReferenceInvokeMethod.getEndOffset());
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression $this$createFunctionReferenceInvokeMethod_u24lambda_u241_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241), (IrFunctionSymbol)this.callee.getSymbol(), (IrType)this.referenceReturnType);
            boolean bl4 = false;
            for (IrTypeParameter typeParameter : IrUtilsKt.getAllTypeParameters((IrFunction)((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner())) {
                $this$createFunctionReferenceInvokeMethod_u24lambda_u241_u240.getTypeArguments().set(typeParameter.getIndex(), this.typeArgumentsMap.get(typeParameter.getSymbol()));
            }
            for (IrValueParameter parameter : this.callee.getParameters()) {
                IrExpression irExpression;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair != null ? (IrValueParameter)pair.getFirst() : null), (Object)parameter)) {
                    if (this.samSuperType == null) {
                        IrBuilder irBuilder = (IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241;
                        IrBuilder irBuilder2 = (IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241;
                        IrBuilder irBuilder3 = (IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241;
                        IrValueParameter irValueParameter2 = $this$createFunctionReferenceInvokeMethod.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter2);
                        irExpression = (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilder)irBuilder, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilder)irBuilder2, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2))), (IrField)Companion.getReceiverField$backend_jvm_lower(this.functionReferenceClass, $this$createFunctionReferenceInvokeMethod_u24lambda_u241.getBackendContext()), null, (int)4, null)), (IrType)((IrExpression)this.boundReceiver.getSecond()).getType());
                    } else {
                        IrBuilder irBuilder = (IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241;
                        IrValueDeclaration irValueDeclaration = receiver;
                        Intrinsics.checkNotNull((Object)irValueDeclaration);
                        irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder, (IrValueDeclaration)irValueDeclaration);
                    }
                } else if (unboundIndex >= this.argumentTypes.size()) {
                    irExpression = null;
                } else {
                    int n2 = unboundIndex;
                    unboundIndex = n2 + 1;
                    irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)$this$createFunctionReferenceInvokeMethod)).get(n2)));
                }
                if ((irValueParameter = irExpression) == null) continue;
                IrValueParameter it = irValueParameter;
                boolean bl5 = false;
                $this$createFunctionReferenceInvokeMethod_u24lambda_u241_u240.getArguments().set(parameter, (IrExpression)it);
            }
            IrFunctionAccessExpression call = irFunctionAccessExpression;
            irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilder)((IrBuilder)$this$createFunctionReferenceInvokeMethod_u24lambda_u241), (IrExpression)this.inlineAdapterCallIfPossible(call, $this$createFunctionReferenceInvokeMethod)));
        }

        private final IrExpression inlineAdapterCallIfPossible(IrFunctionAccessExpression expression2, IrSimpleFunction invokeMethod) {
            IrExpression irExpression;
            IrBlockBody adapterBody;
            IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
            if (irCall == null) {
                return (IrExpression)expression2;
            }
            IrCall irCall2 = irCall;
            IrSimpleFunction callee = (IrSimpleFunction)irCall2.getSymbol().getOwner();
            if (!Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE())) {
                return (IrExpression)expression2;
            }
            if (callee.isSuspend()) {
                return (IrExpression)expression2;
            }
            IrBody irBody = callee.getBody();
            IrBlockBody irBlockBody = adapterBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (adapterBody == null || adapterBody.getStatements().size() != 1) {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)callee), null, (int)1, null)));
            }
            IrStatement resultStatement = (IrStatement)adapterBody.getStatements().get(0);
            if (resultStatement instanceof IrReturn) {
                irExpression = ((IrReturn)resultStatement).getValue();
            } else if (resultStatement instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)resultStatement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrCall) {
                irExpression = (IrExpression)resultStatement;
            } else if (resultStatement instanceof IrConstructorCall) {
                irExpression = (IrExpression)resultStatement;
            } else {
                throw new AssertionError((Object)("Unexpected adapter body: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)callee), null, (int)1, null)));
            }
            IrExpression resultExpression = irExpression;
            int startOffset = irCall2.getStartOffset();
            int endOffset = irCall2.getEndOffset();
            LinkedHashMap callArguments = new LinkedHashMap();
            IrBlockImpl inlinedAdapterBlock = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl((int)startOffset, (int)endOffset, (IrType)irCall2.getType(), null);
            Ref.IntRef tmpVarIndex = new Ref.IntRef();
            for (IrValueParameter parameter : callee.getParameters()) {
                Map map = callArguments;
                IrExpression irExpression2 = irCall2.getArguments().get(parameter);
                if (irExpression2 == null) {
                    throw new AssertionError((Object)("No value argument #" + parameter.getIndexInParameters() + " in adapter call: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)irCall2), null, (int)1, null)));
                }
                IrValueDeclaration irValueDeclaration = FunctionReferenceBuilder.inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(startOffset, endOffset, tmpVarIndex, invokeMethod, inlinedAdapterBlock, irExpression2);
                map.put(parameter, irValueDeclaration);
            }
            IrExpression inlinedAdapterResult = resultExpression.transform((IrTransformer)new VariableRemapper((Map)callArguments), null);
            inlinedAdapterBlock.getStatements().add(inlinedAdapterResult);
            callee.setBody(null);
            return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)inlinedAdapterBlock), (IrDeclarationParent)((IrDeclarationParent)invokeMethod));
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            MetadataSource metadataSource = $this$originalName.getMetadata();
            if (metadataSource == null || (metadataSource = metadataSource.getName()) == null) {
                metadataSource = $this$originalName.getName();
            }
            return metadataSource;
        }

        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            IrCall irCall;
            IrCall $this$generateSignature_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$generateSignature), (IrSimpleFunctionSymbol)$this$generateSignature.getBackendContext().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            $this$generateSignature_u24lambda_u240.getArguments().set(0, (Object)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrRawFunctionReferenceImpl((int)-1, (int)-1, (IrType)this.irFunctionReference.getType(), (IrFunctionSymbol)target));
            return (IrExpression)irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrClass objectClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.callee));
            IrDeclaration declaration$iv = (IrDeclaration)this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240 = $this$buildValueParameter_u24lambda_u241$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"$this");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240.setName(name);
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240.setType((IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter((IrFactory)declaration$iv.getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((IrDeclarationParent)declaration$iv)), (Object)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetObjectValueImpl((int)-1, (int)-1, (IrType)((IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0])), (IrClassSymbol)objectClass.getSymbol()));
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$1$1$0(IrVariable $boundReceiverVar, IrBuilder $this$generateConstructorCallArguments) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            IrVariable irVariable = $boundReceiverVar;
            Intrinsics.checkNotNull((Object)irVariable);
            return (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$generateConstructorCallArguments, (IrValueDeclaration)((IrValueDeclaration)irVariable));
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$1(FunctionReferenceBuilder this$0, JvmIrBuilder $this_generateSamEqualsHashCodeMethods, IrVariable $boundReceiverVar, IrBuilderWithScope $this$SamEqualsHashCodeMethodsGenerator, IrExpression it) {
            IrConstructorCall irConstructorCall;
            Intrinsics.checkNotNullParameter((Object)$this$SamEqualsHashCodeMethodsGenerator, (String)"$this$SamEqualsHashCodeMethodsGenerator");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IrClassSymbol internalClass = this$0.isAdaptedReference ? $this_generateSamEqualsHashCodeMethods.getBackendContext().getSymbols().getAdaptedFunctionReference() : $this_generateSamEqualsHashCodeMethods.getBackendContext().getSymbols().getFunctionReferenceImpl();
            Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)((IrClass)internalClass.getOwner()));
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it2 = (IrConstructor)element$iv;
                boolean bl = false;
                if (!(it2.getParameters().size() == 1 + (this$0.boundReceiver != null ? 1 : 0) + 4)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrConstructor constructor = single$iv;
            IrConstructorCall $this$generateSamEqualsHashCodeMethods_u24lambda_u241_u241 = irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilder)((IrBuilder)$this$SamEqualsHashCodeMethodsGenerator), (IrConstructorSymbol)constructor.getSymbol(), (List)CollectionsKt.emptyList());
            boolean bl = false;
            this$0.generateConstructorCallArguments($this_generateSamEqualsHashCodeMethods, (IrFunctionAccessExpression)$this$generateSamEqualsHashCodeMethods_u24lambda_u241_u241, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)arg_0 -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$1$1$0($boundReceiverVar, arg_0)));
            return (IrExpression)irConstructorCall;
        }

        private static final IrExpression createConstructor$lambda$1$1$0$0$0(IrConstructor $this_apply, IrBuilder $this$generateConstructorCallArguments) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            return (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$generateConstructorCallArguments, (IrValueDeclaration)((IrValueDeclaration)CollectionsKt.first((List)$this_apply.getParameters())));
        }

        private static final IrValueDeclaration inlineAdapterCallIfPossible$wrapIntoTemporaryVariableIfNecessary(int startOffset, int endOffset, Ref.IntRef tmpVarIndex, IrSimpleFunction $invokeMethod, IrBlockImpl inlinedAdapterBlock, IrExpression expression2) {
            if (expression2 instanceof IrGetValue) {
                return ((IrGetValue)expression2).getSymbol().getOwner();
            }
            if (!(expression2 instanceof IrTypeOperatorCall) || !(((IrTypeOperatorCall)expression2).getArgument() instanceof IrGetField)) {
                throw new AssertionError((Object)("Unexpected adapter argument:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression2), null, (int)1, null)));
            }
            IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
            IrVariableSymbol irVariableSymbol = (IrVariableSymbol)new IrVariableSymbolImpl(null, 1, null);
            int n = tmpVarIndex.element;
            tmpVarIndex.element = n + 1;
            Name name = Name.identifier((String)("tmp_" + n));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            IrVariableImpl temporaryVar = BuildersKt.IrVariableImpl((int)startOffset, (int)endOffset, (IrDeclarationOrigin)irDeclarationOrigin, (IrVariableSymbol)irVariableSymbol, (Name)name, (IrType)expression2.getType(), (boolean)false, (boolean)false, (boolean)false);
            temporaryVar.setParent((IrDeclarationParent)$invokeMethod);
            temporaryVar.setInitializer(expression2);
            inlinedAdapterBlock.getStatements().add(temporaryVar);
            return (IrValueDeclaration)temporaryVar;
        }
    }
}

