/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmIrAttributesKt;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.EnumIntrinsicsUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCallTypeArgumentsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irBuiltins", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getKClassCtorArgument", "type", "getExternalKClassCtorArgument", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nBuiltInsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n350#2,12:258\n404#3,13:270\n133#4,2:283\n362#5,7:285\n1#6:292\n*S KotlinDebug\n*F\n+ 1 BuiltInsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering\n*L\n45#1:258,12\n119#1:270,13\n119#1:283,2\n159#1:285,7\n*E\n"})
public final class BuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns irBuiltins;
    @NotNull
    private final WasmSymbols symbols;

    public BuiltInsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irBuiltins = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction findEqualsMethod(IrType $this$findEqualsMethod) {
        IrClass irClass = IrTypesKt.getClass((IrType)$this$findEqualsMethod);
        if (irClass == null) {
            irClass = (IrClass)this.irBuiltins.getAnyClass().getOwner();
        }
        IrClass klass = irClass;
        Sequence $this$single$iv = IrUtilsKt.getFunctions((IrClass)klass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!MiscKt.isEqualsInheritedFromAny((IrFunction)it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression transformCall(IrCall call, DeclarationIrBuilder builder) {
        IrSimpleFunctionSymbol symbol;
        block40: {
            block42: {
                block41: {
                    block37: {
                        block39: {
                            block38: {
                                symbol = call.getSymbol();
                                if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getLinkageErrorSymbol())) {
                                    return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)this.context.getWasmSymbols().getThrowLinkageError(), null, null, (int)12, null);
                                }
                                if (!Intrinsics.areEqual((Object)symbol, this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getFloatClass()))) break block37;
                                Object object = call.getArguments().get(0);
                                Intrinsics.checkNotNull((Object)object);
                                if (IrTypeUtilsKt.isNullable((IrType)((IrExpression)object).getType())) break block38;
                                Object object2 = call.getArguments().get(1);
                                Intrinsics.checkNotNull((Object)object2);
                                if (!IrTypeUtilsKt.isNullable((IrType)((IrExpression)object2).getType())) break block39;
                            }
                            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)this.symbols.getNullableFloatIeee754Equals(), null, null, (int)12, null);
                        }
                        return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getFloatType())), null, null, (int)12, null);
                    }
                    if (!Intrinsics.areEqual((Object)symbol, this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getDoubleClass()))) break block40;
                    Object object = call.getArguments().get(0);
                    Intrinsics.checkNotNull((Object)object);
                    if (IrTypeUtilsKt.isNullable((IrType)((IrExpression)object).getType())) break block41;
                    Object object3 = call.getArguments().get(1);
                    Intrinsics.checkNotNull((Object)object3);
                    if (!IrTypeUtilsKt.isNullable((IrType)((IrExpression)object3).getType())) break block42;
                }
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)this.symbols.getNullableDoubleIeee754Equals(), null, null, (int)12, null);
            }
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getDoubleType())), null, null, (int)12, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getEqeqSymbol()) || Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getEqeqeqSymbol())) {
            IrType rhsType;
            Object object = call.getArguments().get(0);
            Intrinsics.checkNotNull((Object)object);
            IrExpression lhs = (IrExpression)object;
            Object object4 = call.getArguments().get(1);
            Intrinsics.checkNotNull((Object)object4);
            IrExpression rhs = (IrExpression)object4;
            if (IrUtilsKt.isNullConst((IrExpression)lhs)) {
                return (IrExpression)BuiltInsLowering.transformCall$callRefIsNull(this, builder, rhs);
            }
            if (IrUtilsKt.isNullConst((IrExpression)rhs)) {
                return (IrExpression)BuiltInsLowering.transformCall$callRefIsNull(this, builder, lhs);
            }
            IrType lhsType = lhs.getType();
            if (Intrinsics.areEqual((Object)lhsType, (Object)(rhsType = rhs.getType()))) {
                IrSimpleFunctionSymbol newSymbol;
                Object object5 = this.symbols.getEqualityFunctions().get(lhsType);
                if (object5 == null) {
                    object5 = call.getSymbol() == this.irBuiltins.getEqeqeqSymbol() ? this.symbols.getFloatEqualityFunctions().get(lhsType) : null;
                }
                if ((newSymbol = object5) != null) {
                    return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)newSymbol, null, null, (int)12, null);
                }
            }
            if (call.getSymbol() == this.irBuiltins.getEqeqSymbol() && !IrTypeUtilsKt.isNullable((IrType)lhsType) && !IrTypePredicatesKt.isNothing((IrType)lhsType)) {
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)this.findEqualsMethod(lhsType).getSymbol(), null, null, (int)12, null);
            }
            IrSimpleFunctionSymbol fallbackEqFun = call.getSymbol() == this.irBuiltins.getEqeqeqSymbol() ? this.symbols.getRefEq() : this.symbols.getNullableEquals();
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)fallbackEqFun, null, null, (int)12, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getCheckNotNullSymbol())) {
            void this_$iv$iv;
            Object object = call.getArguments().get(0);
            Intrinsics.checkNotNull((Object)object);
            IrExpression arg = (IrExpression)object;
            if (IrUtilsKt.isNullConst((IrExpression)arg)) {
                return (IrExpression)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getThrowNullPointerException());
            }
            IrBuilderWithScope $this$irComposite_u24default$iv = (IrBuilderWithScope)builder;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$transformCall_u24lambda_u241 = this_$iv$iv;
            boolean bl = false;
            IrVariable temporary = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$transformCall_u24lambda_u241), (IrExpression)arg, null, null, (boolean)false, null, (int)30, null);
            $this$transformCall_u24lambda_u241.unaryPlus((IrStatement)ExpressionHelpersKt.irIfNull((IrBuilder)((IrBuilder)builder), (IrType)IrTypesKt.makeNotNull((IrType)arg.getType()), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$transformCall_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)temporary))), (IrExpression)((IrExpression)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getThrowNullPointerException())), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$transformCall_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)temporary)))));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (this.symbols.getComparisonBuiltInsToWasmIntrinsics().keySet().contains(symbol)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getComparisonBuiltInsToWasmIntrinsics().get(symbol);
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)newSymbol, null, null, (int)12, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getNoWhenBranchMatchedExceptionSymbol())) {
            return (IrExpression)ExpressionHelpersKt.irCall$default((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getThrowNoBranchMatchedException(), (IrType)this.irBuiltins.getNothingType(), (int)0, null, (int)12, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getIllegalArgumentExceptionSymbol())) {
            IrCall newSymbol;
            IrCall $this$transformCall_u24lambda_u242 = newSymbol = ExpressionHelpersKt.irCall$default((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getThrowIAE(), (IrType)this.irBuiltins.getNothingType(), (int)0, null, (int)12, null);
            boolean bl = false;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$transformCall_u24lambda_u242.getArguments();
            Object object = call.getArguments().get(0);
            Intrinsics.checkNotNull((Object)object);
            valueArgumentsList.set(0, object);
            return (IrExpression)newSymbol;
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol()) || Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberToStringSymbol())) {
            int n;
            IrCall $this$transformCall_u24lambda_u243;
            IrCall irCall;
            IrType argumentType;
            IrExpression argument;
            block36: {
                Object object = call.getArguments().get(0);
                Intrinsics.checkNotNull((Object)object);
                argument = (IrExpression)object;
                argumentType = argument.getType();
                IrSimpleFunctionSymbol overloadSymbol = null;
                IrType returnType = null;
                if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol())) {
                    overloadSymbol = this.symbols.findContentHashCodeOverload(argumentType);
                    returnType = this.irBuiltins.getIntType();
                } else {
                    overloadSymbol = this.symbols.findContentToStringOverload(argumentType);
                    returnType = this.irBuiltins.getStringType();
                }
                $this$transformCall_u24lambda_u243 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)overloadSymbol, (IrType)returnType, (int)0, null, (int)12, null);
                boolean bl = false;
                List $this$indexOfFirst$iv = ((IrSimpleFunction)overloadSymbol.getOwner()).getParameters();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    IrValueParameter it = (IrValueParameter)item$iv;
                    boolean bl2 = false;
                    if (it.getKind() == IrParameterKind.ExtensionReceiver) {
                        n = index$iv;
                        break block36;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int extensionIndex = n;
            $this$transformCall_u24lambda_u243.getArguments().set(extensionIndex, (Object)argument);
            if (Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull((IrType)argumentType), (Object)this.irBuiltins.getArrayClass())) {
                $this$transformCall_u24lambda_u243.getTypeArguments().set(0, IrTypeUtilsKt.getArrayElementType((IrType)argumentType, (IrBuiltIns)this.irBuiltins));
            }
            return (IrExpression)irCall;
        }
        if (this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().contains(symbol)) {
            int arity = this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().indexOf(symbol);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction((IrClass)this.irBuiltins.suspendFunctionN(arity), (String)"invoke");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call), (IrSimpleFunctionSymbol)newSymbol, null, null, (int)12, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.context.getReflectionSymbols().getGetKClass())) {
            IrConstructorCallImpl irConstructorCallImpl;
            Object e = call.getTypeArguments().get(0);
            Intrinsics.checkNotNull(e);
            IrType type = (IrType)e;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type);
            if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
                throw new IllegalStateException("Invalid type".toString());
            }
            IrClassSymbol klass = irClassSymbol;
            IrExpression constructorArgument = null;
            IrConstructor kclassConstructor = null;
            if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)klass))) {
                if (!this.context.isWasmJsTarget()) {
                    boolean $i$a$-check-BuiltInsLowering$transformCall$52 = false;
                    String $i$a$-check-BuiltInsLowering$transformCall$52 = "External classes reflection in WASI mode are not supported";
                    throw new IllegalStateException($i$a$-check-BuiltInsLowering$transformCall$52.toString());
                }
                kclassConstructor = (IrConstructor)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)this.symbols.getJsRelatedSymbols().getKExternalClassImpl().getOwner())));
                constructorArgument = this.getExternalKClassCtorArgument(type, builder);
            } else {
                kclassConstructor = IrTypeUtilsKt.isInterface((IrType)type) ? (IrConstructor)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)this.symbols.getReflectionSymbols$backend_wasm().getKClassInterfaceImpl().getOwner()))) : (IrConstructor)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)this.symbols.getReflectionSymbols$backend_wasm().getKClassImpl().getOwner())));
                constructorArgument = this.getKClassCtorArgument(type, builder);
            }
            IrConstructorCallImpl it = irConstructorCallImpl = BuildersKt.IrConstructorCallImpl$default((int)-1, (int)-1, (IrType)kclassConstructor.getReturnType(), (IrConstructorSymbol)kclassConstructor.getSymbol(), (int)1, (int)0, null, null, (int)192, null);
            boolean bl = false;
            IrConstructorCallTypeArgumentsKt.putClassTypeArgument((IrConstructorCall)((IrConstructorCall)it), (int)0, (IrType)type);
            it.getArguments().set(0, (Object)constructorArgument);
            return (IrExpression)irConstructorCallImpl;
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumValueOfIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumValueOfIntrinsic((IrFunctionAccessExpression)call);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumValuesIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumValuesIntrinsic((IrFunctionAccessExpression)call);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumEntriesIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumEntriesIntrinsic((IrFunctionAccessExpression)call);
        }
        return (IrExpression)call;
    }

    private final IrExpression getKClassCtorArgument(IrType type, DeclarationIrBuilder builder) {
        IrConstructorCall irConstructorCall;
        String string;
        IrCall it2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type);
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            throw new IllegalStateException("Invalid type".toString());
        }
        IrClassSymbol klass = irClassSymbol;
        if (!IrUtilsKt.isInterface((IrClass)klass)) {
            IrCall irCall;
            IrCall it2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getWasmGetTypeRtti());
            boolean bl = false;
            it2.getTypeArguments().set(0, type);
            return (IrExpression)irCall;
        }
        IrCall it3 = it2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)builder), (IrSimpleFunctionSymbol)this.symbols.getWasmTypeId());
        boolean bl = false;
        it3.getTypeArguments().set(0, type);
        IrCall typeId = it2;
        FqName fqName = IrTypesKt.getClassFqName((IrType)type);
        Intrinsics.checkNotNull((Object)fqName);
        FqName fqName2 = fqName;
        boolean fqnShouldBeEmitted = (Boolean)CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.context.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            string = FqNamesUtilKt.parentOrNull((FqName)fqName2);
            if (string == null || (string = string.asString()) == null) {
                string = "";
            }
        } else {
            string = "";
        }
        String packageName = string;
        String string2 = fqName2.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String typeName = string2;
        IrConstructorCall it4 = irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilder)((IrBuilder)builder), (IrConstructorSymbol)((IrConstructorSymbol)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this.symbols.getReflectionSymbols$backend_wasm().getWasmTypeInfoData()))), (List)CollectionsKt.emptyList());
        boolean bl2 = false;
        it4.getArguments().set(0, (Object)typeId);
        it4.getArguments().set(1, (Object)IrUtilsKt.toIrConst$default((Object)packageName, (IrType)this.context.getIrBuiltIns().getStringType(), (int)0, (int)0, (int)6, null));
        it4.getArguments().set(2, (Object)IrUtilsKt.toIrConst$default((Object)typeName, (IrType)this.context.getIrBuiltIns().getStringType(), (int)0, (int)0, (int)6, null));
        return (IrExpression)irConstructorCall;
    }

    private final IrExpression getExternalKClassCtorArgument(IrType type, DeclarationIrBuilder builder) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type);
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            throw new IllegalStateException("Invalid type".toString());
        }
        IrClassSymbol klass = irClassSymbol;
        if (!(klass.getKind() != ClassKind.INTERFACE)) {
            boolean bl = false;
            String string = "External interface must not be a class literal";
            throw new IllegalStateException(string.toString());
        }
        IrBuilder irBuilder = (IrBuilder)builder;
        IrSimpleFunction irSimpleFunction = WasmIrAttributesKt.getGetJsClassForExternalClass((IrClass)klass);
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        return (IrExpression)ExpressionHelpersKt.irCall((IrBuilder)irBuilder, (IrFunction)((IrFunction)irSimpleFunction));
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)irFile.getSymbol()), (int)0, (int)0, (int)6, null);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)new IrElementTransformerVoidWithContext(this, builder){
            final /* synthetic */ BuiltInsLowering this$0;
            final /* synthetic */ DeclarationIrBuilder $builder;
            {
                this.this$0 = $receiver;
                this.$builder = $builder;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression newExpression = BuiltInsLowering.access$transformCall(this.this$0, expression2, this.$builder);
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)newExpression), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                return newExpression;
            }
        }));
    }

    private static final IrCall transformCall$callRefIsNull(BuiltInsLowering this$0, DeclarationIrBuilder $builder, IrExpression expr) {
        IrCall irCall;
        if (!this$0.context.isWasmJsTarget() && IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expr.getType()).isExternal()) {
            throw new IllegalStateException("Unexpected external refs in wasi mode".toString());
        }
        IrSimpleFunctionSymbol refIsNull = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expr.getType()).isExternal() ? this$0.symbols.getJsRelatedSymbols().getExternRefIsNull() : this$0.symbols.getRefIsNull();
        IrCall $this$transformCall_u24callRefIsNull_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$builder), (IrSimpleFunctionSymbol)refIsNull);
        boolean bl = false;
        $this$transformCall_u24callRefIsNull_u24lambda_u240.getArguments().set(0, (Object)expr);
        return irCall;
    }

    public static final /* synthetic */ IrExpression access$transformCall(BuiltInsLowering $this, IrCall call, DeclarationIrBuilder builder) {
        return $this.transformCall(call, builder);
    }
}

