/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.FieldInitializersLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/FieldInitializersLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "stringPoolFqName", "Lorg/jetbrains/kotlin/name/FqName;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nFieldInitializersLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInitializersLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/FieldInitializersLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class FieldInitializersLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final FqName stringPoolFqName;

    public FieldInitializersLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.stringPoolFqName = new FqName("kotlin.wasm.internal.stringPool");
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Ref.ObjectRef nonConstantFieldInitializer = new Ref.ObjectRef();
        Ref.ObjectRef objectInstanceFieldInitializer = new Ref.ObjectRef();
        Ref.ObjectRef stringPoolFieldInitializer = new Ref.ObjectRef();
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)irFile), (IrVisitorVoid)new IrVisitorVoid(this, irFile, (Ref.ObjectRef<IrSimpleFunction>)objectInstanceFieldInitializer, (Ref.ObjectRef<IrSimpleFunction>)stringPoolFieldInitializer, (Ref.ObjectRef<IrSimpleFunction>)nonConstantFieldInitializer){
            final /* synthetic */ FieldInitializersLowering this$0;
            final /* synthetic */ IrFile $irFile;
            final /* synthetic */ Ref.ObjectRef<IrSimpleFunction> $objectInstanceFieldInitializer;
            final /* synthetic */ Ref.ObjectRef<IrSimpleFunction> $stringPoolFieldInitializer;
            final /* synthetic */ Ref.ObjectRef<IrSimpleFunction> $nonConstantFieldInitializer;
            {
                this.this$0 = $receiver;
                this.$irFile = $irFile;
                this.$objectInstanceFieldInitializer = $objectInstanceFieldInitializer;
                this.$stringPoolFieldInitializer = $stringPoolFieldInitializer;
                this.$nonConstantFieldInitializer = $nonConstantFieldInitializer;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
            }

            private final IrSimpleFunction createInitializerFunction() {
                IrFactory irFactory = this.this$0.getContext().getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION();
                Name name = Name.identifier((String)"fieldInitializer");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
                IrSimpleFunction newFunction = IrFactory.createSimpleFunction$default((IrFactory)irFactory, (int)-1, (int)-1, (IrDeclarationOrigin)irDeclarationOrigin, (Name)name, (DescriptorVisibility)descriptorVisibility, (boolean)false, (boolean)false, (IrType)this.this$0.getContext().getIrBuiltIns().getUnitType(), (Modality)Modality.FINAL, (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)new IrSimpleFunctionSymbolImpl(null, null, 3, null)), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)114688, null);
                newFunction.setParent((IrDeclarationParent)this.$irFile);
                newFunction.setBody((IrBody)this.this$0.getContext().getIrFactory().createBlockBody(-1, -1));
                return newFunction;
            }

            public void visitField(IrField declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                super.visitField(declaration);
                if (declaration.isExternal()) {
                    return;
                }
                if (!declaration.isStatic()) {
                    return;
                }
                IrExpressionBody irExpressionBody = declaration.getInitializer();
                if (irExpressionBody == null || (irExpressionBody = irExpressionBody.getExpression()) == null) {
                    return;
                }
                IrExpressionBody initializer = irExpressionBody;
                if (initializer instanceof IrConst && !(((IrConst)initializer).getKind() instanceof IrConstKind.String)) {
                    return;
                }
                IrSimpleFunction initializeFunction = IrJsUtilsKt.isObjectInstanceField(declaration) ? (IrSimpleFunction)this.$objectInstanceFieldInitializer.element : (Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)), (Object)FieldInitializersLowering.access$getStringPoolFqName$p(this.this$0)) ? (IrSimpleFunction)this.$stringPoolFieldInitializer.element : (IrSimpleFunction)this.$nonConstantFieldInitializer.element);
                IrSimpleFunction irSimpleFunction = initializeFunction;
                if (irSimpleFunction == null) {
                    lower.1 var5_4 = this;
                    FieldInitializersLowering fieldInitializersLowering2 = this.this$0;
                    Ref.ObjectRef<IrSimpleFunction> objectRef = this.$objectInstanceFieldInitializer;
                    Ref.ObjectRef<IrSimpleFunction> objectRef2 = this.$stringPoolFieldInitializer;
                    Ref.ObjectRef<IrSimpleFunction> objectRef3 = this.$nonConstantFieldInitializer;
                    lower.1 $this$visitField_u24lambda_u240 = var5_4;
                    boolean bl = false;
                    Object object = fieldInitializersLowering2.getContext().getIrFactory().getStageController().restrictTo((IrDeclaration)declaration, () -> lower.1.visitField$lambda$0$0($this$visitField_u24lambda_u240));
                    IrSimpleFunction it = (IrSimpleFunction)object;
                    boolean bl2 = false;
                    if (IrJsUtilsKt.isObjectInstanceField(declaration)) {
                        objectRef.element = it;
                    } else if (Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)), (Object)FieldInitializersLowering.access$getStringPoolFqName$p(fieldInitializersLowering2))) {
                        objectRef2.element = it;
                    } else {
                        objectRef3.element = it;
                    }
                    irSimpleFunction = (IrSimpleFunction)object;
                }
                IrSimpleFunction currentFunction = irSimpleFunction;
                IrSetFieldImpl initializerStatement = ExpressionHelpersKt.irSetField$default((IrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.this$0.getContext()), (IrSymbol)((IrSymbol)currentFunction.getSymbol()), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)initializer)), null, (IrField)declaration, (IrExpression)initializer, null, (int)8, null);
                IrBody irBody = currentFunction.getBody();
                Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                ((IrBlockBody)irBody).getStatements().add(initializerStatement);
                declaration.setInitializer(null);
            }

            private static final IrSimpleFunction visitField$lambda$0$0(lower.1 $this_run) {
                return $this_run.createInitializerFunction();
            }
        });
        if (objectInstanceFieldInitializer.element != null || stringPoolFieldInitializer.element != null || nonConstantFieldInitializer.element != null) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction irSimpleFunction3;
            IrSimpleFunction it;
            WasmBackendContext.CrossFileContext crossFileContext;
            IrSimpleFunction irSimpleFunction4;
            WasmBackendContext.CrossFileContext $this$lower_u24lambda_u240 = this.context.getFileContext(irFile);
            boolean bl = false;
            WasmBackendContext.CrossFileContext crossFileContext2 = $this$lower_u24lambda_u240;
            IrSimpleFunction irSimpleFunction5 = (IrSimpleFunction)objectInstanceFieldInitializer.element;
            if (irSimpleFunction5 != null) {
                IrSimpleFunction irSimpleFunction6 = irSimpleFunction4 = irSimpleFunction5;
                crossFileContext = crossFileContext2;
                boolean bl2 = false;
                irFile.getDeclarations().add(it);
                crossFileContext2 = crossFileContext;
                irSimpleFunction3 = irSimpleFunction4;
            } else {
                irSimpleFunction3 = null;
            }
            crossFileContext2.setObjectInstanceFieldInitializer(irSimpleFunction3);
            WasmBackendContext.CrossFileContext crossFileContext3 = $this$lower_u24lambda_u240;
            IrSimpleFunction irSimpleFunction7 = (IrSimpleFunction)stringPoolFieldInitializer.element;
            if (irSimpleFunction7 != null) {
                it = irSimpleFunction4 = irSimpleFunction7;
                crossFileContext = crossFileContext3;
                boolean bl3 = false;
                irFile.getDeclarations().add(it);
                crossFileContext3 = crossFileContext;
                irSimpleFunction2 = irSimpleFunction4;
            } else {
                irSimpleFunction2 = null;
            }
            crossFileContext3.setStringPoolFieldInitializer(irSimpleFunction2);
            WasmBackendContext.CrossFileContext crossFileContext4 = $this$lower_u24lambda_u240;
            IrSimpleFunction irSimpleFunction8 = (IrSimpleFunction)nonConstantFieldInitializer.element;
            if (irSimpleFunction8 != null) {
                it = irSimpleFunction4 = irSimpleFunction8;
                crossFileContext = crossFileContext4;
                boolean bl4 = false;
                irFile.getDeclarations().add(it);
                crossFileContext4 = crossFileContext;
                irSimpleFunction = irSimpleFunction4;
            } else {
                irSimpleFunction = null;
            }
            crossFileContext4.setNonConstantFieldInitializer(irSimpleFunction);
        }
    }

    public static final /* synthetic */ FqName access$getStringPoolFqName$p(FieldInitializersLowering $this) {
        return $this.stringPoolFqName;
    }
}

