/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "parseLegacyPluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue", "parseModernPluginOption", "getPluginOptionString", "key", "value", "plugin-api"})
@SourceDebugExtension(value={"SMAP\nCliOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliOptions.kt\norg/jetbrains/kotlin/compiler/plugin/CliOptionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,101:1\n1585#2:102\n1660#2,2:103\n1662#2:107\n233#3:105\n233#3:106\n*S KotlinDebug\n*F\n+ 1 CliOptions.kt\norg/jetbrains/kotlin/compiler/plugin/CliOptionsKt\n*L\n53#1:102\n53#1:103,2\n53#1:107\n60#1:105\n61#1:106\n*E\n"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends AbstractCliOption> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            String string3;
            Object[] objectArray;
            int n;
            Object[] objectArray2;
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = it.getOptionName() + ' ' + it.getValueDescription();
            String margin = name.length() > MAX_OPTION_WIDTH ? '\n' + StringsKt.repeat((CharSequence)" ", (int)(MAX_OPTION_WIDTH + LEFT_INDENT + 1)) : StringsKt.repeat((CharSequence)" ", (int)(1 + MAX_OPTION_WIDTH - name.length()));
            Object[] objectArray3 = objectArray2 = new String[2];
            int n2 = 0;
            boolean condition$iv = it.getRequired();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                n = n2;
                objectArray = objectArray3;
                boolean bl2 = false;
                string3 = "required";
                objectArray3 = objectArray;
                n2 = n;
                string2 = string3;
            } else {
                string2 = null;
            }
            objectArray3[n2] = string2;
            Object[] objectArray4 = objectArray2;
            int n3 = 1;
            condition$iv = it.getAllowMultipleOccurrences();
            $i$f$runIf = false;
            if (condition$iv) {
                n = n3;
                objectArray = objectArray4;
                boolean bl3 = false;
                string3 = "multiple";
                objectArray4 = objectArray;
                n3 = n;
                string = string3;
            } else {
                string = null;
            }
            objectArray4[n3] = string;
            List modifiers = CollectionsKt.listOfNotNull((Object[])objectArray2);
            String modifiersEnclosed = modifiers.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default((Iterable)modifiers, null, null, null, (int)0, null, null, (int)63, null) + ')';
            collection.add(StringsKt.repeat((CharSequence)" ", (int)LEFT_INDENT) + name + margin + it.getDescription() + modifiersEnclosed);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin \"" + pluginId + "\" usage:\n" + CollectionsKt.joinToString$default((Iterable)renderedOptions, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }

    @Nullable
    public static final CliOptionValue parseLegacyPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter((Object)argumentValue, (String)"argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @Nullable
    public static final CliOptionValue parseModernPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter((Object)argumentValue, (String)"argumentValue");
        Pattern pattern = Pattern.compile("^([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            return new CliOptionValue("<NO_ID>", string, string2);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "plugin:" + pluginId + ':' + key + '=' + value;
    }
}

