/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.jsexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\"\u0010\f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\r\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0010\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0019\u001a\u00020\u0014*\u00020\u0005\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"isStaticMethod", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getExportCandidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldDeclarationBeExportedImplicitlyOrExplicitly", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "source", "shouldDeclarationBeExported", "isAllowedFakeOverriddenDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "isOverriddenEnumProperty", "isOverriddenExported", "isExported", "reservedWords", "", "", "strictModeReservedWords", "getStrictModeReservedWords", "()Ljava/util/Set;", "allReservedWords", "getExportedIdentifier", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGeneratorKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n233#2:530\n1585#3:531\n1660#3,3:532\n1806#3,3:543\n32#4,2:535\n9#4,6:537\n28#5:546\n29#5:548\n1#6:547\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/jsexport/ExportModelGeneratorKt\n*L\n439#1:530\n448#1:531\n448#1:532,3\n456#1:543,3\n449#1:535,2\n449#1:537,6\n524#1:546\n524#1:548\n524#1:547\n*E\n"})
public final class ExportModelGeneratorKt {
    @NotNull
    private static final Set<String> reservedWords;
    @NotNull
    private static final Set<String> strictModeReservedWords;
    @NotNull
    private static final Set<String> allReservedWords;

    private static final boolean isStaticMethod(IrFunction $this$isStaticMethod) {
        return ES6ConstructorLoweringKt.isEs6ConstructorReplacement((IrDeclaration)$this$isStaticMethod) || IrDeclarationsKt.isStaticMethodOfClass((IrFunction)$this$isStaticMethod);
    }

    private static final IrDeclarationWithName getExportCandidate(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || !(declaration instanceof IrDeclarationWithName) || !((IrDeclarationWithVisibility)declaration).getVisibility().isPublicAPI() || IrUtilsKt.isExpect((IrDeclaration)declaration)) {
            return null;
        }
        if (declaration instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            Object object = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null) {
                return Intrinsics.areEqual((Object)property2.getGetter(), (Object)declaration) ? (IrDeclarationWithName)property2 : null;
            }
        }
        return (IrDeclarationWithName)declaration;
    }

    private static final boolean shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context, IrDeclaration source) {
        return AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)declaration) || ExportModelGeneratorKt.shouldDeclarationBeExported(declaration, context, source);
    }

    static /* synthetic */ boolean shouldDeclarationBeExportedImplicitlyOrExplicitly$default(IrDeclarationWithName irDeclarationWithName, JsIrBackendContext jsIrBackendContext, IrDeclaration irDeclaration, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclaration = (IrDeclaration)irDeclarationWithName;
        }
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(irDeclarationWithName, jsIrBackendContext, irDeclaration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldDeclarationBeExported(IrDeclarationWithName declaration, JsIrBackendContext context, IrDeclaration source) {
        boolean bl;
        boolean bl2;
        if (declaration instanceof IrClass && ((IrClass)declaration).getKind() == ClassKind.ENUM_ENTRY) {
            return false;
        }
        if (AnnotationUtilsKt.isJsExportIgnore((IrAnnotationContainer)declaration)) return false;
        Object object = declaration instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)declaration : null;
        if (object != null && (object = object.getVisibility()) != null) {
            if (!((DescriptorVisibility)object).isPublicAPI()) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)context.getAdditionalExportedDeclarationNames(), (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration))) {
            return true;
        }
        if (((HashSet)context.getAdditionalExportedDeclarations()).contains(declaration)) {
            return true;
        }
        if (source instanceof IrOverridableDeclaration) {
            boolean overriddenNonEmpty;
            boolean bl3 = overriddenNonEmpty = !((Collection)((IrOverridableDeclaration)source).getOverriddenSymbols()).isEmpty();
            if (overriddenNonEmpty) {
                boolean bl4;
                if (ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)source, context)) return true;
                IrDeclaration irDeclaration = source;
                IrSimpleFunction irSimpleFunction = irDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclaration : null;
                if (irSimpleFunction != null) {
                    if (IrUtilsKt.isMethodOfAny((IrFunction)((IrFunction)irSimpleFunction))) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) return true;
                if (!ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)source, context)) return false;
                return true;
            }
        }
        if (AnnotationUtilsKt.isJsExport((IrAnnotationContainer)declaration)) {
            return true;
        }
        IrDeclarationParent parent2 = declaration.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            bl = ExportModelGeneratorKt.shouldDeclarationBeExported$default((IrDeclarationWithName)parent2, context, null, 4, null);
            return bl;
        } else {
            if (!(parent2 instanceof IrAnnotationContainer)) return false;
            bl = AnnotationUtilsKt.isJsExport((IrAnnotationContainer)parent2);
        }
        return bl;
    }

    static /* synthetic */ boolean shouldDeclarationBeExported$default(IrDeclarationWithName irDeclarationWithName, JsIrBackendContext jsIrBackendContext, IrDeclaration irDeclaration, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclaration = (IrDeclaration)irDeclarationWithName;
        }
        return ExportModelGeneratorKt.shouldDeclarationBeExported(irDeclarationWithName, jsIrBackendContext, irDeclaration);
    }

    public static final boolean isAllowedFakeOverriddenDeclaration(@NotNull IrOverridableDeclaration<?> $this$isAllowedFakeOverriddenDeclaration, @NotNull JsIrBackendContext context) {
        IrOverridableDeclaration irOverridableDeclaration;
        Intrinsics.checkNotNullParameter($this$isAllowedFakeOverriddenDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ExportModelGeneratorKt.isOverriddenEnumProperty($this$isAllowedFakeOverriddenDeclaration, context)) {
            return true;
        }
        boolean condition$iv = $this$isAllowedFakeOverriddenDeclaration.isFakeOverride();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract($this$isAllowedFakeOverriddenDeclaration, arg_0 -> ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration$lambda$0$0($this$isAllowedFakeOverriddenDeclaration, context, arg_0));
        } else {
            irOverridableDeclaration = null;
        }
        if (irOverridableDeclaration == null) {
            return false;
        }
        IrOverridableDeclaration firstExportedRealOverride = irOverridableDeclaration;
        return IrJsUtilsKt.isExportedInterface((IrDeclaration)IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)firstExportedRealOverride)), context) && !AnnotationUtilsKt.isJsExportIgnore((IrAnnotationContainer)firstExportedRealOverride);
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isOverriddenEnumProperty(@NotNull IrOverridableDeclaration<?> $this$isOverriddenEnumProperty, @NotNull JsIrBackendContext context) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter($this$isOverriddenEnumProperty, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                $this$map$iv = $this$isOverriddenEnumProperty.getOverriddenSymbols();
                $i$f$map = false;
                var4_4 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var9_9 = (IrSymbol)item$iv$iv;
                    var11_11 = destination$iv$iv;
                    $i$a$-map-ExportModelGeneratorKt$isOverriddenEnumProperty$1 = false;
                    var11_11.add(it.getOwner());
                }
                $this$filterIsInstanceAnd$iv = (List)destination$iv$iv;
                $i$f$filterIsInstanceAnd = false;
                if (!$this$filterIsInstanceAnd$iv.isEmpty()) break block4;
                v0 = CollectionsKt.emptyList();
                break block5;
            }
            $this$mapTo$iv$iv = $this$filterIsInstanceAnd$iv;
            destination$iv$iv = (Collection)new SmartList();
            $i$f$filterIsInstanceAndTo = false;
            for (T element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrOverridableDeclaration)) continue;
                it = (IrOverridableDeclaration)element$iv$iv;
                $i$a$-filterIsInstanceAnd-ExportModelGeneratorKt$isOverriddenEnumProperty$2 = false;
                if (!it.getOverriddenSymbols().isEmpty()) ** GOTO lbl-1000
                v1 = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)it));
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSymbol() : null), (Object)context.getIrBuiltIns().getEnumClass())) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        }
        return ((Collection)v0).isEmpty() == false;
    }

    public static final boolean isOverriddenExported(@NotNull IrOverridableDeclaration<?> $this$isOverriddenExported, @NotNull JsIrBackendContext context) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$isOverriddenExported, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$any$iv = $this$isOverriddenExported.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrDeclarationWithName candidate;
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
                    IrDeclarationWithName owner = (IrDeclarationWithName)irSymbolOwner;
                    IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate((IrDeclaration)owner);
                    if (irDeclarationWithName == null) {
                        irDeclarationWithName = owner;
                    }
                    if (!ExportModelGeneratorKt.shouldDeclarationBeExported(candidate = irDeclarationWithName, context, (IrDeclaration)owner)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isExported(@NotNull IrDeclaration $this$isExported, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isExported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExported);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExported(candidate, context, $this$isExported);
    }

    @NotNull
    public static final Set<String> getStrictModeReservedWords() {
        return strictModeReservedWords;
    }

    @NotNull
    public static final String getExportedIdentifier(@NotNull IrDeclarationWithName $this$getExportedIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getExportedIdentifier, (String)"<this>");
        Name $this$getExportedIdentifier_u24lambda_u240 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        if ($this$getExportedIdentifier_u24lambda_u240.isSpecial()) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl2 = false;
            IrExceptionBuilder $this$getExportedIdentifier_u24lambda_u240_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl3 = false;
            $this$getExportedIdentifier_u24lambda_u240_u240.withIrEntry("this", (IrElement)$this$getExportedIdentifier);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        String string = $this$getExportedIdentifier_u24lambda_u240.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAllowedFakeOverriddenDeclaration$lambda$0$0(IrOverridableDeclaration $this_isAllowedFakeOverriddenDeclaration, JsIrBackendContext $context, IrOverridableDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it == $this_isAllowedFakeOverriddenDeclaration) return true;
        if (it.isFakeOverride()) return true;
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)it));
        if (irClass == null) return true;
        if (!ExportModelGeneratorKt.isExported((IrDeclaration)irClass, $context)) return true;
        return false;
    }

    public static final /* synthetic */ IrDeclarationWithName access$getExportCandidate(IrDeclaration declaration) {
        return ExportModelGeneratorKt.getExportCandidate(declaration);
    }

    public static final /* synthetic */ boolean access$shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context, IrDeclaration source) {
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(declaration, context, source);
    }

    public static final /* synthetic */ boolean access$isStaticMethod(IrFunction $receiver) {
        return ExportModelGeneratorKt.isStaticMethod($receiver);
    }

    public static final /* synthetic */ Set access$getAllReservedWords$p() {
        return allReservedWords;
    }

    static {
        Object[] objectArray = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};
        reservedWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"};
        strictModeReservedWords = SetsKt.setOf((Object[])objectArray);
        allReservedWords = SetsKt.plus(reservedWords, (Iterable)strictModeReservedWords);
    }
}

