/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0012H\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "addBoxParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createJsObjectLiteral", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateBoxParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateDefaultResolution", "replaceThisWithBoxBeforeSuperCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "boxParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "hackEnums", "constructor", "hackSimpleClassWithCapturing", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6AddBoxParameterLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6AddBoxParameterLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n362#2,7:164\n362#2,3:171\n365#2,4:175\n1#3:174\n*S KotlinDebug\n*F\n+ 1 ES6AddBoxParameterLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering\n*L\n149#1:164,7\n153#1:171,3\n153#1:175,4\n*E\n"})
public final class ES6AddBoxParameterToConstructorsLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6AddBoxParameterToConstructorsLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.context.getEs6mode() || !(declaration instanceof IrConstructor) || IrJsUtilsKt.hasStrictSignature((IrConstructor)declaration, this.context)) {
            return null;
        }
        this.hackEnums((IrConstructor)declaration);
        this.hackSimpleClassWithCapturing((IrConstructor)declaration);
        if (!PrimaryConstructorLoweringKt.isSyntheticPrimaryConstructor(declaration)) {
            this.addBoxParameter((IrConstructor)declaration);
        }
        return null;
    }

    private final void addBoxParameter(IrConstructor $this$addBoxParameter) {
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$addBoxParameter));
        IrValueParameter boxParameter = this.generateBoxParameter($this$addBoxParameter, irClass);
        $this$addBoxParameter.setParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus((List)$this$addBoxParameter.getParameters(), (Object)boxParameter));
        IrBody irBody = $this$addBoxParameter.getBody();
        IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
        if (irBlockBody == null) {
            return;
        }
        IrBlockBody body = irBlockBody;
        boolean isBoxUsed = this.replaceThisWithBoxBeforeSuperCall((IrBody)body, irClass, (IrValueSymbol)boxParameter.getSymbol());
        if (isBoxUsed) {
            body.getStatements().add(0, this.generateDefaultResolution(boxParameter));
        }
    }

    private final IrExpression createJsObjectLiteral() {
        return (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsEmptyObject(), null, null, null, null, 0, 0, 126, null);
    }

    private final IrValueParameter generateBoxParameter(IrConstructor $this$generateBoxParameter, IrClass irClass) {
        JsIrBuilder jsIrBuilder = JsIrBuilder.INSTANCE;
        String string = Namer.INSTANCE.getES6_BOX_PARAMETER_NAME();
        IrType irType = IrTypesKt.makeNullable((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)irClass)));
        IrDeclarationOriginImpl irDeclarationOriginImpl = ES6AddBoxParameterLoweringKt.getES6_BOX_PARAMETER();
        return JsIrBuilder.buildValueParameter$default(jsIrBuilder, (IrFunction)$this$generateBoxParameter, string, irType, true, (IrDeclarationOrigin)irDeclarationOriginImpl, null, 32, null);
    }

    private final IrExpression generateDefaultResolution(IrValueParameter $this$generateDefaultResolution) {
        DeclarationIrBuilder $this$generateDefaultResolution_u24lambda_u240 = LowerUtilsKt.createIrBuilder((LoweringContext)((LoweringContext)this.context), (IrSymbol)((IrSymbol)$this$generateDefaultResolution.getSymbol()), (int)-1, (int)-1);
        boolean bl = false;
        return (IrExpression)ExpressionHelpersKt.irIfThen((IrBuilder)((IrBuilder)$this$generateDefaultResolution_u24lambda_u240), (IrType)$this$generateDefaultResolution_u24lambda_u240.getContext().getIrBuiltIns().getUnitType(), (IrExpression)ExpressionHelpersKt.irEqeqeqWithoutBox((IrBuilder)((IrBuilder)$this$generateDefaultResolution_u24lambda_u240), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$generateDefaultResolution_u24lambda_u240), (IrType)$this$generateDefaultResolution.getType(), (IrValueSymbol)((IrValueSymbol)$this$generateDefaultResolution.getSymbol()))), (IrExpression)IrJsUtilsKt.getVoid(this.context)), (IrExpression)((IrExpression)ExpressionHelpersKt.irSet$default((IrBuilder)((IrBuilder)$this$generateDefaultResolution_u24lambda_u240), (IrValueSymbol)((IrValueSymbol)$this$generateDefaultResolution.getSymbol()), (IrExpression)this.createJsObjectLiteral(), null, (int)4, null)), (IrStatementOrigin)((IrStatementOrigin)ES6AddBoxParameterLoweringKt.getES6_BOX_PARAMETER_DEFAULT_RESOLUTION()));
    }

    private final boolean replaceThisWithBoxBeforeSuperCall(IrBody $this$replaceThisWithBoxBeforeSuperCall, IrClass irClass, IrValueSymbol boxParameterSymbol) {
        Ref.BooleanRef meetCapturing = new Ref.BooleanRef();
        Ref.BooleanRef meetDelegatingConstructor = new Ref.BooleanRef();
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol selfParameterSymbol = irValueParameter.getSymbol();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)selfParameterSymbol, (Object)boxParameterSymbol));
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)$this$replaceThisWithBoxBeforeSuperCall), (IrElementTransformerVoid)((IrElementTransformerVoid)new ValueRemapper(meetDelegatingConstructor, boxParameterSymbol, meetCapturing, map){
            final /* synthetic */ Ref.BooleanRef $meetDelegatingConstructor;
            final /* synthetic */ IrValueSymbol $boxParameterSymbol;
            final /* synthetic */ Ref.BooleanRef $meetCapturing;
            {
                this.$meetDelegatingConstructor = $meetDelegatingConstructor;
                this.$boxParameterSymbol = $boxParameterSymbol;
                this.$meetCapturing = $meetCapturing;
                super($super_call_param$1);
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return this.$meetDelegatingConstructor.element ? (IrExpression)expression2 : super.visitGetValue(expression2);
            }

            public IrExpression visitSetField(IrSetField expression2) {
                IrGetValue receiver;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (this.$meetDelegatingConstructor.element) {
                    return (IrExpression)expression2;
                }
                IrExpression newExpression = super.visitSetField(expression2);
                IrExpression irExpression = expression2.getReceiver();
                IrGetValue irGetValue = receiver = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
                if (Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getSymbol() : null), (Object)this.$boxParameterSymbol)) {
                    this.$meetCapturing.element = true;
                }
                return newExpression;
            }

            public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.$meetDelegatingConstructor.element = true;
                return super.visitDelegatingConstructorCall(expression2);
            }
        }));
        return meetCapturing.element;
    }

    private final void hackEnums(IrConstructor constructor) {
        constructor.transformChildren((IrTransformer)new IrElementTransformerVoid(){

            public IrExpression visitTypeOperator(IrTypeOperatorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = expression2.getArgument();
                IrDelegatingConstructorCall irDelegatingConstructorCall = irExpression instanceof IrDelegatingConstructorCall ? (IrDelegatingConstructorCall)irExpression : null;
                return irDelegatingConstructorCall != null ? (IrExpression)irDelegatingConstructorCall : (IrExpression)expression2;
            }
        }, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void hackSimpleClassWithCapturing(IrConstructor constructor) {
        block13: {
            block12: {
                irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)constructor));
                if (IrUtilsKt.getSuperClass((IrClass)irClass) != null || !irClass.isInner() && !AdditionalIrUtilsKt.isOriginallyLocal((IrDeclaration)((IrDeclaration)irClass))) {
                    return;
                }
                var5_3 = constructor.getBody();
                v0 = var5_3 instanceof IrBlockBody != false ? (IrBlockBody)var5_3 : null;
                if (v0 == null || (v0 = v0.getStatements()) == null) {
                    return;
                }
                $this$indexOfFirst$iv = statements = v0;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                var8_9 = $this$indexOfFirst$iv.iterator();
                while (var8_9.hasNext()) {
                    item$iv = var8_9.next();
                    it = (IrStatement)item$iv;
                    $i$a$-indexOfFirst-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$delegationConstructorIndex$1 = false;
                    if (it instanceof IrDelegatingConstructorCall) {
                        v1 = index$iv;
                        break block12;
                    }
                    ++index$iv;
                }
                v1 = delegationConstructorIndex = -1;
            }
            if (delegationConstructorIndex == -1) {
                return;
            }
            $this$indexOfFirst$iv = statements;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            var9_11 = $this$indexOfFirst$iv.iterator();
            while (var9_11.hasNext()) {
                block15: {
                    block14: {
                        item$iv = var9_11.next();
                        statement = (IrStatement)item$iv;
                        $i$a$-indexOfFirst-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$firstClassFieldAssignment$1 = false;
                        if (!(statement instanceof IrSetField)) ** GOTO lbl-1000
                        if (((IrSetField)statement).getReceiver() == null) break block14;
                        $i$a$-let-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$firstClassFieldAssignment$1$1 = false;
                        if (!(it instanceof IrGetValue)) ** GOTO lbl-1000
                        v2 = irClass.getThisReceiver();
                        if (Intrinsics.areEqual((Object)((IrGetValue)it).getSymbol(), (Object)(v2 != null ? v2.getSymbol() : null))) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        v4 = v3;
                        break block15;
                    }
                    v4 = false;
                }
                if (v4) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (v5) {
                    v6 = index$iv;
                    break block13;
                }
                ++index$iv;
            }
            v6 = firstClassFieldAssignment = -1;
        }
        if (firstClassFieldAssignment == -1 || firstClassFieldAssignment > delegationConstructorIndex) {
            return;
        }
        statements.add(firstClassFieldAssignment, statements.get(delegationConstructorIndex));
        statements.remove(delegationConstructorIndex + 1);
    }
}

